package com.bcxin.sync.apis.controllers;
import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.runtime.domain.metas.commands.BatchCreateFormSyncMetaCommand;
import com.bcxin.runtime.domain.metas.entities.FormSyncMetaEntity;
import com.bcxin.runtime.domain.metas.repositories.FormSyncMetaRepository;
import com.bcxin.runtime.domain.metas.services.FormSyncMetaService;
import com.bcxin.sync.apis.requests.BatchFormSyncRequest;
import com.bcxin.sync.apis.requests.FormSyncRequest;
import com.bcxin.sync.apis.responses.FormSyncMetaResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import java.util.Collection;
import java.util.stream.Collectors;

@RestController("com.bcxin.sync.apis.controllers.FormSyncMetaController")
@RequestMapping(value = "/v2/sync/form-sync/metas")
public class FormSyncMetaController {
    private final FormSyncMetaRepository formSyncMetaRepository;
    private final FormSyncMetaService formSyncMetaService;

    public FormSyncMetaController(FormSyncMetaRepository formSyncMetaRepository,
                                  FormSyncMetaService formSyncMetaService) {
        this.formSyncMetaRepository = formSyncMetaRepository;
        this.formSyncMetaService = formSyncMetaService;
    }

    @PostMapping
    public ResponseEntity post(@RequestBody FormSyncRequest request) {
        this.formSyncMetaService.saveAll(request.getCommand());

        return this.get();
    }

    @GetMapping
    public ResponseEntity get() {
        Collection<FormSyncMetaEntity> formSyncMetaEntities =
                this.formSyncMetaRepository.findAll();

        Collection<FormSyncMetaResponse.FormSync> formSyncs =
                formSyncMetaEntities.stream().map(fm -> {
                    return FormSyncMetaResponse.FormSync.create(fm.getId(),
                            fm.getFormMeta().getApplicationMeta().getAppId(),
                            fm.getFormMeta().getId(),fm.getIsOnline()== BooleanStatus.TRUE, fm.getNote(),
                            fm.getFormMeta().getFormType(),
                            fm.getConfig(),
                            fm.getTargetMetaEntity().getId());
                }).collect(Collectors.toList());

        return ResponseEntity.ok(FormSyncMetaResponse.create(formSyncs));
    }

    @DeleteMapping("/{id}")
    public ResponseEntity delete(@PathVariable String id) {
        this.formSyncMetaService.delete(id);

        return ResponseEntity.ok().body("ok");
    }

    @PostMapping("/batches")
    public ResponseEntity batchPost(@RequestBody BatchFormSyncRequest request) {
        BatchCreateFormSyncMetaCommand command = request.getCommand();
        this.formSyncMetaService.batch(command);

        return this.get();
    }
}
