package com.bcxin.sync.apis.controllers;

import com.bcxin.runtime.domain.syncs.commands.UpdateDataSyncMapCommand;
import com.bcxin.runtime.domain.syncs.entities.DataSyncMapEntity;
import com.bcxin.runtime.domain.syncs.repositories.DataSyncMapRepository;
import com.bcxin.runtime.domain.syncs.services.DataSyncMapService;
import com.bcxin.sync.apis.requests.DataMapRequest;
import com.bcxin.sync.apis.responses.DataSyncMapResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import java.util.Collection;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/v2/sync/data-maps")
public class DataMapController {
    private final DataSyncMapService dataSyncMapService;
    private final DataSyncMapRepository dataSyncMapRepository;

    public DataMapController(DataSyncMapService dataSyncMapService,
                             DataSyncMapRepository dataSyncMapRepository) {
        this.dataSyncMapService = dataSyncMapService;
        this.dataSyncMapRepository = dataSyncMapRepository;
    }

    @PostMapping
    public ResponseEntity post(@RequestBody DataMapRequest request) {
        this.dataSyncMapService.create(request.getCommand());

        return this.get();
    }

    @PutMapping("/{id}")
    public ResponseEntity put(@PathVariable String id, @RequestBody DataMapRequest request) {
        this.dataSyncMapService.update(
                UpdateDataSyncMapCommand.create(id, request.getMapKey(), request.getJdbcMap()));

        return this.get();
    }

    @GetMapping
    public ResponseEntity get() {
        Collection<DataSyncMapEntity> dataSyncMapEntities =
                this.dataSyncMapRepository.findAll();

        Collection<DataSyncMapResponse> responses =
                dataSyncMapEntities.stream().map(ii -> {
                    return DataSyncMapResponse.create(ii.getId(), ii.getMapKey(), ii.getTargetConfig());
                }).collect(Collectors.toList());

        return ResponseEntity.ok(responses);
    }

    @DeleteMapping("/{id}")
    public ResponseEntity delete(@PathVariable String id) {
        this.dataSyncMapService.delete(id);

        return this.get();
    }
}
