import { Polygon, MultiPolygon, Feature, FeatureCollection } from 'geojson';

/**
 * Takes a kinked polygon and returns a feature collection of polygons that have
 * no kinks.
 *
 * Uses [simplepolygon](https://github.com/mclaeysb/simplepolygon) internally.
 *
 * @function
 * @param {FeatureCollection<Polygon|MultiPolygon>|Feature<Polygon|MultiPolygon>|Polygon|MultiPolygon} geojson polygons to unkink
 * @returns {FeatureCollection<Polygon>} Unkinked polygons
 * @example
 * const poly = turf.polygon([[[0, 0], [2, 0], [0, 2], [2, 2], [0, 0]]]);
 *
 * const result = turf.unkinkPolygon(poly);
 *
 * //addToMap
 * const addToMap = [poly, result]
 */
declare function unkinkPolygon<T extends Polygon | MultiPolygon>(geojson: Feature<T> | FeatureCollection<T> | T): FeatureCollection<Polygon>;

export { unkinkPolygon as default, unkinkPolygon };
