import { request } from '../utils/request';

/**********************************************内勤管理******************************************/

/**
 * 获取班次分页查询
 * @author xyz
 */

export function attendanceGetShiftPage(data) {
  return request('/task/attendance/get-shift-page', {
    method: 'GET',
    data: data || {}
  });
}

/**
 * 删除班次根据班次id``
 * @author xyz
 */

export function attendanceDeleteShiftById(data) {
  return request('/task/attendance/delete-shift-by-id', {
    method: 'GET',
    data: data || {}
  });
}

/**
 * 新增考勤组
 * @author hjj
 */

export function taskAttendanceComAttendGroupAddAttendGroup(data) {
  return request('/task/attendance/com-attend-group/add-attend-group', {
    method: 'POST',
    data: data || {}
  });
}

/**
 * 新增考勤组-设置考勤人员-详情
 * @author hjj
 */
export function taskAttendanceComAttendGroupFindAttendGroupById(data) {
  return request('/task/attendance/com-attend-group/find-attend-group-by-id', {
    method: 'get',
    data: data || {}
  });
}

/**
 * 更新考勤组信息
 * @author hjj
 */
export function taskAttendanceComAttendGroupUpdateAttendGroup(data) {
  return request('/task/attendance/com-attend-group/update-attend-group', {
    method: 'POST',
    data: data || {}
  });
}

/**
 * 检查人员是否存在于其他考勤组
 * @author hjj
 */
export function taskAttendanceComAttendGroupFindAttendGroupByPerId(data) {
  return request(
    '/task/attendance/com-attend-group/find-attend-group-by-per-id',
    {
      method: 'POST',
      data: data || {}
    }
  );
}

/**
 * 获取考勤组分页查询
 * @author hjj
 */
export function taskAttendanceComAttendGroupPageForGroup(data) {
  return request('/task/attendance/com-attend-group/page-for-group', {
    method: 'get',
    data: data || {}
  });
}
/**
 * 删除考勤组
 * @author hjj
 */
export function taskAttendanceComAttendGroupDelete(data) {
  return request('/task/attendance/com-attend-group/delete', {
    method: 'POST',
    data: data || {}
  });
}
/**
 * 获取班次分页查询
 * @author hjj
 */
export function taskComShiftPage(data) {
  return request('/task/com-shift/page', {
    method: 'get',
    data: data || {}
  });
}
/**
 * 新增考勤组-设置考勤人员-检查多个人员是否存在于其他考勤组
 * @author hjj
 */
export function taskAttendanceComAttendGroupFindAttendGroupByPerIdStr(data) {
  return request(
    '/task/attendance/com-attend-group/find-attend-group-by-per-id-str',
    {
      method: 'POST',
      data: data || {}
    }
  );
}
/**
 * 新增考勤组-选择考勤类型-固定班制-详情
 * @author hjj
 */
export function taskAttendanceComattendgroupfixedGetDetail(data) {
  return request('/task/attendance/comattendgroupfixed/get-detail', {
    method: 'get',
    data: data || {}
  });
}
/**
 * 新增考勤组-选择考勤类型-固定班制-修改
 * @author hjj
 */
export function taskAttendanceComattendgroupfixedUpdate(data) {
  return request('/task/attendance/comattendgroupfixed/update', {
    method: 'POST',
    data: data || {}
  });
}
/**
 * 新增考勤组-选择考勤类型-固定班制-获取周一到周日模板
 * @author hjj
 */
export function taskAttendanceComattendgroupfixedGetAddTemp(data) {
  return request('/task/attendance/comattendgroupfixed/get-add-temp', {
    method: 'get',
    data: data || {}
  });
}
/**
 * 新增考勤组-选择考勤类型-固定班制-新增
 * @author hjj
 */
export function taskAttendanceComattendgroupfixedSave(data) {
  return request('/task/attendance/comattendgroupfixed/save', {
    method: 'post',
    data: data || {}
  });
}
/**
 * 新增考勤组-设置考勤方式-详情
 * @author hjj
 */
export function taskAttendanceComAttendGroupListAttendGroupAddress(data) {
  return request(
    '/task/attendance/com-attend-group/list-attend-group-address',
    {
      method: 'get',
      data: data || {}
    }
  );
}
/**
 * 新增考勤组-设置考勤方式-修改
 * @author hjj
 */
export function taskAttendanceComAttendGroupUpdateAttendGroupAddress(data) {
  return request(
    '/task/attendance/com-attend-group/update-attend-group-address',
    {
      method: 'post',
      data: data || {}
    }
  );
}
/**
 * 新增考勤组-设置考勤方式-新增
 * @author hjj
 */
export function taskAttendanceComAttendGroupAddAttendGroupAddress(data) {
  return request('/task/attendance/com-attend-group/add-attend-group-address', {
    method: 'post',
    data: data || {}
  });
}
/**
 * 班次管理-班次删除并删除班次的考勤时间安排
 * @author hjj
 */
export function taskComShiftDelete(data) {
  return request('/task/com-shift/delete', {
    method: 'POST',
    data: data || {}
  });
}
/**
 * 根据id获取班次
 * @author hjj
 */
export function taskComShiftGet(data) {
  return request('/task/com-shift/get', {
    method: 'get',
    data: data || {}
  });
}
/**
 * 添加班次
 * @author hjj
 */
export function taskComShiftInsert(data) {
  return request('/task/com-shift/insert', {
    method: 'POST',
    data: data || {}
  });
}
/**
 * 编辑班次
 * @author hjj
 */
export function taskComShiftUpdate(data) {
  return request('/task/com-shift/update', {
    method: 'POST',
    data: data || {}
  });
}
/**
 * 进入考勤设置第一步页面
 * @author hjj
 */
export function taskAttendanceComAttendGroupInFirstStepAttendGroup(data) {
  return request(
    '/task/attendance/com-attend-group/in-first-step-attend-group',
    {
      method: 'POST',
      data: data || {}
    }
  );
}
/**
 * 进入考勤设置第一步页面
 * @author hjj
 */
export function taskAttendanceComAttendGroupSaveFirstStepAttendGroup(data) {
  return request(
    '/task/attendance/com-attend-group/save-first-step-attend-group',
    {
      method: 'POST',
      data: data || {}
    }
  );
}
/**
 * 进入考勤组设置-第二步页面
 * @author hjj
 */
export function taskAttendanceComAttendGroupInSecondStepAttendGroup(data) {
  return request(
    '/task/attendance/com-attend-group/in-second-step-attend-group',
    {
      method: 'POST',
      data: data || {}
    }
  );
}
/**
 * 新增或者修改考勤组-第二步-设置考勤地址
 * @author hjj
 */
export function taskAttendanceComAttendGroupSaveSecondStepAttendGroup(data) {
  return request(
    '/task/attendance/com-attend-group/save-second-step-attend-group',
    {
      method: 'POST',
      data: data || {}
    }
  );
}
/**
 * 进入考勤组设置-第三步页面
 * @author hjj
 */
export function taskAttendanceComAttendGroupInThirdStepAttendGroup(data) {
  return request(
    '/task/attendance/com-attend-group/in-third-step-attend-group',
    {
      method: 'POST',
      data: data || {}
    }
  );
}
/**
 * 新增或者修改考勤组-第三步-设置考勤人员并保存
 * @author hjj
 */
export function taskAttendanceComAttendGroupSaveThirdStepAttendGroup(data) {
  return request(
    '/task/attendance/com-attend-group/save-third-step-attend-group',
    {
      method: 'POST',
      data: data || {}
    }
  );
}
/**
 * 新增或者修改考勤组-设置考勤人员-检查人员是否存在于其他考勤组
 * @author hjj
 */
export function taskAttendanceComAttendGroupCheckAttendPer(data) {
  return request('/task/attendance/com-attend-group/check_attend_per', {
    method: 'POST',
    data: data || {}
  });
}
/**
 * 人员考勤日统计分页查询
 * @author Wfh
 */
export function getdayStatisticsData(data) {
  return request('/task/count/attend-count/page-for-count-per-attend-date', {
    method: 'GET',
    data: data || {}
  });
}
/**
 * 人员考勤月统计分页查询
 * @author Wfh
 */
export function getmonthStatisticsData(data) {
  return request('/task/count/attend-count/page-for-count-per-attend-month', {
    method: 'GET',
    data: data || {}
  });
}
/**
 * 获取部门--该接口理论上应该是一个全局接口，数据因挂载在全局模块，但数据为空时才进行请求，目前只有该处使用
 * @author Wfh
 */
export function getDepartmentData(data) {
  return request('/depart/get-tree-depart-not-data-auth', {
    method: 'GET',
    data: data || {}
  });
}
/**
 * 获取部门--获取考勤统计数据详情
 * @author Wfh
 */
export function getAttendRecordDetail(data) {
  return request('/task/count/attend-count/get-attend-record-list', {
    method: 'GET',
    data: data || {}
  });
}
/**
 * 获取部门--修改考勤统计数据详情
 * @author Wfh
 */
export function changeRecordDetail(data) {
  return request('/task/count/attend-count/update-attend-record', {
    method: 'POST',
    data: data || {}
  });
}
