/**
 * 防空指挥
 */
import { request,v5comRequest,v5baseRequest,v5adminRequest } from "../utils/request";
import {gup} from "../utils/utils"
/***************************im********************************/
/*web端获取腾讯im登录sig接口*/
export function getTencentImSig(data) {
  return v5comRequest('/identify/api/tencent/get-tencent-sig', {
    method: 'GET',
    data
  });
}
//解散音视频房间
export function trtcVideoRoom(data) {
  return v5comRequest('/identify/api/tencent/trtc-video-room', {
    method: 'POST',
    data: data || {}
  });
}
//分页查询调度记录
export function findComVideoRoomPage(data) {
  return v5comRequest("/identify/api/tencent/find-com-video-room-page", {
    method: "POST",
    data: data || {},
  });
}
//调度记录详情
export function getVideoRoomDetail(data) {
  return v5comRequest("/identify/api/tencent/get-video-room-detail", {
    method: "POST",
    data: data || {},
  });
}
//设置房间结束时间
export function updateRoomEndTime(data) {
  return v5comRequest("/identify/api/tencent/update-room-end-time", {
    method: "POST",
    data: data || {},
  });
}
//推送音视频房间号给指定人员
export function sendVideoRoomMsg(data) {
  return v5comRequest('/identify/api/tencent/send-video-room-msg', {
    method: 'POST',
    data: data || {}
  });
}
//继续推送音视频房间号给指定人员
export function continueSendVideoRoomMsg(data) {
  return v5comRequest('/identify/api/tencent/continue-send-video-room-msg', {
    method: 'POST',
    data: data || {}
  });
}
//web端获取腾讯音视频sig接口
export function getTencentYspSig(data) {
  return v5comRequest('/identify/api/tencent/get-tencent-ysp-sig', {
    method: 'GET',
    data: data || {}
  });
}

//防控指挥获取驻勤点列表
export function getComTaskList(data) {
  return request('/task/get-com-task-list', {
    method: 'POST',
    data: data || {}
  });
}
//防控指挥获取临保任务列表
export function getComTempTaskList(data) {
  return request('/task/tempTask/get-com-temp-task-list', {
    method: 'POST',
    data: data || {}
  });
}
//获取该公司对应有的驻勤点类型
export function getComTaskStationType(data) {
  return request('/task/get-com-task-station-type', {
    method: 'POST',
    data: data || {}
  });
}


export function usersMyprofile(data) {
  return v5baseRequest("/obpm/api/runtime/users/myprofile", {
    method: "GET",
    data: data || {},
  });
}

//获取保安员列表数据
export function getPersonList(urlData,data) {
  const type = gup('app_type', window.location.href);
  let url = type==1?"/obpm/api/runtime/__ZBa8XIkdSja8zAZgpQV/views/__WHP9HkjenwExgWW53TP/documents":"/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__FBwWBm18eyoRndv9tIP/documents";
  return v5baseRequest(url, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  });
}

//获取驻勤点列表数据
export function getTaskList(urlData,data) {
  const type = gup('app_type', window.location.href);
  let url = type==1?"/obpm/api/runtime/__ZBa8XIkdSja8zAZgpQV/views/__GX5vvg8b2rUmRWtLHFJ/documents":"/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__jWxVWbbGObe5KRYEOoU/documents";
  return v5baseRequest(url, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  });
}

//部门用户搜索(用来获取cid)
export function searchDeptUser(urlData,data) {
  return v5baseRequest(`/obpm/magic-api/fkzh/getSecurityByIphone`, {
    method: "GET",
    urlData:urlData||{},
    data: data || {},
  })
}

//获取用户全部信息
export function getUserAllInfo(urlData,data) {
  return v5baseRequest(`/obpm/api/authtime/user/`+urlData, {
    method: "GET",
  })
}

//获取分类列表
export function getClassification(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__mRmXX7P1rAhxDf570Ck/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}

//驻勤点根据分类获取分类数据
export function attendanceGetTypeData(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__YxVuFY8k0tZjSoJWNS4/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}

//态势感知根据分类获取分类数据
export function perceptionGetTypeData(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__gnF6tfEwBQwo6IrdMrK/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//近期实时上报异常数据
export function recentAbnormalData(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__N04pcqn4nJYvdkjohbK/views/__0iiRNXOJBGOiwTDPSr3/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//获取一张图列表中保安资源列表数据
export function getSecurityResourcesList(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__FBwWBm18eyoRndv9tIP/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//获取今日异常上报分类数量
export function getTodayAbnormalData(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__N04pcqn4nJYvdkjohbK/views/__K3a3SsbfKNZis2xBMjQ/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//根据时间查询异常总数
export function getAbnormaCount(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__N04pcqn4nJYvdkjohbK/views/__kZW6NG4GdBBRHfcSzlx/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//
export function getTimeAbnormalCount(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__N04pcqn4nJYvdkjohbK/views/__CZBJre6k8BYpk881gTV/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
// 获取保安公司列表
export function getSecurityCompanyList(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__cjmZ3QwX3HE1ZHPCOOt/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
/******************警保联动图层******************/
//获取所有企业列表信息
export function getEnterpriseList(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__xzByH4ZZxj2gVJZv0G4/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//根据所有企业id获取对应的部门列表
export function passEnterpriseIDGetDepartList(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__MbFPvXeIwgTOEoodAVc/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//根据部门id获取对应的部门列表
export function passDepartIdGetDepartList(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__uPN8uNlIhDaGiEgKxnX/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//根据部门id获取对应的保安员列表
export function passDepartIdGetPersonList(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__P1bb27ekxYoAiowqVv1/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//根据部门id获取对应的驻勤点列表
export function passEnterpriseIDGetAttendanceList(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__Mxf0ppgb6L8Hg6Va7Y5/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//根据驻勤点id获取对应的保安员列表
export function passAttendanceIdGetPersonList(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__jPQpIYhfGyrkUDVNVAE/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//根据驻勤点id获取对应的保安员列表
export function getSecurityManByAttendanceId(urlData,data) {
  return v5baseRequest(`/obpm/magic-api/fkzh/getSecuritymanByAttendanceId/${urlData.attendanceId}`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//根据userid查询key、sid、tid
export function getTerminalByUserId(data) {
  return v5comRequest('/identify/api/trajectory/get-terminal-by-user-id', {
    method: 'POST',
    data: data || {}
  },true);
}
//根据userid查询key、sid、tid
export function trackTrsearch(data) {
  return v5comRequest('/identify/api/trajectory/track-trsearch', {
    method: 'POST',
    data: data || {}
  });
}
//获取图层权限设置
export function getLayoutAuthority(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__jN3d9GetQI3p4DdC5To/documents`, {
    // return v5baseRequest(`/obpm/api/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__jN3d9GetQI3p4DdC5To/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//Gis菜单配置
export function getGISMenu(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__yCQ9PtckfTJYgpHrgGm/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//海康数据接口
export function getHaiKangApiUrl(data) {
  return v5baseRequest(`https://nngba.baibaodun.com.cn:9000/fkzh/getHKData`, {
    method: "POST",
    data: data || {},
  })
}
//搜索地点周围信息接口
export function getSearchInformation(urlData,data) {
  return v5baseRequest(`/obpm/api/runtime/__ZLuP7RGirprZZ6SCdiX/views/__huLYV33YRM6tdseIVTp/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
export function getRangeData(urlData,data) {
  return v5baseRequest(`/obpm/magic-api/fkzh/getRangeData`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
//警报联动搜索地点周围信息接口
export function getPoliceSearchInformation(urlData,data) {
  return v5baseRequest(`/obpm/runtime/__ZLuP7RGirprZZ6SCdiX/views/__alnvhRO3LL5hO0vBgb1/documents`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
// 查询企业信息
export function getDomainInfo(urlData,data) {
  return v5baseRequest(`/obpm/magic-api/fkzh/getDomainById/${urlData.domainId}`, {
    method: "GET",
  })
}
// 查询企业根部门
export function getRootDep(urlData,data) {
  return v5adminRequest(`/obpm/api/authtime/domain/${urlData.domainId}/department/root`, {
    method: "GET",
  })
}
// 根据部门id查询下级部门
export function getSubdepartmentList(urlData,data) {
  return v5adminRequest(`/obpm/api/authtime/domain/${urlData.domainId}/department/${urlData.depId}/subdepartments`, {
    method: "GET",
  })
}
// 企业id获取保安员信息
export function getSecuritymanByDomainid(urlData,data) {
  return v5baseRequest(`/obpm/magic-api/fkzh/getSecuritymanByDomainid`, {
    method: "POST",
    urlData:urlData||{},
    data: data || {},
  })
}
// 企业id获取驻勤点
export function getAttendance(urlData,data) {
  let url = urlData.id ? `/obpm/magic-api/fkzh/getAttendance/${urlData.id}` :  `/obpm/magic-api/fkzh/getAttendance?name=${urlData.name}`;
  return v5baseRequest(url, {
    method: "GET",
  })
}
// 通过保安员id获取驻勤点信息
export function getAttendanceInfoBySecurityId(urlData,data) {
  return v5baseRequest(`/obpm/magic-api/fkzh/getAttendanceInfoBySecurityId/`, {
    method: "GET",
  })
}
// 获取保安企业列表
export function getDomainList(urlData,data) {
  return v5baseRequest(`/obpm/magic-api/fkzh/auth/getdomainList`, {
    method: "GET",
    urlData:urlData||{},
    data: data || {},
  })
}

// 根据事件级别返回事件
export function getEventByLevel(urlData,data) {
  return v5baseRequest(`/obpm/magic-api/fkzh/event/getEventByLevel`, {
    method: "GET",
    urlData:urlData||{},
    data: data || {},
  })
}

// 根据事件级别返回列表
export function getEventByLevelList(urlData,data) {
  return v5baseRequest(`/obpm/magic-api/fkzh/event/getEventByLevelList`, {
    method: "GET",
    urlData:urlData||{},
    data: data || {},
  })
}

// 根据事件级别返回事件
export function updateEventStatus(urlData,data) {
  return v5baseRequest(`/obpm/magic-api/fkzh/event/updateEventStatus`, {
    method: "GET",
    urlData:urlData||{},
    data: data || {},
  })
}
