import { noLoginRequest, loginRequest,request } from '../utils/request';

/**********************************************登录注册相关******************************************/

/**
 * 游客注册-联系手机验证
 * @author Orm
 */
export function systemPerAccountInfoVerificationPhone(data) {
  return noLoginRequest('/per-account-info/verification-phone', {
    method: 'POST',
    data
  });
}

/**
 * 获取手机验证码
 * @author Orm
 */
export function systemPlatNewsSendVerificationCode(data) {
  return request('/public/common/send-verification-code', {
    method: 'POST',
    data
  });
}


/**
 * 游客注册-个人用户注册
 * @author Orm
 */
export function systemPerAccountInfoSave(data) {
  return noLoginRequest('/per-account-info/save', {
    method: 'POST',
    data
  });
}

/* 登录 */
export function accesstoken(data) {
  const url = `/oauth/web/accesstoken?grant_type=password&client_secret=web&client_id=saasweb&username=${
    data.username
    }&password=${data.password}&redirect_uri=${data["redirect_uri"]}&public_key=${data.public_key}`;
  return loginRequest(url, {});
}

/* 获取秘钥原始值 */
export function getPublicKey(data) {
  return noLoginRequest('/public/common/get/public_key', {
    method: 'GET',
    data
  });
}
/**
 * 验证短信验证码
 * @author Orm
 */
 export function systemPlatNewsVerificationCode(data) {
  return request('/public/common/verification-code', {
    method: 'POST',
    data
  });
}