/**
 * 金融钱包模块
 */
import { request } from "../utils/request";

/** 获取企业钱包服务开通情况*/
export function getComWalletServiceOpenInfo(data) {
    return request('/wallet/get-com-wallet-service-open-info', {
        method: 'GET',
        data: data || {}
    });
}
/** 获取指定企业钱包服务开通情况*/
export function getComWalletServiceOpenInfoFormOne(data) {
    return request('/wallet/get-com-wallet-service-open-info', {
        method: 'GET',
        data: data || {}
    }, false, false, true, true);
}
/** 保存钱包银行卡信息变更*/
export function saveBankCardChangeEvent(data) {
    return request('/wallet/save-bank-card-change-event', {
        method: 'POST',
        data: data || {}
    });
}
/** 获取企业钱包服务当前开通步骤*/
export function getComWalletCurrentProcess(data) {
    return request('/wallet/get-com-wallet-current-process', {
        method: 'GET',
        data: data || {}
    });
}
/** 获取企业未开通钱包服务人员列表*/
export function getNoOpenWalletServicePerList(data) {
    return request('/task/per/wallet/get-no-open-wallet-service-per-list', {
        method: 'GET',
        data: data || {}
    });
}
/** 获取企业已开通钱包服务人员列表*/
export function getOpenWalletServicePerList(data) {
    return request('/task/per/wallet/get-open-wallet-service-per-list', {
        method: 'GET',
        data: data || {}
    });
}
/** 获取企业人员开通钱包服务情况  已开通和未开通的人数*/
export function getPerOpenWalletServiceInfo(data) {
    return request('/task/per/wallet/get-per-open-wallet-service-info', {
        method: 'GET',
        data: data || {}
    });
}
/** 获取银行配置*/
export function getConfigBankList(data) {
    return request('/public/common/get-config-bank-list', {
        method: 'GET',
        data: data || {}
    });
}
/** 企业业务发送验证码*/
export function sendVerifyCode(data) {
    return request('/wallet/send_verify_code', {
        method: 'POST',
        data: data || {}
    });
}
/** 企业保存开户资料(原来的两步变成一步完成)*/
export function saveCccountInfo(data) {
    return request('/wallet/save-account-info', {
      method: 'POST',
      data: data || {}
    });
  }
/** 注册完‘去认证’(原来的两步变成一步完成)*/
export function getAccountConfirmApi(data) {
  return request('/wallet/get-account-confirm', {
    method: 'POST',
    data: data || {}
  });
}  
/** 获取企业钱包账户资料*/
export function getComWalletAccount(data) {
    return request('/wallet/get-com-wallet-account', {
      method: 'GET',
      data: data || {}
    }, null, false, true);
  }
  /** 获取企业钱包账户交易明细*/
export function getComWalletAccountTradeDetail(data) {
    return request('/wallet/get-com-wallet-account-trade-detail', {
      method: 'GET',
      data: data || {}
    });
  }
  /** 获取企业钱包账户金额*/
export function getComWalletAccountAmount(data) {
    return request('/wallet/get-com-wallet-account-amount', {
      method: 'GET',
      data: data || {}
    });
  }
  /** 获取企业钱包账户对账数据*/
export function getComWalletReconciliation(data) {
    return request('/wallet/get-com-wallet-reconciliation', {
      method: 'POST',
      data: data || {}
    });
  }
/** 企业钱包账户提现*/
export function comWalletAccountExtract(data) {
    return request('/wallet/com-wallet-account-extract', {
      method: 'POST',
      data: data || {}
    });
  }
/** 企业钱包账户充值*/
export function getWalletRechargeToken(data) {
  return request('/wallet/get-wallet-recharge-token', {
    method: 'POST',
    data: data || {}
  });
}
  