import React, { PureComponent } from 'react';
import {
  Row,
  Button,
  Table,
  Modal,
  message,
  Alert
} from 'antd';

import PMap from '../../../components/Pro/PMap';
import bcx_utils from '../../../common/bcx_utils';

import './less/style.less';

/**
 * 配置角色及权限
 */
export default class SetLocation extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      address: '',
      points: [],
      visible: false, //添加地点
      addressRange: '200' //考勤范围
    };
  }

  /******************************生命周期******************************/

  componentDidMount = () => {
  };

  componentWillReceiveProps = (nextProps, newState) => { };

  /******************************ajax请求******************************/

  /******************************相关事件******************************/
  //提交地点
  handleOk = e => {
    const { address, points,addressRange } = this.state;
    console.log(points)
    if (address === '' || points.length === 0) {
      bcx_utils.preventRepeatAsync(callback =>
        callback(resolve => {
          message.warning('请选择地点', 1.5, () => {
            window.setTimeout(() => {
              resolve();
            }, 500);
          });
        })
      );
      return;
    }
    this.props.addArea(points, address,addressRange);
    this.setState({
      visible: false
    });
  };
  //取消地点
  handleCancel = e => {
    this.setState({
      visible: false,
      address: '',
      points: []
    });
  };

  deleteItem = (index, record) => {
    this.props.deleteLocalItem(index, record);
  };

  areaChange = (points, address) => {
    console.log(points)
    console.log(address)
    this.setState({ points, address });
  };

  // inputchange = e => {
  //   const addressRange = e.target.value.trim().replace(/[^0-9]/g, '');
  //   // this.setState({ addressRange });
  //   this.props.addressRangeChange(addressRange);
  // };

  /******************************render******************************/

  render() {
    const { dataSource = [] } = this.props;
    const newDataSource = dataSource.map((val, key) => ({
      ...val,
      ...{ key }
    }));
    /* 考勤地点--drawer */
    let columns = [
      {
        key: 'address',
        title: '考勤地点',
        dataIndex: 'address'
      },
      {
        key: 'addressLongitude',
        title: '经度',
        dataIndex: 'addressLongitude'
      },
      {
        key: 'addressLatitude',
        title: '纬度',
        dataIndex: 'addressLatitude'
      },
      {
        key: 'addressRange',
        title: '考勤范围(米)',
        dataIndex: 'addressRange'
      },
      {
        width: 60,
        title: '操作',
        dataIndex: 'b',
        render: (text, record, index) => (
          this.props.disabled? 
            <span>删除</span>
            :
          <span
            style={{ color: '#0F71FF', cursor: 'pointer' }}
            onClick={this.deleteItem.bind(this, index, record)}
          >
            删除
          </span>
        )
      }
    ];
    if(!this.props.text1) {
      columns.splice(1, 1);
    }
    return (
      <div>
        <Row span={24}>
          {
            <div>
                <Alert
                  message={
                    <div>
                      提示：有效范围请勿设置过小，手机定位会受信号等因素影响偏移，造成无法打卡。
                    </div>
                  }
                  type="warning"
                  showIcon
                />
                <section style={{marginTop:'15px'}}>
                  <Button
                    // disabled={this.props.disabled}
                    type="primary"
                    ghost
                    onClick={() => {
                      this.setState({ visible: true });
                    }}
                  >
                    添加
                    </Button>
                </section>
            </div>
          }
            <Table
              style={{ marginTop: 16 }}
              size="middle"
              pagination={false}
              columns={columns}
              dataSource={newDataSource}
            />
        </Row>
        <Modal
          title="添加地点"
          visible={this.state.visible}
          okText="提交"
          cancelText="关闭"
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          width={800}
        >
          <PMap
            areaChange={this.areaChange}
            taskCityName={''} //添加当前驻勤城市名称，9-28
            ifProvince={false}
            addressRange={this.state.addressRange}
            changeAddressRange={(value)=>{
              console.log(value)
              this.setState({
                addressRange:value
              })
            }}
          />
        </Modal>
      </div>
    );
  }
}
