import React, { Component } from 'react';
import store from 'store';
import {
  Modal,
  Button,
  Upload,
  message 
} from 'antd';
import $loading from '../../../../utils/loading';
import {
  systemComDepartExportDepartTemp,
  systemComVaseInfoGet
} from '../../../../services/api';
import st from 'styled-components';
export default class BulkInsuranceModal extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      failData: null  //上传失败的文件
    };
  }
  componentWillMount() {

  }
  render() {
    return (
      <Modal
        title="导入投保人员"
        visible={this.props.visible}
        onOk={() => this.props.setParentState({
          bulkVisible: false
        })}
        onCancel={() => this.props.setParentState({
          bulkVisible: false
        })}
      >
        {/* 下载 */}
        <a
          onClick={() => {
            // 获取企业详情 拿到comId
            systemComVaseInfoGet({}).then(
              response => {
                const { comId } = response.data;
                systemComDepartExportDepartTemp({ comId }).then(res => {
                  if (!res) {
                    return;
                  }
                  let url = window.URL.createObjectURL(res.data);
                  let link = document.createElement('a');
                  link.style.display = 'none';
                  link.href = url;
                  link.setAttribute(
                    'download',
                    `组织架构模板.xls`
                  );
                  document.body.appendChild(link);
                  link.click();
                });
              }
            );
          }}
        >点击下载导入投保人员模板</a>


        <UploadContainer>
          <p>
            投保人员数据:
        </p>

          <Upload
            name="xfile"
            action="/saas_api/system/com-depart/import-excel-per"
            headers={{
              authorization: 'Basic c2Fhc3dlYjp3ZWI=',
              access_token: store.get('saas')['access_token']
            }}
            onChange={info => {
              if (info.file.status === 'uploading') {
                return;
              }
              if (info.file.status === 'done') {
                $loading.close();
                const { data, msg, retType } = info.file.response;
                //"retType":"-1"为错误，data会有相应的路径值
                //"retType":"0"为正确，data为空
                if (retType === '-1') {
                  
                  message.error(msg);
                  this.setState({
                    failData: data  //上传失败的文件
                  });
                } else if (retType === '0') {
                  // 返回的数据
                  message.success(msg);
                } else {
                  message.error(msg);
                }
              }
            }}
            beforeUpload={file => {
              $loading.open(<div>
                <span>系统正在为您识别并导入数据内容...</span><br />
                <span>若数据量较大，导入时间相对偏长，请耐心等待</span>
              </div>);
              if (file.name.indexOf('xls') === -1 && file.name.indexOf('xlsx') === -1) {
                $loading.close();
                message.error('请上传xls或xlsx文件!');
                return false;
              }
              if(file.size/1024/1024 > 1.5){
                $loading.close();
                message.error('请上传小于1.5M文件!');
                return false;
              }
              return true;
            }}
          >
            <Button type="primary">选择上传文件</Button>
          </Upload>
        </UploadContainer>

      </Modal>

    );
  }
}

const UploadContainer = st.div`
  display: flex;
  align-items: center;
`;
