import React, { PureComponent } from 'react';
import style from "styled-components";
import { Card ,List, Avatar,Table,Button } from 'antd';
import "./InsuranceMangerment.less";
import TitleBlue from '../../../assets/images/title_blue.png';
import TitleYellow from '../../../assets/images/title_yellow.png';
export default class InsuranceScheme extends PureComponent {
  // constructor(props, context) {
  //   super(props, context);
  //   this.state = {
  //   };
  // }
  render() {
    const moderndata = [
      {
        title: '员工的风险',
        description:'员工的风险员工的风险员工的风险员工的风险员工的风险员工的风险员工的风险员工的风险员工的风险员工的风险员工的风险员工的风险员工的风险员工的风险员工的风险',
      },
      {
        title: '企业的风险',
        description:'企业的风险企业的风险企业的风险企业的风险企业的风险企业的风险企业的风险企业的风险企业的风险企业的风险企业的风险企业的风险企业的风险企业的风险企业的风险企业的风企企业的风险企业的风险企业的风险企业的风险企业的风险企业的风险',
      },
      {
        title: '综合概括',
        description:<div>
                      <p>生活工作全覆盖的保障，可免除员工后顾之忧</p>
                      <p>完善公司福利体系，吸引优秀人才</p>
                      <p>增加企业核心竞争力同时有效转移企业经营风险，避免经济或是法律纠纷。</p>
                    </div>,
      },
    ];
    const contentdata = [
      {
        title: '预计投保人数：10人',
        description:<div className="totalcost">
                      <img src={TitleYellow} className="totalcostimg"/>
                      <span className="totalcostcount">总费用：</span>
                      <span>1800元</span>
                      <span className="totalcostremark">&nbsp;（预计投保人数*保费）</span>
                    </div>,
      },
      {
        title: '产品优势',
        description:'60周岁保单周年日起每年提供5%保额医疗金，累计30%保额 为限，     全面覆盖门诊、住院，二级及二级以上医院社保内全额报销，不扣除其他渠道的医疗费用补偿',
      },
    ];
    const servicedata = [
      {
        title: '保险服务',
        description:<div>
                      <p>1、保险保全</p>
                      <p>保险保全保险保全保险保全保险保全保险保全保险保全保险保全保险保全保险保全保险保全保险保全</p>
                      <p>2、理赔咨询</p>
                      <p>理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询理赔咨询</p>
                    </div>,
      },
      {
        title: '免费增值服务',
        description:<div>
                      <p>1、在线培训服务</p>
                      <p>在线培训服务在线培训服务在线培训服务在线培训服务在线培训服务在线培训服务在线培训服务在线培训服务在线培训服务在线培训服务在线培训服务在线培训服务</p>
                      <p>2、人员管理服务</p>
                      <p>人员管理服务人员管理服务人员管理服务人员管理服务人员管理服务人员管理服务人员管理服务人员管理服务</p>
                      <p>3、任务管理服务</p>
                      <p>任务管理服务任务管理服务任务管理服务任务管理服务任务管理服务任务管理服务任务管理服务任务管理服务任务管理服务任务管理服务任务管理服务任务管理服务任务管理服务</p>
                    </div>,
      },
    ];
    const columns = [{
      title: '保险责任',
      dataIndex: 'name',
      render: text => <a >{text}</a>,
    }, {
      title: '保额',
      className: 'column-money',
      dataIndex: 'money',
    }];
    const liabilitydata = [{
      key: '1',
      name: '意外身故',
      money: '30万元  （武装押运人员保额为20万）',
    }, {
      key: '2',
      name: '意外伤残',
      money: '30万元  （武装押运人员保额为20万）',
    }, {
      key: '3',
      name: '意外医疗',
      money: '3万元  （武装押运人员保额为2万）',
    }, {
      key: '4',
      name: '意外住院津贴',
      money: '100元/天   （武装押运人员保额为50元/天）',
    }, {
      key: '5',
      name: '保费',
      money: '180元/人',
    }];
    return (
      <Container className="insurancescheme">
        <h3 className="insurancetitle">安保无优全年意外项目计划书</h3>
        <p className="insurancetext">
          <span>尊敬的XXXX保安公司：</span>
          <br />
          <span>感谢您对安保无忧全年意外险（30万计划）的亲睐！ ！ ！</span>
        </p>
        <Card title="现代保安公司的风险暨风险需求分析">
          <List
          itemLayout="horizontal"
          dataSource={moderndata}
          renderItem={item => (
            <List.Item>
              <List.Item.Meta
                avatar={<Avatar src={TitleBlue} style={{ }}/>}
                title={<a>{item.title}</a>}
                description={item.description}
              />
            </List.Item>
          )}
         />
       </Card>
        <Card title="保险保险内容">
          <Table
            columns={columns}
            dataSource={liabilitydata}
            bordered
            pagination={false}
          />
          <List
          itemLayout="horizontal"
          dataSource={contentdata}
          renderItem={item => (
            <List.Item>
              <List.Item.Meta
                avatar={<Avatar src={TitleBlue} style={{ }}/>}
                title={<span>{item.title}</span>}
                description={item.description}
              />
            </List.Item>
          )}
          />
        </Card>
        <Card title="享受权利及服务">
          <List
          itemLayout="horizontal"
          dataSource={servicedata}
          renderItem={item => (
            <List.Item>
              <List.Item.Meta
                avatar={<Avatar src={TitleBlue} style={{ }}/>}
                title={<a>{item.title}</a>}
                description={item.description}
              />
            </List.Item>
          )}
        />
        </Card>
        <div className="customerservice">
          <div className="customerservicetotle">
            <span className="customerservicetext">如有疑问，欢迎拨打百保盾客服电话：</span>
            <span className="customerservicephone">400-662-9696</span>
          </div>
          <div className="customerservicebtn">
            <Button>下载PDF</Button>
            <Button
            onClick={() => {
              window.print();
            }}
            >在线打印</Button>
            <Button>获取其他方案</Button>
            <Button type="primary">立即购买</Button>
          </div>
        </div>
      </Container>
    );
  }
}

const Container = style.div`
  padding:24px;
  .insurancetitle{
    padding-bottom:13px;
    border-bottom: 1px solid #e8e8e8;
    font-size: 20px;
    color: #333333;
    font-weight:bold;
    font-family: PingFangSC-Medium;
  }
  .insurancetext{
    font-family: PingFangSC-Medium;
    font-size: 14px;
    color: #666666;
  }
  .ant-card{
    margin-top:15px;
  }
  .ant-card-body{
    padding:5px 12px;
  }
  .ant-card-head{
    background-color:#F5F9FF;
    padding:0;
  }
  .ant-card-head-title{
    margin-left:24px;
    color:#666666;
    font-weight:bold;
  }
  .ant-list-item-meta-avatar{
    width: 6px;
    height:6px;
    position:relative;
    top:7px;
    left:10px;
  }
  .ant-avatar{
    width: 6px;
    height:6px;
  }
  .ant-list-item-meta-title>a{
    color:#0F71FF;
  }
  .ant-list-item-meta-description{
    font-size:12px;
    color:#666666;
  }
  .ant-list-item-meta-description div p{
    margin-bottom: 0px;
    fontSize: 12px;
  }
  .totalcost{
    font-size:14px;
    color:#FF420F;
    margin-left:-12px;
  }
  .totalcostimg{
    margin-top:-3px;
  }
  .totalcostcount{
    margin-left:6px;
  }
  .totalcostremark{
    color:#2A2A2A;
  }
  .ant-table-thead tr th{
    color:#333333 ;
    font-size:12px;
    font-weight:bold;
   
  }
  .ant-table-row td{
    color:#666666 ;
    font-size:12px;
  }
  .ant-table-row td a{
    color:#666666 ;
    font-size:12px;
  }
  th.column-money,
  td.column-money {
    text-aligh:center;
  }
  .ant-table-wrapper{
    padding:10px 10px 0 10px;
  }
  .ant-table-tbody tr:nth-of-type(5) td:nth-of-type(2){
    color:#FF420F;
  }
  .customerservicetext{
    font-family: PingFangSC-Regular;
    font-size: 14px;
    color: #333333;
  }
  .customerservicephone{
    font-family: PingFangSC-Regular;
    font-size: 20px;
    color: #0F71FF;
  }
  .customerservice{
    padding:15px 0;
  }
  .customerservicetotle{
    float:left;
  }
  .customerservicebtn{
    float:right;
  }
  .customerservicebtn button{
    margin-left:5px;
  }
`;
