
export default function() {
  return [
    {
      title: '任务单号',
      dataIndex: 'comWalletVoucherEventId',
      key: 'comWalletVoucherEventId',
    },
    {
      title: '创建时间',
      dataIndex: 'createTime',
      key: 'createTime',
    },
    
    {
      title: '交易时间范围',
      dataIndex: 'startDate',
      key: 'startDate',
      render: (text, record) => {
        const { startDate, endDate } = record;
        return (
          `${startDate}~${endDate}`
        );
      }
    },
    {
      title: '状态',
      dataIndex: 'processStatus',
      key: 'processStatus',
      render: text => {
        switch(true) {
          case text == 0:
            return <span style={{color: 'orange'}}>处理中</span>;
          case text == 1:
            return <span style={{color: 'green'}}>已处理</span>;
          default:
            return '';
        }
      }
    },
    {
      title: '操作',
      dataIndex: 'downloadUrl',
      key: 'downloadUrl',
      width: 200,
      fixed: 'right',
      render: (text, record) => {
        if(text) {
          return (
            <a href={text} target="_blank">下载到本地</a>
          );
        }
        return (
          <span style={{color: '#999'}}>下载到本地</span>
        );
      }
    },
  ];
} 