import $nModal from '../../../../utils/modal/nModal';
import $modal from '../../../../utils/modal';
import OpenVideo from '../../GIS/APicture/openVideo';
/**
 * 
 * @param {*} data 
 * @param {*} name 
 * @param {*} type :判断是态势，还是驻勤点（如果是驻勤点，样式就一套。如果是态势，就要根据name来展示不一样的样式）
 * @returns 
 */
//定义一张图图层的信息窗体
export default function (data, name, optionType) {
  console.log(data)
  //定义最底部按钮
  var button = document.createElement("div");
  button.className = 'button'
  const { position, userName, phone, equipmentName, equipmentId, company, type, status, definition, belong, heightPosition, PRINCIPALNAME, PRINCIPALPHONENO, ATTENDANCESITENAME, ATTENDANCESITEADDRESS, ATTENDANCESITEFULLADDRESS, PERFORMRANGE, OFFICEPOLICEADDRESS, CONTRACTSTATE, SERVEOBJECTNAME, ATTENDANCESITECONTENT } = data;
  var content = [];
  switch (optionType) {
    case 'perception':
      switch (name) {
        case '无人机':
          content = _renderContent(equipmentName, [
            {
              name: '位置：',
              data: position
            }, {
              name: '责任单位：',
              data: company
            }, {
              name: '责任人：',
              data: userName
            }, {
              name: '责任人电话：',
              data: phone
            }
          ])
          button.innerHTML = '播放视频'
          button.onclick = () => {
            openVideo()
          }
          break;
        case '对讲机':
          content = _renderContent(equipmentName, [
            {
              name: '设备id：',
              data: equipmentId
            }, {
              name: '位置：',
              data: position
            }, {
              name: '拥有者：',
              data: belong
            }
          ])
          button.innerHTML = '历史轨迹'
          button.onclick = () => {
            $modal('该功能正在开发中...', '', null, 'warning');
          }
          break;
        case '视频监控':
          content = _renderContent(equipmentName, [
            {
              name: '设备id：',
              data: equipmentId
            }, {
              name: '地址：',
              data: position
            }, {
              name: '清晰度：',
              data: definition
            }, {
              name: '状态：',
              data: status
            }, {
              name: '高度位置：',
              data: heightPosition
            }
          ])
          button.innerHTML = '播放视频'
          button.onclick = () => {
            openVideo()
          }
          break;
        case '执法记录仪':
          content = _renderContent(equipmentName, [
            {
              name: '设备id：',
              data: equipmentId
            }, {
              name: '地址：',
              data: position
            }, {
              name: '清晰度：',
              data: definition
            }, {
              name: '状态：',
              data: status
            }, {
              name: '高度位置：',
              data: heightPosition
            }
          ])
          button.innerHTML = '历史轨迹'
          button.onclick = () => {
            $modal('该功能正在开发中...', '', null, 'warning');
          }
          break;
        case '车牌识别':
          content = _renderContent(equipmentName, [
            {
              name: '设备id：',
              data: equipmentId
            }, {
              name: '地址：',
              data: position
            }, {
              name: '清晰度：',
              data: definition
            }, {
              name: '状态：',
              data: status
            }, {
              name: '垂直位置：',
              data: heightPosition
            }, {
              name: '类型：',
              data: type
            }
          ])
          button.innerHTML = '播放视频'
          button.onclick = () => {
            openVideo()
          }
          break;
        case '人脸识别':
          content = _renderContent(equipmentName, [
            {
              name: '设备id：',
              data: equipmentId
            }, {
              name: '地址：',
              data: position
            }, {
              name: '清晰度：',
              data: definition
            }, {
              name: '状态：',
              data: status
            }, {
              name: '垂直位置：',
              data: heightPosition
            }, {
              name: '类型：',
              data: type
            }
          ])
          button.innerHTML = '播放视频'
          button.onclick = () => {
            openVideo()
          }
          break;
        default:
          content = _renderContent(equipmentName, [
            {
              name: '位置：',
              data: position
            }
          ])
          break;
      }
      break;
    case 'attendance':
      content = _renderContent(ATTENDANCESITENAME, [
        {
          name: '负责人姓名：',
          data: PRINCIPALNAME
        }, {
          name: '负责人电话：',
          data: PRINCIPALPHONENO
        }, {
          name: '驻勤点省市区：',
          data: ATTENDANCESITEADDRESS
        }, {
          name: '驻勤点详细地址：',
          data: ATTENDANCESITEFULLADDRESS
        }, {
          name: '执勤范围(米)：',
          data: PERFORMRANGE
        }, {
          name: '所属监管机构：',
          data: OFFICEPOLICEADDRESS
        }, {
          name: '服务对象名称：',
          data: SERVEOBJECTNAME
        }, {
          name: '合同状态：',
          data: CONTRACTSTATE
        }
      ])
      button.innerHTML = '驻勤内容'
      button.onclick = () => {
        $nModal({
          title: ATTENDANCESITENAME,
          footer: null,
          width: 400,
          content: (
            <div>
              {ATTENDANCESITECONTENT}
            </div>
          )
        });
      }
      break;
  }
  content.join("<br/>");
  var divInfo = document.createElement("div");
  divInfo.className = this.props.mapStyle
  var info = document.createElement("div");
  info.className = "content-window-card-picture ";
  divInfo.appendChild(info);
  // 定义内容
  var middle = document.createElement("div");
  middle.innerHTML = content;
  info.appendChild(middle);
  //定义关闭按钮
  var detail = document.createElement("div");
  detail.className = "close-div";
  var a = document.createElement("a");
  a.innerHTML = "x";
  a.onclick = () => {
    // this.state.map.clearInfoWindow();
    this.clear('clearInfoWindow')
  };
  detail.appendChild(a);
  info.appendChild(detail);
  //加入最底部按钮
  info.appendChild(button)
  return divInfo;
}

function _renderContent(equipmentName, list) {
  let renderContent = []
  list.map(item => {
    renderContent.push(
      "<div class='list'><span class='name'>" + item.name + "</span><span class='data'>" +
      item.data +
      "</span></div>"
    )
  })
  let content = []
  content.push(
    "<div class='info'><div class='title'>" + equipmentName + "</div><div class=message>" + renderContent.toString().replace(/,/g, "") + "</div></div>"
  );
  return content;
}

//打开视频
function openVideo() {
  let url = "https://wvp.test.baibaodun.cn/#/play/wasm/wss%3A%2F%2Fwvp.test.baibaodun.cn%2Frtp%2Fgb_play_44010200492000000002_34090000001320000001.flv"
  // return $nModal({
  //   title: null,
  //   footer: null,
  //   width: 700,
  //   content: (
  //     <OpenVideo />
  //   )
  // });
  return OpenVideo({

  })
}