/**
 * IM可视化视图
 */
import React, { Component } from 'react';
import { Pagination, Badge, Tooltip, Popover } from 'antd';
import { connect } from 'dva';
import './im.less';
import ConversationList from './ConversationList';
// import FriendList from './FriendList';
@connect(state => ({
  totalUnreadCount: state.im.totalUnreadCount
}))
export default class SideBar extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showConversationList: true,
      // showFriendList: false,
      conversationID: props.conversationID
    };
  }

  componentDidMount() { }
  componentWillReceiveProps(nextProps) {
    this.setState({
      conversationID: nextProps.conversationID
    });
  }

  render() {
    return (
      <div className="side-bar-wrapper">
        <div className="bar-content">
          <ConversationList
            visible={this.state.showConversationList}
            conversationID={this.state.conversationID}
          />
        </div>
      </div>
    );
  }
}
