import eventCenter from "@common/events"; // 引入 EventEmitter
import { getDomainInfo, getDomainList } from '@services/api';
import { isEmpty } from '@utils/utils';

// 公司定位信息展示
export function showCompanyPointInfo({ doMainId, success = null }){
  // 清除地图所有标记
  eventCenter.emit('clearMapTag');
  // 初始化右侧数据模块
  eventCenter.emit('initRightDataModule');
  eventCenter.emit('clearMapModal', 'ComponeyInfo');
  eventCenter.emit('clearMapModal', 'AttendInfo');
  eventCenter.emit('isOpenTopSwitch', {
    type: "searchViews",
    value: false
  })
  getDomainInfo({ domainId: doMainId }).then(res => {
    // TAG: v5baseRequest 对于 res.data 的情况，会返回 res 不作任何处理，以下做为指定接口的处理
    if (res.code == 0 && res.data.length>0) {
      let datas = res.data[0]
      // TAG: 因需求变更，不再获取公司定位信息
      // var placeSearch = new AMap.PlaceSearch({ city: '全国' });
      // placeSearch.search(datas.field13, (status, result) => {
        // 搜索成功时，result即是对应的匹配数据
        // if (status === "complete" && result.poiList.count > 0) {
          // let location = result.poiList.pois[0].location;
          let info = {
            // latitude: location.lat,
            // longitude: location.lng,
            companyName: datas.name,
            componeyLogo: datas.logo_url,
            name: datas.legalperson,
            mobilePhone: datas.legalpersonphone,
            selectComponeyId: datas.id
          }
          info.clickType = 'personnel';
          success && success(info);
        // } else {
        // }
      // })
    }
  })
}

// 获取公司列表信息
export function getCompanyList({ keyWord = '', success = null, pageNo = 1, pageSize = 5, hasMark = true }){
  // 清除地图所有标记
  eventCenter.emit('clearMapTag');
  // 初始化右侧数据模块
  eventCenter.emit('initRightDataModule');
  eventCenter.emit('clearMapModal', 'ComponeyInfo');
  eventCenter.emit('clearMapModal', 'AttendInfo');
  // eventCenter.emit('isOpenTopSwitch', {
  //   type: "searchViews",
  //   value: false
  // })
  let params = {};
  if (!isEmpty(keyWord)) {
    params.domainname = keyWord;
  }

  getDomainList(params).then(res => {
    console.log('getCompanyList', res);
    if (res.data.length > 0) {
      let datas = [];
      res.data.forEach((item, index) => {
        let data = {};
        let location = item.location && JSON.parse(item.location)
        if (location) {
          data.longitude = location.longitude || ''
          data.latitude = location.latitude || ''
        } else {
          location = item.field17 ? item.field17.split(',') : ['', ''];
          data.longitude = location[0] || ''
          data.latitude = location[1] || ''
        }
        data.name = item.legalperson ? item.legalperson : '';
        data.mobilePhone = item.legalpersonphone ? item.legalpersonphone : '';
        data.companyName = item.name;
        data.componeyLogo = item.logo_url;
        data.selectComponeyId = item.id;
        datas.push(data);
      });
      if (hasMark) {
        eventCenter.emit('addPictueMarks', {
          data: {
            data: datas,
          },
          type: 'securityCompany'
        });
      }
      success && success(datas);
    } else {
      success && success([]);
    }
  }).catch(error =>{
    console.error(error);
  })
}
