//渲染每一个人员item
/**
 * 通过搜索获得地图列表(保安人员)
 */
import React, { Component } from "react";
import { connect } from "dva";
import classNames from 'classnames';
import { Pagination, message, Icon, Modal, Button, Tooltip } from "antd";
import styles from "./index.less";
import eventCenter from "@common/events"; // 引入 EventEmitter
import PersonItem from "../SearchListTab/PersonMessage/PersonItem";
// import "../person.less";
const { confirm } = Modal;
@connect((state) => ({
  selectedId: state.command.personList.selectedId,
  layoutAuthority: state.command.layoutAuthority,
  mapStyle: state.command.mapStyle,
  //   tabIndex2: state.command.tabIndex.person.tabIndex2,
}))
export default class PoliceList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: props.data || [],
      // height: '',Z
      loadingText: "",
    };
  }

  componentDidMount() { }
  componentWillReceiveProps(nextProps) {
    this.setState({
      loadingText: nextProps.loadingText,
    });
    if (nextProps.data != this.state.data) {
      this.setState({
        data: nextProps.data,
      });
    }
  }
  render() {
    const {  mapStyle } = this.props
    const clsString = classNames(styles[mapStyle], 'security', 'search-list_command', 'amap_lib_placeSearch');
    return (
      <div className={clsString} >
        <div
          className="list"
          style={{ maxHeight: this.state.height, overflow: "auto" }}
        >
          <PersonItem
            data={this.state.data}
            loadingText={" "}
          />
        </div>
      </div>
    );
  }
}
