import React, { Component } from 'react';

import {
  Modal,
  message,
  Alert
} from "antd";
import {

} from '../../../services/api';
import PTable from '../../../components/Pro/PTable';

export default class DeleteShiftsModal extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      total: 0
    }
  }


  componentWillReceiveProps(props) {

  }
  componentDidMount() {

  }

  render() {
    return (
      <Modal
        title="移除班次"
        visible={this.props.visible}
        width={600}
        destroyOnClose={true}
        maskClosable={false}
        onCancel={() => this.props.setState({ deleteVisible: false })}
        okText="移除"
        okType='danger'
        onOk={() => {
          if(this.state.selectedRows) {
            this.props.onOk && this.props.onOk(this.state.selectedRows, () => {
              this.setState({
                selectedRowKeys:null,
                selectedRows:null,
              });
            });
          }else {
            message.error("你还没选中班次");
          }
        }}
      >
        <Alert
          message='只有未被安排过的班次才可以移除，请勾选需要移除的班次并点击移除即可'
          type="warning"
          showIcon
        />
        {
          !!this.props.comTaskId &&
          <PTable
            style={{ marginTop: 20 }}
            columns={[
              {
                title: '班次名称',
                dataIndex: 'shiftName',
                key: 'shiftName'
              },
              {
                title: '出勤时间',
                dataIndex: 'shiftRuleDetail',
                key: 'shiftRuleDetail',
              }
            ]}
            url="getNoSchedulShiftList"
            pageParm={{ pageNumber: 1, pageSize: 10, comTaskId: this.props.comTaskId }}
            forceUpdate={false}
            rowSelection={{
              onChange: (selectedRowKeys, selectedRows) => {
                this.setState({
                  selectedRows,
                  selectedRowKeys
                });
              },
              selectedRowKeys: this.state.selectedRowKeys || []
            }}
            dateChange={({total}) => {
              this.setState({
                total
              });
            }}
          />
        }
      </Modal>
    );
  }
}
