/**
 * 购买云会议资源
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Form, Alert, Tabs, Breadcrumb, Button } from "antd";
import SelectResource from "./SelectResource";
import SelectAddServices from "./SelectAddServices";
import SelectHardEquipment from "./SelectHardEquipment";
import ConfirmOrder from "./ConfirmOrder";
import "../../meeting.less";
import { formatCurrency } from "../../../../utils/utils";
const { TabPane } = Tabs;
@connect(state => ({
  comName: state.global.companyInfo.comName,
  // mobilePhone: state.user.currentUser.mobilePhone
}))
@Form.create()
export default class BuyResource extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      buyMeetingResource: [], //选择会议资源
      buyHardEquipment: [], //选择硬件资源
      buyAddServices: [], //选择增值服务
      mergeList: [], //合并后的所有购买资源
      totalAmount: 0, //总价
      keyTab: "1",
      randomNum: 1 //随机值
    };
  }
  //过滤每个人的购买列表
  _filterBuyList(buyList, itemInfoList, itemName,productServiceType) {
    const productInfoList = itemInfoList.filter(list => {
      return list.amount > 0;
    });
    if (productInfoList.length > 0) {
      productInfoList.map(infolist => {
        buyList.push({
          name: itemName,
          productServiceType,
          ...infolist
        });
      });
    }
    return buyList;
  }
  //合并金额
  _merge() {
    let buyMeetingResource = [];
    this.state.buyMeetingResource.map(item => {
      buyMeetingResource = this._filterBuyList(
        buyMeetingResource,
        item.productInfoList,
        item.name,
        item.productServiceType
      );
    });
    let buyHardEquipment = [];
    this.state.buyHardEquipment.map(item => {
      buyHardEquipment = this._filterBuyList(
        buyHardEquipment,
        item.productInfoList,
        item.name,
        item.productServiceType
      );
    });
    let buyAddServices = [];
    this.state.buyAddServices.map(item => {
      buyAddServices = this._filterBuyList(
        buyAddServices,
        item.productInfoList,
        item.name,
        item.productServiceType
      );
    });
    const mergeList = buyMeetingResource.concat(
      buyHardEquipment.concat(buyAddServices)
    );
    if (mergeList.length > 0) {
      let totalAmount = 0;
      mergeList.forEach(item => {
        totalAmount += item.amount;
      });
      this.setState({
        totalAmount
      });
    } else {
      this.setState({
        totalAmount: 0
      });
    }
    this.setState({
      mergeList
    });
  }
  //下一步按钮统一渲染
  renderNextState() {
    return (
      <Button
        className="next"
        type="primary"
        style={{ float: "right" }}
        onClick={() => {
          this.nextState("add");
        }}
      >
        下一步
      </Button>
    );
  }
  //上一步按钮统一渲染
  renderBackState() {
    return (
      <Button
        className="after"
        type="primary"
        onClick={() => {
          this.nextState("reduce");
        }}
      >
        上一步
      </Button>
    );
  }
  nextState(param) {
    if (param === "add") {
      //加一步
      this.setState({
        keyTab: (parseInt(this.state.keyTab) + 1).toString(),
        randomNum: Math.random()
      });
    } else {
      // 减一步
      this.setState({
        keyTab: (parseInt(this.state.keyTab) - 1).toString(),
        randomNum: Math.random()
      });
    }
  }
  render() {
    const { mergeList, totalAmount } = this.state;
    return (
      <div className="buy-resource">
        <Alert
          message={
            <div style={{ color: "#333" }}>
              <div>
                1、购买云会议资源，仅支持企业钱包支付，请提前充值购买资金到企业钱包中（若未开通，请访问【组织权益】-【企业钱包】进行开通）；
              </div>
              <div>
                2、下单支付完成后，请等待系统配置资源，预计1~2个工作日后配置完成；
              </div>
              <div>
                3、若您需要增加购买其他内容，可重新下单，勾选需要的产品进行购买即可。
              </div>
            </div>
          }
          type="warning"
          showIcon
          style={{ marginBottom: "15px" }}
        />
        <Tabs
          defaultActiveKey={this.state.keyTab}
          tabPosition="top"
          className="select-buy-resource"
          key={this.state.randomNum}
          onChange={value => {
            this.setState({
              keyTab: value
            });
          }}
        >
          <TabPane tab="选择会议资源" key="1">
            <div>
              <SelectResource
                changeTotal={buyList => {
                  this.setState(
                    {
                      buyMeetingResource: buyList
                    },
                    () => {
                      this._merge();
                    }
                  );
                }}
              />
              <div className="nextState">{this.renderNextState()}</div>
            </div>
          </TabPane>
          <TabPane tab="选择硬件设备" key="2">
            <div>
              <SelectHardEquipment
                changeTotal={buyList => {
                  this.setState(
                    {
                      buyHardEquipment: buyList
                    },
                    () => {
                      this._merge();
                    }
                  );
                }}
              />
              <div className="nextState">
                {this.renderBackState()}
                {this.renderNextState()}
              </div>
            </div>
          </TabPane>
          <TabPane tab="选择增值服务" key="3">
            <div>
              <SelectAddServices
                changeTotal={buyList => {
                  this.setState(
                    {
                      buyAddServices: buyList
                    },
                    () => {
                      this._merge();
                    }
                  );
                }}
              />
              <div className="nextState">
                {this.renderBackState()}
                {this.renderNextState()}
              </div>
            </div>
          </TabPane>
          <TabPane
            tab={
              <span>
                <span>确认订单</span>
                <span style={{ color: "#F59A23" }}>
                  （{formatCurrency(totalAmount)}元）
                </span>
              </span>
            }
            key="4"
            className="confirm-order"
          >
            <div>
              <ConfirmOrder
                mergeList={mergeList}
                totalAmount={totalAmount}
                renderBackState={this.renderBackState}
                changeKeyTab={value => {
                  this.props.changeKeyTab(value);
                }}
              >
                {/* 把确认订单的上一步按钮调成同一行 */}
                <span className="nextState" style={{marginRight: "20px",marginLeft:0}}>{this.renderBackState()}</span>
              </ConfirmOrder>
              {
                this.state.keyTab==="4"?"":<div className="nextState">{this.renderBackState()}</div>
              }
            </div>
          </TabPane>
        </Tabs>
      </div>
    );
  }
}
