/**
 * 绘制矢量图
 */
import React, { Component } from "react";
import { Row, Col, Tooltip } from "antd";
import "./index.less";
import { connect } from "dva";
const _CHANGE_STATUS = ['cancel', 'circle', 'rectangle', 'polygon'];
const _CHANGE_TIP = ['单选', '圈选', '框选', '多边选择'];
@connect((state) => ({
  selectedId: state.command.personList.selectedId,
  mapStyle: state.command.mapStyle
}))
export default class Vectorgraph extends Component {
  constructor(props) {
    super(props);
    this.state = {
      paintValue: props.paintValue,
    };
  }

  componentDidMount() { }
  componentWillReceiveProps(nextPorps) {
    this.setState({
      paintValue: nextPorps.paintValue,
    });
  }
  //把点击的状态值返回给上级
  returnParent(selectValue) {
    this.props.changeSelect(selectValue);
    if (this.props.selectedId) {
      this.props.dispatch({
        type: "command/setPersonSelectIndex",
        payload: null,
      });
      this.props.dispatch({
        type: "command/clearInfoWindow",
        payload: true,
      });
    }
  }
  _renderPicture(param) {
    const { paintValue } = this.state
    const { mapStyle } = this.props
    switch (paintValue == param) {
      case true:
        return require("@assets/images/prevention/" + param + "-click.png")
      case false:
        if (mapStyle == 'dark') {
          return require("@assets/images/prevention/" + param + "-white.png")
        } else {
          return require("@assets/images/prevention/" + param + ".png")
        }
    }
  }
  // 切换
  _onChangeParent=(paintValue)=>{
    this.setState({
      paintValue,
    });
    const { _thisGIS } = this.props;
    this.returnParent(paintValue);
  }
  render() {
    const { mapStyle } = this.props
    const { paintValue } = this.state;
    return (
      <div className=" switch vectorgraph">
        {_CHANGE_STATUS.map((value, index)=>{
          return <Tooltip title={_CHANGE_TIP[index]}><div className="layer-btn" onClick={this._onChangeParent.bind(this, value)}>
            <img
              className="layer-img"
              src={
                this._renderPicture(value)
              }
            />
          </div>
          </Tooltip>
        })}
      </div>
    );
  }
}
