import { timestamp } from '../../../../utils/utils'

export default function (pointData) {
  removePathSimplifierIns()
  pointData = pointData.map(item => {
    const lnglat = item.location.split(",")
    return {
      time: timestamp(item.locatetime),
      lnglat: [lnglat[0], lnglat[1]]
    }
  })
  const _this = this
  AMapUI.load(['ui/misc/PathSimplifier'], function (PathSimplifier) {
    if (!PathSimplifier.supportCanvas) {
      alert('当前环境不支持 Canvas！');
      return;
    }
    console.log('ui环境准备完毕')
    var defaultRenderOptions = {
      renderAllPointsIfNumberBelow: 100,
      pathTolerance: 2,
      keyPointTolerance: 0,
      pathLineStyle: {
        lineWidth: 3,
        strokeStyle: '#0E70FF',
        borderWidth: 1,
        borderStyle: '#eeeeee',
        dirArrowStyle: false
      },
      // pathLineHoverStyle: {
      //   lineWidth: 3,
      //   strokeStyle: 'rgba(204, 63, 88,1)',
      //   borderWidth: 1,
      //   borderStyle: '#cccccc',
      //   dirArrowStyle: false
      // },
      // pathLineSelectedStyle: {
      //   lineWidth: 6,
      //   strokeStyle: '#C11534',
      //   borderWidth: 1,
      //   borderStyle: '#cccccc',
      //   dirArrowStyle: true
      // },
      // dirArrowStyle: {
      //   stepSpace: 35,
      //   strokeStyle: '#ffffff',
      //   lineWidth: 2
      // },
      // startPointStyle: {
      //   radius: 4,
      //   fillStyle: '#109618',
      //   lineWidth: 1,
      //   strokeStyle: '#eeeeee'
      // },
      // endPointStyle: {
      //   radius: 4,
      //   fillStyle: '#dc3912',
      //   lineWidth: 1,
      //   strokeStyle: '#eeeeee'
      // },
      // keyPointStyle: {
      //   radius: 3,
      //   fillStyle: 'rgba(8, 126, 196, 1)',
      //   lineWidth: 1,
      //   strokeStyle: '#eeeeee'
      // },
      // keyPointHoverStyle: {
      //   radius: 4,
      //   fillStyle: 'rgba(0, 0, 0, 0)',
      //   lineWidth: 2,
      //   strokeStyle: '#ffa500'
      // },
      // keyPointOnSelectedPathLineStyle: {
      //   radius: 4,
      //   fillStyle: 'rgba(8, 126, 196, 1)',
      //   lineWidth: 2,
      //   strokeStyle: '#eeeeee'
      // }
    };

    var pathSimplifierIns = new PathSimplifier({
      zIndex: 100,
      //autoSetFitView:false,
      map: _this.state.map, //所属的地图实例

      getPath: function (pathData, pathIndex) {

        var points = pathData.points,
          lnglatList = [];

        for (var i = 0, len = points.length; i < len; i++) {
          lnglatList.push(points[i].lnglat);
        }

        return lnglatList;
      },
      getHoverTitle: function (pathData, pathIndex, pointIndex) {
        if (pointIndex >= 0) {
          return pathData.points[pointIndex].time
        }
      },
      // renderOptions: {
      //   renderAllPointsIfNumberBelow: -1,
      //   pathTolerance: 2,
      //   keyPointTolerance: 0,
      //   pathLineStyle: {
      //       lineWidth: 3,
      //       strokeStyle: '#F7B538',
      //       borderWidth: 1,
      //       borderStyle: '#eeeeee',
      //       dirArrowStyle: false
      //   },
      //   pathLineHoverStyle: {
      //       lineWidth: 3,
      //       strokeStyle: 'rgba(204, 63, 88,1)',
      //       borderWidth: 1,
      //       borderStyle: '#cccccc',
      //       dirArrowStyle: false
      //   },

      //   startPointStyle: {
      //       radius: 4,
      //       fillStyle: '#109618',
      //       lineWidth: 1,
      //       strokeStyle: '#eeeeee'
      //   },
      //   endPointStyle: {
      //       radius: 4,
      //       fillStyle: '#dc3912',
      //       lineWidth: 1,
      //       strokeStyle: '#eeeeee'
      //   },
      // }
      renderOptions: defaultRenderOptions
    });

    window.pathSimplifierIns = pathSimplifierIns;

    //设置数据
    pathSimplifierIns.setData([{
      name: '路线0',
      points: pointData
    }]);

    //选中路线0
    // pathSimplifierIns.setSelectedPathIndex(0);

    pathSimplifierIns.on('pointClick', function (e, info) {

      console.log('Click: ' + info.pathData.points[info.pointIndex].name);
    });
  });
}

//清除地图上的轨迹路线
export function removePathSimplifierIns() {
  if (window.pathSimplifierIns) {
    window.pathSimplifierIns.setData([]);
  }
}