import eventCenter from "@common/events"; // 引入 EventEmitter
import { attendanceGetTypeData, getAttendance } from '@services/api';
import { data as typeData } from "@constants/TypeData";
import { isEmpty } from '@utils/utils';

// 驻勤点信息展示
export function showAttendPointInfo({ aid, companyName = "", doMainId, success = null, pageNo = 1, pageSize = 20, hasMark = true }){
  // 清除地图所有标记
  eventCenter.emit('clearMapTag');
  // 初始化右侧数据模块
  eventCenter.emit('initRightDataModule');
  eventCenter.emit('clearMapModal', 'ComponeyInfo');
  eventCenter.emit('clearMapModal', 'AttendInfo');
  // 关闭搜索视图
  eventCenter.emit('isOpenTopSwitch', {
    type: "searchViews",
    value: false
  })

  attendanceGetTypeData({
    _currpage: pageNo,
    lines: pageSize
  }, { zid: aid }).then(res => {
    console.log('showAttendPointInfo', aid, res);
    if (res.data && res.data.data && res.data.data.length > 0) {
      let data = res.data.data[0]
      let param = {
        domainid: doMainId,
        selectAttendId: aid,
        attendName: data.ATTENDANCESITENAME,
        latitude: data.latitude || '',
        longitude: data.longitude|| '',
        componey: companyName,
        name: data.PRINCIPALNAME,
        phone: data.PRINCIPALPHONENO,
        address: data.ATTENDANCESITEADDRESS,
        addressDetail: data.ATTENDANCESITEFULLADDRESS,
        scope: data.PERFORMRANGE,
        org: data.OFFICEPOLICEADDRESS,
        obj: data.SERVEOBJECTNAME,
        contract: data.CONTRACTSTATE,
      }
      // 如果没有符合的图标，默认设置
      let current = typeData.length - 1;
      typeData.map((item, index)=>{
        if (item.key == data.ATTENDANCESITETYPE) {
          current = index;
        }
      })
      param.markerIcon = typeData[current].markerIcon;
      param.clickMarkerIcon = typeData[current].clickMarkerIcon;

      if(hasMark){
        eventCenter.emit('addPictueMarks', {
          data: {
            data: [param],
          },
          type: 'attendancePoint'
        });
      }
      success && success(param)
    }
  })
}

// 驻勤点列表展示
export function showAttendList({doMainId, success = null, doMainName = '', keyWord = ''}){
  let params = {};
  if (isEmpty(keyWord)) {
    params.id = doMainId;
  } else {
    params.name = keyWord
  }
  getAttendance(params).then(res => {
    console.log('showAttendList', res);
    if (res.data) {
      let data = res.data;
      if (data.length == 0) {
        return success && success([]);
      }
      let result = [];
      for (let i = 0; i < data.length; i++) {
        // 对数据字段重新组装
        let rJson = {};
        rJson.lnglat = data[i].item_attendancesitelatitude? [data[i].item_attendancesitelongitude,data[i].item_attendancesitelatitude]:''
        rJson.taskName = data[i].item_attendancesitename
        rJson.attendName = data[i].item_attendancesitename
        rJson.componey = isEmpty(doMainName) ? data[i].item_companyname : doMainName;
        rJson.name = data[i].item_principalname
        rJson.phone = data[i].item_principalphoneno
        rJson.mobilePhone = data[i].item_principalphoneno
        rJson.idCardNo = data[i].item_principalidcardno
        rJson.address = data[i].item_attendancesiteaddress
        rJson.addressDetail = data[i].item_attendancesitefulladdress
        rJson.taskAddress = data[i].item_attendancesitefulladdress
        rJson.scope = data[i].item_performrange
        rJson.org = data[i].item_officepoliceaddress
        rJson.obj = data[i].item_serveobjectname
        rJson.contract = data[i].item_contractstate
        rJson.companyName = isEmpty(doMainName) ? data[i].item_companyname : doMainName;
        rJson.comTaskId = data[i].id
        rJson.perId = data[i].id
        rJson.selectAttendId = data[i].id
        rJson.domainid = doMainId
        rJson.latitude = data[i].item_attendancesitelatitude;
        rJson.longitude = data[i].item_attendancesitelongitude
        rJson.markerIcon = data[i].markerIcon;
        rJson.clickMarkerIcon = data[i].clickMarkerIcon;


        // 如果没有符合的图标，默认设置
        let current = typeData.length - 1;
        typeData.map((item, index)=>{
          if (item.key == data[i].item_attendancesitetype) {
            current = index;
          }
        })
        rJson.markerIcon = typeData[current].markerIcon;
        rJson.clickMarkerIcon = typeData[current].clickMarkerIcon;

        result.push(rJson);
      }

      eventCenter.emit('addPictueMarks', {
        data: {
          data: result,
        },
        type: 'attendancePoint'
      });

      // TAG: 统一驻勤点标记,故注释
      // this.props.dispatch({
      //   type: "command/fetchAllAttendanceList",
      //   payload: {
      //     attendanceList: data,
      //   },
      // });
      success && success(result);
    }
  })
}
