import React, { PureComponent } from "react";
// import Person from "./PersonMessage";
// import Attendance from "./Attendance";
// import Event from "./EventList";
// import PersonSearchList from "./Attendance/PersonSearchList";
import "./index.less";
import { connect } from "dva";
import { Tooltip } from "antd";
import classNames from 'classnames';
import Vectorgraph from "@mapModule/Vectorgraph";
import SwitchArea from '@mapModule/SwitchArea';
import LayerExtensionBtn from '@mapModule/LayerExtensionBtn';
// import Record from "../Record/index";
import SwitchMap from "@mapModule/SwitchMap";
import SwitchChat from '@mapModule/SwitchChat';
import Switch3D from '@mapModule/Switch3D';
import { gup } from '@utils/utils';
// import SwitchSearch from '@mapModule/SwitchSearch';
import SwitchStyle from '@mapModule/SwitchStyle';
import eventCenter from "@common/events"; // 引入 EventEmitter'

/**
 * 最顶部的图标切换
 */
@connect((state) => ({
  mapStyle: state.command.mapStyle,
  switchOpenStatus: state.command.switchOpenStatus,
  mapLayerSwitchState: state.command.mapLayerSwitchState,
}))
export default class TopButton extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      paintValue: "cancel", //选中的是用哪个图形画图
      areaSelect: false
    };
  }

  // 切换图形
  _onChangeSelect=(paintValue)=> {
    const { gisMAP, _thisGIS } = this.props
    this.setState({
      paintValue,
    });
    gisMAP.clearInfoWindow();
    switch (paintValue) {
      case "circle":
        _thisGIS.mouseTool.circle({
          fillColor: "#00b0ff",
          strokeColor: "#80d8ff",
        });
        break;
      case "rectangle":
        _thisGIS.mouseTool.rectangle({
          fillColor: "#00b0ff",
          strokeColor: "#80d8ff",
        });
        break;
      case "polygon":
        _thisGIS.mouseTool.polygon({
          fillColor: "#00b0ff",
          strokeColor: "#80d8ff",
        });
        break;
      case "cancel":
        _thisGIS.mouseTool.close(true);
        break;
    }
  };
  // 切换风格
  _onSwitchStyle=(value)=>{
    const { gisMAP } = this.props;
    var styleName = "amap://styles/" + value;
    gisMAP.setMapStyle(styleName);
  }
  _onSwitch=(param)=>{
    const { localMap, satelliteLayer } = this.props;
    if (param == 'satellite') {
      this.props.setSatellite(true)
      // param = 'dark';
      param = 'normal';
    } else {
      this.props.setSatellite(false)
      localMap.remove(satelliteLayer)
      this._onSwitchStyle(param)
    }
  }
  // 切换图层
  _onSwitchMap=(param)=>{
    const { gisMAP, layerStatus, _thisGIS } = this.props

    this.props.dispatch({
      type: 'command/setMapStyle',
      payload: "normal"
    })

    let style = ""
    if(param=="aPicture"){
      style="dark"
    }else{
      style = "normal"
    }

    var styleName = "amap://styles/" + "normal";
    // 删除轨迹查看的弹窗组件
    const divs = document.getElementsByClassName('n_trajectory');
    if (divs) {
      Reflect.apply(Array.prototype.forEach, divs, [item => {
        ReactDom.unmountComponentAtNode(item);
        document.body.removeChild(item);
      }]);
    }

    gisMAP.setMapStyle(styleName);
    // this.props.switchMap(param)


    _thisGIS.mouseTool.close(true);
    gisMAP.clearInfoWindow();

    let setJSON = {
      paintValue: "cancel",
    };
    // _thisGIS.setState({
    //   paintValue: "cancel",
    // });

    if (param !== layerStatus) {
      //有切换的时候才进行数据的处理
      //如果是切换地图的
      setJSON.searchList = [];
      // _thisGIS.setState({ searchList: [] });
      //为真的时候是海量图，为假是普通图
      switch (param) {
        case "attendance":
          //换成驻勤点图
          setJSON.layerSatatus = param;
          setJSON.map = _thisGIS.state.normalMap
          // _thisGIS.setState({
          //   layerSatatus: param,
          //   map: _thisGIS.state.normalMap,
          // });
          //创建矢量图画图工具
          _thisGIS.createMouseTool(_thisGIS.state.normalMap);
          break;
        case "person":
          setJSON.layerSatatus = param;
          setJSON.map = _thisGIS.state.personMap
          // _thisGIS.setState({
          //   layerSatatus: param,
          //   map: _thisGIS.state.personMap,
          // });
          //创建矢量图画图工具
          _thisGIS.createMouseTool(_thisGIS.state.personMap);
          break;
        case "aPicture":
          //换成一张图图层
          setJSON.layerSatatus = param;
          setJSON.map = _thisGIS.state.locaMap
          // _thisGIS.setState({
          //   layerSatatus: param,
          //   map: _thisGIS.state.locaMap,
          // });
          //创建矢量图画图工具
          _thisGIS.createMouseTool(_thisGIS.state.locaMap);
          break;
        case "police":
          //换成警保联动图层
          setJSON.layerSatatus = param;
          setJSON.map = _thisGIS.state.policeMap
          // _thisGIS.setState({
          //   layerSatatus: param,
          //   map: _thisGIS.state.policeMap,
          // });
          // //创建矢量图画图工具
          // this.createMouseTool(this.state.policeMap);
          break;
        case "nanNing":
          //换成警保联动图层
          setJSON.layerSatatus = param;
          setJSON.map = _thisGIS.state.nanNingMap
          // _thisGIS.setState({
          //   layerSatatus: param,
          //   map: _thisGIS.state.nanNingMap,
          // });
          // //创建矢量图画图工具
          // _thisGIS.createMouseTool(_thisGIS.state.policeMap);
          break;
      }
    }
    _thisGIS.setState(setJSON);
    if (param === "aPicture") {
      _thisGIS.setSatellite(true)
    } else {
      _thisGIS.setSatellite(false)
    }
  }
  // 切换 IM
  _onSwitchChat=()=>{
    // this.setState({ imStatus: !this.state.imStatus });
    eventCenter.emit('changeImStatus', 'change');
    const { gisMAP } = this.props;
    gisMAP.clearInfoWindow();
  }
  render() {
    const { mapStyle, layerStatus, localMap, _thisGIS, conversationID } = this.props;
    const { paintValue } = this.state;

    const clsNameRadio =  classNames("radio_container", mapStyle);
    const hasaPicture = layerStatus == 'aPicture' ? true : false;
    const hasPolice = layerStatus == 'police' ? true : false;
    const hasNanNing = layerStatus == 'nanNing' ? true : false;

    return (
      <div className={clsNameRadio} style={{ display: 'flex' }}>
        {/* 绘制矢量图 */}
        { hasaPicture && <LayerExtensionBtn /> }
        { hasaPicture && <div className="border-line" />}
        {
          !hasNanNing && <Vectorgraph
            _thisGIS={_thisGIS}
            changeSelect={this._onChangeSelect.bind(this)}
            paintValue={paintValue}
          />
        }
        { hasaPicture && <div className="border-line" />}
        {/* 上下左右按钮，搜索图层不含 */}
        {/* { hasaPicture && resourceViews && <SwitchOpen />} */}
        {/* { hasaPicture && resourceViews && <div className="border-line" />} */}
        {/* 切换搜索框 */}
        {/* { hasaPicture && <SwitchSearch />} */}
        { hasaPicture && <SwitchArea _thisGIS={_thisGIS} />}
        {/* 切换风格颜色 */}
        {
          ( hasaPicture || hasPolice|| hasNanNing) && <SwitchStyle
            // switchStyle={this._onSwitchStyle}
            onSwitch={this._onSwitch.bind(this)}
            // locaMap={localMap}
            satellite={this.state.satellite}
            // setSatellite={this.setSatellite.bind(this)}
            // satelliteLayer={this.state.satelliteLayer}
            layerStatus={layerStatus}
            that={this}
          />
        }
        { hasaPicture && <div />}
        {/* 地图切换 */}
        {
          gup('app_type', window.location.href) == 1 ? '' : <SwitchMap
            _thisGIS={_thisGIS}
            layerStatus={layerStatus}
            onSwitchMap={this._onSwitchMap.bind(this)}
          />
        }
        {/* im聊天界面 */}
        {
          gup('app_type', window.location.href) == 1 ? '' : <SwitchChat
            onClick={this._onSwitchChat.bind(this)}
            // imStatus={this.state.imStatus}
            conversationID={conversationID}
          />
        }
        {/* 3d切换 */}
        { hasaPicture && <Switch3D localMap={localMap} />}
      </div>
    );
  }
}
