function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Interaction = require('./base');

var getFieldRange = require('./helper/get-field-range');

var getLimitRange = require('./helper/get-limit-range');

var DEFAULT_TYPE = 'X';

var ScrollBar = /*#__PURE__*/function (_Interaction) {
  _inheritsLoose(ScrollBar, _Interaction);

  var _proto = ScrollBar.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Interaction.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      startEvent: null,
      processEvent: null,
      endEvent: null,
      resetEvent: null,
      type: DEFAULT_TYPE,
      xStyle: {
        backgroundColor: 'rgba(202, 215, 239, .2)',
        fillerColor: 'rgba(202, 215, 239, .75)',
        size: 4,
        lineCap: 'round',
        offsetX: 0,
        offsetY: -10
      },
      yStyle: {
        backgroundColor: 'rgba(202, 215, 239, .2)',
        fillerColor: 'rgba(202, 215, 239, .75)',
        size: 4,
        lineCap: 'round',
        offsetX: 8,
        offsetY: 0
      }
    });
  };

  _proto._renderScrollBars = function _renderScrollBars() {
    var chart = this.chart;
    var scrollBarCfg = chart.get('_scrollBarCfg');
    if (!scrollBarCfg) return;
    var data = chart.get('data');
    var plotRange = chart.get('plotRange');
    plotRange.width = Math.abs(plotRange.br.x - plotRange.bl.x);
    plotRange.height = Math.abs(plotRange.tl.y - plotRange.bl.y);
    var backPlot = chart.get('backPlot');
    var canvas = chart.get('canvas');
    var canvasHeight = canvas.get('height');
    var limitRange = chart.get('_limitRange');
    var type = scrollBarCfg.type;

    if (type.indexOf('X') > -1) {
      var _scrollBarCfg$xStyle = scrollBarCfg.xStyle,
          offsetX = _scrollBarCfg$xStyle.offsetX,
          offsetY = _scrollBarCfg$xStyle.offsetY,
          lineCap = _scrollBarCfg$xStyle.lineCap,
          backgroundColor = _scrollBarCfg$xStyle.backgroundColor,
          fillerColor = _scrollBarCfg$xStyle.fillerColor,
          size = _scrollBarCfg$xStyle.size;
      var xScale = chart.getXScale();
      var xLimitRange = limitRange[xScale.field];

      if (!xLimitRange) {
        xLimitRange = getLimitRange(data, xScale);
        limitRange[xScale.field] = xLimitRange;
      }

      var currentRange = getFieldRange(xScale, xLimitRange, xScale.type);
      var horizontalBar = chart.get('_horizontalBar');
      var yPos = canvasHeight - size / 2 + offsetY;

      if (horizontalBar) {
        var progressLine = horizontalBar.get('children')[1];
        progressLine.attr({
          x1: Math.max(plotRange.bl.x + plotRange.width * currentRange[0] + offsetX, plotRange.bl.x),
          x2: Math.min(plotRange.bl.x + plotRange.width * currentRange[1] + offsetX, plotRange.br.x)
        });
      } else {
        horizontalBar = backPlot.addGroup({
          className: 'horizontalBar'
        });
        horizontalBar.addShape('line', {
          attrs: {
            x1: plotRange.bl.x + offsetX,
            y1: yPos,
            x2: plotRange.br.x + offsetX,
            y2: yPos,
            lineWidth: size,
            stroke: backgroundColor,
            lineCap: lineCap
          }
        });
        horizontalBar.addShape('line', {
          attrs: {
            x1: Math.max(plotRange.bl.x + plotRange.width * currentRange[0] + offsetX, plotRange.bl.x),
            y1: yPos,
            x2: Math.min(plotRange.bl.x + plotRange.width * currentRange[1] + offsetX, plotRange.br.x),
            y2: yPos,
            lineWidth: size,
            stroke: fillerColor,
            lineCap: lineCap
          }
        });
        chart.set('_horizontalBar', horizontalBar);
      }
    }

    if (type.indexOf('Y') > -1) {
      var _scrollBarCfg$yStyle = scrollBarCfg.yStyle,
          _offsetX = _scrollBarCfg$yStyle.offsetX,
          _offsetY = _scrollBarCfg$yStyle.offsetY,
          _lineCap = _scrollBarCfg$yStyle.lineCap,
          _backgroundColor = _scrollBarCfg$yStyle.backgroundColor,
          _fillerColor = _scrollBarCfg$yStyle.fillerColor,
          _size = _scrollBarCfg$yStyle.size;
      var yScale = chart.getYScales()[0];
      var yLimitRange = limitRange[yScale.field];

      if (!yLimitRange) {
        yLimitRange = getLimitRange(data, yScale);
        limitRange[yScale.field] = yLimitRange;
      }

      var _currentRange = getFieldRange(yScale, yLimitRange, yScale.type);

      var verticalBar = chart.get('_verticalBar');
      var xPos = _size / 2 + _offsetX;

      if (verticalBar) {
        var _progressLine = verticalBar.get('children')[1];

        _progressLine.attr({
          y1: Math.max(plotRange.tl.y + plotRange.height * _currentRange[0] + _offsetY, plotRange.tl.y),
          y2: Math.min(plotRange.tl.y + plotRange.height * _currentRange[1] + _offsetY, plotRange.bl.y)
        });
      } else {
        verticalBar = backPlot.addGroup({
          className: 'verticalBar'
        });
        verticalBar.addShape('line', {
          attrs: {
            x1: xPos,
            y1: plotRange.tl.y + _offsetY,
            x2: xPos,
            y2: plotRange.bl.y + _offsetY,
            lineWidth: _size,
            stroke: _backgroundColor,
            lineCap: _lineCap
          }
        });
        verticalBar.addShape('line', {
          attrs: {
            x1: xPos,
            y1: Math.max(plotRange.tl.y + plotRange.height * _currentRange[0] + _offsetY, plotRange.tl.y),
            x2: xPos,
            y2: Math.min(plotRange.tl.y + plotRange.height * _currentRange[1] + _offsetY, plotRange.bl.y),
            lineWidth: _size,
            stroke: _fillerColor,
            lineCap: _lineCap
          }
        });
        chart.set('_verticalBar', verticalBar);
      }
    }
  };

  function ScrollBar(cfg, chart) {
    var _this;

    _this = _Interaction.call(this, cfg, chart) || this;

    var defaultCfg = _this.getDefaultCfg();

    chart.set('_scrollBarCfg', Util.deepMix({}, defaultCfg, cfg));
    chart.set('_limitRange', {});

    if (!chart.get('_horizontalBar') && !chart.get('_verticalBar')) {
      _this._renderScrollBars();
    }

    return _this;
  }

  _proto._clear = function _clear() {
    var chart = this.chart;

    if (chart) {
      var hBar = chart.get('_horizontalBar');
      var vBar = chart.get('_verticalBar');
      hBar && hBar.remove(true);
      vBar && vBar.remove(true);
      chart.set('_horizontalBar', null);
      chart.set('_verticalBar', null);
    }
  };

  _proto._bindEvents = function _bindEvents() {
    this._onAfterclearOrBeforechangedata = this._onAfterclearOrBeforechangedata.bind(this);
    this._onAfterclearinner = this._onAfterclearinner.bind(this);
    this._onAfterdrawgeoms = this._onAfterdrawgeoms.bind(this);
    var chart = this.chart;
    chart.on('afterclear', this._onAfterclearOrBeforechangedata);
    chart.on('beforechangedata', this._onAfterclearOrBeforechangedata);
    chart.on('afterclearinner', this._onAfterclearinner);
    chart.on('afterdrawgeoms', this._onAfterdrawgeoms);
  };

  _proto._onAfterclearOrBeforechangedata = function _onAfterclearOrBeforechangedata() {
    this.chart && this.chart.set('_limitRange', {});
  };

  _proto._onAfterclearinner = function _onAfterclearinner() {
    this._clear();
  };

  _proto._onAfterdrawgeoms = function _onAfterdrawgeoms() {
    this._renderScrollBars();
  };

  _proto._clearEvents = function _clearEvents() {
    var chart = this.chart;

    if (chart) {
      chart.off('afterclear', this._onAfterclearOrBeforechangedata);
      chart.off('beforechangedata', this._onAfterclearOrBeforechangedata);
      chart.off('afterclearinner', this._onAfterclearinner);
      chart.off('afterdrawgeoms', this._onAfterdrawgeoms);
    }
  };

  _proto.destroy = function destroy() {
    this._clearEvents();

    this._clear();

    this.canvas.draw();
  };

  return ScrollBar;
}(Interaction);

module.exports = ScrollBar;