function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview 点图
 * @author dxq613@gmail.com
 */
var GeomBase = require('./base');

var Util = require('../util');

require('./shape/point');

var Point = /*#__PURE__*/function (_GeomBase) {
  _inheritsLoose(Point, _GeomBase);

  function Point() {
    return _GeomBase.apply(this, arguments) || this;
  }

  var _proto = Point.prototype;

  /**
   * 获取默认的配置属性
   * @protected
   * @return {Object} 默认属性
   */
  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _GeomBase.prototype.getDefaultCfg.call(this);

    cfg.type = 'point';
    cfg.shapeType = 'point';
    cfg.generatePoints = true;
    return cfg;
  };

  _proto.drawPoint = function drawPoint(obj, container, shapeFactory, index) {
    var self = this;
    var shape = obj.shape;
    var cfg = self.getDrawCfg(obj);

    self._applyViewThemeShapeStyle(cfg, shape, shapeFactory);

    var geomShape;

    if (Util.isArray(obj.y)) {
      var hasAdjust = self.hasStack();
      Util.each(obj.y, function (y, idx) {
        cfg.y = y;
        cfg.yIndex = idx;

        if (!hasAdjust || idx !== 0) {
          geomShape = shapeFactory.drawShape(shape, cfg, container);
          self.appendShapeInfo(geomShape, index + idx);
        }
      });
    } else if (!Util.isNil(obj.y)) {
      geomShape = shapeFactory.drawShape(shape, cfg, container);
      self.appendShapeInfo(geomShape, index);
    }
  };

  return Point;
}(GeomBase);

var PointJitter = /*#__PURE__*/function (_Point) {
  _inheritsLoose(PointJitter, _Point);

  function PointJitter() {
    return _Point.apply(this, arguments) || this;
  }

  var _proto2 = PointJitter.prototype;

  _proto2.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Point.prototype.getDefaultCfg.call(this);

    cfg.hasDefaultAdjust = true;
    cfg.adjusts = [{
      type: 'jitter'
    }];
    return cfg;
  };

  return PointJitter;
}(Point);

var PointStack = /*#__PURE__*/function (_Point2) {
  _inheritsLoose(PointStack, _Point2);

  function PointStack() {
    return _Point2.apply(this, arguments) || this;
  }

  var _proto3 = PointStack.prototype;

  _proto3.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Point2.prototype.getDefaultCfg.call(this);

    cfg.hasDefaultAdjust = true;
    cfg.adjusts = [{
      type: 'stack'
    }];
    return cfg;
  };

  return PointStack;
}(Point);

Point.Jitter = PointJitter;
Point.Stack = PointStack;
GeomBase.Point = Point;
GeomBase.PointJitter = PointJitter;
GeomBase.PointStack = PointStack;
module.exports = Point;