function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview 路径图，无序的线图
 * @author dxq613@gmail.com
 */
var GeomBase = require('./base');

var SplitMixin = require('./mixin/split');

var Util = require('../util');

var Path = /*#__PURE__*/function (_GeomBase) {
  _inheritsLoose(Path, _GeomBase);

  var _proto = Path.prototype;

  /**
   * 获取默认的配置属性
   * @protected
   * @return {Object} 默认属性
   */
  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _GeomBase.prototype.getDefaultCfg.call(this);

    cfg.type = 'path';
    cfg.shapeType = 'line';
    return cfg;
  };

  function Path(cfg) {
    var _this;

    _this = _GeomBase.call(this, cfg) || this;
    Util.assign(_assertThisInitialized(_this), SplitMixin);
    return _this;
  }

  _proto.getDrawCfg = function getDrawCfg(obj) {
    var cfg = _GeomBase.prototype.getDrawCfg.call(this, obj);

    cfg.isStack = this.hasStack();
    return cfg;
  };

  _proto.draw = function draw(data, container, shapeFactory, index) {
    var self = this;
    var splitArray = this.splitData(data);
    var cfg = this.getDrawCfg(data[0]);

    self._applyViewThemeShapeStyle(cfg, cfg.shape, shapeFactory);

    cfg.origin = data; // path,line 等图的origin 是整个序列

    Util.each(splitArray, function (subData, splitedIndex) {
      if (!Util.isEmpty(subData)) {
        cfg.splitedIndex = splitedIndex; // 传入分割片段索引 用于生成id

        cfg.points = subData;
        var geomShape = shapeFactory.drawShape(cfg.shape, cfg, container);
        self.appendShapeInfo(geomShape, index + splitedIndex);
      }
    });
  };

  return Path;
}(GeomBase);

GeomBase.Path = Path;
module.exports = Path;