function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview 面积图
 * @author dxq613@gmail.com
 */
var GeomBase = require('./base');

var SplitMixin = require('./mixin/split');

var Util = require('../util');

require('./shape/area');

var Area = /*#__PURE__*/function (_GeomBase) {
  _inheritsLoose(Area, _GeomBase);

  var _proto = Area.prototype;

  /**
   * 获取默认的配置属性
   * @protected
   * @return {Object} 默认属性
   */
  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _GeomBase.prototype.getDefaultCfg.call(this);

    cfg.type = 'area';
    cfg.shapeType = 'area';
    cfg.generatePoints = true;
    cfg.sortable = true;
    return cfg;
  };

  function Area(cfg) {
    var _this;

    _this = _GeomBase.call(this, cfg) || this;
    Util.assign(_assertThisInitialized(_this), SplitMixin);
    return _this;
  }

  _proto.draw = function draw(data, container, shapeFactory, index) {
    var self = this;
    var cfg = this.getDrawCfg(data[0]);

    self._applyViewThemeShapeStyle(cfg, cfg.shape, shapeFactory);

    var splitArray = this.splitData(data);
    cfg.origin = data; // path,line,area 等图的origin 是整个序列

    Util.each(splitArray, function (subData, splitedIndex) {
      cfg.splitedIndex = splitedIndex; // 传入分割片段索引 用于生成id

      var points = subData.map(function (obj) {
        return obj.points;
      });
      cfg.points = points;
      var geomShape = shapeFactory.drawShape(cfg.shape, cfg, container);
      self.appendShapeInfo(geomShape, index + splitedIndex);
    });
  };

  return Area;
}(GeomBase);

var AreaStack = /*#__PURE__*/function (_Area) {
  _inheritsLoose(AreaStack, _Area);

  function AreaStack() {
    return _Area.apply(this, arguments) || this;
  }

  var _proto2 = AreaStack.prototype;

  _proto2.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Area.prototype.getDefaultCfg.call(this);

    cfg.hasDefaultAdjust = true;
    cfg.adjusts = [{
      type: 'stack'
    }];
    return cfg;
  };

  return AreaStack;
}(Area);

Area.Stack = AreaStack;
GeomBase.Area = Area;
GeomBase.AreaStack = AreaStack;
module.exports = Area;