function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../../util');

var Guide = require('@antv/component/lib/guide/base');

var _require = require('@antv/g/lib'),
    Path = _require.Path;

var RegionFilter = /*#__PURE__*/function (_Guide) {
  _inheritsLoose(RegionFilter, _Guide);

  function RegionFilter() {
    return _Guide.apply(this, arguments) || this;
  }

  var _proto = RegionFilter.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Guide.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      name: 'regionFilter',
      zIndex: 1,
      top: true,
      start: null,
      end: null,
      color: null,
      apply: null,
      style: {
        opacity: 1
      }
    });
  };

  _proto.render = function render(coord, group, viewData, view) {
    var self = this;
    var layer = group.addGroup();
    layer.name = 'guide-region-filter';
    view.once('afterpaint', function () {
      // 2018-08-08 by blue.lb padding为auto时，会导致重新绘制一次，这时候layer已经被销毁了
      if (layer.get('destroyed')) return;

      self._drawShapes(view, layer);

      var clip = self._drawClip(coord);

      layer.attr({
        clip: clip
      });
      self.set('clip', clip);
      self.get('appendInfo') && layer.setSilent('appendInfo', self.get('appendInfo'));
      self.set('el', layer);
    });
  };

  _proto._drawShapes = function _drawShapes(view, layer) {
    var self = this;
    var output = [];
    var geoms = view.getAllGeoms();
    geoms.map(function (geom) {
      var shapes = geom.getShapes();
      var geomType = geom.get('type');

      var filter = self._geomFilter(geomType);

      if (filter) {
        shapes.map(function (shape) {
          var shapeType = shape.type; // const shapeAttr = Util.mix({}, shape.attr());

          var shapeAttr = Util.cloneDeep(shape.attr());

          self._adjustDisplay(shapeAttr);

          var s = layer.addShape(shapeType, {
            attrs: shapeAttr
          });
          output.push(s);
          return shape;
        });
      }

      return geom;
    });
    return output;
  };

  _proto._drawClip = function _drawClip(coord) {
    var self = this;
    var start = self.parsePoint(coord, self.get('start'));
    var end = self.parsePoint(coord, self.get('end'));
    var path = [['M', start.x, start.y], ['L', end.x, start.y], ['L', end.x, end.y], ['L', start.x, end.y], ['z']];
    var clip = new Path({
      attrs: {
        path: path,
        opacity: 1
      }
    });
    return clip;
  };

  _proto._adjustDisplay = function _adjustDisplay(attr) {
    var self = this;
    var color = self.get('color');

    if (attr.fill) {
      attr.fill = attr.fillStyle = color;
    }

    attr.stroke = attr.strokeStyle = color;
  };

  _proto._geomFilter = function _geomFilter(geomType) {
    var self = this;
    var apply = self.get('apply');

    if (apply) {
      return Util.contains(apply, geomType);
    }

    return true;
  };

  _proto.clear = function clear() {
    _Guide.prototype.clear.call(this);

    var clip = this.get('clip');
    clip && clip.remove();
  };

  return RegionFilter;
}(Guide);

module.exports = RegionFilter;