var Util = require('../util');

var DomUtil = Util.DomUtil;
var EVENT_TYPES = ['start', 'process', 'end', 'reset'];

var Interaction = /*#__PURE__*/function () {
  var _proto = Interaction.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    return {
      startEvent: 'mousedown',
      processEvent: 'mousemove',
      endEvent: 'mouseup',
      resetEvent: 'dblclick'
    };
  };

  _proto._start = function _start(ev) {
    var me = this;
    me.preStart && me.preStart(ev);
    me.start(ev);
    me.onStart && me.onStart(ev);
  };

  _proto._process = function _process(ev) {
    var me = this;
    me.preProcess && me.preProcess(ev);
    me.process(ev);
    me.onProcess && me.onProcess(ev);
  };

  _proto._end = function _end(ev) {
    var me = this;
    me.preEnd && me.preEnd(ev);
    me.end(ev);
    me.onEnd && me.onEnd(ev);
  };

  _proto._reset = function _reset(ev) {
    var me = this;
    me.preReset && me.preReset(ev);
    me.reset(ev);
    me.onReset && me.onReset(ev);
  };

  _proto.start = function start() {// TODO override
  };

  _proto.process = function process() {// TODO override
  };

  _proto.end = function end() {// TODO override
  };

  _proto.reset = function reset() {// TODO override
  };

  function Interaction(cfg, view) {
    var me = this;
    var defaultCfg = me.getDefaultCfg();
    Util.assign(me, defaultCfg, cfg);
    me.view = me.chart = view;
    me.canvas = view.get('canvas');

    me._bindEvents();
  }

  _proto._bindEvents = function _bindEvents() {
    var me = this;
    var canvas = me.canvas;
    var canvasDOM = canvas.get('canvasDOM');

    me._clearEvents();

    Util.each(EVENT_TYPES, function (type) {
      var ucType = Util.upperFirst(type);
      me["_on" + ucType + "Listener"] = DomUtil.addEventListener(canvasDOM, me[type + "Event"], Util.wrapBehavior(me, "_" + type));
    });
  };

  _proto._clearEvents = function _clearEvents() {
    var me = this;
    Util.each(EVENT_TYPES, function (type) {
      var listenerName = "_on" + Util.upperFirst(type) + "Listener";
      me[listenerName] && me[listenerName].remove();
    });
  };

  _proto.destroy = function destroy() {
    this._clearEvents();
  };

  return Interaction;
}();

module.exports = Interaction;