function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview The class of tail legend
 * @author Ye Liu
 */
var Util = require('../../util'); // const Category = require('./category');


var Components = require('@antv/component/lib');

var Global = require('../../global');

var Legend = Components.Legend;
var Category = Legend.Category;

var Tail = /*#__PURE__*/function (_Category) {
  _inheritsLoose(Tail, _Category);

  function Tail() {
    return _Category.apply(this, arguments) || this;
  }

  var _proto = Tail.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Category.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      /**
       * type标识
       * @type {String}
       */
      type: 'tail-legend',

      /**
       * 布局方式
       * horizontal 水平
       * vertical 垂直
       * @type {String}
       */
      layout: 'vertical',
      autoLayout: true
    });
  };

  _proto._addItem = function _addItem(item) {
    var itemsGroup = this.get('itemsGroup');

    var x = this._getNextX();

    var y = 0;
    var unCheckColor = this.get('unCheckColor');
    var itemGroup = itemsGroup.addGroup({
      x: 0,
      y: 0,
      value: item.value,
      scaleValue: item.scaleValue,
      checked: item.checked
    });
    itemGroup.translate(x, y);
    itemGroup.set('viewId', itemsGroup.get('viewId'));
    var textStyle = this.get('textStyle');
    var wordSpace = this.get('_wordSpaceing');
    var startX = 0;

    if (item.marker) {
      // 如果有marker添加marker
      var markerAttrs = Util.mix({}, item.marker, {
        x: item.marker.radius,
        y: 0
      });

      if (!item.checked) {
        if (markerAttrs.fill) {
          markerAttrs.fill = unCheckColor;
        }

        if (markerAttrs.stroke) {
          markerAttrs.stroke = unCheckColor;
        }
      }

      var markerShape = itemGroup.addShape('marker', {
        type: 'marker',
        attrs: markerAttrs
      });
      markerShape.attr('cursor', 'pointer');
      markerShape.name = 'legend-marker';
      startX += markerShape.getBBox().width + wordSpace;
    }

    var textAttrs = Util.mix({}, textStyle, {
      x: startX,
      y: 0,
      text: this._formatItemValue(item.value)
    });

    if (!item.checked) {
      Util.mix(textAttrs, {
        fill: unCheckColor
      });
    }

    var textShape = itemGroup.addShape('text', {
      attrs: textAttrs
    });
    textShape.attr('cursor', 'pointer');
    textShape.name = 'legend-text';
    this.get('appendInfo') && textShape.setSilent('appendInfo', this.get('appendInfo')); // 添加一个包围矩形，用于事件支持

    var bbox = itemGroup.getBBox();
    var itemWidth = this.get('itemWidth');
    var wrapperShape = itemGroup.addShape('rect', {
      attrs: {
        x: x,
        y: y - bbox.height / 2,
        fill: '#fff',
        fillOpacity: 0,
        width: itemWidth || bbox.width,
        height: bbox.height
      }
    });
    wrapperShape.attr('cursor', 'pointer');
    wrapperShape.setSilent('origin', item); // 保存图例项相关的数据，便于事件操作

    wrapperShape.name = 'legend-item';
    this.get('appendInfo') && wrapperShape.setSilent('appendInfo', this.get('appendInfo'));
    itemGroup.name = 'legendGroup';
    return itemGroup;
  };

  _proto._adjust = function _adjust() {
    var self = this;
    var geom = self.get('geom');

    if (geom) {
      var groupMatrix = self.get('group').attr('matrix');
      groupMatrix[7] = 0;
      var dataArray = self.get('geom').get('dataArray');
      var groups = this.get('itemsGroup').get('children');
      var index = 0;
      Util.each(groups, function (groupItem) {
        var dArray = dataArray[index];
        var lastY = dArray[dArray.length - 1].y;

        if (Util.isArray(lastY)) {
          lastY = lastY[1];
        }

        var groupHeight = groupItem.getBBox().height;
        var x = groupItem.get('x');
        var y = lastY - groupHeight / 2;
        groupItem.translate(x, y);
        index++;
      });

      if (self.get('autoLayout')) {
        self._antiCollision(groups);
      }
    }
  };

  _proto.render = function render() {
    var _this = this;

    _Category.prototype.render.call(this);

    var chart = this.get('chart');
    chart.once('afterpaint', function () {
      _this._adjust();
    });
  };

  _proto._getPreviousY = function _getPreviousY(item) {
    var y = item.attr('matrix')[7];
    var height = item.getBBox().height;
    return y + height;
  };

  _proto._adjustDenote = function _adjustDenote(group, start, end) {
    var margin = Global.legend.legendMargin;
    var x0 = -2;
    var x2 = -margin * 2;
    group.addShape('path', {
      attrs: {
        path: 'M' + x0 + ',' + start + 'L' + x2 + ',' + (end + 3),
        lineWidth: 1,
        lineDash: [2, 2],
        stroke: '#999999'
      }
    });
  };

  _proto._antiCollision = function _antiCollision(items) {
    if (items === void 0) {
      items = [];
    }

    if (!items.length) return;
    var self = this;
    items.sort(function (a, b) {
      var ay = a.attr('matrix')[7];
      var by = b.attr('matrix')[7];
      return ay - by;
    });
    var overlapping = true;
    var plotRange = self.get('chart').get('plotRange');
    var startY = plotRange.tl.y;
    var totalHeight = Math.abs(startY - plotRange.bl.y);
    var elementHeight = items[0].getBBox().height;
    var minY = Number.MIN_VALUE;
    var maxY = 0;
    var boxes = items.map(function (item) {
      var y = item.attr('matrix')[7];

      if (y > maxY) {
        maxY = y;
      }

      if (y < minY) {
        minY = y;
      }

      return {
        size: item.getBBox().height,
        targets: [y - startY]
      };
    });
    minY -= startY;
    var i = 0;

    while (overlapping) {
      for (var _i = 0; _i < boxes.length; _i++) {
        var box = boxes[_i];
        var target = (Math.min.apply(minY, box.targets) + Math.max.apply(minY, box.targets)) / 2;
        box.pos = Math.min(Math.max(minY, target - box.size / 2), totalHeight - box.size);
      }

      overlapping = false;
      i = boxes.length;

      while (i--) {
        if (i > 0) {
          var previous = boxes[i - 1];
          var current = boxes[i];

          if (previous.pos + previous.size > current.pos) {
            // overlapping
            previous.size += current.size;
            previous.targets = previous.targets.concat(current.targets);
            boxes.splice(i, 1);
            overlapping = true;
          }
        }
      } // end of while i

    } // end of while
    // adjust y


    i = 0;
    var group = this.get('itemsGroup').addGroup();
    boxes.forEach(function (b) {
      var posInCompositeBox = startY + elementHeight;
      b.targets.forEach(function () {
        var origin_y = items[i].attr('matrix')[7];
        var y = b.pos + posInCompositeBox - elementHeight / 2;
        var dist = Math.abs(origin_y - y);

        if (dist > elementHeight / 2) {
          self._adjustDenote(group, y, origin_y - self.get('group').attr('matrix')[7] / 2);
        }

        items[i].translate(0, -origin_y);
        items[i].translate(0, y);
        posInCompositeBox += elementHeight;
        i++;
      });
    });
  } // end of antiCollision
  ;

  return Tail;
}(Category);

module.exports = Tail;