function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Interaction = require('./base');

var filterData = require('./helper/filter-data');

var getColDef = require('./helper/get-col-def');

var getLimitRange = require('./helper/get-limit-range');

var DAY_TIMESTAMPS = 86400000; // const G2 = require('../core.js');

var DRAGGING_TYPES = ['X', 'Y', 'XY'];
var DEFAULT_TYPE = 'X';

var Drag = /*#__PURE__*/function (_Interaction) {
  _inheritsLoose(Drag, _Interaction);

  var _proto = Drag.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Interaction.prototype.getDefaultCfg.call(this);

    return Util.mix({}, cfg, {
      type: DEFAULT_TYPE,
      stepRatio: 0.05,
      limitRange: {},
      stepByField: {},
      threshold: 20,
      originScaleDefsByField: {},
      previousPoint: null,
      isDragging: false
    });
  };

  _proto._disableTooltip = function _disableTooltip() {
    var me = this;
    var chart = me.chart;
    var tooltipController = chart.get('tooltipController');

    if (tooltipController) {
      me._showTooltip = true;
      chart.tooltip(false);
    }
  };

  _proto._enableTooltip = function _enableTooltip(ev) {
    var me = this;
    var chart = me.chart;

    if (me._showTooltip) {
      chart.tooltip(true);
      chart.showTooltip(ev);
    }
  };

  function Drag(cfg, chart) {
    var _this;

    _this = _Interaction.call(this, cfg, chart) || this;

    var me = _assertThisInitialized(_this);

    me.type = me.type.toUpperCase();
    me.chart = chart;
    me.coord = chart.get('coord');
    var data = me.data = chart.get('data'); // pre process

    filterData(chart);
    var scales = chart.getYScales();
    var xScale = chart.getXScale();
    scales.push(xScale);
    var scaleController = chart.get('scaleController');
    scales.forEach(function (scale) {
      var field = scale.field;
      me.limitRange[field] = getLimitRange(data, scale);
      var def = scaleController.defs[field] || {};
      me.originScaleDefsByField[field] = Util.mix(def, {
        nice: !!def.nice
      });

      if (scale.isLinear) {
        me.stepByField[field] = (scale.max - scale.min) * me.stepRatio;
      }
    });

    if (!DRAGGING_TYPES.includes(me.type)) {
      me.type = DEFAULT_TYPE;
    }

    me._disableTooltip();

    return _this;
  } // onDragstart() { }
  // onDrag() { }
  // onDragend() { }


  _proto._applyTranslate = function _applyTranslate(scale, offset, total) {
    if (offset === void 0) {
      offset = 0;
    }

    var me = this;

    if (scale.isLinear) {
      me._translateLinearScale(scale, offset, total);
    } else {
      me._translateCatScale(scale, offset, total);
    }
  };

  _proto._translateCatScale = function _translateCatScale(scale, offset, total) {
    var me = this;
    var chart = me.chart;
    var type = scale.type,
        field = scale.field,
        values = scale.values,
        ticks = scale.ticks;
    var colDef = getColDef(chart, field);
    var originValues = me.limitRange[field];
    var ratio = offset / total;
    var valueLength = values.length;
    var deltaCount = Math.max(1, Math.abs(parseInt(ratio * valueLength)));
    var firstIndex = originValues.indexOf(values[0]);
    var lastIndex = originValues.indexOf(values[valueLength - 1]);

    if (offset > 0 && firstIndex >= 0) {
      // right
      for (var i = 0; i < deltaCount && firstIndex > 0; i++) {
        firstIndex -= 1;
        lastIndex -= 1;
      }

      var newValues = originValues.slice(firstIndex, lastIndex + 1);
      var newTicks = null;

      if (type === 'timeCat') {
        var tickGap = ticks.length > 2 ? ticks[1] - ticks[0] : DAY_TIMESTAMPS;

        for (var _i = ticks[0] - tickGap; _i >= newValues[0]; _i -= tickGap) {
          ticks.unshift(_i);
        }

        newTicks = ticks;
      }

      chart.scale(field, Util.mix({}, colDef, {
        values: newValues,
        ticks: newTicks
      }));
    } else if (offset < 0 && lastIndex <= originValues.length - 1) {
      // left
      for (var _i2 = 0; _i2 < deltaCount && lastIndex < originValues.length - 1; _i2++) {
        firstIndex += 1;
        lastIndex += 1;
      }

      var _newValues = originValues.slice(firstIndex, lastIndex + 1);

      var _newTicks = null;

      if (type === 'timeCat') {
        var _tickGap = ticks.length > 2 ? ticks[1] - ticks[0] : DAY_TIMESTAMPS;

        for (var _i3 = ticks[ticks.length - 1] + _tickGap; _i3 <= _newValues[_newValues.length - 1]; _i3 += _tickGap) {
          ticks.push(_i3);
        }

        _newTicks = ticks;
      }

      chart.scale(field, Util.mix({}, colDef, {
        values: _newValues,
        ticks: _newTicks
      }));
    }
  };

  _proto._translateLinearScale = function _translateLinearScale(scale, offset, total) {
    var me = this;
    var chart = me.chart,
        limitRange = me.limitRange; // linear / cat

    var min = scale.min,
        max = scale.max,
        field = scale.field;
    if (min === limitRange[field].min && max === limitRange[field].max) return;
    var ratio = offset / total;
    var range = max - min;
    var colDef = getColDef(chart, field);
    chart.scale(field, Util.mix({}, colDef, {
      nice: false,
      min: min + ratio * range,
      max: max + ratio * range
    }));
  };

  _proto.start = function start(ev) {
    var me = this;
    var canvas = me.canvas;
    var canvasDOM = canvas.get('canvasDOM');
    canvasDOM.style.cursor = 'pointer'; // const coord = chart.get('coord');

    me.isDragging = true;
    me.previousPoint = {
      x: ev.x,
      y: ev.y
    };

    me._disableTooltip();
  };

  _proto.process = function process(ev) {
    var me = this;

    if (me.isDragging) {
      var chart = me.chart,
          type = me.type,
          canvas = me.canvas,
          coord = me.coord,
          threshold = me.threshold;
      var canvasDOM = canvas.get('canvasDOM');
      canvasDOM.style.cursor = 'move'; // const coord = chart.get('coord');

      var previousPoint = me.previousPoint;
      var currentPoint = ev;
      var deltaX = currentPoint.x - previousPoint.x;
      var deltaY = currentPoint.y - previousPoint.y;
      var modified = false;

      if (Math.abs(deltaX) > threshold && type.indexOf('X') > -1) {
        modified = true;
        var xScale = chart.getXScale();

        me._applyTranslate(xScale, xScale.isLinear ? -deltaX : deltaX, coord.width);
      }

      if (Math.abs(deltaY) > threshold && type.indexOf('Y') > -1) {
        modified = true;
        var yScales = chart.getYScales();
        yScales.forEach(function (yScale) {
          me._applyTranslate(yScale, currentPoint.y - previousPoint.y, coord.height);
        });
      }

      if (modified) {
        me.previousPoint = currentPoint;
        chart.repaint();
      }
    }
  };

  _proto.end = function end(ev) {
    var me = this;
    me.isDragging = false;
    var canvas = me.canvas;
    var canvasDOM = canvas.get('canvasDOM');
    canvasDOM.style.cursor = 'default';

    me._enableTooltip(ev);
  };

  _proto.reset = function reset() {
    var me = this;
    var view = me.view,
        originScaleDefsByField = me.originScaleDefsByField;
    var scales = view.getYScales();
    var xScale = view.getXScale();
    scales.push(xScale);
    scales.forEach(function (scale) {
      if (scale.isLinear) {
        var field = scale.field;
        view.scale(field, originScaleDefsByField[field]);
      }
    });
    view.repaint();

    me._disableTooltip();
  };

  return Drag;
}(Interaction);

module.exports = Drag;