package com.bcxin.ars.service;

import java.util.Date;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.OrderNoLog;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-service.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class OrderNoLogServiceTest {

	@Autowired
	private OrderNoLogService orderNoLogService;
	
	@Test
	public void testGetNewOrderNo(){
		String today = DateUtil.getCurrentDate("yyyyMMdd");
		Long serialNo = orderNoLogService.findMaxSerialNoByDate(today);
		if(serialNo == null){
			serialNo = 1l;
		}else{
			serialNo = serialNo + 1;
		}
		String orderNo = today + StringUtil.addZero(serialNo+"", 3);
		
		OrderNoLog orderNoLog = new OrderNoLog();
		orderNoLog.setActive(true);
		orderNoLog.setCreateTime(new Date());
		orderNoLog.setDate(today);
		orderNoLog.setOrderNo(orderNo);
		orderNoLog.setSerialNo(serialNo);
		orderNoLog.setUpdateBy("systemTest");
		orderNoLog.setUpdateTime(new Date());
		
		orderNoLogService.save(orderNoLog);
	}
}
