package com.bcxin.ars.service.util.gen;

import com.bcxin.ars.model.gen.GenTable;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.text.StringUtils;
import org.apache.velocity.VelocityContext;

import java.util.ArrayList;
import java.util.List;

public class VelocityUtils{
    /** 项目空间路径 */
    private static final String PROJECT_PATH = "main/java";

    /** mybatis空间路径 */
    private static final String MYBATIS_PATH = "main/resources/mapper";

    /** html空间路径 */
    private static final String TEMPLATES_PATH = "main/resources/templates";
    
    /** 默认上级菜单，系统工具 */
    private static final String DEFAULT_PARENT_MENU_ID = "3";

    /**
     * 设置模板变量信息
     * 
     * @return 模板列表
     */
    public static VelocityContext prepareContext(GenTable genTable){
        String moduleName = genTable.getModuleName();
        String businessName = genTable.getBusinessName();
        String packageName = genTable.getPackageName();
        String tplCategory = genTable.getTplCategory();
        String functionName = genTable.getFunctionName();

        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("tplCategory", genTable.getTplCategory());
        velocityContext.put("tableName", genTable.getTableName());
        velocityContext.put("functionName", StringUtils.isNotEmpty(functionName) ? functionName : "【请填写功能名称】");
        velocityContext.put("ClassName", genTable.getClassName());
        velocityContext.put("className", StringUtils.uncapitalize(genTable.getClassName()));
        velocityContext.put("moduleName", genTable.getModuleName());
        velocityContext.put("businessName", genTable.getBusinessName());
        velocityContext.put("basePackage", getPackagePrefix(packageName));
        velocityContext.put("packageName", packageName);
        velocityContext.put("author", genTable.getFunctionAuthor());
        velocityContext.put("datetime", DateUtil.getCurrentDate());
        velocityContext.put("pkColumn", genTable.getPkColumn());
        velocityContext.put("permissionPrefix", getPermissionPrefix(moduleName, businessName));
        velocityContext.put("columns", genTable.getColumns());
        velocityContext.put("table", genTable);
        setMenuVelocityContext(velocityContext, genTable);
        return velocityContext;
    }

    public static void setMenuVelocityContext(VelocityContext context, GenTable genTable){
        context.put("parentMenuId", genTable.getParentMenuId());
    }

    /**
     * 获取模板信息
     * 
     * @return 模板列表
     */
    public static List<String> getTemplateList(String tplCategory){
        List<String> templates = new ArrayList<String>();
        templates.add("vm/java/domain.java.vm");
        templates.add("vm/java/searchDto.java.vm");
        templates.add("vm/java/mapper.java.vm");
        templates.add("vm/java/service.java.vm");
        templates.add("vm/java/serviceImpl.java.vm");
        templates.add("vm/java/controller.java.vm");
        templates.add("vm/xml/mapper.xml.vm");
        templates.add("vm/html/list.jsp.vm");
        templates.add("vm/html/detail.jsp.vm");
        templates.add("vm/html/edit.jsp.vm");
        templates.add("vm/sql/sql.vm");
        return templates;
    }

    /**
     * 获取文件名
     */
    public static String getFileName(String template, GenTable genTable){
        // 文件名称
        String fileName = "";
        // 包路径
        String packageName = genTable.getPackageName();
        // 模块名
        String moduleName = genTable.getModuleName();
        // 大写类名
        String className = genTable.getClassName();
        // 业务名称
        String businessName = genTable.getBusinessName();

        String javaPath = PROJECT_PATH + "/" + StringUtils.replace(packageName, ".", "/");
        String mybatisPath = MYBATIS_PATH ;
        String htmlPath = TEMPLATES_PATH + "/" + businessName;

        if (template.contains("domain.java.vm")){
            fileName = StringUtils.format("{}/model/{}.java", javaPath, className);
        }
        else if (template.contains("searchDto.java.vm")){
            fileName = StringUtils.format("{}/dto/{}PageSearchDto.java", javaPath, className);
        }
        else if (template.contains("mapper.java.vm")){
            fileName = StringUtils.format("{}/dao/{}Dao.java", javaPath, className);
        }
        else if (template.contains("service.java.vm")){
            fileName = StringUtils.format("{}/service/{}Service.java", javaPath, className);
        }
        else if (template.contains("serviceImpl.java.vm")){
            fileName = StringUtils.format("{}/service/impl/{}ServiceImpl.java", javaPath, className);
        }
        else if (template.contains("controller.java.vm")){
            fileName = StringUtils.format("{}/controller/{}Controller.java", javaPath, className);
        }
        else if (template.contains("mapper.xml.vm")){
            fileName = StringUtils.format("{}/{}Dao.xml", mybatisPath, className);
        }
        else if (template.contains("list.jsp.vm")){
            fileName = StringUtils.format("{}/list.jsp", htmlPath);
        }
        else if (template.contains("detail.jsp.vm")){
            fileName = StringUtils.format("{}/detail.jsp", htmlPath);
        }
        else if (template.contains("edit.jsp.vm")){
            fileName = StringUtils.format("{}/edit.jsp", htmlPath);
        }
        else if (template.contains("sql.vm")){
            fileName = businessName + "Menu.sql";
        }
        return fileName;
    }

    /**
     * 获取项目文件路径
     * 
     * @return 路径
     */
    public static String getProjectPath(){
        String packageName = GenConfig.packageName;
        StringBuffer projectPath = new StringBuffer();
        projectPath.append("main/java/");
        projectPath.append(packageName.replace(".", "/"));
        projectPath.append("/");
        return projectPath.toString();
    }

    /**
     * 获取包前缀
     * 
     * @param packageName 包名称
     * @return 包前缀名称
     */
    public static String getPackagePrefix(String packageName){
        int lastIndex = packageName.lastIndexOf(".");
        String basePackage = StringUtils.substring(packageName, 0, lastIndex);
        return basePackage;
    }

    /**
     * 获取权限前缀
     * 
     * @param moduleName 模块名称
     * @param businessName 业务名称
     * @return 返回权限前缀
     */
    public static String getPermissionPrefix(String moduleName, String businessName){
        if(StringUtil.isNotEmpty(moduleName)) {
            return StringUtils.format("{}:{}", moduleName, businessName);
        }

        return StringUtils.format("{}", businessName);
    }
}