package com.bcxin.ars.service.util.excel;

import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;

import java.io.File;
import java.io.FileOutputStream;
import java.sql.*;

/*
 * ExcelUtil工具类实现功能:
 * 导出时传入list<T>,即可实现导出为一个excel,其中每个对象Ｔ为Excel中的一条记录.
 * 导入时读取excel,得到的结果是一个list<T>.T是自己定义的对象.
 * 需要导出的实体对象只需简单配置注解就能实现灵活导出,通过注解您可以方便实现下面功能:
 * 1.实体属性配置了注解就能导出到excel中,每个属性都对应一列.
 * 2.列名称可以通过注解配置.
 * 3.导出到哪一列可以通过注解配置.
 * 4.鼠标移动到该列时提示信息可以通过注解配置.
 * 5.用注解设置只能下拉选择不能随意填写功能.
 * 6.用注解设置是否只导出标题而不导出内容,这在导出内容作为模板以供用户填写时比较实用.
 */
public class DBExcelUtil {

    public static void main(String[] args) {
        try{
            getInfo();
        }catch (Exception e){
            e.printStackTrace();
        }
    }


    /**
     * 生成数据库文档
     * @throws SQLException
     */
    private static void  getInfo() throws SQLException {
        Connection connection = null;
        String connectionURL = "jdbc:mysql://114.115.153.118:3306/information_schema";
        //String connectionURL = "jdbc:mysql://localhost:3306/information_schema";
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        PreparedStatement psmnt = null;
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            connection = DriverManager.getConnection(connectionURL, "root", "Bcxin@2019");

            String sql1 = "select TABLE_NAME,TABLE_COMMENT from TABLES t1 WHERE t1.table_schema = 'test_ars_in' "
                    + " and t1.TABLE_TYPE='BASE TABLE'"
                    + " and t1.TABLE_NAME not like 'act%'"
                    + " and t1.TABLE_NAME not like 'app%'"
                    + " and t1.TABLE_NAME not like 'config%'"
                    + " and t1.TABLE_NAME not like 'sys%'"
                    + " and t1.TABLE_NAME not like 'file%'"
                    + " and t1.TABLE_NAME not like 'in%'"
                    + " and t1.TABLE_NAME not like 'log%'"
                    + " and t1.TABLE_NAME not like 'message%'"
                    + " and t1.TABLE_NAME not like 'module%'"
                    + " and t1.TABLE_NAME not like 'mobile%'"
                    + " and t1.TABLE_NAME not like 'na%'"
                    + " and t1.TABLE_NAME not like 'permission%'"
                    + " and t1.TABLE_NAME not like 'temp%'"
                    + " and t1.TABLE_NAME not like '%temp'"
                    + " and t1.TABLE_NAME not like 'tmp%'"
                    + " and t1.TABLE_NAME not like 'train%'"
                    + " and t1.TABLE_NAME not like 'report%'"
                    + " and t1.TABLE_NAME not like 'tri%'"
                    + " and t1.TABLE_NAME not like '%_copy'"
                    +" ORDER BY t1.table_name ASC";

            String sql2 = "select t1.TABLE_NAME,t1.ORDINAL_POSITION,t1.Column_Name,t1.DATA_TYPE,IFNULL(NUMERIC_PRECISION,''),IFNULL(CHARACTER_MAXIMUM_LENGTH,''),IFNULL(COLUMN_COMMENT,''),if(t1.IS_NULLABLE='NO','否','是'),if(t1.COLUMN_KEY='PRI','是','否') from columns t1 WHERE t1.table_schema = 'test_ars_in' "
                    + " and t1.TABLE_NAME = '[tableName]'"
                    + " and t1.TABLE_NAME not like 'act%'"
                    + " and t1.TABLE_NAME not like 'app%'"
                    + " and t1.TABLE_NAME not like 'config%'"
                    + " and t1.TABLE_NAME not like 'sys%'"
                    + " and t1.TABLE_NAME not like 'file%'"
                    + " and t1.TABLE_NAME not like 'in%'"
                    + " and t1.TABLE_NAME not like 'log%'"
                    + " and t1.TABLE_NAME not like 'message%'"
                    + " and t1.TABLE_NAME not like 'module%'"
                    + " and t1.TABLE_NAME not like 'mobile%'"
                    + " and t1.TABLE_NAME not like 'na%'"
                    + " and t1.TABLE_NAME not like 'permission%'"
                    + " and t1.TABLE_NAME not like 'temp%'"
                    + " and t1.TABLE_NAME not like '%temp'"
                    + " and t1.TABLE_NAME not like 'tmp%'"
                    //+ " and t1.TABLE_NAME not like 'train%'"
                    + " and t1.TABLE_NAME not like 'report%'"
                    + " and t1.TABLE_NAME not like 'tri%'"
                    + " and t1.TABLE_NAME not like '%_copy'"
                    +" ORDER BY t1.table_name ASC";

            String sql3 = "SELECT INDEX_NAME,COLUMN_NAME from STATISTICS where TABLE_SCHEMA='test_ars_in' and TABLE_NAME='[tableName]' and INDEX_NAME !='PRIMARY'";
            psmnt = connection.prepareStatement(sql1);
            rs1=psmnt.executeQuery();

            Integer rowIndex = 0;

            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("治综数据元统计表");
            CellStyle stringStyle = getStringStyle(wb);
            CellStyle titleStyle = getTableTitleStyle(wb);
            CellStyle indexStyle = getTableIndexStyle(wb);
            CellStyle endStyle = getTableEndStyle(wb);

            String tableName ="";
            String cName ="";
            while(rs1.next()){
                tableName =rs1.getString(1);
                cName =rs1.getString(2);

                rowIndex = setTableInfo(wb,sheet1,rowIndex,tableName,cName);
                psmnt = connection.prepareStatement(sql2.replace("[tableName]",tableName));
                rs2=psmnt.executeQuery();
                while(rs2.next()){
                    rowIndex = setTableValue(sheet1,rs2,rowIndex,stringStyle);
                }

                psmnt = connection.prepareStatement(sql3.replace("[tableName]",tableName));
                rs3=psmnt.executeQuery();
                if(rs3.getRow()>0) {
                    while (rs3.next()) {
                        rowIndex = setTableIndex(sheet1, rs3, rowIndex, titleStyle);
                    }
                }else{
                    rowIndex = setTableIndex(sheet1, rs3, rowIndex, indexStyle);
                }
                rowIndex = setTableEnd(sheet1,rowIndex,endStyle);
            }
            File file = new File("f:/aaa1.xls");
            //输出模板
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            System.out.println("Found success!");
            connection.close();
            psmnt.close();
        }
    }

    private static Integer setTableIndex(HSSFSheet sheet1,ResultSet rs3,Integer rowIndex,CellStyle endStyle) throws Exception {
        HSSFRow rowDataRR = sheet1.createRow(rowIndex);
        CellRangeAddress cra1 = new CellRangeAddress(rowIndex, rowIndex, 0, 3);
        sheet1.addMergedRegion(cra1);
        for (int i = 0; i <= 3; i++) {
            HSSFCell cellStyle = rowDataRR.createCell(i); //获取第一行的每个单元格
            cellStyle.setCellStyle(endStyle);
        }
        HSSFCell cell1 = rowDataRR.createCell(0); //获取第一行的每个单元格
        cell1.setCellValue("索引名称:"+ (rs3.getRow()<1 ? "无":rs3.getString(1)));
        cell1.setCellStyle(endStyle);

        CellRangeAddress cra2 = new CellRangeAddress(rowIndex, rowIndex, 4, 8);
        sheet1.addMergedRegion(cra2);
        for (int i = 4; i <= 8; i++) {
            HSSFCell cellStyle = rowDataRR.createCell(i); //获取第一行的每个单元格
            cellStyle.setCellStyle(endStyle);
        }
        HSSFCell cell2 = rowDataRR.createCell(4); //获取第一行的每个单元格
        cell2.setCellValue("索引字段:"+ (rs3.getRow()<1 ? "":rs3.getString(2)));
        cell2.setCellStyle(endStyle);

        return ++rowIndex;
    }

    private static Integer setTableEnd(HSSFSheet sheet1,Integer rowIndex,CellStyle endStyle){
        HSSFRow rowDataRR = sheet1.createRow(rowIndex);
        CellRangeAddress cra1 = new CellRangeAddress(rowIndex, rowIndex, 0, 8);
        sheet1.addMergedRegion(cra1);
        for (int i = 0; i <= 8; i++) {
            HSSFCell cellStyle = rowDataRR.createCell(i); //获取第一行的每个单元格
            cellStyle.setCellStyle(endStyle);
        }
        HSSFCell cell = rowDataRR.createCell(0); //获取第一行的每个单元格
        cell.setCellValue("");
        cell.setCellStyle(endStyle);

        return ++rowIndex;
    }

    private static Integer setTableInfo(HSSFWorkbook wb,HSSFSheet sheet1,Integer rowIndex,String tableName,String cName){
        CellStyle style1 = getTableTitleStyle(wb);
        CellStyle style2 = getTableHeadStyle(wb);

        HSSFRow row1 = sheet1.createRow(rowIndex);
        CellRangeAddress cra1 =new CellRangeAddress(rowIndex, rowIndex, 0, 8);
        sheet1.addMergedRegion(cra1);
        for(int i=0;i<=8;i++){
            HSSFCell cellStyle = row1.createCell(i); //获取第一行的每个单元格
            cellStyle.setCellStyle(style1);
        }
        HSSFCell cell = row1.createCell(0); //获取第一行的每个单元格
        cell.setCellValue("业务模块名称:"+cName);
        cell.setCellStyle(style1);
        rowIndex++;

        HSSFRow row2 = sheet1.createRow(rowIndex);
        CellRangeAddress cra2 =new CellRangeAddress(rowIndex, rowIndex, 0, 8);
        sheet1.addMergedRegion(cra2);
        for(int i=0;i<=8;i++){
            HSSFCell cellStyle = row2.createCell(i); //获取第一行的每个单元格
            cellStyle.setCellStyle(style1);
        }
        HSSFCell cell2 = row2.createCell(0); //获取第一行的每个单元格
        cell2.setCellValue("业务模块功能简介:"+cName);
        cell2.setCellStyle(style1);
        rowIndex++;

        HSSFRow row3 = sheet1.createRow(rowIndex);
        CellRangeAddress cra3 =new CellRangeAddress(rowIndex, rowIndex, 0, 8);
        sheet1.addMergedRegion(cra3);
        for(int i=0;i<=8;i++){
            HSSFCell cellStyle = row3.createCell(i); //获取第一行的每个单元格
            cellStyle.setCellStyle(style1);
        }
        HSSFCell cell3 = row3.createCell(0); //获取第一行的每个单元格
        cell3.setCellValue("数据表名称:"+tableName);
        cell3.setCellStyle(style1);
        rowIndex++;

        HSSFRow rowHead1 = sheet1.createRow(rowIndex);
        HSSFCell cellHead0 = rowHead1.createCell(0); //获取第一行的每个单元格
        cellHead0.setCellStyle(style2);
        cellHead0.setCellValue("序号");

        HSSFCell cellHead1 = rowHead1.createCell(1); //获取第一行的每个单元格
        cellHead1.setCellStyle(style2);
        cellHead1.setCellValue("字段标识");

        HSSFCell cellHead2 = rowHead1.createCell(2); //获取第一行的每个单元格
        cellHead2.setCellStyle(style2);
        cellHead2.setCellValue("公安数据\n" +"元标识");

        HSSFCell cellHead3 = rowHead1.createCell(3); //获取第一行的每个单元格
        cellHead3.setCellStyle(style2);
        cellHead3.setCellValue("公安数据元\n" +"限定词标识");

        HSSFCell cellHead4 = rowHead1.createCell(4); //获取第一行的每个单元格
        cellHead4.setCellStyle(style2);
        cellHead4.setCellValue("字段类型");

        HSSFCell cellHead5 = rowHead1.createCell(5); //获取第一行的每个单元格
        cellHead5.setCellStyle(style2);
        cellHead5.setCellValue("字段长度");

        HSSFCell cellHead6 = rowHead1.createCell(6); //获取第一行的每个单元格
        cellHead6.setCellStyle(style2);
        cellHead6.setCellValue("是否可空");

        HSSFCell cellHead7 = rowHead1.createCell(7); //获取第一行的每个单元格
        cellHead7.setCellStyle(style2);
        cellHead7.setCellValue("是否主键");

        HSSFCell cellHead8 = rowHead1.createCell(8); //获取第一行的每个单元格
        cellHead8.setCellStyle(style2);
        cellHead8.setCellValue("字段解释");
        return ++rowIndex;
    }


    private static Integer setTableValue(HSSFSheet sheet1,ResultSet rs1,Integer rowIndex,CellStyle stringStyle) throws SQLException {
        HSSFRow rowData1 = sheet1.createRow(rowIndex);
        HSSFCell cellData0 = rowData1.createCell(0); //获取第一行的每个单元格
        cellData0.setCellStyle(stringStyle);
        cellData0.setCellValue(rs1.getString(2));

        HSSFCell cellData1 = rowData1.createCell(1); //获取第一行的每个单元格
        cellData1.setCellStyle(stringStyle);
        cellData1.setCellValue(rs1.getString(3));

        HSSFCell cellData2 = rowData1.createCell(2); //获取第一行的每个单元格
        cellData2.setCellStyle(stringStyle);
        cellData2.setCellValue("暂无");

        HSSFCell cellData3 = rowData1.createCell(3); //获取第一行的每个单元格
        cellData3.setCellStyle(stringStyle);
        cellData3.setCellValue("暂无");

        HSSFCell cellData4 = rowData1.createCell(4); //获取第一行的每个单元格
        cellData4.setCellStyle(stringStyle);
        cellData4.setCellValue(rs1.getString(4));

        HSSFCell cellData5 = rowData1.createCell(5); //获取第一行的每个单元格
        cellData5.setCellStyle(stringStyle);

        String dataType = rs1.getString(4);
        if(dataType.equals("bit")
                || dataType.equals("datetime")
                || dataType.equals("timestamp")
                || dataType.equals("date")
                || dataType.equals("blob")
                || dataType.equals("longblob")
                || dataType.equals("longtext")){
            cellData5.setCellValue("");
        }else{
            cellData5.setCellValue(rs1.getString(5)+rs1.getString(6));
        }

        HSSFCell cellData6 = rowData1.createCell(6); //获取第一行的每个单元格
        cellData6.setCellStyle(stringStyle);
        cellData6.setCellValue(rs1.getString(8));

        HSSFCell cellData7 = rowData1.createCell(7); //获取第一行的每个单元格
        cellData7.setCellStyle(stringStyle);
        cellData7.setCellValue(rs1.getString(9));


        HSSFCell cellData8 = rowData1.createCell(8); //获取第一行的每个单元格
        cellData8.setCellStyle(stringStyle);
        cellData8.setCellValue(rs1.getString(7));

        return ++rowIndex;
    }

    private static CellStyle getTableHeadStyle(HSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("等线");
        font.setFontHeightInPoints((short)11);
        style.setFont(font);
        style.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        style.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        //style.setFillForegroundColor(HSSFColor.LIGHT_ORANGE.index);
        style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);

        style.setWrapText(true);
        style.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框
        style.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框
        style.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框
        style.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框
        return style;
    }

    private static CellStyle getTableTitleStyle(HSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("等线");
        font.setFontHeightInPoints((short)11);
        style.setFont(font);
        //style.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        //style.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        //style.setFillForegroundColor(HSSFColor.LIGHT_ORANGE.index);
        style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);

        style.setWrapText(true);
        style.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框
        style.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框
        style.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框
        style.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框
        return style;
    }

    private static CellStyle getTableIndexStyle(HSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("等线");
        font.setFontHeightInPoints((short)10);
        style.setFont(font);
        //style.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        //style.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        //style.setFillForegroundColor(HSSFColor.LIGHT_ORANGE.index);
        style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);

        style.setWrapText(true);
        style.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框
        style.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框
        style.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框
        style.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框
        return style;
    }

    private static CellStyle getTableEndStyle(HSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        style.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        style.setFillForegroundColor(HSSFColor.GREY_50_PERCENT.index);
        style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
        style.setWrapText(true);
        style.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框
        style.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框
        style.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框
        style.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框
        return style;
    }

    private static CellStyle getStringStyle(HSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        HSSFFont font = wb.createFont();
        font.setFontName("等线");
        font.setFontHeightInPoints((short)10);
        style.setFont(font);
        style.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        style.setDataFormat(format.getFormat("@"));
        style.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框
        style.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框
        style.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框
        style.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框
        return style;
    }
}