package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.sys.SysdictDAO;
import com.bcxin.ars.model.sys.Sysdict;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.bcxin.ars.service.util.SysAreaUtil.REDIS_PREFIX_KEY;


/**
 * 字典工具类
 * @author wjb
 * @date 2018年8月16日17:31:17
 * @desc 数据库编码表的工具类
 */
@Service(value="sysDictUtils")
public class SysDictUtils {
    private Logger log = LoggerFactory.getLogger(SysDictUtils.class);

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private SysdictDAO dictDao;

    /**
     *
     * @Decription:初始化全部字典到缓存
     * @author：zhongjianhui
     * @method  getDictList
     * @date：2018/6/5 16:29
     * @params： * @param type
     * @return java.util.List<com.bcxin.ars.model.sys.Syscode>
     */

    //初始化全部字典到缓存
    public void initDictList(){
        //找到数据库表中所有的值
        List<Sysdict> rList = dictDao.findAll();
        List<Sysdict> list;
        //遍历list
        for (Sysdict sysdict : rList) {
            list = new ArrayList<>();
            //获取出类型
            String dictType = sysdict.getCodeType();
            for (Sysdict sysdict2 : rList) {
                //将相同类型放入list
                if (dictType.equals(sysdict2.getCodeType())) {
                    list.add(sysdict2);
                }
            }
            //根据类型来进行缓存
            redisUtil.set(REDIS_PREFIX_KEY + "systemDict_" + StringUtil.upperCase(dictType), JSON.toJSONString(list));
            log.debug("设置进入redis缓存[{}]", "systemDict_" + StringUtil.upperCase(dictType));
        }
    }

    public void initDictMap(Map<String, String> map){
        //找到数据库表中所有的值
        List<Sysdict> rList = dictDao.findAll();
        //遍历list
        for (Sysdict sysdict : rList) {
            //根据类型来进行缓存
            map.put(sysdict.getCodeType().toUpperCase()+sysdict.getCodeValue(),sysdict.getLabel());
        }
    }


    /****
     * 根据类型和值获取对应的
     * @param dictType
     * @param codeValue
     * @return
     */
    public String getDictTypeValue(String dictType,String codeValue){
        List<Sysdict> list = getDictType(dictType);
        String result  = "";

        for (Sysdict s:
             list) {
            if(s.getCodeValue().equals(codeValue)) {
                result = s.getLabel();
                break;
            }
        }
        return result;
    }


    /**
     * 根据编码类型获取字典
     * @param dictType
     * @return
     */
    public  List<Sysdict> getDictType(String dictType) {
        String value = "";
        try {
            //从缓存中获取相应类型的值
            value = redisUtil.get(REDIS_PREFIX_KEY + "systemDict_" + StringUtil.upperCase(dictType));
        } catch (RuntimeException ex) {
            log.error("redis缓存获取systemDict异常[{}]", dictType);
        }

        //缓存中如果有值直接返回
        if(value != null) {
            if (StringUtil.isNotEmpty(value)) {
                return JSON.parseArray(value,Sysdict.class);
            }else{
                Sysdict sysdict=new Sysdict();
                sysdict.setLabel("未找到该类型数据");
                List<Sysdict> nullList=new ArrayList<>();
                nullList.add(sysdict);
                return nullList;
            }
        }

        log.debug("从数据库中重新获取systemDict配置[{}]", dictType);

        List<Sysdict> list = dictDao.findByCodeType(dictType);

        if(list != null && list.size() > 0){
            redisUtil.set(REDIS_PREFIX_KEY + "systemDict_" + StringUtil.upperCase(dictType), JSON.toJSONString(list));
            log.debug("设置进入redis缓存[{}]", "systemDict_" + StringUtil.upperCase(dictType));
        }else{
            redisUtil.set(REDIS_PREFIX_KEY + "systemDict_" + StringUtil.upperCase(dictType), "",120);
        }

        return list;
    }

}
