package com.bcxin.ars.service.util;

import com.bcxin.ars.model.Config;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @author linqinglin
 * @date 2020/12/08 0008 16:46
 */

@Service
public class DataSyncContantsUtil {


    @Autowired
    private ConfigUtils configUtils;

    @Value("${ftp-folder}")
    public String ftpFolder;

    @Value("${ftp-in-folder}")
    public String ftpInFolder;

    @Value("${ftp-out-folder}")
    public String ftpOutFolder;


    public String getTimeUrl(){
        Config config = configUtils.getConfigByKey(Constants.TIME_HOST);
        if(config != null){
            return config.getValue();
        }
        return StringUtil.EMPTY;
    }

    public String getTargetTimeUrl(){
        Config config = configUtils.getConfigByKey(Constants.TARGET_TIME_HOST);
        if(config != null){
            return config.getValue();
        }
        return StringUtil.EMPTY;
    }

    public String getDataSyncFtpUrl(){
        Config config = configUtils.getConfigByKey(Constants.DATA_SYNC_FTP_HOST);
        if(config != null){
            return config.getValue();
        }
        return StringUtil.EMPTY;
    }

}
