package com.bcxin.ars.service.util;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.TokenUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 数据库配置表的工具类
 * @author lql
 * @date 2018年8月31日17:31:17
 * @desc 数据库配置表的工具类
 */
@Service(value="configUtils")
public class ConfigUtils {
    private Logger log = LoggerFactory.getLogger(ConfigUtils.class);

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private ConfigDao configDao;


    /***
     * 广西内网地址
     */
    public final String GX_IN_URL = "http://10.148.77.214:8018/ars-rest/uploadFileBjToGx.do";


    @Value("${time-approval-download-folder}")
    public static String spdownloadFolder;

    @Value("${upload-folder}")
    public String uploadFolder;

    @Value("${approval-download-folder}")
    public String downloadFolder;

    @Value("${base-folder}")
    public String baseFolder;

    @Value("${temp-folder}")
    public String tempfolder;

    @Value("${ftp-folder}")
    public String ftpFolder;

    @Value("${timeFlag}")
    public String timeFlag = "";

    //根据数据数量情况，切分不同的大小
    @Value("${limitSize}")
    public Integer limitSize;

    //SAAS后端地址
    @Value("${saas_data_host}")
    public String saas_data_host;

    //百课堂接口地址
    @Value("${bkt_data_host}")
    public String bkt_data_host;

    @Value("${authurl}")
    public String authurl = "";
    @Value("${authswitch}")
    public String authswitch = "";
    @Value("${client_id}")
    public String client_id = "";


    @Value("${bj_zrr_client_id}")
    public String bj_zrr_client_id = "";

    @Value("${bj_zrr_client_secret}")
    public String bj_zrr_client_secret = "";

    @Value("${bj_zrr_singleLogin_url}")
    public String bj_zrr_singleLogin_url = "";

    @Value("${sysAttachmentFolder}")
    public String sysAttachmentFolder;

    @Value("${time-approval-download-folder}")
    public String intToOutFolder;

    @Value("${uploadInToOutFolder}")
    public String uploadInToOutFolder;

    //指定的cache缓存名称 2018年8月16日18:00:27 wjb
    public final static String REDIS_PREFIX_KEY = "config:";

    //初始化全部配置到缓存
    public List<Config> initConfig(){
        List<Config> configList = configDao.findAll();
        Map<String,String> map = new HashMap();
        for (Config config : configList){
            map.put(redisUtil.REDIS_PREFIX_KEY + REDIS_PREFIX_KEY + "key_" + config.getKey(), JSON.toJSONString(config));
        }

        redisUtil.multiSet(map);
        return configList;
    }
    /**
     * 获取 config 信息
     * @param key
     * @return
     */
    public Config getConfigByKey(String key){
        String value = "";
        try {
            //从缓存中获取相应类型的值
            value = redisUtil.get(REDIS_PREFIX_KEY + "key_"+key);
        } catch (RuntimeException ex) {
            ex.printStackTrace();
            log.error("redis缓存获取异常[{}]", ex);
        }

        //缓存中如果有值直接返回
        if(value != null) {
            if (StringUtil.isNotEmpty(value)) {
                return JSON.parseObject(value, Config.class);
            }else{
                return null;
            }
        }

        log.debug("从数据库中重新获取系统配置[{}]", key);

        Config config = configDao.findByKey(key);

        if(config != null){
            redisUtil.set(REDIS_PREFIX_KEY + "key_" + key, JSON.toJSONString(config));
        }else{
            redisUtil.set(REDIS_PREFIX_KEY + "key_" + key, "",120);
        }

        return config;
    }
    public Config findByKeyAndName(String key,String name){
        String value = "";
        try {
            //从缓存中获取相应类型的值
            value = redisUtil.get(REDIS_PREFIX_KEY + "keyName_"+key+"_"+name);
        } catch (RuntimeException ex) {
            log.error("redis缓存获取异常[{}]", "config");
        }

        //缓存中如果有值直接返回
        if (StringUtil.isNotEmpty(value)) {
            return JSON.parseObject(value, Config.class);
        }

        log.debug("从数据库中重新获取系统配置[{}]", key+"_"+name);

        Config config = configDao.findByKeyAndName(key,name);

        if(config != null){
            redisUtil.set(REDIS_PREFIX_KEY + "keyName_" + key+"_"+name, JSON.toJSONString(config));
        }

        return config;
    }

    public List<Config> findByLikeKey(String key){
        String value = "";
        try {
            //从缓存中获取相应类型的值
            value = redisUtil.get(REDIS_PREFIX_KEY + "likeKey_"+key);
        } catch (RuntimeException ex) {
            log.error("redis缓存获取异常[{}]", "config");
        }

        //缓存中如果有值直接返回
        if (StringUtil.isNotEmpty(value) && !"[]".equals(value)) {
            return JSON.parseArray(value, Config.class);
        }

        log.debug("从数据库中重新获取系统配置[{}]", key);

        List<Config> configs = configDao.findByLikeKey(key);

        if(configs != null){
            redisUtil.set(REDIS_PREFIX_KEY + "likeKey_" + key, JSON.toJSONString(configs));
        }

        return configs;
    }

    public void updateForKey(Config config){
        configDao.update(config);
        redisUtil.set(REDIS_PREFIX_KEY + "key_" + config.getKey(), JSON.toJSONString(config));
    }

    public void updateForKeyName(Config config){
        configDao.update(config);
        redisUtil.set(REDIS_PREFIX_KEY + "keyName_" + config.getKey()+"_"+config.getName(), JSON.toJSONString(config));
    }

    public String getWebHost(){
        Config config = getConfigByKey(Constants.WEBHOST);
        if(config != null){
            return config.getValue();
        }
        return StringUtil.EMPTY;
    }
    //获取内网环境在线预览的地址
    public String getOnlinePreviewUrl(){
        Config config = getConfigByKey(Constants.ONLINE_PREVIEW_URL);
        if(config != null){
            return config.getValue();
        }
        return StringUtil.EMPTY;
    }

    public String getCurrentNative(){
        Config config = getConfigByKey(Constants.CURRENT_NATIVE);
        if(config != null){
            return config.getValue();
        }
        return StringUtil.EMPTY;
    }

    public String getCurrentProvince(){
        Config config = getConfigByKey(Constants.CURRENT_PROVINCE);
        if(config != null){
            return config.getValue();
        }
        return StringUtil.EMPTY;
    }

    /***
     * 根据Key获取值信息
     * @return
     */
    public String getValueByKey(String key){
        Config config = getConfigByKey(key);
        if(config != null){
            return config.getValue();
        }
        return StringUtil.EMPTY;
    }


    public String getCompanyAccountRole(){
        Config config = getConfigByKey(Constants.COMPANY_ACCOUNT_ROLE);
        if(config != null){
            return config.getValue();
        }else{
            log.error("config的COMPANY_ACCOUNT_ROLE未配置");
        }
        return StringUtil.EMPTY;
    }

    public String getDataSyncStartFileName(Class annotation){
        if(annotation.equals(DataSyncAnnotation.class)){
            //外到内
            return this.getCompanyAccountRole() + Constants.UNDERLINE + Constants.DATASYNC_SHORT + Constants.UNDERLINE + Constants.OUT;
        }else{
            return this.getCompanyAccountRole() + Constants.UNDERLINE + Constants.DATASYNC_SHORT + Constants.UNDERLINE + Constants.IN;
        }
    }

    public String getIntranetName(){
        if(isIntranet()){
            //外到内
            return Constants.IN;
        }else{
            return Constants.OUT;
        }
    }
    /**
     * 判断当前是否内网
     * @return
     */
    public boolean isIntranet(){
        Config config = this.getConfigByKey(Constants.POLICE);
        if(config != null){
            if(Constants.POLICE_IN.equals(config.getValue())){
                return true;
            }
        }else{
            log.error("config的police未配置");
        }
        return false;
    }

 /**
     * 获取token
     * 用做表单重复提交验证
     * @return
     */
    public String getToken(){
        String token =  TokenUtil.getInstance().makeToken();
        redisUtil.set(token, token,1800);
        return token;
    }

    /**
     * 判断token是否存在
     * @param token
     * @return
     */
    public boolean isExistToken(String token){
        if(StringUtil.isEmpty(token)){
            return false;
        }
        //取出缓存中的token
        String server_token = redisUtil.get(token);
        //2、缓存中不存在Token(令牌)，则用户是重复提交了表单
        if(StringUtil.isEmpty(server_token)){
            return false;
        }
        redisUtil.delete(server_token);
        return true;
    }
}
