package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.context.SecurityContext;
import com.bcxin.ars.dao.conference.ConferenceAccountDao;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.conference.ConferenceAccount;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.huawei.HttpBuildUtil;
import com.bcxin.ars.util.huawei.HuaweiMeetConst;
import com.bcxin.ars.util.huawei.RestRequest;
import com.bcxin.ars.util.huawei.RestResponse;
import com.bcxin.ars.util.redis.RedisUtil;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

@Service
public class ArsUtil {


	/***
	 * 日志
	 */
	public static final Logger log = LoggerFactory.getLogger(ArsUtil.class);

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ConferenceAccountDao conferenceAccountDao;


	@Autowired
	private RedisUtil redisUtil;
	/**
	 * 获取系统当前的区域编号
	 * @return
	 */
	public Long getCurrentNatvie() {
		return SecurityContext.currentNative.get();
	}
	
	/**
	 * 获取系统当前登录用户
	 * @return
	 */
	public User getCurrentUser() {
//		User user = SecurityContext.currentUser.get();
//		if(user == null){
		try{
			if(SecurityUtils.getSubject()!=null) {
				Subject currentUser = SecurityUtils.getSubject();
				Session session = currentUser.getSession();
				User user = null;
				if (session.getAttribute("user") != null) {
					user = (User) session.getAttribute("user");
				}
				return user;
			}
		}catch (Exception e){

		}

		return null;
	}

	public ConferenceAccount getConferenceAccount(){
		User currentUser = getCurrentUser();
		ConferenceAccount account = currentUser.getConferenceAccount();
		if(account == null){
			account = conferenceAccountDao.selectByUserId(currentUser.getId());
		}

		return account;
	}
	
	/**
	 * 设置登录用户
	 * @param user
	 */
	public void setCurrentUser(User user,int timeout) {
		Subject currentUser = SecurityUtils.getSubject();
		Session session=currentUser.getSession();
		session.setAttribute("user", user);
		session.setTimeout(timeout);//单位 ms
		SecurityContext.currentUser.set(user);
	}
	
	public void clearSecurityContext() {
		SecurityContext.currentUser.remove();
		SecurityContext.currentNative.remove();
	}
	/***
	 * 判断当前用户是否为省级
	 * @return true为是，false 不是
	 * @desc  subh 2019-03-19 add
	 */
	public boolean isProvinceLevel(){
		//获取当前用户信息
		User user =getCurrentUser();
		//判断当前用户是否为空
		if(user!=null){
			//获取当前用户的机构信息
			Police police =  user.getPolice();
			//1、判断当前用户机构是否为空。2、判断当前用户机构的机构类型是否为省级
			if(police!=null && Constants.ORGTYPE_PROVINCE.equals(police.getOrgtype())){
				//当前用户机构是省级返回true
				return true;
			}
		}
		//当前用户机构非省级返回false
		return false;
	}

	public void setPoliceSearch_old(SearchDto searchDto){
		//获取当前用户信息
		User user =getCurrentUser();
		//判断当前用户是否为空
		if(user!=null){
			//获取当前用户的机构信息
			Police police =  user.getPolice();
			//1、判断当前用户机构是否为空。2、判断当前用户机构的机构类型是否为省级
			if (police != null) {
				String areaCode = police.getAreacode();
				if(StringUtil.isNotEmpty(searchDto.getAreaCode())){
					areaCode = searchDto.getAreaCode();
				}else if(Constants.BEIJING.equals(configUtils.getCurrentNative())){
					areaCode = configUtils.getCurrentNative();
				}
				if (areaCode.endsWith("0000")) {// 省
					searchDto.setAreaCode(areaCode.substring(0, 2) + "____");
				} else if (areaCode.endsWith("00")) {// 市
					searchDto.setAreaCode(areaCode.substring(0, 4) + "__");
				} else {// 区
					searchDto.setAreaCode(areaCode);
				}
				searchDto.setDistrict(searchDto.getAreaCode());
				if(!Constants.BEIJING.equals(configUtils.getCurrentNative())) {
					if (Constants.POLICE_ORGTYPE_PCS.equals(police.getOrgtype())) {
						searchDto.setOrgId(police.getId());
					}
					searchDto.setPath(police.getPath());

					if(searchDto.isPoliceBusiness()) {
						searchDto.setUserid(user.getId());
					}
				}
			}
		}
	}

	public void setPoliceSearchAll(SearchDto searchDto){
		//获取当前用户信息
		User user =getCurrentUser();
		//判断当前用户是否为空
		if(user!=null){
			//获取当前用户的机构信息
			Police police =  user.getPolice();
			//1、判断当前用户机构是否为空。2、判断当前用户机构的机构类型是否为省级
			if (police != null) {
				String areaCode = police.getAreacode();
				if(StringUtil.isNotEmpty(searchDto.getAreaCode())){
					areaCode = searchDto.getAreaCode();
				}
				if (areaCode.endsWith("0000")) {// 省
					searchDto.setAreaCode(areaCode.substring(0, 2) + "____");
				} else if (areaCode.endsWith("00")) {// 市
					searchDto.setAreaCode(areaCode.substring(0, 4) + "__");
				} else {// 区
					searchDto.setAreaCode(areaCode);
				}
				searchDto.setDistrict(searchDto.getAreaCode());
				if (Constants.POLICE_ORGTYPE_PCS.equals(police.getOrgtype())) {
					searchDto.setOrgId(police.getId());
				}
				searchDto.setPath(police.getPath());

				if(searchDto.isPoliceBusiness()) {
					searchDto.setUserid(user.getId());
				}
			}
		}
	}

	public void setPoliceSearch(SearchDto searchDto){
		//获取当前用户信息
		User user =getCurrentUser();
		//获取当前用户的机构信息
		if(null==user){
			return;
		}
		Police police =  user.getPolice();

		//判断当前用户是否为空
		if(user == null || police == null){
			return;
		}

		String areaCode = null;

		if(Constants.RANKAUTH_ALL.equals(searchDto.getRankAuth()) || Constants.ADMIN_YES.equals(user.getIsAdmin())){
			areaCode = configUtils.getCurrentProvince();
			//searchDto.setAreaCode(areaCode);
		}else{
			areaCode = police.getAreacode();
			if (Constants.POLICE_ORGTYPE_PCS.equals(police.getOrgtype())) {
				searchDto.setOrgId(police.getId());
			}
			searchDto.setPath(police.getPath());

			if(searchDto.isPoliceBusiness()) {
				searchDto.setUserid(user.getId());
			}
		}

		if(StringUtil.isNotEmpty(searchDto.getAreaCode())){
			areaCode = searchDto.getAreaCode();
		}else{
			searchDto.setAreasList(user.getAreasList());
		}

		if(StringUtil.isNotEmpty(areaCode)) {
			if (areaCode.endsWith("0000")) {// 省
				searchDto.setAreaCode(areaCode.substring(0, 2) + "____");
			} else if (areaCode.endsWith("00")) {// 市
				searchDto.setAreaCode(areaCode.substring(0, 4) + "__");
			} else {// 区
				searchDto.setAreaCode(areaCode);
			}
			searchDto.setDistrict(searchDto.getAreaCode());
		}
	}







	/**
	 * 获取华为云会议acessToken
	 * @param userName
	 * @param passWord
	 * @param userId
	 * @return accessToken
	 * @auth llc
	 * @date 2019-07-09
	 */
	public String getHuaweiMeetAccessToken(String userName, String passWord, Long userId) {
		String redisKey = redisUtil.REDIS_PREFIX_KEY + "huaweiMeet" + userId;
		String accessToken = "";
		if (!redisUtil.hasKey(redisKey)) {
			String authorization = Base64.getEncoder().encodeToString((userName + ":" + passWord).getBytes());
			Map<String, Object> map = new HashMap<>();
			map.put("account", userName);
			map.put("clientType", 0);
			map.put("createTokenType", 0);
			String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.GET_ACCESSTOKEN;
			Map<String, String> headMap = new HashMap<>();
			headMap.put("Authorization", "Basic " + authorization);
			RestRequest restRequest = HttpBuildUtil.buildRestRequest(Constants.METHOD_POST, headMap, JSON.toJSONString(map), null);
			RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
			// 200表示请求成功
			if (response.getHttpCode() == HuaweiMeetConst.HUAWEI_SUCCESS_CODE) {
				Map<String, Object> data = JSON.parseObject(response.getEntity(), Map.class);
				accessToken = data.get("accessToken").toString();
				String expiresIn = data.get("validPeriod").toString();
				// 华为云token失效时间- 一小时
				int expiresTime = Integer.parseInt(expiresIn) - 3600;
				if (expiresTime > 0) {
					redisUtil.set(redisKey, accessToken,expiresTime);
				}
			}
		} else {
			accessToken = redisUtil.get(redisKey);
			log.info("从缓存中拿accessToken:" + accessToken);
		}
		return accessToken;
	}


	/**
	 * 获取华为云会议acessToken 个人
	 * @param userName
	 * @param passWord
	 * @param userId
	 * @return accessToken
	 * @auth llc
	 * @date 2019-07-09
	 */
	public String getHuaweiMeetSelfAccessToken(String userName, String passWord, Long userId) {
		String redisKey = redisUtil.REDIS_PREFIX_KEY + "huaweiMeetSelf" + userId;
		String accessToken = "";
		if (!redisUtil.hasKey(redisKey)) {
			String authorization = Base64.getEncoder().encodeToString((userName + ":" + passWord).getBytes());
			Map<String, Object> map = new HashMap<>();
			map.put("account", userName);
			map.put("clientType", 0);
			map.put("createTokenType", 0);
			String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.GET_SELF_ACCESSTOKEN;
			Map<String, String> headMap = new HashMap<>();
			headMap.put("Authorization", "Basic " + authorization);
			RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, JSON.toJSONString(map), null);
			RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
			if (response.getHttpCode() == HuaweiMeetConst.HUAWEI_SUCCESS_CODE) {
				Map<String, Object> resultMap = JSON.parseObject(response.getEntity().toString(), Map.class);
				if (resultMap != null) {
					accessToken = resultMap.get("accessToken").toString();
					String expires_in = resultMap.get("validPeriod").toString();
					/*** 华为云token失效时间- 一小时 ***/
					int expiresTime = Integer.parseInt(expires_in) - 3600;
					if (expiresTime > 0) {
						redisUtil.set(redisKey, accessToken,expiresTime);
					}
				}
			}
		} else {
			accessToken = redisUtil.get(redisKey);
			log.info("从缓存中拿accessToken:" + accessToken);
		}
		return accessToken;
	}

	//地区查询条件的设置,areaCode,distrinct也可
	public String changeNativePlace(String nativePlace){
		if (nativePlace.endsWith("0000")) {
			return nativePlace.substring(0, 2) + "________________";
		} else if (nativePlace.endsWith("00")) {
			//市、设置机构类型 市级2
			return nativePlace.substring(0, 4) + "______________";
		}
		return nativePlace;
	}
}
