package com.bcxin.ars.service.task.impl;

import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.task.UrgentTeamDAO;
import com.bcxin.ars.dao.task.UrgentTeamPersonDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.TeamPerson;
import com.bcxin.ars.model.task.UrgentTeam;
import com.bcxin.ars.service.task.UrgentTeamService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * Created by Darren on 2017/4/2.
 */
@Service
public class UrgentTeamServiceImpl implements UrgentTeamService {

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private UrgentTeamDAO urgentTeamDAO;
    
    @Autowired
    private UrgentTeamPersonDAO urgentTeamPersonDAO;

    @Autowired
    private SecurityCompanyDao companyDao;
    @Autowired
    private SecurityPersonDao personDao;

    @Override
    public void saveUrgentTeam(String personids) {
        User user = arsUtil.getCurrentUser();
        if(user.getPlatform().intValue() == 1){
            throw new RuntimeException("当前登录不是保安公司");
        }
        
        SecurityCompany company = null;
		if(user.getPlatform() == 2){
			company = companyDao.findByUserid(user.getId());
		}
        
        //删除保安公司的应急人员小队
        urgentTeamPersonDAO.delUrgentTeam(company.getId());

        String[] personid = personids.split(",");
        if(personid!=null && personid.length>0){
            for(int i=0;i<personid.length;i++){
             String[] id =  personid[i].split("@");
                TeamPerson team = new TeamPerson();
                team.setCompanyId(company.getId());
                team.setPersonId(new Long(id[0]));
                if (id[1].equals("1")){
                    team.setInCharge(true);
                }else {
                    team.setInCharge(false);
                }
                team.setCreateTime(new Date());
                team.setUpdateTime(team.getCreateTime());

                urgentTeamPersonDAO.insert(team);

            }
        }

    }

	@Override
	public List<UrgentTeam> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return urgentTeamDAO.searchForDataSynchronization(searchDto);
	}
}
