package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.task.ComContractDao;
import com.bcxin.ars.dao.task.ComContractStationDao;
import com.bcxin.ars.dao.task.ComTaskDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.task.ComContractSearchDto;
import com.bcxin.ars.dto.task.ComContractDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.model.task.ComContractStation;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.task.ComContractService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 合同service实现
 * @author linqinglin
 * @date 2019/10/12 0012 17:46
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = ComContract.class,getMethodName = "importBatch",getImportType = ImportType.BATCH)
public class ComContractServiceImpl extends BaseService implements ComContractService {

    @Autowired
    private ComContractDao comContractDao;

    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ComTaskDao comTaskDao;

    @Autowired
    private ComContractStationDao comContractStationDao;
    @Override
    public ComContract findById(Long id) {
        return comContractDao.findById(id);
    }

    @Override
    public void search(ComContractSearchDto dto, AjaxPageResponse<ComContract> page) {
        page.setData(comContractDao.search(dto));
        page.setTotal(comContractDao.searchCount(dto));
    }

    @Override
    public void save(ComContract comContract) {
        comContract.setUpdateTime(new Date());

        Config config = configUtils.getConfigByKey(Constants.COVERT_CONTRACT_LOCATION);

        //判断劳动合同地址是否需要转换成子站的



        if (config == null || config.getValue().equals(Constants.COVERT_CONTRACT)
                || Constants.CONTRACTTYPE_COMSER.equals(comContract.getContractType())) {
            //saas文件地址 保存为ars地址
            if (StringUtil.isNotEmpty(comContract.getContractUrl())) {
                comContract.setContractUrl(getAttPath(comContract.getContractUrl()));
            }
        }

        ComContract dbComContract = comContractDao.findById(comContract.getComContractId());
        if(dbComContract != null){
            BeanUtils.copyPropertiesIgnore(comContract,dbComContract,true);
            if(comContract.getPerId() == null){
                dbComContract.setPerId(null);
            }
            BeanUtils.copyPropertiesIgnore(dbComContract,comContract,false);
            //删除企业合同驻勤点
            comContractStationDao.deleteBatchByComContractId(dbComContract.getComContractId());
        }
        comContractDao.save(comContract);
        /***
         * 合同驻勤点信息列表
         */
        if(StringUtil.isNotEmpty(comContract.getTaskStationArrs())) {
            //批量增加合同驻勤点信息
            List<ComContractStation> comContractStationList = JSON.parseArray(comContract.getTaskStationArrs(),ComContractStation.class);
            comContractStationDao.saveBatch(comContractStationList);
        }

        if(Constants.ISDELETE_YES.equals(comContract.getIsDelete())){
            comTaskDao.deleteByContractId(comContract.getComContractId());
        }
    }

    /***
     * 保存驻勤点合同
     * @param comContract
     */
    private void saveContractStation(ComContract comContract, Boolean ignoreNull){

        List<ComContractStation> newComContractStationList = comContract.getComContractStationList();

        if(ignoreNull && (newComContractStationList == null || newComContractStationList.size()==0)){
            return;
        }

        if(newComContractStationList == null) {
            newComContractStationList = new ArrayList<>();
        }

        List<ComContractStation> dbComContractStationList = comContractStationDao.findByComContractId(comContract.getComContractId());
        if (dbComContractStationList.size() > 0) {
            //删除不存在的
            List<ComContractStation> removeList = new ArrayList<>();
            CollectionUtils.addAll(removeList, new Object[dbComContractStationList.size()]);
            Collections.copy(removeList, dbComContractStationList);
            removeList.removeAll(newComContractStationList);
            if (removeList.size() > 0) {
                comContractStationDao.deleteBatchIds(removeList);
            }
        }
        //删除数据库中已存在的
        newComContractStationList.removeAll(dbComContractStationList);

        if (newComContractStationList.size() > 0) {
            //保存新增的
            comContractStationDao.saveBatch(newComContractStationList);
        }
    }
    @Override
    public void importBatch(List<ComContract> list) {
        List<ComContract> dbList = comContractDao.findByBatchIds(list);
        list.removeAll(dbList);
        if(list.size() > 0) {
            comContractDao.saveBatch(list);
            list.forEach(comContract -> {
                saveContractStation(comContract, false);
            });
            comTaskDao.deleteBatchByContractIds(list);
        }
    }

    /**
     * 搜索同步到内网的数据
     * @param dto
     * @return
     */
    @Override
    public List<ComContract> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return comContractDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ComContract> findByPerId(Long perId) {
        return comContractDao.findByPerId(perId);
    }
 @Override
    public ComContractDto findDetailById(Long id) {
        return comContractDao.findDetailById(id);
    }
    @Override
    public void converImg() {
        List<ComContract> list = comContractDao.findConverImg();
        for (ComContract comContract:
             list) {
            //saas文件地址 保存为ars地址
            if(StringUtil.isNotEmpty(comContract.getContractUrl())){
                comContract.setContractUrl(getAttPath(comContract.getContractUrl()));
                comContract.setUpdateTime(new Date());
                comContractDao.updateUrl(comContract);
            }

        }
    }


}
