package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.SubsidyConfigDao;
import com.bcxin.ars.dao.sys.SubsidyConfigDaoAop;
import com.bcxin.ars.dto.sys.SubsidyConfigDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.SubsidyConfig;
import com.bcxin.ars.service.sys.SubsidyConfigService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @author  yyx
 * @date 2020-05-14
 * @desc 补贴参数配置实现层
 */
@Service
@Transactional
public class SubsidyConfigServiceImpl implements SubsidyConfigService {

    @Autowired
    private SubsidyConfigDao subsidyConfigDao;

    @Autowired
    private SubsidyConfigDaoAop subsidyConfigDaoAop;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public SubsidyConfig findById(Long id) {
        return subsidyConfigDao.findById(id);
    }

    @Override
    public void search(SubsidyConfigDto subsidyConfigDto, AjaxPageResponse<SubsidyConfig> page) {
        subsidyConfigDao.search(subsidyConfigDto,page);
    }

    @Override
    public void save(SubsidyConfig subsidyConfig) {
        User currentUser = arsUtil.getCurrentUser();
        if(subsidyConfig.getId() == null){
            subsidyConfig.setCreateTime(new Date());
        }
        subsidyConfig.setActive(true);
        subsidyConfig.setCreateTime(new Date());
        subsidyConfig.setUpdateBy(currentUser.getUsername());
        subsidyConfig.setUpdateTime(new Date());
        subsidyConfigDaoAop.save(subsidyConfig);
    }

    @Override
    public SubsidyConfig findByBusinessType(String businessType) {
        return subsidyConfigDao.findByBusinessType(businessType);
    }

    @Override
    public List<SubsidyConfig> findAll() {
        return subsidyConfigDao.findAll();
    }
}
