package com.bcxin.ars.service.sys.impl;

import cn.jiguang.common.utils.StringUtils;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDao;
import com.bcxin.ars.dao.subsidy.ImportConfigDaoAop;
import com.bcxin.ars.dao.sys.ImportConfigDao;
import com.bcxin.ars.dao.sys.ImportDao;
import com.bcxin.ars.dao.sys.SubsidyComparisonDao;
import com.bcxin.ars.dto.subsidy.ImportAopDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.bcxin.ars.model.sys.ImportConfig;
import com.bcxin.ars.model.sys.SubsidyComparison;
import com.bcxin.ars.service.bean.factory.ImportBusinessBeanFactory;
import com.bcxin.ars.service.subsidy.GradeSubsidyRosterService;
import com.bcxin.ars.service.subsidy.ImportBusiness;
import com.bcxin.ars.service.sys.ImportService;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
public class ImportServiceImpl implements ImportService {
    @Autowired
    private ImportConfigDao importConfigDao;
    @Autowired
    private ImportDao importDao;
    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;
    @Autowired
    private SubsidyComparisonDao subsidyComparisonDao;
    @Autowired
    private ImportConfigDaoAop importConfigDaoAop;
    @Autowired
    private GradeSubsidyRosterService gradeSubsidyRosterService;

    @Override
    public ImportConfig importRoster(String businessType) {
        //通过业务类型查询出相应的导入配置
        return importConfigDao.selectByBusinessType(businessType);
    }
    @Override
    public List<Map<String, String>> selectCheckImportList(List<Map<String, String>> list,ImportConfig importConfig) {
        /***
         * 步骤
         * 1.获取业务数据
         * 2.验证是否在数据库或是否有比对过，返回错误信息
         * 3.更新业务数据
         */
        //校验失败的list
        List<Map<String, String>> failList = new ArrayList<Map<String, String>>();
        List<Map<String, String>> updateList = new ArrayList<Map<String, String>>();
        //需要查询的字段内容
        List<String> fileList = new ArrayList<>();
        fileList.add(importConfig.getFiledName());
        fileList.add(importConfig.getResultFiledName());
        String where = "";
        //不同业务有不同的取值
        ImportBusiness importBusiness= ImportBusinessBeanFactory.getImportBusinessBean(importConfig.getBusinessType());
        if(importBusiness == null){
            throw new ArsException("未找到对应业务类型");
        }
        where = importBusiness.addFileList(fileList);
        //查询数据库需要的字段
        List<Map<String, Object>> mapList =  importDao.selectByIdNum(list,fileList,importConfig,where);
        //没找到对应的身份证号则返回失败
        if(mapList == null || mapList.size() == 0 ){
            list.forEach(data->{
                data.put("errorMsg","系统中未查询到该人员的身份证号");
            });
            return list;
        }
        //返回失败的failList并去掉失败的idNum
        updateList.addAll(list);
        //TODO 待优化，用compare 来实现
        list.forEach(data->{
            //falg 表示是否加入失败列的标志，true表示失败，false表示成功
            Boolean flag = false;
            String errorMsg ="";
            for(int i = 0; i<mapList.size();i++){
                //花名册的idNum不等于数据库查找的idNum，跳过本次循环进入下一次循环，并且flag标志为true
                if(!mapList.get(i).get(importConfig.getFiledName()).equals(data.get("keyValue"))){
                    flag = true;
                    errorMsg="系统中未查询到该人员的身份证号";
                    continue;
                }else {
                    //数据中存在已经比对的状态不能再导入
                    String subsidyStatus = (String)mapList.get(i).get(importConfig.getResultFiledName());
                    if(StringUtils.isNotEmpty(subsidyStatus)&&!(Constants.TO_BE_COMPARED).equals(subsidyStatus)){
                        errorMsg="该人员已比对";
                        flag = true;
                        break;
                    }
                    String errorMsgBusiness = "";
                    //不同的业务有不同的失败信息校验
                    errorMsgBusiness = importBusiness.addErrorMsg(mapList.get(i));
                    if(StringUtils.isNotEmpty(errorMsgBusiness)){
                        flag =true;
                        errorMsg = errorMsgBusiness;
                        break;
                    }
                    //能查询到对应的身份证号
                    flag = false;
                    break;
                }
            }
            //flag为true表示最后没在数据库找到idNumber或者已比对，那么删除该人员并放入failList中
            if(flag){
                updateList.remove(data);
                data.put("errorMsg",errorMsg);
                failList.add(data);
            }
        });
        if(updateList == null || updateList.size() ==0){
            return failList;
        }
        // 获取对应的比对状态
        List<Map<String, String>> updateStatusList = getSubsidyStatus(updateList, importConfig.getBusinessType(),importConfig,failList);
        if(updateStatusList!=null&& updateStatusList.size()>0) {
            Date inTime = null;
            if(importConfig.getBusinessType().equals(Constants.COMPARE_SIGN)){
                inTime = new Date();
            }
           //把更新条件和查询条件放入一个实体类中便于操作日志的查看
            ImportAopDto importAopDto = new ImportAopDto();
            importAopDto.setUpdateStatusList(updateStatusList);
            importAopDto.setImportConfig(importConfig);
            importAopDto.setInTime(inTime);
            importAopDto.setWhere(where);
            importAopDto.setTableName(importConfig.getTableName());
            importConfigDaoAop.updateListV1(importAopDto);
            /*importDao.updateList(updateStatusList, importConfig,inTime);*/

            //等级证补贴比对同步百课堂
            if(Constants.SUBSIDY_COMPARED.equals(importConfig.getBusinessType())){
                List<GradeSubsidyRoster> rosterList = gradeSubsidyRosterDao.findByImportConfig(importAopDto);
                if(rosterList.size() > 0){
                    gradeSubsidyRosterService.compareStatusToBKT(rosterList);
                }
            }
        }
        return failList;
    }

    //根据对应的code和业务类型查询对应的比对状态
    public  List<Map<String,String>> getSubsidyStatus(List<Map<String,String>> list,String businessType,ImportConfig importConfig,List<Map<String, String>> failList){
        //根据业务类型获取所有的比对配置流向
        List<SubsidyComparison> subsidyComparisons = subsidyComparisonDao.selectAllByBusinessType(businessType);
        //能获取到比对结果的集合
        List<Map<String, String>> updateList1 = new ArrayList<Map<String, String>>();
        updateList1.addAll(list);
        list.forEach(map->{
            //code为结果状态吗
            String code = map.get("resultValue");
            map.put("resultValue","");
            subsidyComparisons.forEach(subsidyComparison -> {
                //业务类型和结果状态码可以确定唯一的比对状态
                if (subsidyComparison.getCode().equals(code)){
                    //把比对状态放入map中
                    map.put("resultValue",subsidyComparison.getFlowTo());
                }
            });
            if(StringUtils.isEmpty(map.get("resultValue"))){
                map.put("resultValue",code);
                map.put("errorMsg","未查询到该比对结果的流向");
                failList.add(map);
                updateList1.remove(map);
            }
        });
        return updateList1;
    }
}
