package com.bcxin.ars.service.sys.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sys.BankAccountDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.BankAccountPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.BankAccount;
import com.bcxin.ars.service.sys.BankAccountService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 银行账号信息Service实现类
 *
 * @author linqinglin
 * @Date 2020-05-13 14:37:13
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = BankAccount.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
public class BankAccountServiceImpl implements BankAccountService {

    Logger logger = LoggerFactory.getLogger(BankAccountServiceImpl.class);

    @Autowired
    private BankAccountDao bankAccountDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private IdWorker idWorker;

    @Override
    public int delete(BankAccount bankAccount) {
        User currentUser = arsUtil.getCurrentUser();
        bankAccount.setUpdateTime(new Date());
        bankAccount.setUpdateBy(currentUser.getUsername());
        return bankAccountDao.delete(bankAccount);
    }

    @Override
    public int save(BankAccount bankAccount) {
        BankAccount dbBankAccount = bankAccountDao.findByIdNum(bankAccount.getIdNum());
        if(dbBankAccount == null){
            bankAccount.setCreateTime(new Date());
            bankAccount.setId(idWorker.nextId());
        }else{
            BeanUtils.copyPropertiesIgnore(bankAccount,dbBankAccount,true);
            BeanUtils.copyPropertiesIgnore(dbBankAccount,bankAccount,false);
        }

        bankAccount.setActive(true);
        bankAccount.setUpdateTime(new Date());
        bankAccount.setUpdateflag(true);
        return bankAccountDao.save(bankAccount);
    }

    @Override
    public BankAccount findById(Long id) {
        return bankAccountDao.findById(id);
    }

    @Override
    public void searchForPage(BankAccountPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
       bankAccountDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<BankAccount> list) {
        List<BankAccount> dbList = bankAccountDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (BankAccount bankAccount : list) {
                bankAccount.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                       bankAccount.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, bankAccount.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            bankAccountDao.saveBatch(list);
        }
    }

    @Override
    public List<BankAccount> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return bankAccountDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<BankAccount> findDSOutList(String startDate) {
        return bankAccountDao.findDSOutList(startDate);
    }

    @Override
    public List<BankAccount> findByBatchId(List<BankAccount> list) {
        return bankAccountDao.findByBatchId(list);
    }

    @Override
    public BankAccount findByIdNum(String idNum) {
        return bankAccountDao.findByIdNum(idNum);
    }

    @Override
    public void updateSelective(BankAccount bankAccount) {
        User currentUser = arsUtil.getCurrentUser();
        bankAccount.setUpdateTime(new Date());
        bankAccount.setUpdateBy(currentUser.getUsername());
        bankAccountDao.updateSelective(bankAccount);
    }
}
