
package com.bcxin.ars.service.sys.impl;


import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.MSGConstants;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.act.ActivitiCommentDao;
import com.bcxin.ars.dao.approve.ApproveTempDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.gx.IntegratedDao;
import com.bcxin.ars.dao.sb.*;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDaoAop;
import com.bcxin.ars.dao.sys.*;
import com.bcxin.ars.dao.task.ComContractDao;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.certificate.SecurityCertificateSearchDto;
import com.bcxin.ars.dto.gx.IntegratedApplyDto;
import com.bcxin.ars.dto.gx.ResultXML;
import com.bcxin.ars.dto.page.ApprovalOutTimePageSearchDto;
import com.bcxin.ars.dto.page.ApprovalPageSearchDto;
import com.bcxin.ars.dto.saas.CrosscompanyInfo;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.dto.sys.ApprovalFormDto;
import com.bcxin.ars.dto.sys.ApprovalNoticeFormDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Activiti.ActivitiProcess;
import com.bcxin.ars.model.Activiti.ActivitiTask;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.approve.ApproveTemp;
import com.bcxin.ars.model.certificate.CompanyCertificate;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.certificate.TrainCertificate;
import com.bcxin.ars.model.gx.IntegratedApply;
import com.bcxin.ars.model.gx.IntegratedResult;
import com.bcxin.ars.model.sb.*;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.model.sys.Syscode;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.model.zw.Pctinfo;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityGuardService;
import com.bcxin.ars.service.certificate.CompanyCertificateService;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.certificate.TrainCertificateService;
import com.bcxin.ars.service.gx.InterfaceNoticeService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.*;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.util.*;
import com.bcxin.ars.service.zw.PctinfoService;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.util.gx.IntegratedConstants;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.bcxin.ars.util.xml.JaxbUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.io.Files;
import com.itextpdf.text.DocumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/***
 * 通用审批
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = Approval.class,getSeq=10000,getDataSyncType = SyncType.SYNC)
@DataSyncOutAnnotation(getClazz = Approval.class,getSeq=10000,getDataSyncType = SyncType.SYNC,getImportType = ImportType.FOREACH_FILE,getMethodName = "importApproval")
public class ApprovalServiceImpl extends BaseService implements ApprovalService {

    /**
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(ApprovalServiceImpl.class);
    /**
     * 系统统一分配给接口使用方的身份标识，作为接口账号
     */
    @Value("${integrated-key}")
    private String integratedKey;
    /**
     * 系统统一分配给接口使用方的密钥，用于保证应用程序来源的可靠性，避免应用程序被伪造，作为接口密钥
     */
    @Value("${integrated-secret}")
    private String integratedSecret;
    @Autowired
    private IntegratedDao integratedDao;
    /***
     * 广西公安互联网+平台接口地址
     */
    @Value("${integrated-resturl}")
    private String integratedRestURL;

    /**
     * 发送消息日志
     */
    @Autowired
    private MessageLogDao messageLogDao;
    /**
     * 审批工具类
     */
    @Autowired
    private ApprovalUtil approvalUtil;

    /***
     * 审批
     */
    @Autowired
    private ApprovalDAO approvalDAO;
    /**
     * 审批配置
     */
    @Autowired
    private ApprovalConfigDAO approvalConfigDAO;
    /***
     * 培训单位
     */
    @Autowired
    private TrainCertificateService trainCertificateService;

    @Autowired
    private UserBusinessTypeDao userBusinessTypeDao;
    /***
     * 保安服务公司
     */
    @Autowired
    private SponsorlicenseService sponsorlicenseService;
    /***
     * 保安服务子公司
     */
    @Autowired
    private SubsidiaryService subsidiaryService;
    /***
     * 保安员证
     */
    @Autowired
    private PersoncertificateService personcertificateService;
    /***
     *跨区域经营保安公司
     */
    @Autowired
    private CrosscompanyService crosscompanyService;
    /**
     * 培训服务
     */
    @Autowired
    private TraincompanyapplyService traincompanyapplyService;
    @Autowired
    private TrainrecordService trainrecordService;

    @Autowired
    private LegalchangeService legalchangeService;

    @Autowired
    private TrainChangeService trainChangeService;

    @Autowired
    private PerCerGrantService perCerGrantService;
    /***
     * 自行招用保安员单位
     */
    @Autowired
    private ConfesscompanyService confesscompanyService;
    /***
     * 自行招用保安员单位撤销备案
     */
    @Autowired
    private ConfesscompanyundoService confesscompanyundoService;

    @Autowired
    private YearreportService yearreportService;

    @Autowired
    private YearreportdataService yearreportdataService;

    @Autowired
    private DatasyncDao datasyncDao;

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private SyscodeDAO syscodeDAO;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private SecurityCompanyDao companyDao;

    @Autowired
    private SecurityCompanyDaoAop companyDaoAop;

    @Autowired
    private SecurityPersonDao personDao;

    @Autowired
    private ComContractDao comContractDao;
    @Autowired
    private ApprovalLogDao approvalLogDao;

    @Autowired
    private OrgnoDao orgnodao;

    @Autowired
    private CompanyCertificateService companyCertificateService;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private SecurityCertificateDao securityCertificateDao;

    @Autowired
    private PersoncertificateDao personcertificateDao;

    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private SecurityGuardService securityGuardService;

    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    @Autowired
    private ShareholderDao shareholderDao;

    @Autowired
    private ShareholderService shareholderService;

    @Autowired
    private SbSponsorlicenseManagerDao sbSponsorlicenseManagerDao;

    @Autowired
    private SbSponsorlicenseVmanagerDao sbSponsorlicenseVmanagerDao;

    @Autowired
    private SecurityCertificateService securityCertificateService;
    @Autowired
    private IdWorker idWorker;

    @Autowired
    private GradeSubsidyBatchService gradeSubsidyBatchService;

    @Autowired
    private GradeSubsidyRosterDaoAop gradeSubsidyRosterDaoAop;

    @Autowired
    private UserDao userDao;

    @Autowired
    private UserDaoAop userDaoAop;

    @Value("${base-folder}")
    private String baseFolder;

    @Value("${personcertificate-download-folder}")
    private String tempftpFolder;

    @Value("${pdf-folder}")
    private String pdfFolder;

    @Resource
    private RuntimeService runtimeService;

    @Resource
    private TaskService taskService;

    @Resource
    private HistoryService historyService;

    /**
     * 枪支机构
     */
    @Autowired
    private ArmtrainorgService armtrainorgService;

    @Autowired
    private ActivitiCommentDao activitiCommentDao;

    @Autowired
    private BackgroundApprovalService backgroundApprovalService;

    @Autowired
    private PctinfoService pctinfoService;

    @Autowired
    private ApproveTempDao approveTempDao;

    @Autowired
    private PersonBaseInfoDao personBaseInfoDao;

    @Autowired
    private InterfaceNoticeService interfaceNoticeService;
    /**
     * 保全审批分页查询
     */
    @Override
    public PageResult queryApprovalList(Map<Object, Object> p) {
        return new PageResult(approvalDAO.queryAllCnt(p), approvalDAO.queryApprovalList(p));
    }

    @Override
    public int queryAllCnt(Map<Object, Object> p) {
        return approvalDAO.queryAll(p);
    }

    @Override
    public int queryWeekNewAddCnt(Map<Object, Object> p) {
        return approvalDAO.queryWeekNewAddCnt(p);
    }

    @Override
    public int queryMonthsNewAddCnt(Map<Object, Object> p) {
        return approvalDAO.queryMonthsNewAddCnt(p);
    }

    @Override
    public int queryYearNewAddCnt(Map<Object, Object> p) {
        return approvalDAO.queryYearNewAddCnt(p);
    }
    @Override
    public int countTimeOutDays() {
        Map<Object, Object> p =  new HashMap<>();
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            if (user.getPlatform().intValue() == Constants.PLATFORM_NATURAL_PERSON || user.getPlatform().intValue() == Constants.PLATFORM_COMPANY) {//自然人或公司
                p.put("userid", user.getId());
            } else {//公安
                /***
                 * edit subh 2018-02-21 查询条件改成用用户ID begin
                 */
                if (user.getPoliceman() != null && user.getPoliceman()) {
                    p.put("policeid", user.getId());
                    p.put("taskDefinitionKey", Constants.ACTIVITI_POLICEMAN);
                }

                p.put("userid", user.getId());
                p.put("platform", user.getPlatform());

                //旧审批用到的条件
                //角色列表
                List<PoliceRole> roles = user.getRoles();
                if (roles != null && roles.size() > 0) {
                    p.put("roles", roles);
                }

                //机构信息
                Police police = policeDao.findById(user.getOrgid());
                //判断是否为派出所
                if (police.getOrgtype() != null && police.getOrgtype().equals("4")) {
                    p.put("orgid", police.getId());
                }

                //机构信息
                String areacode = police.getAreacode();
                //区域过滤
                if (StringUtil.isNotEmpty(areacode)) {
                    if (areacode.endsWith("0000")) {//省
                        p.put("areaCode", areacode.substring(0, 2) + "____");
                    } else if (areacode.endsWith("00")) {//市
                        p.put("areaCode", areacode.substring(0, 4) + "__");
                    } else {//区
                        p.put("areaCode", areacode);
                    }
                }
                //业务类型权限
                if (user.getUserBusinessTypeList() != null && user.getUserBusinessTypeList().size() > 0) {
                    p.put("userBusinessTypeList", user.getUserBusinessTypeList());
                }
            }
        }
        p.put("searchType","001");
        return approvalDAO.countTimeOutDays(p);
    }

    @Override
    public List findAllUserBusinessType(Long userId) {
        return userBusinessTypeDao.findByUserId(userId);
    }

    @Override
    public ApprovalDTO query(ApprovalDTO dto) {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            //TODO 审批机构ID
            if (user.getPlatform() == 4 || user.getPlatform() == 2) {
                dto.setUserid(user.getId());
            } else {
                //角色列表
                List<PoliceRole> roles = user.getRoles();
                if (roles != null && roles.size() > 0) {
                    dto.setRoles(roles);
                }
                //判断是否指派民警，如果是，民警则根据userid查询，
                Config config = configUtils.getConfigByKey(Constants.ISPOLICE);
                //陕西
                if (config != null && config.getValue().equals(Constants.ISPOLICE_YES)) {
                    //判断是否为民警
                    if (user.getPoliceman() != null && user.getPoliceman()) {
                        dto.setPoliceid(user.getId());
                    }
                }
                //机构信息
                Police police = policeDao.findById(user.getOrgid());
                //判断是否为派出所
                if (police.getOrgtype() != null && police.getOrgtype().equals("4")) {
                    dto.setOrgid(police.getId());
                }

                //机构信息
                String areacode = police.getAreacode();
                //区域过滤
                if (StringUtil.isNotEmpty(areacode)) {
                    if (areacode.endsWith("0000")) {//省
                        dto.setAreaCode(areacode.substring(0, 2) + "____");
                    } else if (areacode.endsWith("00")) {//市
                        dto.setAreaCode(areacode.substring(0, 4) + "__");
                    } else {//区
                        dto.setAreaCode(areacode);
                    }
                }
                dto.setPlatform(user.getPlatform());
                //业务类型权限
                if (user.getUserBusinessTypeList() != null && user.getUserBusinessTypeList().size() > 0) {
                    dto.setUserBusinessTypeList(user.getUserBusinessTypeList());
                }

            }

        }
        List<Approval> data = approvalDAO.search(dto);
        Long count = approvalDAO.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }


    @Override
    public List<Approval> findAll() {
        ApprovalDTO dto = new ApprovalDTO();
        dto.setPaging(false);
        List<Approval> data = approvalDAO.searchForExport(dto);
        return data;
    }

    @Override
    public ApprovalDTO queryTB(ApprovalDTO dto) {
        List<Approval> data = approvalDAO.search(dto);
        Long count = approvalDAO.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    /*@Override
	public void saveReplyReason(ApprovalDTO dto) {
		//获取审批信息
		Approval approval = approvalDAO.getById(dto.getId());
		//审批原因
		approval.setReplyreason(dto.getReplyreason());
		if (approval.getBusinesstype().equals(BusinessType.BAFWGS)) { //保安服务公司
			//获取保安服务公司信息，更新审批信息
			Sponsorlicense sponsorlicense = sponsorlicenseService.findById(approval.getBusinessid());
			sponsorlicense.setReplyreason(dto.getReplyreason());//批复意见
			sponsorlicenseService.saveOrUpdate(sponsorlicense);

			ApprovalDTO policeapp = new ApprovalDTO();
			policeapp.setBusinessid(sponsorlicense.getId());
			policeapp.setBusinesstype(BusinessType.BAFWGS);
			policeapp.setOrgid(sponsorlicense.getPoliceid());
			List list = approvalDAO.getBusinessidAndType(policeapp);
			if (list != null && list.size() > 0) {
				Approval temp = (Approval) list.get(0);
				temp.setApprovalstate("010");//上传批复文件
				approvalDAO.update(temp);
			}

		}  else if (approval.getBusinesstype().equals(BusinessType.PXDW)) {//培训服务
			Traincompanyapply traincompanyapply = traincompanyapplyService.findById(approval.getBusinessid());
			traincompanyapply.setReplyreason(dto.getReplyreason());//批复意见
			traincompanyapplyService.saveOrUpdate(traincompanyapply);
		}
		approvalDAO.update(approval);




	}*/
    @Override
    public void saveBQ(ApprovalDTO dto) {
        //读取配置文件
        Config config = configUtils.getConfigByKey("police");
        //获取审批信息
        Approval approval = approvalDAO.getById(dto.getId());
        //审核状态
        approval.setApprovalstate(approval.getReplystate());
        //删除批复
        approval.setReplystate("");
        //整改文件
        approval.setInfoRar(dto.getInfoRar());
        if (approval.getBusinesstype().equals(BusinessType.BAFWGS)) { //保安服务公司
            //获取保安服务公司信息，更新审批信息
            Sponsorlicense sponsorlicense = sponsorlicenseService.findById(approval.getBusinessid());
            sponsorlicense.setInfoRar(dto.getInfoRar());//整改文件附件
            sponsorlicense.setApprovalstate("004");
            sponsorlicenseService.saveOrUpdateForApproval(sponsorlicense);
        } else if (approval.getBusinesstype().equals(BusinessType.PXDW)) {//培训服务
            Traincompanyapply traincompanyapply = traincompanyapplyService.findById(approval.getBusinessid());
            traincompanyapply.setInfoRar(dto.getInfoRar());//整改文件附件
            traincompanyapply.setApprovalstate("004");
            traincompanyapplyService.saveOrUpdate(traincompanyapply);
        }
        approval.setUpdateTime(new Date());
        if (config.getValue().equals("1")) {
            approval.setUpdateflag(true);
        }
        approvalDAO.update(approval);
    }

    @Override
    public void saveReply(ApprovalDTO dto) {
        //制证状态
        String cardState ="";
        //读取配置文件
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        //获取审批信息
        Approval approval = approvalDAO.getById(dto.getId());
        //批复文件
        approval.setReplyRar(dto.getReplyRar());
        //批复状态
        approval.setReplystate(dto.getReplystate());
        if (StringUtil.isNotEmpty(dto.getReplyreason())) {
            approval.setReplyreason(dto.getReplyreason());
        }
        approval.setUpdateTime(new Date());
        if (config.getValue().equals(Constants.POLICE_IN)) {
            approval.setUpdateflag(true);
        }
        //保安服务公司
        if (approval.getBusinesstype().equals(BusinessType.BAFWGS)) {
            Sponsorlicense sponsorlicense = sponsorlicenseService.findById(approval.getBusinessid());
            sponsorlicense.setInfoRar(approval.getInfoRar());
            sponsorlicense.setReplyRar(approval.getReplyRar());
            if (StringUtil.isNotEmpty(dto.getReplyreason())) {
                sponsorlicense.setReplyreason(approval.getReplyreason());
            }
            //获取制证状态
            cardState = sponsorlicense.getCardState();
            sponsorlicense.setReplyState(approval.getReplystate());
            sponsorlicenseService.saveOrUpdateForApproval(sponsorlicense);
        //保安培训机构
        } else if (approval.getBusinesstype().equals(BusinessType.PXDW)) {
            Traincompanyapply traincompany = traincompanyapplyService.findById(approval.getBusinessid());
            traincompany.setInfoRar(approval.getInfoRar());
            traincompany.setReplyRar(approval.getReplyRar());
            if (StringUtil.isNotEmpty(dto.getReplyreason())) {
                traincompany.setReplyreason(approval.getReplyreason());
            }
            //获取制证状态
            cardState = traincompany.getCardState();
            traincompany.setReplyState(approval.getReplystate());
            traincompanyapplyService.saveOrUpdateForApproval(traincompany);
        }
        //如果已制证，下一级审批人员，显示无
        if(Constants.CARD_STATE_YZZ.equals(cardState)) {
            approval.setNextPerson(null);
        }else {
            //提示下一个审批人，上传批复文件 SUBH 2019-01-26
            if (StringUtil.isEmpty(approval.getReplyRar())) {
                approval.setNextPerson(Constants.APPROVAL_FILE);//上传批复文件
            } else {
                if(Constants.GUANGXI.equals(configUtils.getCurrentNative()) && approval.getBusinesstype().equals(BusinessType.PXDW)) {
                    Traincompanyapply traincompany = traincompanyapplyService.findById(approval.getBusinessid());
                    approval.setNextPerson(null);
                    User newUser = new User();
                    newUser.setInit(false);
                    newUser.setRealname(traincompany.getTraincompanyname());
                    newUser.setPhone(traincompany.getTrainphone());
                    //保安公司或培训单位
                    newUser.setPlatform(Constants.PLATFORM_COMPANY);
                    SecurityCompany newCompany = new SecurityCompany();
                    newCompany.setName(traincompany.getTraincompanyname());

                    newCompany.setLegalPerson(traincompany.getTrainlegalname());
                    newCompany.setLegalPersonNo(traincompany.getTraincreditcode());
                    newCompany.setLocation(traincompany.getTrainaddress());

                    newCompany.setTrainContent(traincompany.getTraincontent());
                    newCompany.setAreaCode(approval.getAreaCode());
                    newCompany.setUser(newUser);
                    //培训单位
                    newCompany.setInstitutionType(Constants.BKT_ORGTYPE_JG);
                    newCompany.setUpdateflag(true);
                    //监管机构ID
                    newCompany.setOrgId(traincompany.getOrgid().toString());
                    //监管机构ID
                    Police police = policeDao.findById(traincompany.getOrgid());
                    //机构名称
                    newCompany.setOrgName(police.getOrgname());
                    securityCompanyService.updateCompany(newCompany);
                }else{
                    approval.setNextPerson(Constants.APPROVAL_ZZ);//制证
                }
            }
        }
        approvalDAO.update(approval);
    }

    /**
     * 制证
     *
     * @param dto
     */
    @Override
    public void saveApprovalForZZ(ApprovalDTO dto) {
        Approval approval = approvalDAO.findBybusinessidAndType(dto.getBusinessid(), dto.getBusinesstype());
        Config configVersion = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
        if (approval != null && configVersion != null && Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())) {
            saveApprovalForZZ_new(dto);
        } else {
            saveApprovalForZZ_old(dto);
        }
    }

    @Deprecated
    private void saveApprovalForZZ_old(ApprovalDTO dto) {
        String newGroupid = "";
        //读取配置文件
        Config config = configUtils.getConfigByKey("police");
        //获取审批信息
        Approval approval = approvalDAO.findBybusinessidAndType(dto.getBusinessid(), dto.getBusinesstype());
        if (approval == null) {
            return;
        }

        //审批人
        //审批人
        if (StringUtil.isNotEmpty(dto.getApprovalperson())) {
            approval.setApprovalperson(dto.getApprovalperson());
        } else {
            approval.setApprovalperson("系统自动审批");
        }
        //审批日期
        approval.setApprovaldate(new Date());
//        //审批状态
//		if(StringUtil.isNotEmpty(dto.getApprovalstate())) {
//			approval.setApprovalstate(dto.getApprovalstate());
//		}
        //审批原因
        if (StringUtil.isNotEmpty(dto.getApprovalreason())) {
            approval.setApprovalreason(dto.getApprovalreason());
        }
        //修改建议
        if (StringUtil.isNotEmpty(dto.getInfoRar())) {
            approval.setInfoRar(dto.getInfoRar());
        }
        //批复 文件
        if (StringUtil.isNotEmpty(dto.getReplyRar())) {
            approval.setReplyRar(dto.getReplyRar());
        }
        //批复原因
        if (StringUtil.isNotEmpty(dto.getReplyreason())) {
            approval.setReplyreason(dto.getReplyreason());
        }

        if (BusinessType.BAYZ.equals(dto.getBusinesstype()) && (ApprovalState.SHBTG.equals(dto.getApprovalstate()) && !Constants.PROSTATE_YES.equals(dto.getProstate()))) {
            approval.setApprovalstate(dto.getApprovalstate());
            approval.setNextPerson("");
        } else {
            // 根据流程实例Id查询任务
            //.taskCandidateGroup(userId)
            Task task = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();

            Map<String, Object> variables = new HashMap<String, Object>();
            if (dto.getApprovalstate().equals(ApprovalState.SHBTG)) {
                variables.put("msg", "未通过");
            } else if (dto.getApprovalstate().equals(ApprovalState.SHTG)) {
                variables.put("msg", "通过");
            }
            // 获取流程实例id
            String processInstanceId = task.getProcessInstanceId();
            // 设置用户id
            Authentication.setAuthenticatedUserId(Constants.APPROVAL_SYSTEM);
            // 添加批注信息
            taskService.addComment(task.getId(), processInstanceId, dto.getApprovalreason());
            // 完成任务
            taskService.complete(task.getId(), variables);
            // 根据流程实例Id查询任务
            Task newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
            if (newTask != null) {
                approval.setNextPerson(newTask.getName());

                List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                    IdentityLink identityLink = newTaskEntitys.get(0);
                    newGroupid = identityLink.getGroupId();
                }
            }
        }
        approval.setGroupid(newGroupid);
        approval.setUpdateTime(new Date());
        if (config.getValue().equals("1")) {
            approval.setUpdateflag(true);
        }
        //saveBusinessForApproval(approval);
        if (dto.getApprovalstate().equals(ApprovalState.SHBTG)) {
            if (approval.getBusinesstype().equals(BusinessType.BAYZ)) {
                Personcertificate personcertificate = personcertificateDao.findById(approval.getBusinessid());
                //审批状态
                personcertificate.setApprovalstate(ApprovalState.SHBTG);
                //审批原因
                personcertificate.setApprovalreason(approval.getApprovalreason());
                personcertificate.setGroupid(approval.getGroupid());
                personcertificateDaoAop.update(personcertificate);
                approval.setApprovalstate(ApprovalState.SHBTG);
                approval.setNextPerson("");
            }
        }
        approvalDAO.update(approval);
        //保存审批日志
        saveApprovalLog(approval, dto.getApprovalstate());
    }

    public void saveApprovalForZZ_new(ApprovalDTO dto) {
        String newGroupid = "";
        //读取配置文件
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        //获取审批信息
        Approval approval = null;
        ApprovalDTO newdto = new ApprovalDTO();
        newdto.setBusinessid(dto.getBusinessid());
        newdto.setBusinesstype(dto.getBusinesstype());

        List list = approvalDAO.getBusinessidAndType(newdto);
        if (list != null && list.size() > 0) {
            approval = (Approval) list.get(0);
        } else {
            return;
        }

        //审批人
        if (StringUtil.isNotEmpty(dto.getApprovalperson())) {
            approval.setApprovalperson(dto.getApprovalperson());
        } else {
            approval.setApprovalperson("系统自动审批");
        }
        //对外审批意见
        if (StringUtil.isNotEmpty(dto.getOutreason())) {
            approval.setOutreason(dto.getOutreason());
        } else {
            approval.setOutreason("系统自动审批");
        }
        //审批日期
        approval.setApprovaldate(new Date());
//        //审批状态
//		if(StringUtil.isNotEmpty(dto.getApprovalstate())) {
//			approval.setApprovalstate(dto.getApprovalstate());
//		}
        //审批原因
        if (StringUtil.isNotEmpty(dto.getApprovalreason())) {
            approval.setApprovalreason(dto.getApprovalreason());
        }
        //修改建议
        if (StringUtil.isNotEmpty(dto.getInfoRar())) {
            approval.setInfoRar(dto.getInfoRar());
        }
        //批复 文件
        if (StringUtil.isNotEmpty(dto.getReplyRar())) {
            approval.setReplyRar(dto.getReplyRar());
        }
        //批复原因
        if (StringUtil.isNotEmpty(dto.getReplyreason())) {
            approval.setReplyreason(dto.getReplyreason());
        }

        if ((!Constants.IS_NEED_ACTIVITY_NO.equals(dto.getIsNeedActivity()) && BusinessType.BAYZ.equals(dto.getBusinesstype())) || !BusinessType.BAYZ.equals(dto.getBusinesstype()) ) {
            if (BusinessType.BAYZ.equals(dto.getBusinesstype()) && (ApprovalState.SHBTG.equals(dto.getApprovalstate()) && !Constants.PROSTATE_YES.equals(dto.getProstate()))) {
                approval.setApprovalstate(dto.getApprovalstate());
                approval.setNextPerson("");
            } else {

                // 根据流程实例Id查询任务
                //.taskCandidateGroup(userId)
                Task task = null;
                List<HistoricActivityInstance> list1 = historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
                if (list1 != null && list1.size() > 0) {
                    for (HistoricActivityInstance hai : list1) {
                        logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                        //判断是否为子流程
                        if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                            task = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                        }
                    }
                }
                if (task == null) {
                    task = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
                }


                Map<String, Object> variables = new HashMap<String, Object>();
                if (dto.getApprovalstate().equals(ApprovalState.SHBTG)) {
                    variables.put("msg", Constants.APPROVAL_MSG_BTG);
                } else if (dto.getApprovalstate().equals(ApprovalState.SHTG)) {
                    variables.put("msg", Constants.APPROVAL_MSG_TG);
                }
                // 获取流程实例id
                String processInstanceId = task.getProcessInstanceId();
                // 设置用户id
                Authentication.setAuthenticatedUserId(Constants.APPROVAL_SYSTEM);
                // 添加批注信息
                taskService.addComment(task.getId(), processInstanceId, dto.getApprovalreason());
                // 完成任务
                taskService.complete(task.getId(), variables);
                // 根据流程实例Id查询任务
                /**********************************************add subh 2018-02-21 获取子流程任务************************************************************************************/
                //查询历史
                Task newTask = null;
                List<HistoricActivityInstance> list2 = historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
                if (list != null && list.size() > 0) {
                    for (HistoricActivityInstance hai : list2) {
                        logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                        //判断是否为子流程
                        if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                            // 根据流程实例Id查询任务
                            newTask = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                        }
                    }
                }

                if (newTask == null) {
                    newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
                }
                /**********************************************add subh 2018-02-21 获取子流程任务************************************************************************************/
                // 根据流程实例Id查询任务
                //newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
                if (newTask != null && !dto.getApprovalstate().equals(ApprovalState.SHBTG)) {
                    List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                    if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                        IdentityLink identityLink = newTaskEntitys.get(0);
                        newGroupid = identityLink.getGroupId();
                    }
                    if (StringUtil.isNotEmpty(newGroupid) && (!newGroupid.equals("apply") || StringUtil.isNotEmpty(newTask.getName()))) {
                        approval.setNextPerson(newTask.getName());
                        approval.setTaskDefinitionKey(newTask.getTaskDefinitionKey());
                        approval.setApprovalstate(ApprovalState.SPZ);
                    } else {
                        approval.setNextPerson("");
                    }
                } else {
                    approval.setApprovalstate(dto.getApprovalstate());
                    approval.setNextPerson("");
                }
            }
        }else {
            approval.setApprovalstate(dto.getApprovalstate());
        }

        approval.setGroupid(newGroupid);
        approval.setUpdateTime(new Date());
        if (config.getValue().equals(Constants.POLICE_IN)) {
            approval.setUpdateflag(true);
        }
        approvalDAO.update(approval);


        if (
                //保安员证业务
                BusinessType.BAYZ.equals(dto.getBusinesstype()) &&
                ((
                  //是否启动流程，为否，并已确认成线
                 Constants.IS_NEED_ACTIVITY_NO.equals(dto.getIsNeedActivity()) && Constants.CONFIRMORDER_YES.equals(dto.getConfirmOrder())
                ) ||
                  // 是否考试通过直接制证，是
                  Constants.IS_NEED_CARD_ACTIVITY_YES.equals(dto.getIsNeedCardActivity())
                ) && ApprovalState.SHTG.equals(dto.getApprovalstate())
        ) {
            approval.setApprovalstate(dto.getApprovalstate());
            createCard(approval, dto.getIsNeedActivity());
        } else {
            //保存审批日志
            saveApprovalLogNew(approval, dto.getApprovalstate());
        }

    }

    /**
     * 自动审批 获取指纹、考试通过
     *
     * @param dto
     * @param context
     */
    @Override
    public void saveApprovalForManual(ApprovalDTO dto, String context) {
        Approval approval = approvalDAO.findBybusinessidAndType(dto.getBusinessid(), dto.getBusinesstype());
        Config configVersion = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
        if (approval != null && configVersion != null && Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())) {
            saveApprovalForManual_new(dto, context);
        } else {
            saveApprovalForManual_old(dto, context);
        }
    }

    @Deprecated
    private void saveApprovalForManual_old(ApprovalDTO dto, String context) {
        String newGroupid = "";
        //读取配置文件
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        //获取审批信息
        Approval approval = null;
        ApprovalDTO newdto = new ApprovalDTO();
        newdto.setBusinessid(dto.getBusinessid());
        newdto.setBusinesstype(dto.getBusinesstype());
        List list = approvalDAO.getBusinessidAndType(newdto);
        if (list != null && list.size() > 0) {
            approval = (Approval) list.get(0);
        } else {
            return;
        }
        //审批人
        approval.setApprovalperson(context);
        //审批日期
        approval.setApprovaldate(new Date());
        //审批原因
        if (StringUtil.isNotEmpty(dto.getApprovalreason())) {
            approval.setApprovalreason(dto.getApprovalreason());
        }
        //修改建议
        if (StringUtil.isNotEmpty(dto.getInfoRar())) {
            approval.setInfoRar(dto.getInfoRar());
        }
        //批复 文件
        if (StringUtil.isNotEmpty(dto.getReplyRar())) {
            approval.setReplyRar(dto.getReplyRar());
        }
        //批复原因
        if (StringUtil.isNotEmpty(dto.getReplyreason())) {
            approval.setReplyreason(dto.getReplyreason());
        }

        // 根据流程实例Id查询任务
        //.taskCandidateGroup(userId)
        Task task = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();

        Map<String, Object> variables = new HashMap<String, Object>();
        if (dto.getApprovalstate().equals(ApprovalState.SHBTG)) {
            variables.put("msg", "未通过");
        } else if (dto.getApprovalstate().equals(ApprovalState.SHTG)) {
            variables.put("msg", "通过");
        } else if (dto.getApprovalstate().equals(ApprovalState.JF)) {
            variables.put("msg", "取消缴费");
        }

        if (task != null) {  // 如果流程正确
            // 获取流程实例id
            String processInstanceId = task.getProcessInstanceId();
            // 设置用户id
            Authentication.setAuthenticatedUserId(Constants.APPROVAL_SYSTEM);
            // 添加批注信息
            taskService.addComment(task.getId(), processInstanceId, context);
            // 完成任务
            taskService.complete(task.getId(), variables);
            // 根据流程实例Id查询任务
            Task newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
            if (newTask != null) {
                approval.setNextPerson(newTask.getName());
                List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                    IdentityLink identityLink = newTaskEntitys.get(0);
                    newGroupid = identityLink.getGroupId();
                }
            }

            //设置当前审批候选组
            approval.setGroupid(newGroupid);
            approval.setUpdateTime(new Date());
            if (config.getValue().equals(Constants.ISPOLICE_YES)) {
                approval.setUpdateflag(true);
            }
            approvalDAO.update(approval);
            //保存审批日志
            saveApprovalLog(approval, dto.getApprovalstate());
        } else {  // 如果流程错误

            /***  返回提示信息（流程有误提示语），ajax返回标志位来控制界面的重置流程按钮显示，再编写流程重置方法
             *  请考虑所有保安员证涉及到流程操作的相关方法都做此修改  by llc
             *
             * ***/


        }

    }

    private void saveApprovalForManual_new(ApprovalDTO dto, String title) {
        String newGroupid = "";
        //读取配置文件
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        //获取审批信息
        Approval approval = null;
        ApprovalDTO newdto = new ApprovalDTO();
        newdto.setBusinessid(dto.getBusinessid());
        newdto.setBusinesstype(dto.getBusinesstype());

        List list = approvalDAO.getBusinessidAndType(newdto);
        if (list != null && list.size() > 0) {
            approval = (Approval) list.get(0);
        } else {
            return;
        }
        //审批人
        approval.setApprovalperson(title);
        //审批日期
        approval.setApprovaldate(new Date());
//        //审批状态
//		if(StringUtil.isNotEmpty(dto.getApprovalstate())) {
//			approval.setApprovalstate(dto.getApprovalstate());
//		}
        //审批原因
        if (StringUtil.isNotEmpty(dto.getApprovalreason())) {
            approval.setApprovalreason(dto.getApprovalreason());
        }
        //修改建议
        if (StringUtil.isNotEmpty(dto.getInfoRar())) {
            approval.setInfoRar(dto.getInfoRar());
        }
        //批复 文件
        if (StringUtil.isNotEmpty(dto.getReplyRar())) {
            approval.setReplyRar(dto.getReplyRar());
        }
        //批复原因
        if (StringUtil.isNotEmpty(dto.getReplyreason())) {
            approval.setReplyreason(dto.getReplyreason());
        }

        if ((Constants.IS_NEED_ACTIVITY_YES.equals(dto.getIsNeedActivity())&& BusinessType.BAYZ.equals(dto.getBusinesstype())) || ! BusinessType.BAYZ.equals(dto.getBusinesstype())) {
            // 根据流程实例Id查询任务
            //.taskCandidateGroup(userId)
            Task task = null;
            List<HistoricActivityInstance> list1 = historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
            if (list1 != null && list1.size() > 0) {
                for (HistoricActivityInstance hai : list1) {
                    logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                    //判断是否为子流程
                    if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                        task = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                    }
                }
            }
            if (task == null) {
                task = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
            }

            Map<String, Object> variables = new HashMap<String, Object>();
            if (dto.getApprovalstate().equals(ApprovalState.SHBTG)) {
                variables.put("msg", Constants.APPROVAL_MSG_BTG);
            } else if (dto.getApprovalstate().equals(ApprovalState.SHTG)) {
                variables.put("msg", Constants.APPROVAL_MSG_TG);
            } else if (dto.getApprovalstate().equals(ApprovalState.JF)) {
                variables.put("msg", Constants.APPROVAL_MSG_QXJF);
            }
            // 获取流程实例idbatchSaveApproval
            String processInstanceId = task.getProcessInstanceId();
            // 设置用户id
            Authentication.setAuthenticatedUserId(Constants.APPROVAL_SYSTEM);
            // 添加批注信息
            taskService.addComment(task.getId(), processInstanceId, (dto.getApprovalreason() == null ? "" : dto.getApprovalreason()));
            // 完成任务${msg=='取消缴费'}
            taskService.complete(task.getId(), variables);
            // 根据流程实例Id查询任务
            /**********************************************add subh 2018-02-21 获取子流程任务************************************************************************************/
            //查询历史
            Task newTask = null;
            List<HistoricActivityInstance> list2 = historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
            if (list != null && list.size() > 0) {
                for (HistoricActivityInstance hai : list2) {
                    logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                    //判断是否为子流程
                    if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                        // 根据流程实例Id查询任务
                        newTask = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                    }
                }
            }

            if (newTask == null) {
                newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
            }
            /**********************************************add subh 2018-02-21 获取子流程任务************************************************************************************/
            // 根据流程实例Id查询任务
            //newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
            if (newTask != null && !dto.getApprovalstate().equals(ApprovalState.SHBTG)) {
                List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                    IdentityLink identityLink = newTaskEntitys.get(0);
                    newGroupid = identityLink.getGroupId();
                }
                if (StringUtil.isNotEmpty(newGroupid) && (!newGroupid.equals("apply") || StringUtil.isNotEmpty(newTask.getName()))) {
                    approval.setNextPerson(newTask.getName());
                    approval.setTaskDefinitionKey(newTask.getTaskDefinitionKey());
                    approval.setApprovalstate(ApprovalState.SPZ);

                } else {
                    approval.setNextPerson("");
                }
            } else {
                approval.setApprovalstate(dto.getApprovalstate());
                approval.setNextPerson("");
            }
        }

        approval.setGroupid(newGroupid);
        approval.setUpdateTime(new Date());
        if (config.getValue().equals(Constants.POLICE_IN)) {
            approval.setUpdateflag(true);
        }
        approvalDAO.update(approval);

        //保存审批日志
        //配置 是否需要流程
        if (Constants.IS_NEED_ACTIVITY_NO.equals(dto.getIsNeedActivity()) && BusinessType.BAYZ.equals(dto.getBusinesstype())) {
        } else {
            //保存审批日志
            saveApprovalLogNew(approval, dto.getApprovalstate());
        }

    }
    @Override
    public AjaxResult batchSaveApproval(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        //先批量查询审批id对应的保安员资格证
        List<Approval> approvalList = approvalDAO.batchBayzApprovalFindByID(personIds);
        List<Approval> doApprovalList=new ArrayList<>();
        List<Personcertificate> doPersoncertificate=new ArrayList<>();

        StringBuilder msg = new StringBuilder();
        if (approvalList != null && approvalList.size() > 0) {
            for (Approval approval:approvalList){
                //保安员证
                Personcertificate personcertificate = personcertificateService.findById(approval.getBusinessid());
                if(!Constants.CENSORSTATUS_PASS.equals(personcertificate.getCensorStatus())){
                    msg.append(personcertificate.getName()+"、");
                    continue;
                }

                approval.setApprovalstate(ApprovalState.SHTG);
                String newGroupid = "";
                String processName = "";
                //读取配置文件
                Config config = configUtils.getConfigByKey(Constants.POLICE);
                User currentUser = arsUtil.getCurrentUser();

                //审批人
                approval.setApprovalperson(currentUser.getRealname());
                //审批日期
                approval.setApprovaldate(new Date());
                String   approvalreason="审批通过--批量";
                approval.setApprovalreason(approvalreason);
                String taskDefinitionKey = "";
                Task task = null;
                List<HistoricActivityInstance> list1 = historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
                if (list1 != null && list1.size() > 0) {
                    for (HistoricActivityInstance hai : list1) {
                        logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                        //判断是否为子流程
                        if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                            // 根据流程实例Id查询任务
                            processName = hai.getActivityName();
                            task = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                        }
                    }
                }
                if (task == null) {
                    task = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
                }

                List<IdentityLink> taskEntitys = taskService.getIdentityLinksForTask(task.getId());
                //审批用户ID
                String groupid = "";

                if (taskEntitys != null) {

                    boolean authflag = true;
                    for (IdentityLink identityLink : taskEntitys) {
                        groupid = identityLink.getGroupId();
                        //判断任务的审批groupid是否与当前用户ID是否一致
                        if (groupid.equals(currentUser.getId().toString())) {
                            authflag = false;
                        }
                    }
                    if (authflag) {
                        throw new ArsException("请勿重复审批，或者您的账号没有该环节审批权限！");
                    }
                }

                Map<String, Object> variables = new HashMap<String, Object>();
                variables.put("msg", Constants.APPROVAL_MSG_TG);

                //许可 001
                //不许可002
                //整改 003
                if (StringUtil.isNotEmpty(approval.getReplystate())) {
                    variables.put("replystate", approval.getReplystate());
                } else {
                    variables.put("replystate", "");
                }
                processName = processName + "--" + task.getName();
                // 获取流程实例id
                String processInstanceId = task.getProcessInstanceId();
                // 设置用户id
                Authentication.setAuthenticatedUserId(currentUser.getRealname());
                // 添加批注信息
                logger.info(processName + ":" + approvalreason);
                taskDefinitionKey = task.getTaskDefinitionKey();
                taskService.addComment(task.getId(), processInstanceId, approvalreason);
                // 完成任务
                taskService.complete(task.getId(), variables);
                /**********************************************add subh 2018-02-21 获取子流程任务************************************************************************************/
                //查询历史
                Task newTask = null;

                List<HistoricActivityInstance> list = historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
                if (list != null && list.size() > 0) {
                    for (HistoricActivityInstance hai : list) {
                        logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                        //判断是否为子流程
                        if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                            // 根据流程实例Id查询任务
                            newTask = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                        }
                    }
                }

                if (newTask == null) {
                    newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
                }
                /**********************************************add subh 2018-02-21 获取子流程任务************************************************************************************/
                // 根据流程实例Id查询任务
                //newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
                if (newTask != null ) {
                    List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                    if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                        IdentityLink identityLink = newTaskEntitys.get(0);
                        newGroupid = identityLink.getGroupId();
                    }
                    if (StringUtil.isNotEmpty(newGroupid) && (!newGroupid.equals("apply") || StringUtil.isNotEmpty(newTask.getName()))) {
                        approval.setNextPerson(newTask.getName());
                        approval.setTaskDefinitionKey(newTask.getTaskDefinitionKey());
                        approval.setApprovalstate(ApprovalState.SPZ);

                    } else {
                        approval.setNextPerson("");
                    }
                } else {
                    approval.setApprovalstate(approval.getApprovalstate());
                    approval.setNextPerson("");
                }
                //设置当前审批候选组
                approval.setGroupid(newGroupid);


                //审批人
                personcertificate.setApprovalperson(currentUser.getRealname());
                //审批状态
                personcertificate.setApprovalstate(approval.getApprovalstate());
                personcertificate.setUpdateBy(approval.getUpdateBy());
                //审批原因
                personcertificate.setApprovalreason(approval.getApprovalreason());
                personcertificate.setGroupid(approval.getGroupid());



                /**
                 * 是否需要缴费
                 */
                Config c = configUtils.getConfigByKey(Constants.CONFIGFEE + currentUser.getCityAreaCode());
                //是否需要 缴费确认 环节
                if (null != c && Constants.CONFIGFEE_YES.equals(c.getValue())) {
                    //如果需要缴费
                    //更新缴费标记
                    if (taskDefinitionKey.equals(Constants.PAYCONFIG)) {
                        personcertificate.setPayConfirm(Constants.FEE_STATE_YJF);
                    }
                }
                doPersoncertificate.add(personcertificate);
                approval.setUpdateTime(new Date());
                if (config.getValue().equals(Constants.POLICE_IN)) {
                    approval.setUpdateflag(true);
                }
                doApprovalList.add(approval);
                ApprovalDTO approvalDTO=new ApprovalDTO();
                BeanUtils.copyPropertiesIgnore(approval,approvalDTO);

                //只有保安员证
                saveApproval_all_new(approval, approvalDTO);
            }
            if(doPersoncertificate.size()>0) {
                personcertificateService.updateBatch(doPersoncertificate);
                approvalDAO.updatebatch(doApprovalList);
            }
            result.setSuccessful(true);
            result.setMsg("审批完成");
            if(msg.length()>0){
                result.setSuccessful(false);
                result.setMsg("除了 "+msg.toString() +"背景筛查不通过，无法批量审批通过。其余已审批完成");

            }
            return result;
        } else {
            result.setSuccessful(false);
            result.setMsg("没有选中可以审批的保安员");
            return result;
        }


    }
    @Override
    public void saveApproval(ApprovalDTO dto) {
        String newGroupid = "";
        String processName = "";
        //读取配置文件
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        //获取当前省份
        Config currentNativeConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
        User currentUser = arsUtil.getCurrentUser();
        //获取审批信息
        Approval approval = approvalDAO.getById(dto.getId());
        //审批人
        approval.setApprovalperson(currentUser.getRealname());
        //审批日期
        approval.setApprovaldate(new Date());
        //审批原因
        String approvalreason = "";
        //if (dto.getApprovalstate().equals(Constants.APPROVALSTATE_BTG)) {
        //    approvalreason = "（不同意）";
        //} else {
        //    approvalreason = "（同意）";
        //}

        if (StringUtil.isNotEmpty(dto.getApprovalreason())) {
            approvalreason = dto.getApprovalreason() + approvalreason;
        }
        approval.setApprovalreason(approvalreason);
        //修改建议
        if (StringUtil.isNotEmpty(dto.getInfoRar())) {
            approval.setInfoRar(dto.getInfoRar());
        }
        //批复 文件
        if (StringUtil.isNotEmpty(dto.getReplyRar())) {
            approval.setReplyRar(dto.getReplyRar());
        }

        //批复原因
        if (StringUtil.isNotEmpty(dto.getReplyreason())) {
            approval.setReplyreason(dto.getReplyreason());
        }

        /**
         * 对外意见
         */
        if (StringUtil.isNotEmpty(dto.getOutreason())) {
            approval.setOutreason(dto.getOutreason());
        }
        //对外附件
        if (StringUtil.isNotEmpty(dto.getOutinfoRar())) {
            approval.setOutinfoRar(dto.getOutinfoRar());
        }
        // 根据流程实例Id查询任务
// 		Task task=taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
        String taskDefinitionKey = "";
        Task task = null;
        List<HistoricActivityInstance> list1 = historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
        if (list1 != null && list1.size() > 0) {
            for (HistoricActivityInstance hai : list1) {
                logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                //判断是否为子流程
                if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                    // 根据流程实例Id查询任务
                    processName = hai.getActivityName();
                    task = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                }
            }
        }
        if (task == null) {
            task = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
        }

        List<IdentityLink> taskEntitys = taskService.getIdentityLinksForTask(task.getId());
        //审批用户ID
        String groupid = "";

        if (taskEntitys != null) {

            boolean authflag = true;
            for (IdentityLink identityLink : taskEntitys) {
                groupid = identityLink.getGroupId();
                //判断任务的审批groupid是否与当前用户ID是否一致
                if (groupid.equals(currentUser.getId().toString())) {
                    authflag = false;
                }
            }
            if (authflag) {
                throw new ArsException("请勿重复审批，或者您的账号没有该环节审批权限！");
            }
        }

        Map<String, Object> variables = new HashMap<String, Object>();

        String approvalstateFlag = dto.getApprovalstate();
        if (dto.getApprovalstate().equals(ApprovalState.SHBTG)) {
            //陕西省级 且 不是最后一级审批
            //则 审批不通过也是审批通过，流程往下走
            if( currentNativeConfig!=null && currentNativeConfig.getValue().equals(Constants.SHANGXI) && arsUtil.isProvinceLevel() && !checkProcess(approval.getId())){
                variables.put("msg", Constants.APPROVAL_MSG_TG);
                dto.setOutreason("");
                approvalstateFlag = ApprovalState.SHTG;
            }else {
                variables.put("msg", Constants.APPROVAL_MSG_BTG);
                approval.setTaskDefinitionKey(null);
            }
        } else if (dto.getApprovalstate().equals(ApprovalState.SHTG)) {
            variables.put("msg", Constants.APPROVAL_MSG_TG);
        }



        //许可 001
        //不许可002
        //整改 003
        if (StringUtil.isNotEmpty(approval.getReplystate())) {
            variables.put("replystate", approval.getReplystate());
        } else {
            variables.put("replystate", "");
        }
        processName = processName + "--" + task.getName();
        // 获取流程实例id
        String processInstanceId = task.getProcessInstanceId();
        // 设置用户id
        Authentication.setAuthenticatedUserId(currentUser.getRealname());
        // 添加批注信息
        logger.info(processName + ":" + approvalreason);
        taskDefinitionKey = task.getTaskDefinitionKey();
        taskService.addComment(task.getId(), processInstanceId, approvalreason);
        // 完成任务
        taskService.complete(task.getId(), variables);
        /**********************************************add subh 2018-02-21 获取子流程任务************************************************************************************/
        //查询历史
        Task newTask = null;

        List<HistoricActivityInstance> list = historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
        if (list != null && list.size() > 0) {
            for (HistoricActivityInstance hai : list) {
                logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                //判断是否为子流程
                if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                    // 根据流程实例Id查询任务
                    newTask = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                }
            }
        }

        if (newTask == null) {
            newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
        }
        /**********************************************add subh 2018-02-21 获取子流程任务************************************************************************************/
        // 根据流程实例Id查询任务
        //newTask = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
        if (newTask != null && !approvalstateFlag.equals(ApprovalState.SHBTG)) {
            List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
            if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                IdentityLink identityLink = newTaskEntitys.get(0);
                newGroupid = identityLink.getGroupId();
            }
            if (StringUtil.isNotEmpty(newGroupid) && (!newGroupid.equals("apply") || StringUtil.isNotEmpty(newTask.getName()))) {
                approval.setNextPerson(newTask.getName());
                approval.setTaskDefinitionKey(newTask.getTaskDefinitionKey());
                approval.setApprovalstate(ApprovalState.SPZ);

            } else {
                approval.setNextPerson("");
            }
        } else {
            approval.setApprovalstate(dto.getApprovalstate());
            approval.setNextPerson("");
        }
        //设置当前审批候选组
        approval.setGroupid(newGroupid);


        /**
         * 是否需要缴费
         */
        //保安员证业务
        if(BusinessType.BAYZ.equals(approval.getBusinesstype())) {
            Config c = configUtils.getConfigByKey(Constants.CONFIGFEE + currentUser.getCityAreaCode());
            //是否需要 缴费确认 环节
            if (null != c && Constants.CONFIGFEE_YES.equals(c.getValue())) {
                //如果需要缴费
                //更新缴费标记
                if (taskDefinitionKey.equals(Constants.PAYCONFIG)) {
                    Personcertificate personcertificate = personcertificateService.findById(approval.getBusinessid());
                    personcertificate.setPayConfirm(Constants.FEE_STATE_YJF);
                    personcertificateService.updatePayConfirm(personcertificate);
                }
            }
        }

        approval.setUpdateTime(new Date());
        if (config.getValue().equals(Constants.POLICE_IN)) {
            approval.setUpdateflag(true);
        }

        saveApproval_all_new(approval, dto);


       // approval.setApprovalstate(approvalstateFlag);
        saveBusinessForApproval(approval);

        approvalDAO.update(approval);
    }

    private void saveApproval_all(Approval approval, ApprovalDTO dto) {
        //跨区、自行招用、分公司撤销、自行招用撤销 生成确认单、登记证
        createConfirmAndRegisterForm(approval);
        //法人变更生成证书,保安员制证
        createCard(approval, "");
        //保存审批日志
        saveApprovalLog(approval, dto.getApprovalstate());

        /*********** TODO 待测试 add 2019-05-12 subh  *** */
       /* //获取接口class
        Class businessClassz = BusinessTypeClass.convertClass(approval.getBusinesstype());
        //获取接口实现类
        Object  businessService = SpringContextUtil.getBean(businessClassz);
        //调用审批状态更新方法
        Method updsateStateMethod =  ReflectionUtils.findMethod(businessService.getClass(),Constants.APPROVALUPDATESTATEMETHODNAME);
        //执行方法,更新状态方法
        ReflectionUtils.invokeMethod(updsateStateMethod,businessService,approval);*/
        /*********** TODO 待测试 add 2019-05-12 subh  *** */
    }

    private void saveApproval_all_new(Approval approval, ApprovalDTO dto) {
        //跨区、自行招用、分公司撤销、自行招用撤销 生成确认单、登记证
        createConfirmAndRegisterForm(approval);
        //法人变更生成证书,保安员制证
        createCard(approval, "");
        //保存审批日志
        saveApprovalLogNew(approval, dto.getApprovalstate());


    }

@Override
    public void createCard(Approval approval, String isNeedActiviy) {
        User currentUser = arsUtil.getCurrentUser();
        /**
         * 当前省份信息
         */
        if (approval.getApprovalstate().equals(ApprovalState.SHTG)) {//审批通过
            if (approval.getBusinesstype().equals(BusinessType.FRBG)) {
                //审批通过之后，下一级审批人员提示：填写批复意见，宁夏和陕西不需要填批复意见和批复文件
                approval.setNextPerson(Constants.APPROVAL_ZZ);
            } else if (approval.getBusinesstype().equals(BusinessType.BAYZ)) {
                Personcertificate personcertificate = personcertificateService.findById(approval.getBusinessid());
                Police police = null;
                StringBuffer sb = new StringBuffer();
                //如果不需要activity流程，则根据申报区域获取机构信息
                if (!Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActiviy)) {
                    Police dbPolice = new Police();
                    dbPolice.setAreacode(personcertificate.getDistrict().substring(0, 4) + "00");
                    List<Police> policeList = policeDao.findPoliceByAreacode(dbPolice);
                    police = policeList.get(0);
                } else {
                    police = currentUser.getPolice();
                    sb.append(currentUser.getUsername());
                }

                //生成保安员证
                SecurityCertificate securityCertificate = new SecurityCertificate();
                if (personcertificate != null) {
                    securityCertificate.setSecuritypersonid(personcertificate.getId());
                }
                securityCertificate.setActive(true);
                securityCertificate.setCreateTime(new Date());
                securityCertificate.setUpdateTime(new Date());
                securityCertificate.setUpdateBy(sb.toString());
                //默认生成证书，状态有效
                securityCertificate.setZzzt(Constants.ZSSTATE_YX);
                securityCertificate.setZzrq(new Date());
                securityCertificate.setFzrq(new Date());
                //证书状态为正常
                securityCertificate.setState(Constants.CERT_STATE_YES);
                //发证机关名称
                if (police != null) {
                    securityCertificate.setFzjgmc(police.getOrgname());
                }

                if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                    Boolean havePhoto = false;
                    PersonBaseInfo personBaseInfo = personBaseInfoDao.findByIdNum(personcertificate.getCardnumber());
                    if(personBaseInfo != null && StringUtil.isNotEmpty(personBaseInfo.getImgPath())){
                        //北京人口库照片
                        havePhoto = true;
                        securityCertificate.setHeadImg(personBaseInfo.getImgPath());
                    }else{
                        SecurityPerson securityPerson = personDao.findUsedByIdNum(personcertificate.getCardnumber());
                        if (securityPerson != null && StringUtil.isNotEmpty(securityPerson.getIdPhoto())) {
                            havePhoto = true;
                            securityCertificate.setHeadImg(securityPerson.getIdPhoto());
                        } else if (StringUtil.isNotEmpty(personcertificate.getImglogo())) {
                            havePhoto = true;
                            securityCertificate.setHeadImg(personcertificate.getImglogo());
                        }
                    }
                    securityCertificate.setHavephoto(havePhoto);
                }else if(Constants.SHANGXI.equals(configUtils.getCurrentNative())){
                    //延安、商洛
                    if(Constants.YANAN.equals(personcertificate.getCity()) || Constants.SHANGLUO.equals(personcertificate.getCity())) {
                        if (StringUtil.isNotEmpty(personcertificate.getImglogo())) {
                            securityCertificate.setHavephoto(true);
                            securityCertificate.setHeadImg(personcertificate.getImglogo());
                        }
                    }
                }else if(Constants.GUANGXI.equals(configUtils.getCurrentNative())){
                    Boolean havePhoto = false;
                    SecurityPerson securityPerson = personDao.findUsedByIdNum(personcertificate.getCardnumber());
                    if (securityPerson != null && StringUtil.isNotEmpty(securityPerson.getIdPhoto())) {
                        havePhoto = true;
                        securityCertificate.setHeadImg(securityPerson.getIdPhoto());
                    } else if (securityPerson != null && StringUtil.isNotEmpty(securityPerson.getPhoto())) {
                        havePhoto = true;
                        securityCertificate.setHeadImg(securityPerson.getPhoto());
                    } else if (StringUtil.isNotEmpty(personcertificate.getImglogo())) {
                        havePhoto = true;
                        securityCertificate.setHeadImg(personcertificate.getImglogo());
                    }
                    securityCertificate.setHavephoto(havePhoto);
                }
                securityCertificate.setXm(personcertificate.getName());
                securityCertificate.setIdnum(personcertificate.getCardnumber());
                securityCertificate.setAddress(personcertificate.getAddress());
                securityCertificate.setPopulationAddress(personcertificate.getPopulationAddress());
                securityCertificate.setAreaCode(personcertificate.getDistrict());
                securityCertificate.setOrgId(personcertificate.getOrgid());
                securityCertificate.setCompanyId(personcertificate.getCompanyid());
                securityCertificate.setCompanyName(personcertificate.getCompanyname());
                securityCertificate.setPersonId(personcertificate.getPersonid());
                if(StringUtil.isNotEmpty(personcertificate.getTrainOrgID())) {
                    securityCertificate.setTrainId(Long.parseLong(personcertificate.getTrainOrgID()));
                }else{
                    if(Constants.YES.equals(personcertificate.getNaturalPer())) {
                        if(personcertificate.getCompanyid() != null) {
                            SecurityCompany company = securityCompanyService.findById(personcertificate.getCompanyid());
                            securityCertificate.setTrainId(Long.parseLong(company.getComId()));
                        }
                    }
                }

                if(StringUtil.isNotEmpty(personcertificate.getTrainOrgName())) {
                    securityCertificate.setTrainName(personcertificate.getTrainOrgName());
                }else{
                    if(Constants.YES.equals(personcertificate.getNaturalPer())) {
                        securityCertificate.setTrainName(personcertificate.getCompanyname());
                    }
                }
                securityCertificate.setUserid(personcertificate.getUserid());
                securityCertificate.setPhone(personcertificate.getPhone());
                securityCertificate.setSex(personcertificate.getSex());
                securityCertificate.setCsrq(IdNumUtil.getBirthdayByIdCard(personcertificate.getCardnumber()));

                //默认录入证书的时候，打印状态为未打印
                securityCertificate.setIsprint(false);

                String maxZsbh_year = "";

                if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                    int zsbhId = personcertificateDao.getNextVal("seq_zsbh");
                    maxZsbh_year = "京" +zsbhId;
                    //北京特殊处理，发证机构全部为北京市公安局
                    securityCertificate.setFzjgmc("北京市公安局");
                    securityCertificate.setFzjgbh("110000000000");
                    //背景设置人口库地址
                    //securityCertificate.setAddress(personcertificate.getPopulationAddress());
                }else{
                    //TODO
                    //保安员证编号规则：第一个字为省、自治区、直辖市简称，后面12位数字中，前两位是发证设区市公安机关编号，中间四位是发证年份，最后六位是发证顺序号，从000001开始。
                    SimpleDateFormat simpleDateFormat;
                    simpleDateFormat = new SimpleDateFormat("yyyy");
                    Date date = new Date();
                    Config config = configUtils.getConfigByKey("current_native_short");
                    String year = "";
                    if (config != null && config.getValue() != null) {
                        if (police != null && police.getAreacode() != null) {
                            Orgno orgno = orgnodao.findByAreaCode(police.getAreacode().substring(0, 4));
                            //	Orgno orgno = orgnodao.findByAreaCode("112233");
                            if (orgno != null && !orgno.getOrgnum().equals("")) {
                                year = config.getValue() + orgno.getOrgnum().substring(2, 4) + simpleDateFormat.format(date);
                                securityCertificate.setFzjgbh(orgno.getOrgnum());
                            } else {
                                year = config.getValue() + simpleDateFormat.format(date);
                            }
                        }
                    }
                    SecurityCertificateSearchDto searchdto = new SecurityCertificateSearchDto();
                    searchdto.setZsbh(year);
                    maxZsbh_year = securityCertificateDao.searchMaxZsbhCount(searchdto);

                    if (StringUtils.isEmpty(maxZsbh_year)) {
                        maxZsbh_year = year + "000001";
                    } else {
                        maxZsbh_year = maxZsbh_year.substring(0, 7)
                                + StringUtil.addZeroForNum(String.valueOf((Long.valueOf(maxZsbh_year.substring(7)) + 1)), 6);
                    }
                }
                securityCertificate.setZsbh(maxZsbh_year);

                securityCertificate.setUpdateflag(true);
                securityCertificate.setId(idWorker.nextId());

                String photo = securityCertificateService.getPhotoUrl(securityCertificate);
                securityCertificateService.savePerCerSnapshot(securityCertificate,photo);

                //1、现有资格证数据进行清理，只留最新一条发证数据，历史数据调整为吊销状态，吊销后不可被查询、导出、用于统计；
                //2、人员新考取证书时，需要更新资格证最新记录，设置新考取的证书信息为有效数据；
                //3、同步到SaaS的证书数据中，要带有发证机构编码，便于SaaS区分发证来源。
                securityCertificateDao.updateOldCerState(securityCertificate);

                securityCertificateDao.save(securityCertificate);
                //更新制证状态  已制证
                personcertificate.setUpdateTime(new Date());
                personcertificate.setCardState(Constants.CARD_STATE_YZZ);
                personcertificate.setUpdateflag(true);
                personcertificate.setUpdateBy(sb.toString());
                personcertificateDaoAop.update(personcertificate);

                //人员ID不能为空
                if(personcertificate.getPersonid()!=null) {
                    //证书信息同步到保安人员
                    securityCertificateService.updateSecurityPersonCertificateInfo(securityCertificate);

                if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                    MessageUtil.sendMessageHuaWei(personcertificate.getPhone(), Constants.MESSAGETYPE_B83, messageLogDao, new String[]{}, MSGConstants.SMSCODE_B83);

                    //TODO 站内信通知:
                    SAASMessageDto messageDto=new SAASMessageDto();
                    messageDto.setTitle(Constants.MESSAGETYPE_B83_TITLE);
                    messageDto.setContent(Constants.MESSAGETYPE_B83);
                    messageDto.setWay(Constants.SAAS_MESSAGE_SEND_WAY);//发送方式
                    messageDto.setMessageType(Constants.MESSAGETYPE_010108);    //消息类型
                    messageDto.setIsNeedCallBackBBD(Constants.NEEDCALLBACKBBD_NO); //是否回调
                    messageDto.setIds(String.valueOf(personcertificate.getPersonid())); //接收人id
                    AjaxResult result = saasInterfaceUtil.sendSaasMsg(messageDto);
                }
                }
            }

        }

    }




    /**
     * 保存审批日志
     *
     * @param approval
     */
    @Override
    public void saveApprovalLog(Approval approval, String approvalstate) {
        User currentUser = arsUtil.getCurrentUser();
        ApprovalLog approvalLog = new ApprovalLog();
        if (currentUser == null) {
            approvalLog.setUpdateBy("system");
            approvalLog.setApprovalorg("系统自动");
        } else {
            approvalLog.setUpdateBy(currentUser.getUsername());
            approvalLog.setApprovalorg(currentUser.getPolice().getOrgname());
        }
        approvalLog.setActive(true);
        approvalLog.setType(Constants.APPROVAL_LOG_IN);
        approvalLog.setCreateTime(new Date());
        approvalLog.setUpdateTime(new Date());
        approvalLog.setApprovaldate(new Date());
        approvalLog.setApprovalperson(approval.getApprovalperson());
        approvalLog.setApprovalreason(approval.getApprovalreason());
        approvalLog.setApprovalstate(ApprovalState.convertCode(approvalstate));
        approvalLog.setProcessInstanceId(approval.getProcessInstanceId());
        approvalLog.setApprovalid(approval.getId().toString());
        approvalLogDao.save(approvalLog);




        //如果不通过，保存对外意见,如果是年报并不兼容，年报的通过最后一级也走这个  2018年7月9日16:02:11
        if (ApprovalState.SHBTG.equals(approvalstate) ||
                (StringUtil.isEmpty(approval.getNextPerson()) && ApprovalState.SHTG.equals(approvalstate)) && !BusinessType.BAFWGS.equals(approval.getBusinesstype()) && !BusinessType.PXDW.equals(approval.getBusinesstype())
                || ("批复意见".equals(approval.getNextPerson()) && (BusinessType.BAFWGS.equals(approval.getBusinesstype()) || BusinessType.PXDW.equals(approval.getBusinesstype())))) {
            approvalLog.setType(Constants.APPROVAL_LOG_OUT);
            approvalLog.setCreateTime(new Date());
            approvalLog.setUpdateTime(new Date());
            approvalLog.setApprovaldate(new Date());
            //年报的特殊处理，取Replyreason
			/*if(BusinessType.NDBG.equals(approval.getBusinesstype())){
				approvalLog.setApprovalreason(approval.getReplyreason());
			}else{
				approvalLog.setApprovalreason(approval.getOutreason());
			}*/
			//如果为空值，则默认同意
            if(StringUtil.isEmpty(approval.getOutreason())){
                approval.setOutreason(Constants.APPROVALRESONDELAUFT);
            }

            approvalLog.setApprovalreason(approval.getOutreason());
            approvalLogDao.save(approvalLog);




        }
    }


    /**
     * 保存审批日志
     *
     * @param approval
     */
    @Override
    public void saveApprovalLogNew(Approval approval, String approvalstate) {
        User currentUser = arsUtil.getCurrentUser();
        ApprovalLog approvalLog = new ApprovalLog();
        if (currentUser == null) {
            approvalLog.setUpdateBy("system");
            approvalLog.setApprovalorg("系统自动");
        } else {
            approvalLog.setUpdateBy(currentUser.getUsername());
            if(currentUser.getPolice() != null) {
                approvalLog.setApprovalorg(currentUser.getPolice().getOrgname());
            }else{
                approvalLog.setApprovalorg("系统自动");
            }
        }
        approvalLog.setActive(true);
        approvalLog.setType(Constants.APPROVAL_LOG_IN);
        approvalLog.setCreateTime(new Date());
        approvalLog.setUpdateTime(new Date());
        approvalLog.setApprovaldate(new Date());
        approvalLog.setApprovalperson(approval.getApprovalperson());
        approvalLog.setApprovalreason(approval.getApprovalreason());
        approvalLog.setApprovalstate(ApprovalState.convertCode(approvalstate));
        approvalLog.setProcessInstanceId(approval.getProcessInstanceId());
        approvalLog.setApprovalid(approval.getId().toString());
        approvalLogDao.save(approvalLog);




        //如果不通过，保存对外意见,如果是年报并不兼容，年报的通过最后一级也走这个  2018年7月9日16:02:11
        if (ApprovalState.SHBTG.equals(approval.getApprovalstate()) ||
                (StringUtil.isEmpty(approval.getGroupid()) && ApprovalState.SHTG.equals(approvalstate))) {
            approvalLog.setType(Constants.APPROVAL_LOG_OUT);
            approvalLog.setCreateTime(new Date());
            approvalLog.setUpdateTime(new Date());
            approvalLog.setApprovaldate(new Date());
            //年报的特殊处理，取Replyreason
			/*if(BusinessType.NDBG.equals(approval.getBusinesstype())){
				approvalLog.setApprovalreason(approval.getReplyreason());
			}else{
				approvalLog.setApprovalreason(approval.getOutreason());
			}*/
            approvalLog.setApprovalreason(approval.getOutreason());
            approvalLogDao.save(approvalLog);
        }

        /***
         * 推送给一体化
         */
        sendIntegrated(approval);

        if(Constants.GUANGXI.equals(configUtils.getCurrentNative())){
            interfaceNoticeService.approvalNotice(approval);
        }
    }

    private void saveBusinessForApproval(Approval approval) {
        User user = arsUtil.getCurrentUser();
        Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
        //保安服务公司
        if (approval.getBusinesstype().equals(BusinessType.BAFWGS)) {
            //获取保安服务公司信息，更新审批信息
            Sponsorlicense sponsorlicense = sponsorlicenseService.findById(approval.getBusinessid());
            //审批日期
            sponsorlicense.setApprovaldate(new Date());
            //审批人
            sponsorlicense.setApprovalperson(user.getRealname());
            //审批状态
            if (StringUtil.isNotEmpty(approval.getApprovalstate())) {
                sponsorlicense.setApprovalstate(approval.getApprovalstate());
            }
            //审批原因
            if (StringUtil.isNotEmpty(approval.getApprovalreason())) {
                sponsorlicense.setApprovalreason(approval.getApprovalreason());
            }
            //批复原因
            if (StringUtil.isNotEmpty(approval.getReplyreason())) {
                sponsorlicense.setReplyreason(approval.getReplyreason());
            }
            //更新
            sponsorlicenseService.saveOrUpdateForApproval(sponsorlicense);
            if (ApprovalState.SHTG.equals(sponsorlicense.getApprovalstate())) {//审批通过生成账号
                CompanyCertificate companyCertificate = companyCertificateService.findBySponsorLicenseId(sponsorlicense.getId());
                if (companyCertificate != null) {
                    User newUser = new User();
                    newUser.setInit(false);
                    newUser.setRealname(sponsorlicense.getCompanyname());
                    newUser.setPhone(sponsorlicense.getPhone());
                    //保安公司或培训单位
                    newUser.setPlatform(Constants.PLATFORM_COMPANY);
                    SecurityCompany newCompany = new SecurityCompany();
                    newCompany.setName(sponsorlicense.getCompanyname());

                    Syscode syscode = syscodeDAO.selectByPrimaryKey("FWXKZH", user.getCityAreaCode());
                    if (null == syscode) {
                        throw new ArsException("公保服区域未配置！！");
                    }
                    String current_native_short = syscode.getCodename();

                    newCompany.setPublicSecurityLicenseNumber(companyCertificate.getXkzh().replace(current_native_short, ""));
                    newCompany.setLegalPerson(sponsorlicense.getRepresentative());
                    newCompany.setLegalPersonNo(sponsorlicense.getLegalPersonNo());
                    newCompany.setLocation(sponsorlicense.getAddress());
                    newCompany.setAreaCode(approval.getAreaCode());
                    newCompany.setRegisteredMoney(new BigDecimal(sponsorlicense.getRegcapital().toString()));
                    newCompany.setEconomicType(sponsorlicense.getEnterprisetype());
                    newCompany.setTel(sponsorlicense.getTel());
                    newCompany.setOtherSecScopeType(sponsorlicense.getOtherSecScopeType());
                    newCompany.setSecurityScopeType(sponsorlicense.getManagement());
                    newCompany.setUser(newUser);
                    //公司类型
                    newCompany.setInstitutionType(Constants.BKT_ORGTYPE_GS);
                    newCompany.setOrgId(sponsorlicense.getOrgid().toString());
                    //机构ID
                    Police police = policeDao.findById(sponsorlicense.getOrgid());
                    //机构名称
                    newCompany.setOrgName(police.getOrgname());
                    newCompany.setUpdateflag(true);
                    newCompany.setGiveLicenseName(companyCertificate.getFzjgmc());
                    if(companyCertificate.getFzrq() != null) {
                        newCompany.setGiveLicenseDate(companyCertificate.getFzrq());
                    }
                    securityCompanyService.updateCompany(newCompany);

                }else{
                    //广西审批通过 审批意见即为批复意见 2019-01-17
                    //#5104 广西区厅最高层级领导审批与批复意见的优化
                    if(provinceConfig != null && StringUtil.isNotEmpty(provinceConfig.getValue()) && provinceConfig.getValue().startsWith(Constants.GUANGXI)) {
                        //审批通过之后，下一级审批人员提示：上传批复文件
                        approval.setNextPerson(Constants.APPROVAL_FILE);
                    }else{
                        //宁夏和陕西审批通过之后显示制证
                        if( provinceConfig!=null && !Constants.NINGXIA.equals(provinceConfig.getValue()) && !Constants.SHANGXI.equals(provinceConfig.getValue())  ) {
                            //审批通过之后，下一级审批人员提示：填写批复意见
                            approval.setNextPerson(Constants.APPROVAL_PF);
                        } else{
                            //审批通过之后，下一级审批人员提示：制证
                            approval.setNextPerson(Constants.APPROVAL_ZZ);
                        }
                    }

                }
                /**
                 * 许可通过后请将服务保安公司信息，与服务时间（申请时间）同步至保安师库相关字段
                 */
                securityGuardService.updateSecurityCompany(sponsorlicense);
            }
        } else if (approval.getBusinesstype().equals(BusinessType.BAGSZGS)) {//子公司
            Subsidiary subsidiary = subsidiaryService.findById(approval.getBusinessid());
            //审批日期
            subsidiary.setApprovaldate(new Date());
            //审批人
            subsidiary.setApprovalperson(user.getRealname());
            //审批状态
            subsidiary.setApprovalstate(approval.getApprovalstate());
            //审批原因
            subsidiary.setApprovalreason(approval.getApprovalreason());
            //审批通过，生成子公司帐号
            if (ApprovalState.SHTG.equals(subsidiary.getApprovalstate())) {
                User newUser = new User();
                newUser.setInit(false);
                newUser.setRealname(subsidiary.getSoncompanyname());
                newUser.setPhone(subsidiary.getChargephone());
                //保安公司或培训单位、自行招用、分公司
                newUser.setPlatform(Constants.PLATFORM_COMPANY);
                SecurityCompany newCompany = new SecurityCompany();
                newCompany.setName(subsidiary.getSoncompanyname());

                newCompany.setPublicSecurityLicenseNumber(subsidiary.getLicencenum());
                newCompany.setLegalPerson(subsidiary.getChargename());
                newCompany.setLegalPersonNo(subsidiary.getChargecardnumber());
                newCompany.setLocation(subsidiary.getSonaddrss());
                newCompany.setAreaCode(approval.getAreaCode());
                newCompany.setUser(newUser);
                //TODO 公司类型设置为保安服务公司，是否分公司由saas修改
                newCompany.setInstitutionType(Constants.BKT_ORGTYPE_GS);
                newCompany.setUpdateflag(true);
                newCompany.setOrgId(subsidiary.getOrgid().toString());
                //机构ID
                Police police = policeDao.findById(subsidiary.getOrgid());
                //机构名称
                newCompany.setOrgName(police.getOrgname());
                securityCompanyService.updateCompany(newCompany);
            }
            //更新
            subsidiaryService.saveOrUpdateForApproval(subsidiary);
        } else if (approval.getBusinesstype().equals(BusinessType.BAYZ)) {//保安员证
            Personcertificate personcertificate = personcertificateService.findById(approval.getBusinessid());
            //审批人
            personcertificate.setApprovalperson(user.getRealname());
            //审批状态
            personcertificate.setApprovalstate(approval.getApprovalstate());
            personcertificate.setUpdateBy(approval.getUpdateBy());
            //审批原因
            personcertificate.setApprovalreason(approval.getApprovalreason());
            personcertificate.setGroupid(approval.getGroupid());
            personcertificateService.saveOrUpdateForApproval(personcertificate);
        } else if (approval.getBusinesstype().equals(BusinessType.KQYBAGS)) {//跨区域经营保安公司
            Crosscompany crosscompany = crosscompanyService.findById(approval.getBusinessid());
            //审批日期
            crosscompany.setApprovaldate(new Date());
            //审批人
            crosscompany.setApprovalperson(user.getRealname());
            //审批状态
            crosscompany.setApprovalstate(approval.getApprovalstate());
            //审批原因
            crosscompany.setApprovalreason(approval.getApprovalreason());
            crosscompanyService.saveOrUpdateForApproval(crosscompany);

            if (ApprovalState.SHTG.equals(approval.getApprovalstate())) {
                if(provinceConfig != null && StringUtil.isNotEmpty(provinceConfig.getValue()) && provinceConfig.getValue().startsWith(Constants.BEIJING)) {
                    //北京审批通过之后，下一级审批人员提示：上传回执
                    approval.setNextPerson(Constants.APPROVAL_RECEIPT_FILE);
                }
            }

        } else if (approval.getBusinesstype().equals(BusinessType.PXDW)) {//培训服务
            Traincompanyapply traincompanyapply = traincompanyapplyService.findById(approval.getBusinessid());
            //审批日期
            traincompanyapply.setApprovaldate(new Date());
            //审批人
            traincompanyapply.setApprovalperson(user.getRealname());
            //审批状态
            if (StringUtil.isNotEmpty(approval.getApprovalstate())) {
                traincompanyapply.setApprovalstate(approval.getApprovalstate());
            }
            //审批原因
            if (StringUtil.isNotEmpty(approval.getApprovalreason())) {
                traincompanyapply.setApprovalreason(approval.getApprovalreason());
                if (ApprovalState.SHTG.equals(traincompanyapply.getApprovalstate())) {
                    //广西审批通过 审批意见即为批复意见 2019-01-17
                    //#5104 广西区厅最高层级领导审批与批复意见的优化
                    if (Constants.GUANGXI.equals(configUtils.getCurrentNative())) {
                        traincompanyapply.setReplyreason(approval.getApprovalreason());
                    }
                }
            }
            //批复原因
            if (StringUtil.isNotEmpty(approval.getReplyreason())) {
                traincompanyapply.setReplyreason(approval.getReplyreason());
            }


            traincompanyapplyService.saveOrUpdateForApproval(traincompanyapply);
            //审批通过，提示下一级审批要做什么
            if (ApprovalState.SHTG.equals(traincompanyapply.getApprovalstate())) {
                //培训证书信息
                TrainCertificate trainCertificate = trainCertificateService.findByCompanyId(traincompanyapply.getId());
                if (trainCertificate != null) {
                    User newUser = new User();
                    newUser.setInit(false);
                    //newUser.setRealname(traincompanyapply.getCompanyname());
                    //newUser.setPhone(traincompanyapply.getLegalphone());
                    newUser.setRealname(traincompanyapply.getTraincompanyname());
                    newUser.setPhone(traincompanyapply.getTrainphone());
                    //保安公司或培训单位
                    newUser.setPlatform(Constants.PLATFORM_COMPANY);
                    SecurityCompany newCompany = new SecurityCompany();
                    //newCompany.setName(traincompanyapply.getCompanyname());
                    newCompany.setName(traincompanyapply.getTraincompanyname());

                    Syscode syscode = syscodeDAO.selectByPrimaryKey("FWXKZH", user.getCityAreaCode());
                    if (null == syscode) {
                        throw new ArsException("公保服区域未配置！！");
                    }
                    String current_native_short = syscode.getCodename();
                    newCompany.setPublicSecurityLicenseNumber(trainCertificate.getXkzh().replace(current_native_short, ""));
                    //newCompany.setLegalPerson(traincompanyapply.getLegalname());
                    //newCompany.setLegalPersonNo(traincompanyapply.getLegalcode());
                    //newCompany.setLocation(traincompanyapply.getAddress());
                    newCompany.setLegalPerson(traincompanyapply.getTrainlegalname());
                    newCompany.setLegalPersonNo(traincompanyapply.getTraincreditcode());
                    newCompany.setLocation(traincompanyapply.getTrainaddress());

                    newCompany.setTrainContent(traincompanyapply.getTraincontent());
                    newCompany.setAreaCode(approval.getAreaCode());
                    newCompany.setUser(newUser);
                    //培训单位
                    newCompany.setInstitutionType(Constants.BKT_ORGTYPE_JG);
                    newCompany.setUpdateflag(true);
                    //监管机构ID
                    newCompany.setOrgId(traincompanyapply.getOrgid().toString());
                    //监管机构ID
                    Police police = policeDao.findById(traincompanyapply.getOrgid());
                    //机构名称
                    newCompany.setOrgName(police.getOrgname());
                    newCompany.setGiveLicenseName(trainCertificate.getFzjgmc());
                    if(trainCertificate.getFzrq() != null) {
                        newCompany.setGiveLicenseDate(trainCertificate.getFzrq());
                    }
                    securityCompanyService.updateCompany(newCompany);
                }else {
                    //广西审批通过 审批意见即为批复意见 2019-01-17
                    //#5104 广西区厅最高层级领导审批与批复意见的优化
                    if (Constants.GUANGXI.equals(configUtils.getCurrentNative())) {
                        //审批通过之后，下一级审批人员提示：上传批复文件
                        approval.setNextPerson(Constants.APPROVAL_FILE);
                    }else{
                        //宁夏和陕西审批通过之后显示制证
                        if (!Constants.NINGXIA.equals(configUtils.getCurrentNative()) && !Constants.SHANGXI.equals(configUtils.getCurrentNative()) ) {
                            //审批通过之后，下一级审批人员提示：填写批复意见
                            approval.setNextPerson(Constants.APPROVAL_PF);
                        } else{
                            //审批通过之后，下一级审批人员提示：制证
                            approval.setNextPerson(Constants.APPROVAL_ZZ);
                        }
                    }
                }

                /**
                 * 许可通过后请将服务保安公司信息，与服务时间（申请时间）同步至保安师库相关字段
                 */
                securityGuardService.updateSecurityCompany(traincompanyapply);
            }
        } else if (approval.getBusinesstype().equals(BusinessType.BAPXDWBA)) {//保安培训单位备案
            Trainrecord trainrecord = trainrecordService.findById(approval.getBusinessid());
            //审批日期
            trainrecord.setApprovaldate(new Date());
            //审批人
            trainrecord.setApprovalperson(user.getRealname());
            //审批状态
            if (StringUtil.isNotEmpty(approval.getApprovalstate())) {
                trainrecord.setApprovalstate(approval.getApprovalstate());
            }
            //审批原因
            if (StringUtil.isNotEmpty(approval.getApprovalreason())) {
                trainrecord.setApprovalreason(approval.getApprovalreason());
            }

            trainrecordService.updateSelective(trainrecord);
            //审批通过，提示下一级审批要做什么
            if (ApprovalState.SHTG.equals(trainrecord.getApprovalstate())) {
                User newUser = new User();
                newUser.setInit(false);
                newUser.setRealname(trainrecord.getCompanyname());
                newUser.setPhone(trainrecord.getLegalPhone());
                //保安公司或培训单位
                newUser.setPlatform(Constants.PLATFORM_COMPANY);
                SecurityCompany newCompany = new SecurityCompany();
                newCompany.setName(trainrecord.getCompanyname());
                newCompany.setLegalPerson(trainrecord.getLegalPhone());
                newCompany.setLegalPersonNo(trainrecord.getIdNum());
                newCompany.setLocation(trainrecord.getAddress());

                newCompany.setTrainContent(trainrecord.getTrainContent());
                newCompany.setAreaCode(approval.getAreaCode());
                newCompany.setUser(newUser);
                //培训单位
                newCompany.setInstitutionType(Constants.BKT_ORGTYPE_JG);
                newCompany.setUpdateflag(true);
                //监管机构ID
                newCompany.setOrgId(trainrecord.getOrgid().toString());
                //监管机构ID
                Police police = policeDao.findById(trainrecord.getOrgid());
                //机构名称
                newCompany.setOrgName(police.getOrgname());
                securityCompanyService.updateCompany(newCompany);
            }
        }  else if (approval.getBusinesstype().equals(BusinessType.ZXZY)) {//自行招用保安员单位
            Confesscompany confcesscompany = confesscompanyService.findById(approval.getBusinessid());
            //审批日期
            confcesscompany.setApprovaldate(new Date());
            //审批人
            confcesscompany.setApprovalperson(user.getRealname());
            //审批状态
            confcesscompany.setApprovalstate(approval.getApprovalstate());
            //审批原因
            confcesscompany.setApprovalreason(approval.getApprovalreason());


            //审批通过，生成自行招用帐号
            if (ApprovalState.SHTG.equals(confcesscompany.getApprovalstate())) {
                User newUser = new User();
                newUser.setInit(false);
                newUser.setRealname(confcesscompany.getCompanyname());
                //负责人手机号码
                newUser.setPhone(confcesscompany.getChargephone());
                //保安公司或培训单位、自行招用
                newUser.setPlatform(Constants.PLATFORM_COMPANY);
                SecurityCompany newCompany = new SecurityCompany();
                newCompany.setName(confcesscompany.getCompanyname());

                newCompany.setPublicSecurityLicenseNumber(confcesscompany.getLicencenum());
                newCompany.setLegalPerson(confcesscompany.getLegalname());
                newCompany.setLegalPersonNo(confcesscompany.getLegalcardnumber());
                newCompany.setLocation(confcesscompany.getAddress());
                newCompany.setAreaCode(approval.getAreaCode());
                newCompany.setUser(newUser);
                //自行招用
                newCompany.setInstitutionType(Constants.BKT_ORGTYPE_WY);
                newCompany.setUpdateflag(true);

                newCompany.setOrgId(confcesscompany.getOrgid().toString());
                //机构ID
                Police police = policeDao.findById(confcesscompany.getOrgid());
                //机构名称
                newCompany.setOrgName(police.getOrgname());

                securityCompanyService.updateCompany(newCompany);
            }
            confesscompanyService.saveOrUpdateForApproval(confcesscompany);
        } else if (approval.getBusinesstype().equals(BusinessType.ZZBACX)) { //自行招用保安员单位撤销备案
            Confesscompanyundo confcesscompanyundo = confesscompanyundoService.findById(approval.getBusinessid());
            //审批日期
            confcesscompanyundo.setApprovaldate(new Date());
            //审批人
            confcesscompanyundo.setApprovalperson(user.getRealname());
            //审批状态
            confcesscompanyundo.setApprovalstate(approval.getApprovalstate());
            //审批原因
            confcesscompanyundo.setApprovalreason(approval.getApprovalreason());
            confesscompanyundoService.approve(confcesscompanyundo);

            if (ApprovalState.SHTG.equals(approval.getApprovalstate())) {
                if(provinceConfig != null && StringUtil.isNotEmpty(provinceConfig.getValue()) && provinceConfig.getValue().startsWith(Constants.BEIJING)) {
                    //北京审批通过之后，下一级审批人员提示：上传通知书
                    approval.setNextPerson(Constants.APPROVAL_NOTICE_FILE);
                }
            }

        } else if (approval.getBusinesstype().equals(BusinessType.FRBG)) {//项目变更
            Legalchange legalchange = legalchangeService.findById(approval.getBusinessid());
            //审批日期
            legalchange.setApprovaldate(new Date());
            //审批人
            legalchange.setApprovalperson(user.getRealname());
            //审批状态
            legalchange.setApprovalstate(approval.getApprovalstate());
            //审批原因
            legalchange.setApprovalreason(approval.getApprovalreason());
            legalchangeService.saveOrUpdateForApproval(legalchange);
            //审批通过之后，下一级审批人员提示：制证
            if (ApprovalState.SHTG.equals(legalchange.getApprovalstate())) {
                    approval.setNextPerson(Constants.APPROVAL_ZZ);
            }

        }else if (approval.getBusinesstype().equals(BusinessType.PXDWXMBG)) {//培训单位项目变更
            TrainChange trainChange = trainChangeService.findById(approval.getBusinessid());
            //审批日期
            trainChange.setApprovaldate(new Date());
            //审批人
            trainChange.setApprovalperson(user.getRealname());
            //审批状态
            trainChange.setApprovalstate(approval.getApprovalstate());
            //审批原因
            trainChange.setApprovalreason(approval.getApprovalreason());
            trainChangeService.saveOrUpdateForApproval(trainChange);
        } else if (approval.getBusinesstype().equals(BusinessType.NDBG)) {//年度报告
            Yearreportdata yearreport = yearreportdataService.findById(approval.getBusinessid());
            if (yearreport != null) {
                //审批日期
                yearreport.setApprovaldate(new Date());
                //审批人
                yearreport.setApprovalperson(user.getRealname());
                //审批状态
                yearreport.setApprovalstate(approval.getApprovalstate());
//            7186  ARS-百保盾系统 测试BUG 【WEB】【年度报告备案】公安内部的审批意见不能显示在审批查看界面
//            yearreport.setApprovalreason(approval.getApprovalreason());
                //审批文件
                yearreport.setApprovalfile(approval.getReplyRar());
                //审批原因
                if (StringUtil.isNotEmpty(approval.getReplyreason())) {
                    yearreport.setApprovalreason(approval.getReplyreason());
                }
            }
            yearreportdataService.saveOrUpdateForApproval(yearreport);
        } else if (approval.getBusinesstype().equals(BusinessType.QZPX)) {//枪支备案
            Armtrainorg armtrainorg = armtrainorgService.findById(approval.getBusinessid());
            //审批日期
            armtrainorg.setApprovaldate(new Date());
            //审批人
            armtrainorg.setApprovalperson(user.getRealname());
            //审批状态
            armtrainorg.setApprovalstate(approval.getApprovalstate());
            //审批原因
            armtrainorg.setApprovalreason(approval.getApprovalreason());
            armtrainorgService.saveOrUpdateForApproval(armtrainorg);
        } else if (approval.getBusinesstype().equals(BusinessType.DJZBT)) {//等级证补贴
            GradeSubsidyBatch gradeSubsidyBatch = gradeSubsidyBatchService.findById(approval.getBusinessid());
            //审批日期
            gradeSubsidyBatch.setApprovaldate(new Date());
            //审批人
            gradeSubsidyBatch.setApprovalperson(user.getRealname());
            //审批状态
            gradeSubsidyBatch.setApprovalstate(approval.getApprovalstate());
            //审批原因
            gradeSubsidyBatch.setApprovalreason(approval.getApprovalreason());
            gradeSubsidyBatch.setOutreason(approval.getOutreason());
            if(StringUtil.isEmpty(approval.getApprovalreason())){
                gradeSubsidyBatch.setApprovalreason(approval.getOutreason());
            }
            gradeSubsidyBatch.setUpdateflag(true);
            gradeSubsidyBatch.setUpdateTime(new Date());
            gradeSubsidyBatch.setOffApprovalState(gradeSubsidyBatch.getApprovalstate());
            gradeSubsidyBatchService.updateSelective(gradeSubsidyBatch);

            if(ApprovalState.SHBTG.equals(approval.getApprovalstate())){
                gradeSubsidyRosterDaoAop.updateUnUsedByBatchId(gradeSubsidyBatch.getId());
            }
        }else if (approval.getBusinesstype().equals(BusinessType.ZGZBT)) {//资格证补贴
            GradeSubsidyBatch gradeSubsidyBatch = gradeSubsidyBatchService.findById(approval.getBusinessid());
            //审批日期
            gradeSubsidyBatch.setApprovaldate(new Date());
            //审批人
            gradeSubsidyBatch.setApprovalperson(user.getRealname());
            //审批状态
            gradeSubsidyBatch.setApprovalstate(approval.getApprovalstate());
            //审批原因
            gradeSubsidyBatch.setApprovalreason(approval.getApprovalreason());
            gradeSubsidyBatch.setOutreason(approval.getOutreason());
            if(StringUtil.isEmpty(approval.getApprovalreason())){
                gradeSubsidyBatch.setApprovalreason(approval.getOutreason());
            }
            gradeSubsidyBatch.setUpdateflag(true);
            gradeSubsidyBatch.setUpdateTime(new Date());
            gradeSubsidyBatch.setOffApprovalState(gradeSubsidyBatch.getApprovalstate());
            gradeSubsidyBatchService.updateSelective(gradeSubsidyBatch);

            if(ApprovalState.SHBTG.equals(approval.getApprovalstate())){
                gradeSubsidyRosterDaoAop.updateUnUsedByBatchId(gradeSubsidyBatch.getId());
            }
        }else if (approval.getBusinesstype().equals(BusinessType.BAYZHF)) {//保安员证核发
            PerCerGrant perCerGrant = perCerGrantService.findById(approval.getBusinessid());
            //审批日期
            perCerGrant.setApprovaldate(new Date());
            //审批人
            perCerGrant.setApprovalperson(user.getRealname());
            //审批状态
            perCerGrant.setApprovalstate(approval.getApprovalstate());
            //审批原因
            perCerGrant.setApprovalreason(approval.getApprovalreason());
            perCerGrantService.updateSelective(perCerGrant);
        }
    }

    @Override
    public Approval findById(Long id) {
        return approvalDAO.getById(id);
    }

    @Override
    public Approval findByProcessInstanceId(String id) {
        return approvalDAO.findByProcessInstanceId(id);
    }

    @Override
    public Map findByApprovalId(Long id) {
        return approvalDAO.findByApprovalId(id);
    }

    @Override
    public ApprovalDTO queryById(Long id) {
        ApprovalDTO result = new ApprovalDTO();
        //获取审批信息
        Approval approval = approvalDAO.getById(id);
        result.setId(id);
        if (approval.getBusinesstype().equals(BusinessType.BAGSZGS)) {//子公司
            Subsidiary subsidiary = subsidiaryService.findById(approval.getBusinessid());
            result.setSubsidiary(subsidiary);
        }
        return result;
    }

    @Override
    public List getBusinessidAndType(ApprovalDTO dto) {
        List list = approvalDAO.getBusinessidAndType(dto);
        return list;
    }

    @Override
    public void exportApprovals(List<Approval> approvals, File file) {
        // TODO Auto-generated method stub
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("审批信息");
//			wb.setSheetHidden(1, true);
            //标题
            String[] handers = {"id", "active", "create_time", "update_time", "update_by", "approvalDate", "approvalstate", "approvalperson",
                    "businesstype", "businessid", "businesslink", "context", "orgid", "approvalreason", "userid", "nextPerson", "configid", "rawid", "inrawid"
            }; //列标题

            //生成sheet1内容
            HSSFRow rowFirst = sheet1.createRow(0);//第一个sheet的第一行为标题
            //样式
            CellStyle style = ExcelUtil.getCommonTitleStyle(wb);
            //文本格式
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);
            //写标题

            for (int i = 0; i < handers.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); //获取第一行的每个单元格
                sheet1.setColumnWidth(i, 5000); //设置每列的列宽
                sheet1.setDefaultColumnStyle(i, stringStyle);//设置单元格格式 --文本格式
                cell.setCellStyle(style);
                cell.setCellValue(handers[i]); //往单元格里写数据
            }
            int index = 1;
            HSSFRow row = null;

            CellStyle contentStyle = ExcelUtil.getStringStyle(wb);
            for (Approval approval : approvals) {
                row = sheet1.createRow(index++);
                HSSFCell nameCell0 = row.createCell(0);
                nameCell0.setCellStyle(contentStyle);
                nameCell0.setCellValue(approval.getId()); //往单元格里写数据

                HSSFCell nameCell1 = row.createCell(1);
                nameCell1.setCellStyle(contentStyle);
                if (approval.getActive() != null) {
                    nameCell1.setCellValue(approval.getActive()); //往单元格里写数据
                }

                HSSFCell nameCell2 = row.createCell(2);
                nameCell2.setCellStyle(contentStyle);
                if (approval.getCreateTime() != null) {
                    nameCell2.setCellValue(DateUtil.convertDateToString(approval.getCreateTime(), "yyyy-MM-dd HH:mm:ss")); //往单元格里写数据
                }

                HSSFCell nameCell3 = row.createCell(3);
                nameCell3.setCellStyle(contentStyle);
                if (approval.getUpdateTime() != null) {
                    nameCell3.setCellValue(DateUtil.convertDateToString(approval.getUpdateTime(), "yyyy-MM-dd HH:mm:ss")); //往单元格里写数据
                }

                HSSFCell nameCell4 = row.createCell(4);
                nameCell4.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(approval.getUpdateBy())) {
                    nameCell4.setCellValue(approval.getUpdateBy()); //往单元格里写数据
                }
                HSSFCell nameCell5 = row.createCell(5);
                nameCell5.setCellStyle(contentStyle);
                if (approval.getApprovaldate() != null) {
                    nameCell5.setCellValue(DateUtil.convertDateToString(approval.getApprovaldate(), "yyyy-MM-dd HH:mm:ss")); //往单元格里写数据
                }
                HSSFCell nameCell6 = row.createCell(6);
                nameCell6.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(approval.getApprovalstate())) {
                    nameCell6.setCellValue(approval.getApprovalstate()); //往单元格里写数据
                }
                HSSFCell nameCell7 = row.createCell(7);
                nameCell7.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(approval.getApprovalperson())) {
                    nameCell7.setCellValue(approval.getApprovalperson()); //往单元格里写数据
                }
                HSSFCell nameCell8 = row.createCell(8);
                nameCell8.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(approval.getBusinesstype())) {
                    nameCell8.setCellValue(approval.getBusinesstype()); //往单元格里写数据
                }
                HSSFCell nameCell9 = row.createCell(9);
                nameCell9.setCellStyle(contentStyle);
                if (approval.getBusinessid() != null) {
                    nameCell9.setCellValue(approval.getBusinessid()); //往单元格里写数据
                }
                HSSFCell nameCell10 = row.createCell(10);
                nameCell10.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(approval.getBusinesslink())) {
                    nameCell10.setCellValue(approval.getBusinesslink()); //往单元格里写数据
                }
                HSSFCell nameCell11 = row.createCell(11);
                nameCell11.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(approval.getContext())) {
                    nameCell11.setCellValue(approval.getContext()); //往单元格里写数据
                }
                HSSFCell nameCell12 = row.createCell(12);
                nameCell12.setCellStyle(contentStyle);
                if (approval.getOrgid() != null) {
                    nameCell12.setCellValue(approval.getOrgid()); //往单元格里写数据
                }

                HSSFCell nameCell13 = row.createCell(13);
                nameCell13.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(approval.getApprovalreason())) {
                    nameCell13.setCellValue(approval.getApprovalreason()); //往单元格里写数据
                }
                HSSFCell nameCell14 = row.createCell(14);
                nameCell14.setCellStyle(contentStyle);
                if (approval.getUserid() != null) {
                    nameCell14.setCellValue(approval.getUserid()); //往单元格里写数据
                }

                HSSFCell nameCell15 = row.createCell(15);
                nameCell15.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty(approval.getNextPerson())) {
                    nameCell15.setCellValue(approval.getNextPerson()); //往单元格里写数据
                }

                HSSFCell nameCell16 = row.createCell(16);
                nameCell16.setCellStyle(contentStyle);
                if (approval.getConfigid() != null) {
                    nameCell16.setCellValue(approval.getConfigid()); //往单元格里写数据
                }

                HSSFCell nameCell17 = row.createCell(17);
                nameCell17.setCellStyle(contentStyle);
                if (approval.getRawid() != null) {
                    nameCell17.setCellValue(approval.getRawid()); //往单元格里写数据
                }

                HSSFCell nameCell18 = row.createCell(18);
                nameCell18.setCellStyle(contentStyle);
                if (approval.getInrawid() != null) {
                    nameCell18.setCellValue(approval.getInrawid()); //往单元格里写数据
                }
            }
            //输出模板
            FileOutputStream fileOut;
            fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    @Override
    public void importApproval(Approval approval, Map<String, String> pathMap) throws Exception {
        logger.info("in to out import ... " + approval);
        boolean isSave = false;
        if (approval.getId() == null) {
            throw new ArsException("id缺失");
        } else {
            Approval dbApproval = approvalDAO.getById(approval.getId());
            if (dbApproval != null && approval.getUpdateTime() != null && dbApproval.getUpdateTime() != null && approval.getUpdateTime().getTime() > dbApproval.getUpdateTime().getTime()) {
                approval.setId(dbApproval.getId());
                approval.setUpdateflag(false);
                approval.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, approval.getUpdateTime(), 1));
                approvalDAO.update(approval);
                isSave = true;
            }
        }
        //审批导入
        if (isSave) {
            if (null != pathMap && pathMap.size() > 0) {
                //信息rar导入
                this.importRar(pathMap, approval.getInfoRar());
                //附件导入
                this.importRar(pathMap, approval.getReplyRar());
                //对外审批意见附件
                this.importRar(pathMap, approval.getOutinfoRar());
                //确认单
                this.importRar(pathMap, approval.getConfirmPath());
                //登记单
                this.importRar(pathMap, approval.getRegisterPath());
                //通知书
                this.importRar(pathMap, approval.getNoticePath());
            }
            //更新业务表信息
            this.saveArrovalForImport(approval);
            //推送给一体化平台
            this.sendIntegrated(approval);
            //审批通过才需要发送短信
            if (approval.getApprovalstate().equals(ApprovalState.SHTG)) {
                //备案审批通过发送短信
                sendMsg(approval);
                //跨区 审批通过给saas
                User user = userDao.findById(approval.getUserid());
                if (user != null && user.getPlatform() == Constants.PLATFORM_COMPANY && approval.getBusinesstype().equals(BusinessType.KQYBAGS)) {
                    //跨区备案申报信息
                    Crosscompany crosscompany = crosscompanyService.findById(approval.getBusinessid());

                    CrosscompanyInfo crosscompanyInfo = new CrosscompanyInfo();
                    SecurityCompany company  =  securityCompanyService.findByUserid(user.getId());
                    //判断SaaS的comId是否存在
                    if(company.getComId()==null){
                        throw new ArsException(company.getName()+"ComID数据异常" );
                    }
                    crosscompanyInfo.setComId(Long.valueOf(company.getComId()));
                    //用户名
                    crosscompanyInfo.setUserName(user.getUsername());
                    //跨区经营省份ID
                    crosscompanyInfo.setProvince(crosscompany.getProvince());
                    //跨区经营城市ID
                    crosscompanyInfo.setCity(crosscompany.getCity());
                    //跨区经营区县ID
                    crosscompanyInfo.setArea(crosscompany.getDistrict());
                    //跨区经营地址
                    crosscompanyInfo.setAddress(crosscompany.getAddress());
                    //备案日期
                    crosscompanyInfo.setRecordDate(DateUtil.convertDateToString(approval.getApprovaldate(), DateUtil.FORMAT2));
                    //负责人
                    crosscompanyInfo.setResponsPer(crosscompany.getChargename());
                    //负责人手机号
                    crosscompanyInfo.setResponsPerPhone(crosscompany.getChargephone());
                    //负责人身份证号
                    crosscompanyInfo.setIdCardNo(crosscompany.getChargecardnumber());
                    //负责人职务
                    crosscompanyInfo.setPost(crosscompany.getChargepost());
                    //跨区经营开始日期
                    crosscompanyInfo.setStartDate(DateUtil.convertDateToString(crosscompany.getStartdate(), DateUtil.FORMAT2));
                    //发证机关
                    Config cityFZJG = configUtils.getConfigByKey(crosscompany.getCity() + "CITYPOLICE");
                    if (cityFZJG != null) {
                        crosscompanyInfo.setRecordPoliceName(cityFZJG.getValue());
                    }
                    AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_CROSSCOMPANY_UPDATE, crosscompanyInfo);
                    if (!result.isSuccessful()) {
                        logger.error(crosscompany.getCompanyname() + result.getMsg());
                    }
                }
            }
        }
    }
    @Override
    public void batchImportApproval(List<Approval> approvalList, Map<String, String> pathMap) {
        logger.info("saveOrupdate... " + approvalList);
        try {
            boolean isSave = false;
            List<Approval> dbExistIDList = approvalDAO.getByBatchId(approvalList);
            //比对内外网的update时间，过滤外网时间大于内网时间
            this.removeRepeatApprovalList(approvalList, dbExistIDList);
            if (approvalList.size() > 0) {
                approvalDAO.updatebatch(approvalList);
                isSave = true;
            }
            //审批导入
            if (isSave) {
                List<Approval> approvalUpdateList = new ArrayList<>();
                for (Approval approval : approvalList) {
                    try {
                        //同步更新业务表的审批状态
                        //  approvalDAO.updateBusinessApprovalState(approval);
                        //审批通过
                        if (approval.getApprovalstate().equals(ApprovalState.SHTG)) {

                            //跨区 审批通过给saas TODO
                            User user = userDao.findById(approval.getUserid());
                            if (user != null && user.getPlatform() == Constants.PLATFORM_COMPANY && approval.getBusinesstype().equals(BusinessType.KQYBAGS)) {
                                //跨区备案申报信息
                                Crosscompany crosscompany = crosscompanyService.findById(approval.getBusinessid());
                                CrosscompanyInfo crosscompanyInfo = new CrosscompanyInfo();
                                //用户名
                                crosscompanyInfo.setUserName(user.getUsername());
                                //跨区经营省份ID
                                crosscompanyInfo.setProvince(crosscompany.getProvince());
                                //跨区经营城市ID
                                crosscompanyInfo.setCity(crosscompany.getCity());
                                //跨区经营区县ID
                                crosscompanyInfo.setArea(crosscompany.getDistrict());
                                SecurityCompany company  =  securityCompanyService.findByUserid(user.getUserid());
                                //判断SaaS的comId是否存在
                                if(company.getComId()==null){
                                    throw new ArsException(company.getName()+"ComID数据异常" );
                                }
                                crosscompanyInfo.setComId(Long.valueOf(company.getComId()));
                                //跨区经营地址
                                crosscompanyInfo.setAddress(crosscompany.getAddress());
                                //备案日期
                                crosscompanyInfo.setRecordDate(DateUtil.convertDateToString(approval.getApprovaldate(), DateUtil.FORMAT2));
                                //负责人
                                crosscompanyInfo.setResponsPer(crosscompany.getChargename());
                                //负责人手机号
                                crosscompanyInfo.setResponsPerPhone(crosscompany.getChargephone());
                                //负责人身份证号
                                crosscompanyInfo.setIdCardNo(crosscompany.getChargecardnumber());
                                //负责人职务
                                crosscompanyInfo.setPost(crosscompany.getChargepost());
                                //跨区经营开始日期
                                crosscompanyInfo.setStartDate(DateUtil.convertDateToString(crosscompany.getStartdate(), DateUtil.FORMAT2));
                                //发证机关
                                Config cityFZJG = configUtils.getConfigByKey(crosscompany.getCity() + "CITYPOLICE");
                                if (cityFZJG != null) {
                                    crosscompanyInfo.setRecordPoliceName(cityFZJG.getValue());
                                }
                                AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_CROSSCOMPANY_UPDATE, crosscompanyInfo);
                                if(!result.isSuccessful()){
                                    throw new ArsException(crosscompany.getCompanyname() + result.getMsg() );
                                }

                            }
                        }
                        if (null != pathMap && pathMap.size() > 0) {
                            //信息rar导入
                            this.importRar(pathMap, approval.getInfoRar());
                            //附件导入
                            this.importRar(pathMap, approval.getReplyRar());
                            //对外审批意见附件
                            this.importRar(pathMap, approval.getOutinfoRar());
                            //确认单
                            this.importRar(pathMap, approval.getConfirmPath());
                            //登记单
                            this.importRar(pathMap, approval.getRegisterPath());
                        }
                   }catch ( Exception e){
                        logger.error(e.getMessage(),e);
                    }





                }
                //批量更新
                if (approvalUpdateList != null && approvalUpdateList.size() > 0) {
                    approvalDAO.updatebatch(approvalUpdateList);
                }
                this.saveBatchArrovalForImport(approvalList);
                //审批通过才需要发送短信
                for (Approval approval : approvalList) {
                    if (approval.getApprovalstate().equals(ApprovalState.SHTG)) {
                        try {
                            sendMsg(approval);
                        } catch (Exception e) {
                            logger.error(e.getMessage(), e);
                        }
                    }
                }
                for (Approval approval : approvalList) {
                    //同步更新业务表的审批状态
                      approvalDAO.updateBusinessApprovalState(approval);
                    /***
                     * 推送给一体化
                     */
                    sendIntegrated(approval);
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
            e.printStackTrace();
        }
    }


    /***
     * 推送给一体化
     * @param approval
     */
    private void sendIntegrated(Approval approval){
        IntegratedApplyDto indto = new IntegratedApplyDto();
        indto .setBusinessId(approval.getBusinessid()+"");
        //保安服务公司
        if(BusinessType.BAFWGS.equals(approval.getBusinesstype())) {
            indto.setBusinessNo(IntegratedConstants.BUSINESSNO_FWGS);
        }else if(BusinessType.FRBG.equals(approval.getBusinesstype())){
            //项目变更
            indto.setBusinessNo(IntegratedConstants.BUSINESSNO_XMBG);
        }else if(BusinessType.PXDW.equals(approval.getBusinesstype())){
            //培训单位
            indto.setBusinessNo(IntegratedConstants.BUSINESSNO_PXDW);
        }else{
            return;
        }
        List list = integratedDao.query(indto);
        String SBLSH_SHORT = "";
        String SXBM ="";
        String  spzt ="";
        String token ="";
        if(list!=null && list.size()>0) {
            //获取token
            IntegratedResult result = new IntegratedResult();
            //参数
            Map<String, Object> params = new HashMap<>();
            params.put(IntegratedConstants.KEY, integratedKey);
            params.put(IntegratedConstants.VALUE, integratedSecret);
            String xmlStr = HttpClientUtils.doPostHttpURL(integratedRestURL+ IntegratedConstants.GETTOKEN,params);
            logger.error(xmlStr);
            ResultXML xm =  JaxbUtil.converyToJavaBean(xmlStr,ResultXML.class);
            token =xm.getToken();

            IntegratedApply integratedApply = (IntegratedApply) list.get(0);
            SBLSH_SHORT = integratedApply.getApplyNo();
            SXBM = integratedApply.getBusinessNo();
            spzt = "003".equals(approval.getApprovalstate()) ? "1" : "2";
            //推送过程
            logger.error(HttpClientUtils.doPostHttpURL(integratedRestURL + IntegratedConstants.COURSEINFO, token, "<APPROVEDATAINFO><SBLSH_SHORT>" + SBLSH_SHORT + "</SBLSH_SHORT><SXBM>" + SXBM + "</SXBM>" +
                    "<GDBSSPCL>" +
                    "   <SBLSH_SHORT>" + SBLSH_SHORT + "</SBLSH_SHORT>" +
                    "   <SBLSH>null</SBLSH>" +
                    "   <SXBM>" + SXBM + "</SXBM>" +
                    "   <SXBM_SHORT>null</SXBM_SHORT>" +
                    "   <SXQXBM>1</SXQXBM>" +
                    "   <SPHJDM>2</SPHJDM>" +
                    "   <SPHJMC>审批</SPHJMC>" +
                    "   <SPBMMC>审批</SPBMMC>" +
                    "   <SPBMZZJDMD>212</SPBMZZJDMD>" +
                    "   <XZQHDM></XZQHDM>" +
                    "   <SPRXM>" + approval.getApprovalperson() + "</SPRXM>" + //审批原因
                    "   <SPRZWDM>" + spzt + "</SPRZWDM>" +  //审批状态
                    "   <SPRZWMC></SPRZWMC>" +
                    "   <SPYJ>" + approval.getApprovalreason() + "</SPYJ>" +//审批人
                    "   <SPSJ>" + DateUtil.getCurrentDateTime() + "</SPSJ>" +//审批时间
                    "   <SPHJZTDM>1</SPHJZTDM>" +
                    "   <REC_FLAG>1</REC_FLAG>" +
                    "   <D_ZZJGDM>111</D_ZZJGDM>" +
                    "</GDBSSPCL></APPROVEDATAINFO>"));

        }

        //如果不通过，保存对外意见,如果是年报并不兼容，年报的通过最后一级也走这个  2018年7月9日16:02:11
        if (ApprovalState.SHBTG.equals(approval.getApprovalstate()) ||
                (StringUtil.isEmpty(approval.getGroupid()) && ApprovalState.SHTG.equals(approval.getApprovalstate()))) {
            if(list!=null && list.size()>0) {
                spzt = "003".equals(approval.getApprovalstate()) ? "0" : "1";
                logger.error("办结："+HttpClientUtils.doPostHttpURL(integratedRestURL+ IntegratedConstants.BUSINESSFINISH, token,"<APPROVEDATAINFO><SBLSH_SHORT>" + SBLSH_SHORT + "</SBLSH_SHORT><SXBM>" + SXBM + "</SXBM>" +
                        "<SPBANJIE>" +
                        "   <SBLSH_SHORT>" + SBLSH_SHORT + "</SBLSH_SHORT>" +
                        "   <SBLSH>null</SBLSH>" +
                        "   <SXBM>" + SXBM + "</SXBM>" +
                        "   <SXBM_SHORT>null</SXBM_SHORT>" +
                        "   <SXQXBM>1</SXQXBM>" +
                        "   <BJBMMC>" +approval.getApprovalperson() + "</BJBMMC>" +  //审批人
                        "   <BJBMZZJDDM>1234564</BJBMZZJDDM>" +
                        "   <XZQHDM>"+approval.getAreaCode()+"</XZQHDM>" +//审批区域编码
                        "   <SPRXM>" + approval.getApprovalperson() + "</SPRXM>" +//审批人
                        "   <SPRDM>001</SPRDM>" +
                        "   <BJJGDM>" + spzt + "</BJJGDM>" +
                        "   <BJJGMS>已办理</BJJGMS>" +
                        "   <SFJE>0</SFJE>" +
                        "   <JEDWDM>1</JEDWDM>" +
                        "   <BJSJ>" + DateUtil.getCurrentDateTime() + "</BJSJ>" +
                        "</SPBANJIE>" +
                        "</APPROVEDATAINFO>"));
            }
        }
    }
    private void removeRepeatApprovalList(List<Approval> approvalList, List<Approval> dbExistIDList) {
        for (Approval dbExistApproval : dbExistIDList) {
            int logListSize = approvalList.size();



            for (int i = 0; i < logListSize; i++) {

                if (dbExistApproval.getId().equals(approvalList.get(i).getId())) {
                    if (approvalList.get(i).getUpdateTime().getTime() <= dbExistApproval.getUpdateTime().getTime()) {
                        approvalList.remove(i);
                        i--;
                        break;
                    }
                }
            }
        }
    }

    private void importRar(Map<String, String> pathMap, String infoRar)  {
        try {
            if (StringUtil.isNotEmpty(infoRar)) {
                int lastIndex = infoRar.replaceAll("\\\\", "/").lastIndexOf("/");
                String key = infoRar.substring(lastIndex + 1);
                logger.info(key);

                String filePath = infoRar.replace("getResource.do?path=", "");
                filePath = baseFolder + filePath;
                File file = new File(filePath);
                if (!file.exists()) {
                    File resFile = new File(pathMap.get(key));
                    FileUtil.copyFolder(resFile, new File(filePath.replace(key, "")));
                }
            }
        }catch (Exception e){
            logger.error(e.getMessage(),e);
        }
    }

    /**
     * 导入审批数据（仅适用与内网数据导入到外网）
     */
    @Override
    @Deprecated
    public Map<String, Object> importApproval(File excel) throws Exception {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        User loginUser = arsUtil.getCurrentUser();
        if (loginUser != null && loginUser.getPlatform() == 1) {
            List<Long> saveList = new ArrayList<Long>();
            List<Map<String, String>> faildList = new ArrayList<Map<String, String>>();
            FileInputStream inStream = new FileInputStream(excel);
            Workbook workBook = WorkbookFactory.create(inStream);
            Sheet sheet = workBook.getSheetAt(0);
            boolean flag = true;
            int i = 1;
            while (flag) {
                Row row = sheet.getRow(i);
                if (row != null) {
                    Map<String, String> data = new HashMap<String, String>();
                    try {
                        String id = ExcelUtil.getCellValue(row.getCell(0));
                        data.put("id", id);

                        String active = ExcelUtil.getCellValue(row.getCell(1));
                        data.put("active", active);

                        String create_time = ExcelUtil.getCellValue(row.getCell(2));
                        data.put("create_time", create_time);

                        String update_time = ExcelUtil.getCellValue(row.getCell(3));
                        data.put("update_time", update_time);

                        String update_by = ExcelUtil.getCellValue(row.getCell(4));
                        data.put("update_by", update_by);

                        String approvalDate = ExcelUtil.getCellValue(row.getCell(5));
                        data.put("approvalDate", approvalDate);

                        String approvalstate = ExcelUtil.getCellValue(row.getCell(6));
                        data.put("approvalstate", approvalstate);

                        String approvalperson = ExcelUtil.getCellValue(row.getCell(7));
                        data.put("approvalperson", approvalperson);

                        String businesstype = ExcelUtil.getCellValue(row.getCell(8));
                        data.put("businesstype", businesstype);

                        String businessid = ExcelUtil.getCellValue(row.getCell(9));
                        data.put("businessid", businessid);

                        String businesslink = ExcelUtil.getCellValue(row.getCell(10));
                        data.put("businesslink", businesslink);

                        String context = ExcelUtil.getCellValue(row.getCell(11));
                        data.put("context", context);

                        String orgid = ExcelUtil.getCellValue(row.getCell(12));
                        data.put("orgid", orgid);

                        String approvalreason = ExcelUtil.getCellValue(row.getCell(13));
                        data.put("approvalreason", approvalreason);

                        String userid = ExcelUtil.getCellValue(row.getCell(14));
                        data.put("userid", userid);

                        String nextPerson = ExcelUtil.getCellValue(row.getCell(15));
                        data.put("nextPerson", nextPerson);

                        String configid = ExcelUtil.getCellValue(row.getCell(16));
                        data.put("configid", configid);

                        String rawid = ExcelUtil.getCellValue(row.getCell(17));
                        data.put("rawid", rawid);

                        String inrawid = ExcelUtil.getCellValue(row.getCell(18));
                        data.put("inrawid", inrawid);

//						Cell cellsocialCode = row.getCell(1);
//						cellsocialCode.setCellType(HSSFCell.CELL_TYPE_STRING);
//						String socialCode = ExcelUtil.getCellValue(cellsocialCode);
//						data.put("socialCode", socialCode);

                        Approval approval = new Approval();

                        approval.setId(Long.parseLong(id));

                        if (StringUtil.isNotEmpty(active)) {
                            approval.setActive(active.equals("FALSE") ? false : true);
                        }
                        if (StringUtil.isNotEmpty(approvalDate)) {
                            approval.setApprovaldate(DateUtil.convertStringToDate(approvalDate));
                        }

                        if (StringUtil.isNotEmpty(approvalstate)) {
                            approval.setApprovalstate(approvalstate);
                        }

                        if (StringUtil.isNotEmpty(configid)) {
                            approval.setConfigid(Long.parseLong(configid));
                        }
                        if (StringUtil.isNotEmpty(create_time)) {
                            approval.setCreateTime(DateUtil.convertStringToDate(create_time));
                        }
                        if (StringUtil.isNotEmpty(nextPerson)) {
                            approval.setNextPerson(nextPerson);
                        }
                        if (StringUtil.isNotEmpty(orgid)) {
                            approval.setRoleid(Long.parseLong(orgid));
                        }
                        if (StringUtil.isNotEmpty(update_by)) {
                            approval.setUpdateBy(update_by);
                        }
                        if (StringUtil.isNotEmpty(update_time)) {
                            approval.setUpdateTime(DateUtil.convertStringToDate(update_time));
                        }
                        if (StringUtil.isNotEmpty(userid)) {
                            approval.setUserid(Long.parseLong(userid));
                        }
                        if (StringUtil.isNotEmpty(approvalperson)) {
                            approval.setApprovalperson(approvalperson);
                        }
                        if (StringUtil.isNotEmpty(approvalreason)) {
                            approval.setApprovalreason(approvalreason);
                        }
                        if (StringUtil.isNotEmpty(context)) {
                            approval.setContext(context);
                        }
                        if (StringUtil.isNotEmpty(businesslink)) {
                            approval.setBusinesslink(businesslink);
                        }
                        if (StringUtil.isNotEmpty(businesstype)) {
                            approval.setBusinesstype(businesstype);
                        }
                        if (StringUtil.isNotEmpty(businessid)) {
                            approval.setBusinessid(Long.parseLong(businessid));
                        }
                        if (StringUtil.isNotEmpty(rawid)) {
                            approval.setRawid(Long.parseLong(rawid));
                        }
                        if (StringUtil.isNotEmpty(inrawid)) {
                            approval.setInrawid(Long.parseLong(inrawid));
                        }

                        logger.info("saveOrupdate... " + approval);
                        boolean isSave = false;
                        if (approval.getId() == null) {
                            throw new ArsException("id缺失");
                        } else {

                            //删除以前导入时先判断内网是否有，edit 2018-06-01 subh start

                            Approval dbApproval = approvalDAO.getById(approval.getId());
                            if (approval.getUpdateTime().getTime() > dbApproval.getUpdateTime().getTime()) {
                                approval.setId(dbApproval.getId());
                                approvalDAO.update(approval);
                                isSave = true;
                            }
                            //删除以前导入时先判断内网是否有，edit 2018-06-01 subh start
                        }
                        //审批导入
                        if (isSave) {
                            this.saveArrovalForImport(approval);
                            Datasync dbdatasync = datasyncDao.findByBid(Long.parseLong(orgid));
                            if (dbdatasync != null) {
                                //状态已同步
                                dbdatasync.setState("2");
                                dbdatasync.setUpdateTime(new Date());
                                datasyncDao.update(dbdatasync);
                            }
                        }
                        //审批导入
                        if (isSave) {
                            this.saveArrovalForImport(approval);
                            Datasync dbdatasync = datasyncDao.findByBid(Long.parseLong(orgid));
                            if (dbdatasync != null) {
                                //状态已同步
                                dbdatasync.setState("2");
                                dbdatasync.setUpdateTime(new Date());
                                datasyncDao.update(dbdatasync);
                            }
                        }

                    } catch (Exception e) {
                        faildList.add(data);
                        logger.error("批量录入错误：" + data.get("id"), e);
                    }
                } else {
                    flag = false;
                }
                i++;
            }
//			if(faildList.size() > 0) {
//				resultMap.put("faildFilePath", buildFaildList(faildList));
//			}
            resultMap.put("successIds", saveList);
        } else {
            throw new RuntimeException("当前登录信息错误, user:" + loginUser);
        }
        return resultMap;
    }

    @Override
    public List<Approval> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return approvalDAO.searchForDataSynchronization(searchDto);
    }

    /**
     * ！！！！！仅适用于外网数据导入内网！！！！！
     */
    @Override
    public void saveOrUpdateForDS(Approval approval) {
        saveOrUpdateForDS_new(approval);
    }
    private void saveOrUpdateForDS_new(Approval approval) {
        if (approval.getActive() == null) {
            approval.setActive(true);
        }
        if (!approval.getActive()) {
            approvalDAO.deleteById(approval.getId());
        } else {
            Approval dbApproval = approvalDAO.getById(approval.getId());
            if (dbApproval == null) {
                approval.setProcessInstanceId(null);
                approval.setOutProcessInstanceId(null);
                approval.setInProcessInstanceId(null);
                approvalDAO.saveForDS(approval);
            } else {
                if (approval.getUpdateTime().getTime() > dbApproval.getUpdateTime().getTime()) {
                    if (!approval.getBusinesstype().equals(BusinessType.PXDW) && !approval.getBusinesstype().equals(BusinessType.BAFWGS)) {
                        approval.setProcessInstanceId(dbApproval.getProcessInstanceId());
                    }
                    approval.setOutProcessInstanceId(dbApproval.getProcessInstanceId());
                    approval.setInProcessInstanceId(dbApproval.getProcessInstanceId());
                    approvalDAO.update(approval);
                }
            }
        }
    }
    /***
     * 判断业务是否存在
     * @param approval
     * @return
     */
    private boolean business(Approval approval) {
        //是否显示指纹录入环节
        if (approval.getBusinesstype().equals(BusinessType.BAYZ)) {//保安员证
            Personcertificate personcertificate = personcertificateService.findById(approval.getBusinessid());
            if(personcertificate == null){
                return false;
            }
        }
        if (approval.getBusinesstype().equals(BusinessType.BAFWGS)) { //保安服务公司
            //获取保安服务公司信息，更新审批信息
            Sponsorlicense sponsorlicense = sponsorlicenseService.findById(approval.getBusinessid());
            if(sponsorlicense == null){
                return false;
            }

        }
        if (approval.getBusinesstype().equals(BusinessType.PXDW)) {//培训服务
            Traincompanyapply traincompanyapply = traincompanyapplyService.findById(approval.getBusinessid());
            if(traincompanyapply == null){
                return false;
            }
        }
        return true;
    }


    private void startApply_new(Approval approval) {
        //是否显示指纹录入环节
        Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
        logger.info("begin startApply process!!!");
        String testState = "";
        Long policeId = 0L;
        Boolean personPass = false;
        //保安员证
        if (approval.getBusinesstype().equals(BusinessType.BAYZ)) {
            //配置 是否需要流程
            Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
            Personcertificate personcertificate = personcertificateService.findById(approval.getBusinessid());
            //是否测试通过
            testState = personcertificate.getTestState();

            Config newPersonApproveConfig = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
            if (newPersonApproveConfig != null && Constants.APPROVAL_VERSION_NEW.equals(newPersonApproveConfig.getValue())) {
                //保安员证流程变更
                //同步到内网先做背景筛查 不通过开启activiti流程
                //通过 做获取指纹 获取到指纹 开启activiti流程

                Boolean pass = true;
                Boolean startActiviti = false;

                if (ApprovalState.DSH.equals(approval.getApprovalstate())) {
                    //背景筛查开始
                    BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
                    backgroundApprovalDto.setBusinessid(personcertificate.getId());
                    backgroundApprovalDto.setBusinesstype(Constants.BAYZ);
                    backgroundApprovalDto.setIdNumber(personcertificate.getCardnumber());
                    backgroundApprovalDto.setRealName(personcertificate.getName());
                    //对接八大库查询
                    backgroundApprovalService.approval(backgroundApprovalDto);
                    //查询结果
                    String approvalReason = null;
                    //查询结果
                    List<BackgroundApproval> list = backgroundApprovalService.query(backgroundApprovalDto);
                    for (BackgroundApproval backgroundApproval : list) {
                        if (Constants.APPROVALSTATE_BTG.equals(backgroundApproval.getApprovalstate())) {
                            if( Constants.LIBRARYTYPE_CZ.equals(backgroundApproval.getLibraryType()) ){
                                approvalReason = "背景筛查不通过，原因："+backgroundApproval.getApprovalreason();
                            }else{
                                approvalReason = Constants.BACKGROUNDAPPROVAL_FAIL;

                            }
                            pass = false;
                            break;
                        }
                    }
                    /**
                     * 如果背景筛查不通过 设置审批意见
                     */
                    approval.setApprovalreason(approvalReason);
                    personcertificate.setApprovalreason(approvalReason);

                    //对外审批意见
                    if(StringUtil.isNotEmpty(approvalReason)){
                        approval.setOutreason(approvalReason);
                    }
                    if (pass) {
                        //背景筛查通过
                        personcertificate.setCensorStatus(Constants.CENSORSTATUS_PASS);
                        approval.setApprovalstate(Constants.APPROVALSTATE_SHZ);
                        //修改标记
                        approval.setUpdateflag(true);
                        //更新时间
                        approval.setUpdateTime(new Date());
                        personcertificate.setApprovalstate(Constants.APPROVALSTATE_SHZ);
                    } else {
                        //背景筛查不通过 开启 activiti流程
                        personcertificate.setCensorStatus(Constants.CENSORSTATUS_UNPASS);
                        if (isNeedActivity == null || (null != isNeedActivity && Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue()))) {
                            startActiviti = true;
                        } else {
                            personcertificate.setApprovalstate(ApprovalState.SHBTG);
                            approval.setApprovalstate(ApprovalState.SHBTG);
                            approval.setUpdateflag(true);
                            approval.setUpdateTime(new Date());
                        }
                    }
                    //更新背景筛查状态
                    personcertificate.setUpdateTime(new Date());
                    //   personcertificateService.updateCensorStatus(personcertificate);
                }
                //判断背景筛查是否通过
                if (Constants.CENSORSTATUS_PASS.equals(personcertificate.getCensorStatus())) {
                    if (isShowFingerprintConfig == null || (
                            StringUtil.isNotEmpty(isShowFingerprintConfig.getValue()) && Constants.IS_SHOW_FINGERPRINT_YES.equals(isShowFingerprintConfig.getValue()))
                    ) {
                        //获取指纹
                        if (StringUtil.isEmpty(personcertificate.getFingerprint())) {
                            Pctinfo pctinfo = pctinfoService.findByIdnumber(personcertificate.getCardnumber());
                            if (pctinfo != null) {
                                //获取到指纹 开启 activiti流程
                                personcertificate.setFingerprint(pctinfo.getBarcode());
                                personcertificate.setFingercardState(Constants.FINGERCARD_STATE_JL);
                                personPass = true;
                            }
                        } else {
                            personcertificate.setFingercardState(Constants.FINGERCARD_STATE_JL);
                            personPass = true;
                        }

                        if(Constants.FINGERCARD_STATE_JL.equals(personcertificate.getFingercardState())&&(isNeedActivity == null || (null!=isNeedActivity&&Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue())))){
                            startActiviti = true;
                        }else{
                            startActiviti = false;
                        }

                    } else {
                        logger.info("是否启动流程："+isNeedActivity.getValue());
                        if (isNeedActivity == null || ( null != isNeedActivity && Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue())) ) {
                            startActiviti = true;
                        }
                    }
                }

                //修改标记
                personcertificate.setUpdateflag(true);
                //更新时间
                personcertificate.setUpdateTime(new Date());
                personcertificateService.updateCensorStatus(personcertificate);
                if (!startActiviti) {
                    if (null != isNeedActivity && Constants.IS_NEED_ACTIVITY_NO.equals(isNeedActivity.getValue())) {
                        if(personPass){
                            approval.setApprovalstate(ApprovalState.SPZ);
                            approval.setUpdateflag(true);
                            approval.setUpdateTime(new Date());
                        }
                        approvalDAO.update(approval);
                    }
                    return;
                }

            }
        }
        if (approval.getBusinesstype().equals(BusinessType.BAFWGS)) { //保安服务公司
            //获取保安服务公司信息，更新审批信息
            Sponsorlicense sponsorlicense = sponsorlicenseService.findById(approval.getBusinessid());
            //民警ID
            if (sponsorlicense.getPoliceid() != null) {
                policeId = sponsorlicense.getPoliceid();
            }

        }
        if (approval.getBusinesstype().equals(BusinessType.PXDW)) {//培训服务
            Traincompanyapply traincompanyapply = traincompanyapplyService.findById(approval.getBusinessid());
            //民警ID
            if (traincompanyapply.getPoliceid() != null) {
                policeId = traincompanyapply.getPoliceid();
            }
        }
        //指派民警字段
        if (policeId == 0L || policeId == null) {

            if (approval.getPoliceid() != null) {
                policeId = approval.getPoliceid();
            }
        }
        startApproval(approval,policeId,testState);

        if(personPass) {
            approval.setApprovalstate(ApprovalState.SPZ);
            approvalDAO.updateBusinessApprovalState(approval);
        }
    }

    @Override
    public void startApproval(Approval approval,Long policeId,String testState){
        String processKey = approvalUtil.getBusinessTypeForActKey(approval);
        if (StringUtil.isNotEmpty(processKey)) {

            //区域编码
            String areaCode = approval.getAreaCode();

            ApproveTemp approveTemp = approveTempDao.findByTempCode(processKey + "-" + areaCode);
            if(approveTemp == null){
                //区域编码
                areaCode = areaCode.substring(0,4)+"00";
                approveTemp = approveTempDao.findByTempCode(processKey + "-" + areaCode);
                if(approveTemp == null){
                    approveTemp = approveTempDao.findByTempCode(processKey);
                }
            }

            String newGroupid="";
            Map<String, Object> variables = new HashMap<String, Object>();
            //业务ID
            variables.put("policeId", policeId);
            variables.put("testState", testState);
            variables.put("businessid", approval.getBusinessid());//业务ID
            variables.put("areaCode", areaCode);//区域编码
            String processInstanceId = "";
            // 启动流程
            processKey = approveTemp.getTempCode();

            //生成流程，唯一标识：业务名称+机构ID
            ProcessInstance pi = runtimeService.startProcessInstanceByKey(processKey + "-" + approval.getOrgid(), variables);
            //流程ID
            processInstanceId = pi.getProcessInstanceId();
            approval.setProcessInstanceId(processInstanceId);
            //判断是否为内网
            approval.setUpdateflag(true);

            if (approval.getBusinesstype().equals(BusinessType.PXDW) || approval.getBusinesstype().equals(BusinessType.BAFWGS)) {
                if (StringUtil.isNotEmpty(approval.getInProcessInstanceId())) {
                    try {
                        approvalLogDao.updateProcessInstanceId(processInstanceId, approval.getInProcessInstanceId());
                    } catch (Exception e) {
                        logger.info(e.getMessage());
                        throw e;
                    }
                }
            }
            //}
            approval.setInProcessInstanceId(processInstanceId);
            approval.setOutProcessInstanceId(processInstanceId);
            // 根据流程实例Id查询任务
//	        Task task=taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
            Task task = null;
            List<HistoricActivityInstance> list = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
            if (list != null && list.size() > 0) {
                for (HistoricActivityInstance hai : list) {
                    logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                    //判断是否为子流程
                    if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                        // 根据流程实例Id查询任务
                        task = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                    }
                }
            }
            if (task == null) {
                task = taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
            }
            // 完成 任务提交
            taskService.complete(task.getId(), variables);
            //查询历史
            Task newTask = null;
            List<HistoricActivityInstance> newTasklist = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
            if (newTasklist != null && newTasklist.size() > 0) {
                for (HistoricActivityInstance hai : newTasklist) {
                    logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                    //判断是否为子流程
                    if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                        // 根据流程实例Id查询任务
                        newTask = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                    }
                }
            }

            if (newTask != null) {
                //审批对象
                approval.setNextPerson(newTask.getName());//下一个审批人

                List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                    IdentityLink identityLink = newTaskEntitys.get(0);
                    newGroupid = identityLink.getGroupId();
                }
            }
            approval.setGroupid(newGroupid);
            approvalDAO.update(approval);
        }
    }

    @Override
    public void startCensorStatus(Approval approval) {

        String approvalstate = null;
        //自招
        if (approval.getBusinesstype().equals(BusinessType.ZXZY)) {
            Confesscompany confcesscompany = confesscompanyService.findById(approval.getBusinessid());
            //法人信息政审
            approvalstate = backgroundApprovalService.getCensorStatus(confcesscompany.getId(),Constants.ZZ_FR,confcesscompany.getLegalcardnumber(),confcesscompany.getLegalname());
            confcesscompany.setLegalcensorstatus(approvalstate);
            confesscompanyService.updateCensorStatus(confcesscompany);

            //负责人政审
            approvalstate = backgroundApprovalService.getCensorStatus(confcesscompany.getId(),Constants.ZZ_FZR,confcesscompany.getChargecardnumber(),confcesscompany.getChargename());
            confcesscompany.setChargecensorstatus(approvalstate);
            confesscompanyService.updateCensorStatus(confcesscompany);

            //分公司
        }else if (approval.getBusinesstype().equals(BusinessType.BAGSZGS)){
            Subsidiary subsidiary = subsidiaryService.findById(approval.getBusinessid());
            approvalstate = backgroundApprovalService.getCensorStatus(subsidiary.getId(),Constants.FGS_FR,subsidiary.getLegalcardnumber(),subsidiary.getLegalname());

            subsidiary.setLegalcensorstatus(approvalstate);
            subsidiaryService.updateCensorStatus(subsidiary);

            //负责人政审
            approvalstate = backgroundApprovalService.getCensorStatus(subsidiary.getId(),Constants.FGS_FZR,subsidiary.getChargecardnumber(),subsidiary.getChargename());
            subsidiary.setChargecensorstatus(approvalstate);
            subsidiaryService.updateCensorStatus(subsidiary);
        }else  if (approval.getBusinesstype().equals(BusinessType.BAFWGS)) {

            //获取保安服务公司信息，更新审批信息
            Sponsorlicense sponsorlicense = sponsorlicenseService.findById(approval.getBusinessid());
            //法人信息
            approvalstate = backgroundApprovalService.getCensorStatus(sponsorlicense.getId(),Constants.BAFW_FR,sponsorlicense.getLegalPersonNo(),sponsorlicense.getRepresentative());
            sponsorlicense.setCensorstatus(approvalstate);
            sponsorlicenseService.updateCensorStatus(sponsorlicense);
            //股东信息
            List<Shareholder> shareholderList =  shareholderDao.findBySId(sponsorlicense.getId().toString());
            for (Shareholder shareholder:shareholderList) {
                //法人股东 和自然人股东 才需要背景筛查
                if("1".equals(shareholder.getType()) || "2".equals(shareholder.getType())) {
                    //股东政审
                    approvalstate = backgroundApprovalService.getCensorStatus(shareholder.getId(), Constants.BAFW_GD, shareholder.getIdnumber(), shareholder.getName());
                    shareholder.setCensorstatus(approvalstate);
                    shareholderService.updateCensorStatus(shareholder);
                }
            }
            //总经理
            List<SbSponsorlicenseManager> managerList =  sbSponsorlicenseManagerDao.findBySponsorId(sponsorlicense.getId());
            for (SbSponsorlicenseManager manager : managerList) {
                //政审
                approvalstate = backgroundApprovalService.getCensorStatus(manager.getId(),Constants.BAFW_ZJL,manager.getIdnum(),manager.getName());
                manager.setCensorstatus(approvalstate);
                manager.setUpdateTime(new Date());
                sbSponsorlicenseManagerDao.updateCensorStatus(manager);
            }

            //副总经理
            List<SbSponsorlicenseVmanager> vManagerList =  sbSponsorlicenseVmanagerDao.findBySponsorId(sponsorlicense.getId());
            for (SbSponsorlicenseVmanager manager : vManagerList) {
                //政审
                approvalstate = backgroundApprovalService.getCensorStatus(manager.getId(),Constants.BAFW_FZJL,manager.getVidnum(),manager.getVname());
                manager.setCensorstatus(approvalstate);
                manager.setUpdateTime(new Date());
                sbSponsorlicenseVmanagerDao.updateCensorStatus(manager);
            }
        }else if (approval.getBusinesstype().equals(BusinessType.PXDW)) {//培训服务
            Traincompanyapply traincompanyapply = traincompanyapplyService.findById(approval.getBusinessid());
            //法人信息
            approvalstate = backgroundApprovalService.getCensorStatus(traincompanyapply.getId(),Constants.PXDW_JBFR,traincompanyapply.getLegalcode(),traincompanyapply.getLegalname());

            traincompanyapply.setCensorStatus(approvalstate);
            traincompanyapplyService.updateCensorStatus(traincompanyapply);
            //拟定法人信息
            approvalstate = backgroundApprovalService.getCensorStatus(traincompanyapply.getId(),Constants.BAFW_NPXDWGD,traincompanyapply.getTraincreditcode(),traincompanyapply.getTrainlegalname());

            traincompanyapply.setPlanCensorStatus(approvalstate);
            traincompanyapplyService.updateCensorStatus(traincompanyapply);
        } else if (approval.getBusinesstype().equals(BusinessType.KQYBAGS)) {//跨区域经营保安公司
            Crosscompany crosscompany = crosscompanyService.findById(approval.getBusinessid());
            //法人信息政审
            approvalstate = backgroundApprovalService.getCensorStatus(crosscompany.getId(),Constants.KQ_FR,crosscompany.getLegalcardnumber(),crosscompany.getLegalname());

            crosscompany.setLegalcensorstatus(approvalstate);
            crosscompanyService.updateCensorStatus(crosscompany);
            //负责人政审
            approvalstate = backgroundApprovalService.getCensorStatus(crosscompany.getId(),Constants.KQ_FZR,crosscompany.getChargecardnumber(),crosscompany.getChargename());
            crosscompany.setChargecensorstatus(approvalstate);
            crosscompanyService.updateCensorStatus(crosscompany);
        }else if (approval.getBusinesstype().equals(BusinessType.ZZBACX)) {//自行招用保安员单位撤销备案
            Confesscompanyundo confcesscompanyundo = confesscompanyundoService.findById(approval.getBusinessid());
            //法人信息政审
            approvalstate = backgroundApprovalService.getCensorStatus(confcesscompanyundo.getId(),Constants.QZPX_ZZCX,confcesscompanyundo.getLegalcard(),confcesscompanyundo.getLegalname());

            confcesscompanyundo.setCensorstatus(approvalstate);
            confesscompanyundoService.updateCensorStatus(confcesscompanyundo);

        } else if (approval.getBusinesstype().equals(BusinessType.FRBG)) {//法人变更
            Legalchange legalchange = legalchangeService.findById(approval.getBusinessid());
            if(StringUtil.isNotEmpty(legalchange.getNdlegalcardnum())) {
                //法人变更原法人政审
                approvalstate = backgroundApprovalService.getCensorStatus(legalchange.getId(), Constants.GRBG_YFR, legalchange.getLegalcardnumber(), legalchange.getLegalname());
                legalchange.setLegalcensorstatus(approvalstate);
                legalchangeService.updateCensorStatus(legalchange);
                //法人变更拟法人政审
                approvalstate = backgroundApprovalService.getCensorStatus(legalchange.getId(), Constants.GRBG_NFR, legalchange.getNdlegalcardnum(), legalchange.getNdlegalname());
                legalchange.setNdlegalcensorstatus(approvalstate);
                legalchangeService.updateCensorStatus(legalchange);
            }
            //法人变更负责人
            //backgroundApprovalService.approval(legalchange.getId(),Constants.GRBG_FZR,legalchange.getLegalcard(),legalchange.getLegalname());
        } else if (approval.getBusinesstype().equals(BusinessType.PXDWXMBG)) {//培训单位项目变更
            TrainChange trainChange = trainChangeService.findById(approval.getBusinessid());
            if(StringUtil.isNotEmpty(trainChange.getNdtrainCardnum())) {
                //法人变更原法人政审
                approvalstate = backgroundApprovalService.getCensorStatus(trainChange.getId(), Constants.PXDWGRBG_YFR, trainChange.getTrainCardnumber(), trainChange.getLegalname());
                trainChange.setTrainCensorstatus(approvalstate);
                trainChangeService.updateCensorStatus(trainChange);
                //法人变更拟法人政审
                approvalstate = backgroundApprovalService.getCensorStatus(trainChange.getId(), Constants.PXDWGRBG_NFR, trainChange.getNdtrainCardnum(), trainChange.getNdlegalname());
                trainChange.setNdtrainCensorstatus(approvalstate);
                trainChangeService.updateCensorStatus(trainChange);
            }
            //法人变更负责人
            //backgroundApprovalService.approval(legalchange.getId(),Constants.GRBG_FZR,legalchange.getLegalcard(),legalchange.getLegalname());
        }else if (approval.getBusinesstype().equals(BusinessType.BAPXDWBA)) {//保安培训单位备案
            Trainrecord trainrecord = trainrecordService.findById(approval.getBusinessid());
            //法人信息
            approvalstate = backgroundApprovalService.getCensorStatus(trainrecord.getId(),Constants.BAPXDWBA_FR,trainrecord.getIdNum(),trainrecord.getLegalName());
            trainrecord.setCensorStatus(approvalstate);
            trainrecordService.updateSelective(trainrecord);
            //负责人信息
            approvalstate = backgroundApprovalService.getCensorStatus(trainrecord.getId(),Constants.BAPXDWBA_FZR,trainrecord.getChargeIdNum(),trainrecord.getChargeName());
            trainrecord.setChargeCensorStatus(approvalstate);
            trainrecordService.updateSelective(trainrecord);
        }
    }

    @Override
    public void saveArrovalForImport(Approval approval) {
        //保安服务公司
        if (approval.getBusinesstype().equals(BusinessType.BAFWGS)) {
            //获取保安服务公司信息，更新审批信息
            Sponsorlicense sponsorlicense = sponsorlicenseService.findById(approval.getBusinessid());
            //审批状态
            if (approval.getApprovalstate().equals("010")) {
                sponsorlicense.setApprovalstate("003");
            } else if (approval.getApprovalstate().equals("011")) {
                sponsorlicense.setApprovalstate("004");
            } else if (approval.getApprovalstate().equals("012")) {
                sponsorlicense.setApprovalstate("004");
            } else {
                sponsorlicense.setApprovalstate(approval.getApprovalstate());
            }
            //审批原因
            sponsorlicense.setApprovalreason(approval.getApprovalreason());
            sponsorlicense.setInfoRar(approval.getInfoRar());
            sponsorlicense.setReplyRar(approval.getReplyRar());
            sponsorlicense.setReplyreason(approval.getReplyreason());
            sponsorlicense.setReplyState(approval.getReplystate());
            //更新
            if (approval.getUpdateTime().getTime() > sponsorlicense.getUpdateTime().getTime()) {
                sponsorlicense.setUpdateTime(approval.getUpdateTime());
                sponsorlicenseService.saveOrUpdateForApprovalImport(sponsorlicense);
            }
        } else if (approval.getBusinesstype().equals(BusinessType.BAGSZGS)) {//子公司
            Subsidiary subsidiary = subsidiaryService.findById(approval.getBusinessid());
            //审批状态
            subsidiary.setApprovalstate(approval.getApprovalstate());
            //审批原因
            subsidiary.setApprovalreason(approval.getApprovalreason());
            //更新
            if (approval.getUpdateTime().getTime() > subsidiary.getUpdateTime().getTime()) {
                subsidiary.setUpdateTime(approval.getUpdateTime());
                subsidiaryService.saveOrUpdateForApprovalImport(subsidiary);
            }

        } else if (approval.getBusinesstype().equals(BusinessType.BAYZ)) {//保安员证
            Personcertificate personcertificate = personcertificateService.findById(approval.getBusinessid());
            //审批状态
            personcertificate.setApprovalstate(approval.getApprovalstate());
            if (approval.getApprovalstate().equals(ApprovalState.SHTG)) {
                personcertificate.setCardState(Constants.CARD_STATE_YZZ);
            }
            personcertificate.setUpdateBy(approval.getUpdateBy());
            //审批原因
            personcertificate.setApprovalreason(approval.getApprovalreason());
            personcertificate.setGroupid(approval.getGroupid());
            //更新
            if (approval.getUpdateTime().getTime() > personcertificate.getUpdateTime().getTime()) {
                //	personcertificate.setUpdateTime(approval.getUpdateTime());
                personcertificateService.saveOrUpdateForApprovalImport(personcertificate);
            }
        } else if (approval.getBusinesstype().equals(BusinessType.KQYBAGS)) {//跨区域经营保安公司
            Crosscompany crosscompany = crosscompanyService.findById(approval.getBusinessid());
            //审批状态
            crosscompany.setApprovalstate(approval.getApprovalstate());
            //审批原因
            crosscompany.setApprovalreason(approval.getApprovalreason());
            //更新
            if (approval.getUpdateTime().getTime() > crosscompany.getUpdateTime().getTime()) {
                crosscompany.setUpdateTime(approval.getUpdateTime());
                crosscompanyService.saveOrUpdateForApprovalImport(crosscompany);
            }
        } else if (approval.getBusinesstype().equals(BusinessType.PXDW)) {//培训服务
            Traincompanyapply traincompanyapply = traincompanyapplyService.findById(approval.getBusinessid());
            //审批状态
            if (approval.getApprovalstate().equals("010")) {
                traincompanyapply.setApprovalstate(ApprovalState.SHTG);
            } else if (approval.getApprovalstate().equals("011")) {
                traincompanyapply.setApprovalstate(ApprovalState.SHBTG);
            } else if (approval.getApprovalstate().equals("012")) {
                traincompanyapply.setApprovalstate(ApprovalState.SHBTG);
            } else {
                traincompanyapply.setApprovalstate(approval.getApprovalstate());
            }

            //审批原因
            traincompanyapply.setApprovalreason(approval.getApprovalreason());
            traincompanyapply.setInfoRar(approval.getInfoRar());
            traincompanyapply.setReplyRar(approval.getReplyRar());
            traincompanyapply.setReplyreason(approval.getReplyreason());
            traincompanyapply.setReplyState(approval.getReplystate());

            //更新
            if (approval.getUpdateTime().getTime() > traincompanyapply.getUpdateTime().getTime()) {
                traincompanyapply.setUpdateTime(approval.getUpdateTime());
                traincompanyapplyService.saveOrUpdateForApprovalImport(traincompanyapply);
            }

        } else if (approval.getBusinesstype().equals(BusinessType.ZXZY)) {//自行招用保安员单位
            Confesscompany confcesscompany = confesscompanyService.findById(approval.getBusinessid());
            //审批状态
            confcesscompany.setApprovalstate(approval.getApprovalstate());
            //审批原因
            confcesscompany.setApprovalreason(approval.getApprovalreason());
            //更新
            if (approval.getUpdateTime().getTime() > confcesscompany.getUpdateTime().getTime()) {
                confcesscompany.setUpdateTime(approval.getUpdateTime());
                confesscompanyService.saveOrUpdateForApprovalImport(confcesscompany);
            }

        } else if (approval.getBusinesstype().equals(BusinessType.ZZBACX)) {//自行招用保安员单位撤销备案
            Confesscompanyundo confcesscompanyundo = confesscompanyundoService.findById(approval.getBusinessid());
            //审批状态
            confcesscompanyundo.setApprovalstate(approval.getApprovalstate());
            //审批时间
            confcesscompanyundo.setApprovaldate(approval.getApprovaldate());
            //审批原因
            confcesscompanyundo.setApprovalreason(approval.getApprovalreason());
            confesscompanyundoService.updateForImport(confcesscompanyundo);
        } else if (approval.getBusinesstype().equals(BusinessType.FRBG)) {//法人变更
            Legalchange legalchange = legalchangeService.findById(approval.getBusinessid());
            //审批状态
            legalchange.setApprovalstate(approval.getApprovalstate());
            //审批原因
            legalchange.setApprovalreason(approval.getApprovalreason());
            //更新
            if (approval.getUpdateTime().getTime() > legalchange.getUpdateTime().getTime()) {
                legalchange.setUpdateTime(approval.getUpdateTime());
                legalchangeService.saveOrUpdateForApprovalImport(legalchange);
            }
            this.legalChangeSync(legalchange);
        } else if (approval.getBusinesstype().equals(BusinessType.PXDWXMBG)) {//培训单位 项目变更
            TrainChange trainChange = trainChangeService.findById(approval.getBusinessid());
            //审批状态
            trainChange.setApprovalstate(approval.getApprovalstate());
            //审批原因
            trainChange.setApprovalreason(approval.getApprovalreason());
            //更新
            if (approval.getUpdateTime().getTime() > trainChange.getUpdateTime().getTime()) {
                trainChange.setUpdateTime(approval.getUpdateTime());
                trainChangeService.saveOrUpdateForApprovalImport(trainChange);
            }
            this.trainChangeSync(trainChange);
        } else if (approval.getBusinesstype().equals(BusinessType.NDBG)) {//年度报告
            Yearreportdata yearreport = yearreportdataService.findById(approval.getBusinessid());
            //审批状态
            yearreport.setApprovalstate(approval.getApprovalstate());
            //审批原因
            yearReportSendMessage(yearreport, approval);
            if (approval.getUpdateTime().getTime() > yearreport.getUpdateTime().getTime()) {
                yearreport.setUpdateTime(approval.getUpdateTime());
                yearreportdataService.saveOrUpdateForApprovalImport(yearreport);
            }
        } else if (approval.getBusinesstype().equals(BusinessType.QZPX)) {//枪支培训
            Armtrainorg armtrainorg = armtrainorgService.findById(approval.getBusinessid());
            //审批状态
            armtrainorg.setApprovalstate(approval.getApprovalstate());
            //审批原因
            armtrainorg.setApprovalreason(approval.getApprovalreason());

            //更新
            if (approval.getUpdateTime().getTime() > armtrainorg.getUpdateTime().getTime()) {
                armtrainorg.setUpdateTime(approval.getUpdateTime());
                armtrainorgService.saveOrUpdateForApprovalImport(armtrainorg);
            }
        }else if (approval.getBusinesstype().equals(BusinessType.BAPXDWBA)) {//保安培训单位备案
            Trainrecord trainrecord = trainrecordService.findById(approval.getBusinessid());
            //审批状态
            trainrecord.setApprovalstate(approval.getApprovalstate());
            //审批时间
            trainrecord.setApprovaldate(approval.getApprovaldate());
            //审批原因
            trainrecord.setApprovalreason(approval.getApprovalreason());
            //更新
            if (approval.getUpdateTime().getTime() > trainrecord.getUpdateTime().getTime()) {
                trainrecord.setUpdateTime(approval.getUpdateTime());
                trainrecordService.saveOrUpdateForApprovalImport(trainrecord);
            }

        }
    }

    @Override
    public void saveBatchArrovalForImport(List<Approval> approvalList) {
        if (null != approvalList && approvalList.size() > 0) {
            //保安服务公司List
            List<Approval> bafwgsList = new ArrayList<>();
            //子公司List
            List<Approval> zgsList = new ArrayList<>();
            //保安员证
            List<Approval> bayzList = new ArrayList<>();
            //跨区域
            List<Approval> kqyList = new ArrayList<>();
            //培训服务
            List<Approval> pxfwList = new ArrayList<>();
            //自行招用
            List<Approval> zxzyList = new ArrayList<>();
            //自行招用撤销
            List<Approval> zxzycxList = new ArrayList<>();
            //法人变更
            List<Approval> frbgList = new ArrayList<>();
            //年度报告
            List<Approval> ndbgList = new ArrayList<>();
            //枪支
            List<Approval> qzList = new ArrayList<>();
            //遍历分类型
            for (Approval approval : approvalList) {
                if (null != approval.getBusinesstype()) {
                    switch (approval.getBusinesstype()) {
                        //保安服务公司
                        case BusinessType.BAFWGS:
                            bafwgsList.add(approval);
                            break;
                        //子公司
                        case BusinessType.BAGSZGS:
                            zgsList.add(approval);
                            break;
                        //保安员证
                        case BusinessType.BAYZ:
                            bayzList.add(approval);
                            break;
                        //跨区域经营保安公司
                        case BusinessType.KQYBAGS:
                            kqyList.add(approval);
                            break;
                        //培训服务
                        case BusinessType.PXDW:
                            pxfwList.add(approval);
                            break;
                        //自行招用保安员单位
                        case BusinessType.ZXZY:
                            zxzyList.add(approval);
                            break;
                        //自行招用保安员单位撤销备案
                        case BusinessType.ZZBACX:
                            zxzycxList.add(approval);
                            break;
                        //法人变更
                        case BusinessType.FRBG:
                            frbgList.add(approval);
                            break;
                        //年度报告
                        case BusinessType.NDBG:
                            ndbgList.add(approval);
                            break;
                        //枪支培训
                        case BusinessType.QZPX:
                            qzList.add(approval);
                            break;
                        default:
                            break;
                    }

                }

            }
            //保安服务公司业务处理
            if (null != bafwgsList && bafwgsList.size() > 0) {
                //获取保安服务公司信息，更新审批信息
                List<Sponsorlicense> dbExistPonsorlicenseList = sponsorlicenseService.findByBatchId(bafwgsList);
                List<Sponsorlicense> removeList = new ArrayList<>();
                for (Sponsorlicense sponsorlicense : dbExistPonsorlicenseList) {
                    int logListSize = bafwgsList.size();
                    for (int i = 0; i < logListSize; i++) {
                        if (sponsorlicense.getId().equals(bafwgsList.get(i).getBusinessid())) {
                            if (bafwgsList.get(i).getUpdateTime().getTime() > sponsorlicense.getUpdateTime().getTime()) {
                                Approval approval = bafwgsList.get(i);
                                //审批状态
                                if (approval.getApprovalstate().equals("010")) {
                                    sponsorlicense.setApprovalstate("003");
                                } else if (approval.getApprovalstate().equals("011")) {
                                    sponsorlicense.setApprovalstate("004");
                                } else if (approval.getApprovalstate().equals("012")) {
                                    sponsorlicense.setApprovalstate("004");
                                } else {
                                    sponsorlicense.setApprovalstate(approval.getApprovalstate());
                                }
                                //审批原因
                                sponsorlicense.setApprovalreason(approval.getApprovalreason());
                                sponsorlicense.setInfoRar(approval.getInfoRar());
                                sponsorlicense.setReplyRar(approval.getReplyRar());
                                sponsorlicense.setReplyreason(approval.getReplyreason());
                                sponsorlicense.setReplyState(approval.getReplystate());
                                sponsorlicense.setUpdateTime(approval.getUpdateTime());
                                break;
                            } else {
                                removeList.add(sponsorlicense);
                                break;
                            }

                        }
                    }
                }
                if (removeList.size() > 0) {
                    dbExistPonsorlicenseList.removeAll(removeList);
                }
                if (dbExistPonsorlicenseList.size() > 0) {
                    //批量更新
                    sponsorlicenseService.saveOrUpdateForApprovalBatchImport(dbExistPonsorlicenseList);
                }
            }
            //子公司业务处理
            if (null != zgsList && zgsList.size() > 0) {

                List<Subsidiary> subsidiaryList = subsidiaryService.findByBatchId(zgsList);
                List<Subsidiary> removeList = new ArrayList<>();
                for (Subsidiary subsidiary : subsidiaryList) {
                    int logListSize = zgsList.size();
                    for (int i = 0; i < logListSize; i++) {
                        if (subsidiary.getId().equals(zgsList.get(i).getBusinessid())) {
                            if (zgsList.get(i).getUpdateTime().getTime() > subsidiary.getUpdateTime().getTime()) {
                                Approval approval = zgsList.get(i);
                                //审批状态
                                subsidiary.setApprovalstate(approval.getApprovalstate());
                                //审批原因
                                subsidiary.setApprovalreason(approval.getApprovalreason());
                                subsidiary.setUpdateTime(approval.getUpdateTime());
                            } else {
                                removeList.add(subsidiary);
                            }
                            break;
                        }
                    }
                }

                if (removeList.size() > 0) {
                    subsidiaryList.removeAll(removeList);
                }
                //更新
                if (subsidiaryList.size() > 0) {
                    subsidiaryService.saveOrUpdateForApprovalBatchImport(subsidiaryList);
                }
            }
            //保安员证
            if (null != bayzList && bayzList.size() > 0) {

                List<Personcertificate> personcertificateList = personcertificateService.findByApprovalBatchId(bayzList);
                List<Personcertificate> removeList = new ArrayList<>();
                for (Personcertificate personcertificate : personcertificateList) {
                    int logListSize = bayzList.size();
                    for (int i = 0; i < logListSize; i++) {
                        if (personcertificate.getId().equals(bayzList.get(i).getBusinessid())) {
                            if (bayzList.get(i).getUpdateTime().getTime() > personcertificate.getUpdateTime().getTime()) {
                                Approval approval = bayzList.get(i);
                                //审批状态
                                personcertificate.setApprovalstate(approval.getApprovalstate());
                                if (ApprovalState.SHTG.equals(approval.getApprovalstate())) {
                                    personcertificate.setCardState(Constants.CARD_STATE_YZZ);
                                }
                                personcertificate.setUpdateBy(approval.getUpdateBy());
                                //审批原因
                                personcertificate.setApprovalreason(approval.getApprovalreason());

                            } else {
                                removeList.add(personcertificate);
                            }
                            break;
                        }
                    }
                }
                if (removeList.size() > 0) {
                    personcertificateList.removeAll(removeList);
                }
                //更新
                if (personcertificateList.size() > 0) {
                    personcertificateService.updateBatch(personcertificateList);
                }
            }

            //跨区域经营保安公司
            if (null != kqyList && kqyList.size() > 0) {
                List<Crosscompany> crosscompanyList = crosscompanyService.findByBatchId(kqyList);
                List<Crosscompany> removeList = new ArrayList<>();
                for (Crosscompany crosscompany : crosscompanyList) {
                    int logListSize = kqyList.size();
                    for (int i = 0; i < logListSize; i++) {
                        if (crosscompany.getId().equals(kqyList.get(i).getBusinessid())) {
                            if (kqyList.get(i).getUpdateTime().getTime() > crosscompany.getUpdateTime().getTime()) {
                                Approval approval = kqyList.get(i);
                                //审批状态
                                crosscompany.setApprovalstate(approval.getApprovalstate());
                                //审批原因
                                crosscompany.setApprovalreason(approval.getApprovalreason());
                                crosscompany.setUpdateTime(approval.getUpdateTime());

                            } else {
                                removeList.add(crosscompany);

                            }
                            break;
                        }
                    }

                }
                if (removeList.size() > 0) {
                    crosscompanyList.removeAll(removeList);
                }
                //更新
                if (crosscompanyList.size() > 0) {
                    crosscompanyService.updateBatch(crosscompanyList);
                }
            }
            //培训服务
            if (null != pxfwList && pxfwList.size() > 0) {
                List<Traincompanyapply> traincompanyapplyList = traincompanyapplyService.findByBatchId(pxfwList);
                List<Traincompanyapply> removeList = new ArrayList<>();
                for (Traincompanyapply traincompanyapply : traincompanyapplyList) {
                    int logListSize = pxfwList.size();
                    for (int i = 0; i < logListSize; i++) {
                        if (traincompanyapply.getId().equals(pxfwList.get(i).getBusinessid())) {
                            if (pxfwList.get(i).getUpdateTime().getTime() > traincompanyapply.getUpdateTime().getTime()) {
                                Approval approval = pxfwList.get(i);
//审批状态
                                if (approval.getApprovalstate().equals("010")) {
                                    traincompanyapply.setApprovalstate(ApprovalState.SHTG);
                                } else if (approval.getApprovalstate().equals("011")) {
                                    traincompanyapply.setApprovalstate(ApprovalState.SHBTG);
                                } else if (approval.getApprovalstate().equals("012")) {
                                    traincompanyapply.setApprovalstate(ApprovalState.SHBTG);
                                } else {
                                    traincompanyapply.setApprovalstate(approval.getApprovalstate());
                                }
//审批原因
                                traincompanyapply.setApprovalreason(approval.getApprovalreason());
                                traincompanyapply.setInfoRar(approval.getInfoRar());
                                traincompanyapply.setReplyRar(approval.getReplyRar());
                                traincompanyapply.setReplyreason(approval.getReplyreason());
                                traincompanyapply.setReplyState(approval.getReplystate());
//更新
                                traincompanyapply.setUpdateTime(approval.getUpdateTime());
                            } else {

                                removeList.add(traincompanyapply);
                            }
                            break;
                        }
                    }

                }
                if (removeList.size() > 0) {
                    traincompanyapplyList.removeAll(removeList);
                }
                if (traincompanyapplyList.size() > 0) {
                    //更新
                    traincompanyapplyService.updateBatch(traincompanyapplyList);
                }
            }
            //自行招用保安员单位
            if (null != zxzyList && zxzyList.size() > 0) {
                List<Confesscompany> list = confesscompanyService.findByBatchId(zxzyList);
                List<Confesscompany> removeList = new ArrayList<>();
                for (Confesscompany confesscompany : list) {
                    int logListSize = zxzyList.size();
                    for (int i = 0; i < logListSize; i++) {
                        if (confesscompany.getId().equals(zxzyList.get(i).getBusinessid())) {
                            if (zxzyList.get(i).getUpdateTime().getTime() > confesscompany.getUpdateTime().getTime()) {
                                Approval approval = zxzyList.get(i);
//审批状态
                                confesscompany.setApprovalstate(approval.getApprovalstate());
//审批原因
                                confesscompany.setApprovalreason(approval.getApprovalreason());
//更新
                                confesscompany.setUpdateTime(approval.getUpdateTime());

                            } else {
                                removeList.add(confesscompany);
                            }
                            break;
                        }
                    }

                }
                if (removeList.size() > 0) {
                    list.removeAll(removeList);
                }
                if (list.size() > 0) {
                    //更新
                    confesscompanyService.updateBatch(list);

                }
            }
            //自行招用保安员单位撤销备案
            if (null != zxzycxList && zxzycxList.size() > 0) {
                List<Confesscompanyundo> list = confesscompanyundoService.findByBatchId(zxzycxList);
                List<Confesscompanyundo> removeList = new ArrayList<>();
                for (Confesscompanyundo confesscompanyundo : list) {
                    int logListSize = zxzycxList.size();
                    for (int i = 0; i < logListSize; i++) {
                        if (confesscompanyundo.getId().equals(zxzycxList.get(i).getBusinessid())) {
                            if (zxzycxList.get(i).getUpdateTime().getTime() > confesscompanyundo.getUpdateTime().getTime()) {
                                Approval approval = zxzycxList.get(i);
                                //审批状态
                                confesscompanyundo.setApprovalstate(approval.getApprovalstate());
                                //审批时间
                                confesscompanyundo.setApprovaldate(approval.getApprovaldate());
                                //审批原因
                                confesscompanyundo.setApprovalreason(approval.getApprovalreason());

                            } else {
                                removeList.add(confesscompanyundo);
                            }
                            break;
                        }
                    }

                }
                if (removeList.size() > 0) {
                    list.removeAll(removeList);
                }
                if (list.size() > 0) {
                    //更新
                    confesscompanyundoService.updateBatch(list);
                }
            }
            //法人变更
            if (null != frbgList && frbgList.size() > 0) {
                List<Legalchange> list = legalchangeService.findByBatchId(frbgList);
                List<Legalchange> removeList = new ArrayList<>();
                for (Legalchange legalchange : list) {
                    int logListSize = frbgList.size();
                    for (int i = 0; i < logListSize; i++) {
                        if (legalchange.getId().equals(frbgList.get(i).getBusinessid())) {
                            if (frbgList.get(i).getUpdateTime().getTime() > legalchange.getUpdateTime().getTime()) {
                                Approval approval = frbgList.get(i);

                                //审批状态
                                legalchange.setApprovalstate(approval.getApprovalstate());
                                //审批原因
                                legalchange.setApprovalreason(approval.getApprovalreason());
                                //更新时间
                                legalchange.setUpdateTime(approval.getUpdateTime());
                                //法人变更同步到公司人员（未做批量）
                                this.legalChangeSync(legalchange);
                            } else {
                                removeList.add(legalchange);
                            }
                            break;
                        }
                    }

                }
                if (removeList.size() > 0) {
                    list.removeAll(removeList);
                }
                if (list.size() > 0) {
                    //更新
                    legalchangeService.updateBatch(list);
                }
            }
            //年度报告
            if (null != ndbgList && ndbgList.size() > 0) {
                List<Yearreportdata> list = yearreportdataService.findByBatchId(ndbgList);
                List<Yearreportdata> removeList = new ArrayList<>();
                for (Yearreportdata yearreport : list) {
                    int logListSize = ndbgList.size();
                    for (int i = 0; i < logListSize; i++) {
                        if (yearreport.getId().equals(ndbgList.get(i).getBusinessid())) {
                            if (ndbgList.get(i).getUpdateTime().getTime() > yearreport.getUpdateTime().getTime()) {
                                Approval approval = ndbgList.get(i);
                                //审批状态
                                yearreport.setApprovalstate(approval.getApprovalstate());
                                //年度报告发送通知（未做批量）
                                this.yearReportSendMessage(yearreport, approval);
                                yearreport.setUpdateTime(approval.getUpdateTime());
                            } else {
                                removeList.add(yearreport);
                            }
                            break;
                        }
                    }

                }
                if (removeList.size() > 0) {
                    list.removeAll(removeList);
                }
                if (list.size() > 0) {
                    //更新
                    yearreportdataService.updateBatch(list);
                }
            }
            //枪支培训
            if (null != qzList && qzList.size() > 0) {
                List<Armtrainorg> list = armtrainorgService.findByBatchId(qzList);
                List<Armtrainorg> removeList = new ArrayList<>();
                for (Armtrainorg armtrainorg : list) {
                    int logListSize = qzList.size();
                    for (int i = 0; i < logListSize; i++) {
                        if (armtrainorg.getId().equals(qzList.get(i).getBusinessid())) {
                            if (qzList.get(i).getUpdateTime().getTime() > armtrainorg.getUpdateTime().getTime()) {
                                Approval approval = qzList.get(i);
                                //审批状态
                                armtrainorg.setApprovalstate(approval.getApprovalstate());
                                //审批原因
                                armtrainorg.setApprovalreason(approval.getApprovalreason());
                                //更新
                                armtrainorg.setUpdateTime(approval.getUpdateTime());
                            } else {
                                removeList.add(armtrainorg);
                            }
                            break;
                        }
                    }

                }
                if (removeList.size() > 0) {
                    list.removeAll(removeList);
                }
                if (list.size() > 0) {
                    //更新
                    armtrainorgService.updateBatch(list);
                }
            }
        }

    }

    /**
     * @param approval
     * @return void
     * @Decription:方法抽取年度报告发送信息
     * @author：zhongjianhui
     * @method yearReportSendMessage
     * @date：2018/8/17 13:45
     * @params： * @param yearreport
     */
    private void yearReportSendMessage(Yearreportdata yearreport, Approval approval) {
        if (approval.getApprovalstate().equals(ApprovalState.SHBTG) || approval.getApprovalstate().equals(ApprovalState.SHTG)) {
            //          7186  ARS-百保盾系统 测试BUG 【WEB】【年度报告备案】公安内部的审批意见不能显示在审批查看界面
            //          yearreport.setApprovalreason(approval.getApprovalreason());
            yearreport.setApprovalfile(approval.getReplyRar());
            if (StringUtil.isNotEmpty(approval.getReplyreason())) {
                yearreport.setApprovalreason(approval.getReplyreason());
            }

        }
    }


    /**
     * 项目变更同步公司表并同步到saas
     * @param legalchange
     */
    @Override
    public void legalChangeSync(Legalchange legalchange) {
        if (legalchange.getApprovalstate().equals(ApprovalState.SHTG)) {
            SecurityCompany dbCompany = companyDao.findByUserid(legalchange.getUserid());
            if (dbCompany != null) {
                ComInfoDto comInfoDto = new ComInfoDto();
                Boolean changFlag = false;
                comInfoDto.setUserName(dbCompany.getUser().getUsername());
                comInfoDto.setComId(Long.parseLong(dbCompany.getComId()));
                //法人
                if (StringUtil.isNotEmpty(legalchange.getNdlegalname())) {
                    dbCompany.setLegalPerson(legalchange.getNdlegalname());
                    dbCompany.setLegalPersonNo(legalchange.getNdlegalcardnum());
                    dbCompany.getUser().setPhone(legalchange.getNdlegalphone());

                    comInfoDto.setLegalRepName(dbCompany.getLegalPerson());
                    comInfoDto.setIdCardNo(dbCompany.getLegalPersonNo());
                    comInfoDto.setLegalRepPhone(dbCompany.getUser().getPhone());
                    changFlag = true;
                }
               //地址
                if (StringUtil.isNotEmpty(legalchange.getAddress())) {
                    dbCompany.setLocation(legalchange.getAddress());
                    //TODO 地址 百保盾完整地址带省市区，saas地址不包含省市区
                    comInfoDto.setRegAddress(dbCompany.getLocation());

                    changFlag = true;
                }
                //服务范围
                if (StringUtil.isNotEmpty(legalchange.getOtherSecScopeType())) {
                    dbCompany.setOtherSecScopeType(legalchange.getOtherSecScopeType());
                    changFlag = true;
                }
                //公司名称
                if (StringUtil.isNotEmpty(legalchange.getCompanyname())) {
                    dbCompany.setName(legalchange.getCompanyname());
                    dbCompany.getUser().setRealname(legalchange.getCompanyname());
                    comInfoDto.setComName(dbCompany.getName());
                    changFlag = true;
                }
                //服务范围
                if (StringUtil.isNotEmpty(legalchange.getSecurityScopes())) {
                    dbCompany.setSecurityScopeType(legalchange.getSecurityScopes());

                    /*
            转成saas码表
            complete-xmbg-approve
            safeRange 安全范围
                北京：1:门卫,2:巡逻,3:守护,4:随身护卫,6:武装押运,7:安全检查,8:安全风险评估,9:安全风险评估
                陕西：1:门卫,2:巡逻,3:守护,4:随身护卫,5:押运,6:区域秩序维护,7:安全检查,8:安全风险评估,9:安全技术防范
            */
                    //Map<String, String> safeRangeMap = new HashMap<>();
                    //if(Constants.SHANGXI.equals(configUtils.getCurrentNative())){
                    //    safeRangeMap.put("1", "1");
                    //    safeRangeMap.put("2", "2");
                    //    safeRangeMap.put("3", "3");
                    //    safeRangeMap.put("4", "4");
                    //    safeRangeMap.put("6", "10");
                    //    safeRangeMap.put("5", "6");
                    //    safeRangeMap.put("7", "7");
                    //    safeRangeMap.put("8", "8");
                    //    safeRangeMap.put("9", "9");
                    //}else{
                    //    //北京、广西、宁夏
                    //    safeRangeMap.put("1", "1");
                    //    safeRangeMap.put("2", "2");
                    //    safeRangeMap.put("3", "3");
                    //    safeRangeMap.put("4", "4");
                    //    safeRangeMap.put("6", "6");
                    //    safeRangeMap.put("7", "7");
                    //    safeRangeMap.put("8", "8");
                    //    safeRangeMap.put("9", "9");
                    //}
                    //
                    //StringBuffer safeRange = new StringBuffer();
                    //for (String scopeId : legalchange.getSecurityScopes().split(",")) {
                    //    safeRange.append(safeRangeMap.get(scopeId)+Constants.COMMA);
                    //}
                    comInfoDto.setSafeRange(legalchange.getSecurityScopes());
                    changFlag = true;
                }
                if (legalchange.getBgregisteredMoney() != null) {
                    dbCompany.setRegisteredMoney(new BigDecimal(legalchange.getBgregisteredMoney().toString()));
                    comInfoDto.setRegAmount(dbCompany.getRegisteredMoney().toString());
                    changFlag = true;
                }
                //更新企业信息
                dbCompany.getUser().setUpdateTime(new Date());
                userDaoAop.update(dbCompany.getUser());
                dbCompany.setUpdateTime(new Date());
                companyDaoAop.update(dbCompany);
                //是否与SaaS对接
                Config SaaSJoinConfig = configUtils.getConfigByKey(Constants.SaaSJoin);
                if(SaaSJoinConfig!=null && Constants.SaaSJoin_YES.equals(SaaSJoinConfig.getValue()) && changFlag ) {
                    //将公司信息推送给SaaS
                    AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_LEGALCHANGE_UPDATE, comInfoDto);
                    if(!result.isSuccessful()){
                        throw new ArsException(dbCompany.getName() + result.getMsg() );
                    }
                }

            }
        }
    }

    /**
     * 项目变更同步公司表并同步到saas
     * @param trainChange
     */
    public void trainChangeSync(TrainChange trainChange) {
        if (trainChange.getApprovalstate().equals(ApprovalState.SHTG)) {
            SecurityCompany dbCompany = companyDao.findByUserid(trainChange.getUserid());
            if (dbCompany != null) {
                ComInfoDto comInfoDto = new ComInfoDto();
                Boolean changFlag = false;
                comInfoDto.setUserName(dbCompany.getUser().getUsername());
                comInfoDto.setComId(Long.parseLong(dbCompany.getComId()));
                //法人
                if (StringUtil.isNotEmpty(trainChange.getNdlegalname())) {
                    dbCompany.setLegalPerson(trainChange.getNdlegalname());
                    dbCompany.setLegalPersonNo(trainChange.getNdtrainCardnum());
                    dbCompany.getUser().setPhone(trainChange.getNdlegalphone());

                    comInfoDto.setLegalRepName(dbCompany.getLegalPerson());
                    comInfoDto.setIdCardNo(dbCompany.getLegalPersonNo());
                    comInfoDto.setLegalRepPhone(dbCompany.getUser().getPhone());
                    changFlag = true;
                }
               //地址
                if (StringUtil.isNotEmpty(trainChange.getAddress())) {
                    dbCompany.setLocation(trainChange.getAddress());
                    //TODO 地址 百保盾完整地址带省市区，saas地址不包含省市区
                    comInfoDto.setRegAddress(dbCompany.getLocation());

                    changFlag = true;
                }
                //公司名称
                if (StringUtil.isNotEmpty(trainChange.getCompanyname())) {
                    dbCompany.setName(trainChange.getCompanyname());
                    dbCompany.getUser().setRealname(trainChange.getCompanyname());
                    comInfoDto.setComName(dbCompany.getName());
                    changFlag = true;
                }
                //更新企业信息
                dbCompany.getUser().setUpdateTime(new Date());
                userDaoAop.update(dbCompany.getUser());
                dbCompany.setUpdateTime(new Date());
                companyDaoAop.update(dbCompany);
                //是否与SaaS对接
                Config SaaSJoinConfig = configUtils.getConfigByKey(Constants.SaaSJoin);
                if(SaaSJoinConfig!=null && Constants.SaaSJoin_YES.equals(SaaSJoinConfig.getValue()) && changFlag ) {
                    //将公司信息推送给SaaS
                    AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_LEGALCHANGE_UPDATE, comInfoDto);
                    if(!result.isSuccessful()){
                        throw new ArsException(dbCompany.getName() + result.getMsg() );
                    }
                }

            }
        }
    }

    @Override
    public List<Approval> findUnStartProcess() {
        return  approvalDAO.findUnStartProcess();
    }

    @Override
    public void searchForOutTimeApproval(ApprovalOutTimePageSearchDto dto, AjaxPageResponse<Approval> ajaxPageResponse) {
        //获取当前用户信息
        User user =arsUtil.getCurrentUser();

        arsUtil.setPoliceSearch(dto);
        approvalDAO.searchForOutTimeApproval(dto,ajaxPageResponse);
    }

    @Override
    public void searchForPage(ApprovalPageSearchDto dto, AjaxPageResponse<Approval> page) {
        if("002".equals(dto.getSearchType())) {
            approvalDAO.searchDoneForPage(dto, page);
        }else{
            Long count = approvalDAO.searchForPage_count(dto);
            if(count>0) {
                dto.setPageNum(page.getPageNumber()-1);
                dto.setNumPerPage(page.getPageSize());
                page.setData(approvalDAO.searchForPage(dto));
            }
            page.setTotal(count);
        }
    }

    @Override
    public ComContract findByIdComContract(Long comContractId) {
        return comContractDao.findById(comContractId);
    }


    @Override
    public Boolean checkProcess(Long approvalId) {
        Approval approval = approvalDAO.getById(approvalId);
        Config configVersion = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
        if (approval != null && configVersion != null && Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())) {
            return checkProcess_new(approvalId);
        } else {
            return checkProcess_old(approvalId);
        }
    }

    @Deprecated
    private Boolean checkProcess_old(Long approvalId) {
        Approval approval = approvalDAO.getById(approvalId);
        Config endConfig = configUtils.findByKeyAndName(approval.getAreaCode().substring(0, 4) + "00" + approval.getBusinesstype(), Constants.ACTIVITI_END_PROCESS);
        Task task = taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId()).singleResult();
        if (task.getName().equals(endConfig.getValue())) {//TODO 最后一级审批
            return true;
        } else {
            return false;
        }
    }

    private Boolean checkProcess_new(Long approvalId) {
        //获取审批记录信息
        Approval approval = approvalDAO.getById(approvalId);
        String processKey = approvalUtil.getBusinessTypeForActKey(approval);
        String candidateGroup = "";
        String lastTask = "";
        ApproveTemp approveTemp = approveTempDao.findByTempCode(processKey + "-" + approval.getAreaCode().substring(0, 4) + "00");
        if(approveTemp == null){
            approveTemp = approveTempDao.findByTempCode(processKey + "-" + approval.getAreaCode().substring(0, 2) + "0000");
            if(approveTemp == null){
                approveTemp = approveTempDao.findByTempCode(processKey);
            }
        }
        //ApproveTemp approveTemp = approveTempDao.findByTempCode(processKey);
        //获取配置的流程
        Police police = policeDao.findById(approval.getOrgid());
        if (police != null && StringUtil.isNotEmpty(police.getPath())) {
            String path = police.getPath();
            path = path.substring(0, path.length() - 1);
            String[] policeIds = path.split("/");
            //根据机构信息查询
            String processInfo = approveTempDao.findProcessInfoByTempId(approveTemp.getId(), policeIds);
            ActivitiProcess activitiProcess = JSONObject.parseObject(processInfo, ActivitiProcess.class);
            List<ActivitiTask> tasks = activitiProcess.getTasks();
            for (ActivitiTask task : tasks) {
                if ("1".equals(task.getTaskType())) {
                    candidateGroup = task.getCandidateGroup();
                    lastTask = task.getName();
                }
            }
        }


        boolean flag = false;

        //或签会有多个用逗号隔开
        if (StringUtil.isNotEmpty(candidateGroup) && candidateGroup.contains(Constants.COMMA)) {
            for (String groupId : candidateGroup.split(Constants.COMMA)) {
                if (groupId.equals(approval.getGroupid()) && lastTask.equals(approval.getNextPerson())) {
                    flag = true;
                }
            }
        } else if (candidateGroup.equals(approval.getGroupid()) && lastTask.equals(approval.getNextPerson())) {
            flag = true;
        }

        //判断最后一级审批
        if (flag) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    @Deprecated
    public Approval findByBusinessTypeAndUserId(String businessType, Long userId) {
        return approvalDAO.findBybusinessidAndUserId(userId, businessType);
    }

    @Override
    public PageResult searchApprovalList_table(Map<Object, Object> p) {
        Config config = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
        if (config != null && Constants.APPROVAL_VERSION_NEW.equals(config.getValue())) {

            return searchApprovalList_table_new(p);
        } else {
            return searchApprovalList_table_old(p);
        }
    }

    @Override
    public PageResult searchApprovalForPage(Map<Object, Object> p) {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            if (user.getPlatform().intValue() == Constants.PLATFORM_NATURAL_PERSON || user.getPlatform().intValue() == Constants.PLATFORM_COMPANY) {//自然人或公司
                p.put("userid", user.getId());
            }
        }
        return new PageResult(approvalDAO.searchApprovalForPageCount(p), approvalDAO.searchApprovalForPage(p));
    }

    @Deprecated
    private PageResult searchApprovalList_table_old(Map<Object, Object> p) {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            //TODO 审批机构ID
            if (user.getPlatform() == 4 || user.getPlatform() == 2) {
                p.put("userid", user.getId());
            } else {
                //角色列表
                List<PoliceRole> roles = user.getRoles();
                if (roles != null && roles.size() > 0) {
                    p.put("roles", roles);
                }
                //判断是否为民警
                if (user.getPoliceman() != null && user.getPoliceman()) {
                    p.put("policeid", user.getId());
                }
                //机构信息
                Police police = policeDao.findById(user.getOrgid());
                //判断是否为派出所
                if (police.getOrgtype() != null && police.getOrgtype().equals("4")) {
                    p.put("orgid", police.getId());

                }
                p.put("orgtype", police.getOrgtype());
                //机构信息
                String areacode = police.getAreacode();
                if (p.get("areaCode") != null) {
                    areacode = String.valueOf(p.get("areaCode"));
                }
                //区域过滤
                if (StringUtil.isNotEmpty(areacode)) {
                    if (areacode.endsWith("0000")) {//省
                        p.put("orgType", areacode.substring(0, 2) + "____");
                        p.put("areaCode", areacode.substring(0, 2) + "____");
                    } else if (areacode.endsWith("00")) {//市
                        p.put("areaCode", areacode.substring(0, 4) + "__");
                    } else {//区
                        p.put("areaCode", areacode);
                    }
                }
                p.put("platform", user.getPlatform());
                //业务类型权限
                if (user.getUserBusinessTypeList() != null && user.getUserBusinessTypeList().size() > 0) {
                    p.put("userBusinessTypeList", user.getUserBusinessTypeList());
                }

            }
        }
        return new PageResult(approvalDAO.countApprovalList(p), approvalDAO.searchApprovalList(p));
    }

    private PageResult searchApprovalList_table_new(Map<Object, Object> p) {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            if (user.getPlatform().intValue() == Constants.PLATFORM_NATURAL_PERSON || user.getPlatform().intValue() == Constants.PLATFORM_COMPANY) {//自然人或公司
                p.put("userid", user.getId());
            } else {//公安
                /***
                 * edit subh 2018-02-21 查询条件改成用用户ID begin
                 */
                if (user.getPoliceman() != null && user.getPoliceman()) {
                    p.put("policeid", user.getId());
                    p.put("taskDefinitionKey", Constants.ACTIVITI_POLICEMAN);
                }

                p.put("userid", user.getId());
                p.put("platform", user.getPlatform());

                //旧审批用到的条件
                //角色列表
                List<PoliceRole> roles = user.getRoles();
                if (roles != null && roles.size() > 0) {
                    p.put("roles", roles);
                }

                //机构信息
                Police police = policeDao.findById(user.getOrgid());
                //判断是否为派出所
                if (police.getOrgtype() != null && police.getOrgtype().equals("4")) {
                    p.put("orgid", police.getId());
                }

                //机构信息
                String areacode = police.getAreacode();
                //区域过滤
                if (StringUtil.isNotEmpty(areacode)) {
                    if (areacode.endsWith("0000")) {//省
                        p.put("areaCode", areacode.substring(0, 2) + "____");
                    } else if (areacode.endsWith("00")) {//市
                        p.put("areaCode", areacode.substring(0, 4) + "__");
                    } else {//区
                        p.put("areaCode", areacode);
                    }
                }
                //业务类型权限
                if (user.getUserBusinessTypeList() != null && user.getUserBusinessTypeList().size() > 0) {
                    p.put("userBusinessTypeList", user.getUserBusinessTypeList());
                }
            }
        }
        return new PageResult(approvalDAO.countApprovalList_new(p), approvalDAO.searchApprovalList_new(p));
    }

    @Override
    public void updateFlag(Approval approval) {
        approvalDAO.updateFlag(approval);
    }

    private void writeTxtFile(String readStr, String type) {
//    	logger.info(type);
        try {
            String basePath = tempftpFolder;    //路径
            String filePath = basePath + com.bcxin.ars.util.DateUtil.getCurrentDate() + File.separator;//保存路径

            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                logger.info("文件夹已创建");
            }
            String fullFilePath = filePath + fileName + "_" + com.bcxin.ars.util.DateUtil.getCurrentDateTime(com.bcxin.ars.util.DateUtil.FORMAT8) + fileType;

            //文件处理：写入文件
            File newFile = new File(fullFilePath);
            Files.write(readStr.getBytes(), newFile);
        } catch (Exception e) {
            logger.info("导出失败！");
        }
    }

    @Override
    public void autoExportApproval(String startDate) {
        List<Approval> approvalList = approvalDAO.searchUpdateflagForExport(startDate);

        if (approvalList != null && approvalList.size() > 0) {
            try {
                for (Approval p : approvalList) {

                    p.setUpdateflag(false);
                    String approvalStr = JSONArray.toJSONString(p);
                    logger.info(approvalStr);
                    String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(approvalStr.getBytes(), Constants.APPROVAL_KEY));
                    writeTxtFile(content, "approval");

                    approvalDAO.updateFlag(p);


                }

            } catch (Exception e) {
                logger.info("导出失败！");
            }
        }
    }

    /**
     * 确认单、登记证使用
     *
     * @param approval
     */
    @Override
    public void createConfirmAndRegisterForm(Approval approval) {
        if (approval.getApprovalstate().equals(ApprovalState.SHTG)) {//审批通过
            //跨区、自行招用、自行招用撤销、分公司 生成确认单、登记证
            if (approval.getBusinesstype().equals(BusinessType.KQYBAGS)
                    || approval.getBusinesstype().equals(BusinessType.ZXZY)
                    || approval.getBusinesstype().equals(BusinessType.ZZBACX)
                    || approval.getBusinesstype().equals(BusinessType.BAGSZGS)) {
                try {
                    approvalDAO.update(setApproavlMeaasge(approval));
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if(approval.getBusinesstype().equals(BusinessType.BAPXDWBA)){
                createNotice(approval);
            }
        }
    }

    private void createNotice(Approval approval){
        try {
            Trainrecord trainrecord = trainrecordService.findById(approval.getBusinessid());
            ApprovalNoticeFormDto formDto = new ApprovalNoticeFormDto();
            formDto.setApplyDate(DateUtil.convertDateToString(approval.getCreateTime(),"yyyy年MM月dd日"));
            formDto.setApproveDate(DateUtil.convertDateToString(approval.getCreateTime(),"yyyy年MM月dd日"));
            formDto.setCompanyName(trainrecord.getCompanyname()+":");
            formDto.setRecordNo(approval.getRecordNo());
            formDto.setTitle(Constants.NOTICE_TITLE);
            formDto.setContent(String.format(Constants.NOTICE_CONTENT,formDto.getApplyDate()));
            formDto.setOrgName(Constants.NOTICE_ORG);
            String templatePath = ApprovalServiceImpl.class.getResource("/").toString();
            String noticeTemplatePath = templatePath + "pdfTemplate/noticeTemplate.pdf";
            Date now = new Date();

            String noticeUrl = "";

            String noticeFileName = now.getTime() + "_notice.pdf";

            String dirDate = DateUtil.systemDate.format(now);
            String filePath = "pdf/" + dirDate + "/";


            if (StringUtil.isNotEmpty(approval.getNoticePath())) {
                noticeUrl = approval.getNoticePath();
                noticeFileName = noticeUrl.substring(noticeUrl.lastIndexOf("/"), noticeUrl.length());
                filePath = noticeUrl.substring(noticeUrl.indexOf("pdf/"), noticeUrl.lastIndexOf("/"));
            } else {
                noticeUrl = "getResource.do?path=" + filePath + noticeFileName;
            }

            String pdfPath = baseFolder + filePath;

            File pdfFile = new File(pdfPath);
            if (!pdfFile.exists()) {
                pdfFile.mkdirs();
            }

            String noticePath = pdfPath + noticeFileName;

            PDFUtils.createPDFForTemplate(noticeTemplatePath, noticePath, formDto);
            approval.setNoticePath(noticeUrl);
        }catch (Exception e){

        }
    }

    /**
     * 批量确认单、登记证使用
     *
     * @param approval
     */
    private Approval batchCreateConfirmAndRegisterForm(Approval approval) {
        try {

            return setApproavlMeaasge(approval);

        } catch (Exception e) {
            logger.error(e.getMessage(), e);

        }
        return null;
    }

    private Approval setApproavlMeaasge(Approval approval) throws IOException, DocumentException {
        String serialNo = approval.getSerialNo();

        if (StringUtil.isEmpty(serialNo)) {
            serialNo = approvalDAO.getMaxSerialNo(approval);//获取流水号
            approval.setSerialNo(serialNo);
        }
        ApprovalFormDto formDto = findFormDataByApproval(approval);

        if(approval.getApprovaldate() != null){
            formDto.setYearDate(DateUtil.convertDateToString(approval.getApprovaldate(),DateUtil.FORMAT10));
            formDto.setApprovalDateName(DateUtil.convertDateToString(approval.getApprovaldate(),DateUtil.FORMAT14));
        }
        formDto.setSerialNo(String.format("%04d", Integer.parseInt(serialNo)));//四位流水号 不足自动补0
        //modify zjh time:2018年8月8日 17:27:11 修改标题名称 time:2018年8月13日 09:43:26 不修改确认单标题
        formDto.setConfirmTitle(Constants.CONFIRMTITLE.replace("{businessTypeName}", formDto.getBusinessTypeName()));
        formDto.setConfirmCompanyName(formDto.getCompanyName() + ":");
        formDto.setConfirmContent(Constants.CONFIRMCONTENT.replace("{businessTypeName}", formDto.getBusinessTypeName()).replace("{orgName}", formDto.getOrgName()));
        //modify zjh time:2018年8月13日 09:42:53 修改标题名称
        formDto.setRegisterTitle(Constants.REGISTERTITLE.replace("{titleName}", formDto.getTitleName()));

        formDto.setRegisterNo(Constants.REGISTERNO.replace("{firstCityWord}", formDto.getFirstCityWord()).replace("{yearDate}", formDto.getYearDate()).replace("{serialNo}", formDto.getSerialNo()));
        formDto.setRegisterCompanyName(Constants.REGISTERCOMPANYNAME.replace("{companyName}", formDto.getCompanyName()));
        formDto.setRegisterAddress(Constants.REGISTERADDRESS.replace("{address}", formDto.getAddress()));
        formDto.setRegisterBusinessTypeName(Constants.REGISTERBUSINESSTYPENAME.replace("{businessTypeName}", formDto.getBusinessTypeName()));

        formDto.setLegalPerson(Constants.LEGALPERSON.replace("{legalPerson}", formDto.getLegalPerson()));
        if(!approval.getBusinesstype().equals(BusinessType.BAGSZGS)) {
            formDto.setServiceName(Constants.SERVICENAME.replace("{serviceName}", formDto.getServiceName()));
        }

        // 如果是跨区备案, 添加备案有效期
        if(approval.getBusinesstype().equals(BusinessType.KQYBAGS)) {
            formDto.setValidityPeriodDate(Constants.VALIDITY_PERIOD_DATE.replace("{validityPeriodDate}",formDto.getValidityPeriodDate()));
        }
        String templatePath = ApprovalServiceImpl.class.getResource("/").toString();
        String confirmTemplatePath = templatePath + "pdfTemplate/confirmTemplate.pdf";
        String registerTemplatePath = templatePath + "pdfTemplate/registerTemplate.pdf";
        Date now = new Date();

        String confirmUrl = "";
        String registerUrl = "";

        String confirmFileName = now.getTime() + "_confirm.pdf";
        String registerFileName = now.getTime() + "_register.pdf";

        String dirDate = DateUtil.systemDate.format(now);
        String filePath = "pdf/" + dirDate + "/";


        if (StringUtil.isNotEmpty(approval.getConfirmPath())) {
            confirmUrl = approval.getConfirmPath();
            confirmFileName = confirmUrl.substring(confirmUrl.lastIndexOf("/"), confirmUrl.length());
            filePath = confirmUrl.substring(confirmUrl.indexOf("pdf/"), confirmUrl.lastIndexOf("/"));
        } else {
            confirmUrl = "getResource.do?path=" + filePath + confirmFileName;
        }
        if (StringUtil.isNotEmpty(approval.getRegisterPath())) {
            registerUrl = approval.getRegisterPath();
            registerFileName = registerUrl.substring(registerUrl.lastIndexOf("/"), registerUrl.length());
            filePath = registerUrl.substring(registerUrl.indexOf("pdf/"), registerUrl.lastIndexOf("/"));
        } else {
            registerUrl = "getResource.do?path=" + filePath + registerFileName;
        }

        String pdfPath = baseFolder + filePath;

        File pdfFile = new File(pdfPath);
        if (!pdfFile.exists()) {
            pdfFile.mkdirs();
        }

        String confirmPath = pdfPath + confirmFileName;
        String registerPath = pdfPath + registerFileName;

        PDFUtils.createPDFForTemplate(confirmTemplatePath, confirmPath, formDto);
        PDFUtils.createPDFForTemplate(registerTemplatePath, registerPath, formDto);
        approval.setConfirmPath(confirmUrl);
        approval.setRegisterPath(registerUrl);
        return approval;
    }

        public static void main(String[] args) {
        try {
            ApprovalFormDto formDto = new ApprovalFormDto();
            formDto.setTitleName("保安从业单位");
            formDto.setBusinessTypeName("保安服务公司跨区域提供保安服务");




                formDto.setYearDate("2019");
                formDto.setApprovalDateName("2019年07月17日");
            formDto.setSerialNo(String.format("%04d", Integer.parseInt("0020")));//四位流水号 不足自动补0
            //modify zjh time:2018年8月8日 17:27:11 修改标题名称 time:2018年8月13日 09:43:26 不修改确认单标题
            formDto.setConfirmTitle(Constants.CONFIRMTITLE.replace("{businessTypeName}", "保安服务公司跨区域提供保安服务"));
            formDto.setConfirmCompanyName( "陕西永青物业管理服务有限公司:");
            formDto.setConfirmContent(Constants.CONFIRMCONTENT.replace("{businessTypeName}", "保安服务公司跨区域提供保安服务").replace("{orgName}", "西安市公安局"));
            //modify zjh time:2018年8月13日 09:42:53 修改标题名称
            formDto.setRegisterTitle(Constants.REGISTERTITLE.replace("{titleName}", "保安从业单位"));

            formDto.setRegisterNo(Constants.REGISTERNO.replace("{firstCityWord}", "西").replace("{yearDate}", "2019").replace("{serialNo}", "0020"));
            formDto.setRegisterCompanyName(Constants.REGISTERCOMPANYNAME.replace("{companyName}", "陕西永青物业管理服务有限公司"));
            formDto.setRegisterAddress(Constants.REGISTERADDRESS.replace("{address}", "陕西省西安市未央区龙首北路西段57号天竹综合大厦A座1504室"));
            formDto.setRegisterBusinessTypeName(Constants.REGISTERBUSINESSTYPENAME.replace("{businessTypeName}", "保安服务公司跨区域提供保安服务"));

            formDto.setLegalPerson(Constants.LEGALPERSON.replace("{legalPerson}","李艺杭"));
            formDto.setServiceName(Constants.SERVICENAME.replace("{serviceName}", "中铁琉森水岸、中航万年路小区"));
            formDto.setValidityPeriodDate(Constants.VALIDITY_PERIOD_DATE.replace("{validityPeriodDate}","2020/12/21 - 2021/03/21"));


            String confirmTemplatePath = "C:/Users/zhangyutong/IdeaProjects/ars/ars-web/src/main/resources/pdfTemplate/confirmTemplate.pdf";
            Date now = new Date();
            String registerTemplatePath = "C:/Users/zhangyutong/IdeaProjects/ars/ars-web/src/main/resources/pdfTemplate/registerTemplate.pdf";
            String confirmPath = "C:\\Users\\zhangyutong\\upload\\confirm_"+ now.getTime()+".pdf";
            String registerPath = "C:\\Users\\zhangyutong\\upload\\register_"+ now.getTime()+".pdf";
            PDFUtils.createPDFForTemplate(confirmTemplatePath, confirmPath, formDto);
            PDFUtils.createPDFForTemplate(registerTemplatePath, registerPath, formDto);

        }catch (Exception e){
            e.printStackTrace();
        }

    }

    @Override
    public List<Approval> searchUpdateflagForExport() {
        return approvalDAO.searchUpdateflagForExport(DateUtil.getYesterday());
    }

    @Override
    public ApprovalFormDto findFormDataByApprovalId(Long approvalId) {
        Approval approval = approvalDAO.getById(approvalId);
        return findFormDataByApproval(approval);
    }

    private ApprovalFormDto findFormDataByApproval(Approval approval) {
        ApprovalFormDto formDto = approvalDAO.findFormDataByApproval(approval);
        //modify zjh time：2018年8月8日 11:31:04  按照需求改显示的内容

        if (formDto.getBusinesstype().equals(BusinessType.BAGSZGS)) {
            formDto.setTitleName("保安服务公司分公司");
            formDto.setBusinessTypeName("保安服务公司分公司");
        } else if (formDto.getBusinesstype().equals(BusinessType.KQYBAGS)) {
            formDto.setTitleName("保安从业单位");
            formDto.setBusinessTypeName("保安服务公司跨区域提供保安服务");
        } else if (formDto.getBusinesstype().equals(BusinessType.ZXZY)) {
            formDto.setTitleName("保安从业单位");
            formDto.setBusinessTypeName("自行招用保安员单位提供保安服务");
        } else if (formDto.getBusinesstype().equals(BusinessType.ZZBACX)) {
            formDto.setBusinessTypeName("自行招用保安员单位撤销");
            formDto.setTitleName("自行招用保安员单位撤销");
        }
        formDto.setBusinesstype(approval.getBusinesstype());

        if(BusinessType.BAGSZGS.equals(approval.getBusinesstype())){
            //保安服务公司分公司备案登记字段显示调整
            //分公司备案登记证单位名称应显示分公司的名称。
            //2020-08-27
            Subsidiary subsidiary = subsidiaryService.findById(approval.getBusinessid());
            formDto.setCompanyName(subsidiary.getSoncompanyname());
            formDto.setLegalPerson(subsidiary.getChargename());
            formDto.setAddress(subsidiary.getSonaddrss());
        }

        return formDto;
    }

    /**
     * @Author: wangcy
     * @Description:查询待审批的条数
     * @Date: 2018/03/07 0007 17:21
     */
    @Override
    public void findApprovalNumble(ApprovalDTO dto) {

    }

    /**
     * 发送短信
     *
     * @param approval
     */
    @Override
    public void sendMsg(Approval approval) {
        if (approval == null) {
            return;
        }
        String businessType = approval.getBusinesstype();
        Long bussinessId = approval.getBusinessid();

        if (StringUtil.isEmpty(businessType) || bussinessId == null) {
            //数据有误
            return;
        }
        //申请人信息
        Map<String, Object> applyUserMap = null;
        String businessTypeName = "";
        //审批通过
        if (approval.getApprovalstate().equals(ApprovalState.SHTG)) {
            switch (businessType) {
                case BusinessType.KQYBAGS:
                    //跨区域经营保安公司,由于同步问题需要二次验证时候已经审批通过
                    Crosscompany crosscompany = crosscompanyService.findById(bussinessId);
                    if (crosscompany != null && ApprovalState.SHTG.equals(crosscompany.getApprovalstate())) {
                        applyUserMap = crosscompanyService.selectApplyUserInfoWithId(bussinessId);
                        businessTypeName = "跨区域经营保安服务备案";
                    }
                    break;
                case BusinessType.ZXZY:
                    //自行招用保安员单位
                    Confesscompany confesscompany = confesscompanyService.findById(bussinessId);
                    if (confesscompany != null && ApprovalState.SHTG.equals(confesscompany.getApprovalstate())) {
                        applyUserMap = confesscompanyService.selectApplyUserInfoWithId(bussinessId);
                        businessTypeName = "自行招用保安员单位备案";
                    }
                    break;
                case BusinessType.ZZBACX:
                    //自行招用保安员单位撤销备案
                    Confesscompanyundo confesscompanyundo = confesscompanyundoService.findById(bussinessId);
                    if (confesscompanyundo != null && ApprovalState.SHTG.equals(confesscompanyundo.getApprovalstate())) {
                        applyUserMap = confesscompanyundoService.selectApplyUserInfoWithId(bussinessId);
                        businessTypeName = "自行招用保安员单位撤销备案";
                    }
                    break;
                case BusinessType.BAYZ:
                    //保安员证审批通过通知
                    Config webConfig = configUtils.getConfigByKey(Constants.WEBHOST);
                    if (webConfig != null) {
                        Personcertificate dbPersoncertificate = personcertificateService.findById(approval.getBusinessid());
                        String title = Constants.APPROVAL_PASS_TITLE;
                        String content = Constants.APPROVAL_PERSONCERTIFICATE_PASS_NEW_CONTENT.replace("{webHost}", webConfig.getValue());

                        /****************华为短信*****************/
                        personcertificateService.sendMsgHuaWei(dbPersoncertificate, null, title, content, MSGConstants.SMSCODE_B10,new String[]{ webConfig.getValue()});
                        /****************华为短信*****************/
                    }
                    break;
                default:
                    break;
            }
            if (applyUserMap != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String phone = applyUserMap.containsKey("phone") ? applyUserMap.get("phone").toString() : "";
                String applyDate = applyUserMap.containsKey("applyDate") ? applyUserMap.get("applyDate").toString() : df.format(new Date());
                String content = String.format(Constants.SEND_MSG_TEMPLATE, applyDate, businessTypeName);
                /****************华为短信*****************/
                MessageUtil.sendMessageHuaWei(phone,content, messageLogDao,new String[]{applyDate,businessTypeName}, MSGConstants.SMSCODE_B11);
                /****************华为短信*****************/
            }
        } else {
            return;
        }
    }

    @Override
    public PageResult searchApprovalAndSBList_table(Map<Object, Object> p) {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            //TODO 审批机构ID
            if (user.getPlatform() == 4 || user.getPlatform() == 2) {
                p.put("userid", user.getId());
            } else {
                //角色列表
                List<PoliceRole> roles = user.getRoles();
                if (roles != null && roles.size() > 0) {
                    p.put("roles", roles);
                }
                //判断是否为民警
                if (user.getPoliceman() != null && user.getPoliceman()) {
                    p.put("policeid", user.getId());
                }
                //机构信息
                Police police = policeDao.findById(user.getOrgid());
                //判断是否为派出所
                if (police.getOrgtype() != null && police.getOrgtype().equals("4")) {
                    p.put("orgid", police.getId());
                }
                //根据页面传回的地址进行地址修改
                Object areacodeObject = p.get("areaCode");
                //区域过滤
                if (areacodeObject != null) {
                    String areacode = p.get("areaCode").toString();
                    if (areacode.endsWith("0000")) {//省
                        p.put("areaCode", areacode.substring(0, 2) + "____");
                    } else if (areacode.endsWith("00")) {//市
                        p.put("areaCode", areacode.substring(0, 4) + "__");
                    } else {//区
                        p.put("areaCode", areacode);
                    }
                }
                p.put("platform", user.getPlatform());
                //业务类型权限
                if (user.getUserBusinessTypeList() != null && user.getUserBusinessTypeList().size() > 0) {
                    p.put("userBusinessTypeList", user.getUserBusinessTypeList());
                }

            }
        }

        return new PageResult(approvalDAO.countApprovalAndSBList(p), approvalDAO.searchApprovalAndSBList(p));
    }

    @Override
    public Approval findBybusinessidAndType(Long businessid, String businesstype) {
        return approvalDAO.findBybusinessidAndType(businessid, businesstype);
    }


    @Override
    public void saveApprovalOutreason(ApprovalDTO dto) {

        //获取审批信息
        Approval approval = approvalDAO.getById(dto.getId());
        /**
         * 对外意见
         */
        if (StringUtil.isNotEmpty(dto.getOutreason())) {
            approval.setOutreason(dto.getOutreason());
        }

        //对外附件
        if (StringUtil.isNotEmpty(dto.getOutinfoRar())) {
            approval.setOutinfoRar(dto.getOutinfoRar());
        }


        //保存对外意见审批日志
        User currentUser = arsUtil.getCurrentUser();
        String approvalPerson = approval.getApprovalperson();
        ApprovalLog approvalLog = new ApprovalLog();
        if (currentUser == null) {
            approvalLog.setUpdateBy("system");
            approvalLog.setApprovalorg("系统自动");
        } else {
            approvalLog.setUpdateBy(currentUser.getUsername());
            if(currentUser.getPolice() == null){
                approvalLog.setApprovalorg(currentUser.getRealname());
            }else{
                approvalLog.setApprovalorg(currentUser.getPolice().getOrgname());
            }
            //打回特殊处理
            approvalPerson = currentUser.getUsername();
        }
        approvalLog.setActive(true);
        approvalLog.setType(Constants.APPROVAL_LOG_OUT);
        approvalLog.setCreateTime(new Date());
        approvalLog.setUpdateTime(new Date());
        approvalLog.setApprovaldate(new Date());

        approvalLog.setApprovalperson(approvalPerson);
        //年报的特殊处理，取Replyreason
		/*if(BusinessType.NDBG.equals(approval.getBusinesstype())){
			approvalLog.setApprovalreason(approval.getReplyreason());
		}else{
			approvalLog.setApprovalreason(approval.getOutreason());
		}*/
        approvalLog.setApprovalreason(approval.getOutreason());
        String approvalState = ApprovalState.convertCode(approval.getApprovalstate());
        //打回特殊处理
        if (dto.getApprovalstate() != null) {
            approvalState = ApprovalState.convertCode(dto.getApprovalstate());
        }

        approvalLog.setApprovalstate(approvalState);
        approvalLog.setProcessInstanceId(approval.getProcessInstanceId());
        approvalLog.setApprovalid(approval.getId().toString());
        approvalLogDao.save(approvalLog);

        //更新对外意见
        approvalDAO.update(approval);


    }

    @Override
    public void manualCreateConfirmAndRegisterForm(Approval approval) {

    }

    @Override
    public void deleteByBusinessId(Long businessid, String businesstype) {
        approvalDAO.deleteByBusinessId(businessid, businesstype);
    }

    @Override
    public List<Approval> findDSOutList(List<String> filePaths,String startDate) {
        List<Approval> list = approvalDAO.searchUpdateflagForExport(startDate);
        for (Object object : list) {
            Approval approval = (Approval) object;
            if (StringUtil.isNotEmpty(approval.getInfoRar())) {
                filePaths.add(configUtils.baseFolder + approval.getInfoRar().replace("getResource.do?path=", ""));
            }
            if (StringUtil.isNotEmpty(approval.getReplyRar())) {
                filePaths.add(configUtils.baseFolder + approval.getReplyRar().replace("getResource.do?path=", ""));
            }
            if (StringUtil.isNotEmpty(approval.getOutinfoRar())) {
                filePaths.add(configUtils.baseFolder + approval.getOutinfoRar().replace("getResource.do?path=", ""));
            }
            if (StringUtil.isNotEmpty(approval.getConfirmPath())) {
                filePaths.add(configUtils.baseFolder + approval.getConfirmPath().replace("getResource.do?path=", ""));
            }
            if (StringUtil.isNotEmpty(approval.getRegisterPath())) {
                filePaths.add(configUtils.baseFolder + approval.getRegisterPath().replace("getResource.do?path=", ""));
            }
            if (StringUtil.isNotEmpty(approval.getNoticePath())) {
                filePaths.add(configUtils.baseFolder + approval.getNoticePath().replace("getResource.do?path=", ""));
            }


            //申请备案通过后，相关信息，同步显示在分公司管理。--向公安申请备案通过之后，由公安导出到外网时，审批通过的，并把信息同步生成到分公司管理
            if (BusinessType.BAGSZGS.equals(approval.getBusinessid()) && ApprovalState.SHTG.equals(approval.getApprovalstate())) {
                Subsidiary subsidiary = subsidiaryService.findById(approval.getBusinessid());
                SbSubsidiaryBase sbSubsidiaryBase = new SbSubsidiaryBase();
                sbSubsidiaryBase.setCompanyName(subsidiary.getCompanyname());
                sbSubsidiaryBase.setRegisterAddress(subsidiary.getAddress());
                sbSubsidiaryBase.setMoneyPrincipal(subsidiary.getChargename());
                sbSubsidiaryBase.setMoneyPrincipalId(subsidiary.getChargecardnumber());
                sbSubsidiaryBase.setMoneyPrincipalPhone(subsidiary.getChargephone());

                subsidiaryService.saveOrUpdate(subsidiary);
            }
        }
        return list;
    }

    @Override
    public void update(Approval approval) {
        approval.setUpdateTime(new Date());
        approval.setUpdateflag(true);
        approvalDAO.update(approval);
    }

    /**
     * 登记备案号
     * @param approval
     * @return
     */
    @Override
    public AjaxResult editRecordNo(Approval approval) {
        Approval dbAppoval = approvalDAO.findByRecordNo(approval.getRecordNo());
        if(dbAppoval != null){
            if(dbAppoval.getId().equals(approval.getId())){
                return AjaxResult.error("备案号没有变化！");
            }
            return AjaxResult.error("备案号已存在！");
        }
        dbAppoval = approvalDAO.getById(approval.getId());
        dbAppoval.setRecordNo(approval.getRecordNo());
        this.createNotice(dbAppoval);
        this.update(dbAppoval);

        User currentUser = arsUtil.getCurrentUser();
        ApprovalLog approvalLog = new ApprovalLog();
        approvalLog.setUpdateBy(currentUser.getUsername());
        if(currentUser.getPolice() != null) {
            approvalLog.setApprovalorg(currentUser.getPolice().getOrgname());
        }else{
            approvalLog.setApprovalorg("系统自动");
        }
        approvalLog.setActive(false);
        approvalLog.setType(Constants.APPROVAL_LOG_IN);
        approvalLog.setCreateTime(new Date());
        approvalLog.setUpdateTime(new Date());
        approvalLog.setApprovaldate(new Date());
        approvalLog.setApprovalperson(currentUser.getRealname());
        approvalLog.setApprovalstate("登记备案号："+approval.getRecordNo());
        approvalLog.setApprovalid(approval.getId().toString());
        approvalLogDao.save(approvalLog);

        return AjaxResult.success();
    }
}
