package com.bcxin.ars.service.supervision;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.supervision.PersonComplaintDao;
import com.bcxin.ars.dao.supervision.PersonComplaintDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.supervision.PersonComplaintPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.supervision.PersonAward;
import com.bcxin.ars.model.supervision.PersonComplaint;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2019/07/23 0023 11:10
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = PersonComplaint.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
@DataSyncOutAnnotation(getClazz = PersonComplaint.class,getImportType = ImportType.BATCH)
public class PersonComplaintServiceImpl extends BaseService implements PersonComplaintService {

    @Autowired
    private PersonComplaintDao personComplaintDao;
    @Autowired
    private PersonComplaintDaoAop personComplaintDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ConfigUtils configUtils;

    @Override
    public int delete(PersonComplaint record) {
        User currentUser = arsUtil.getCurrentUser();
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser.getUsername());
        return personComplaintDaoAop.delete(record);
    }

    @Override
    public void save(PersonComplaint record) {
        User currentUser = arsUtil.getCurrentUser();
        if(record.getId() == null){
            record.setId(idWorker.nextId());
            record.setCreateTime(new Date());
            if(StringUtil.isNotEmpty(record.getSignImgPath())){
                record.setSignImgPath(saveBase64Img(record.getSignImgPath()));
            }
        }else{
            PersonComplaint dbRecord = personComplaintDao.findById(record.getId());
            BeanUtils.copyPropertiesIgnore(record,dbRecord,true);
            BeanUtils.copyPropertiesIgnore(dbRecord,record,false);
        }

        record.setActive(true);
        record.setUpdateBy(currentUser.getUsername());
        record.setUpdateTime(new Date());
        record.setUpdateflag(true);
        record.setAreaCode(currentUser.getPolice().getAreacode());
        personComplaintDaoAop.save(record);
    }

    @Override
    public PersonComplaint findById(Long id) {
        return personComplaintDao.findById(id);
    }

    @Override
    public void searchForPage(SearchDto dto, AjaxPageResponse page) {
        dto.setPoliceBusiness(false);
        arsUtil.setPoliceSearch(dto);
        PersonComplaintPageSearchDto searchDto = (PersonComplaintPageSearchDto) dto;
        if(StringUtil.isNotEmpty(searchDto.getOrgAreaCode())) {
            if (searchDto.getOrgAreaCode().endsWith("0000")) {// 省
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 2) + "____");
            } else if (searchDto.getOrgAreaCode().endsWith("00")) {// 市
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 4) + "__");
            } else {// 区
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode());
            }
        }
        personComplaintDao.searchForPage(searchDto, page);
    }

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    public List<PersonComplaint> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return personComplaintDao.searchForDataSynchronization(searchDto);
    }
    /**
     *外网数据同步到内网
     * @param list
     */
    public void  saveOrUpdateForDS(List<PersonComplaint> list) {
        List<PersonComplaint> dbList =new ArrayList<PersonComplaint>();
        //将每一条数据导入内网
        //根据id在内网中查询是否存在，若存在，满足条件外网时间大于内网时间则更新,不满足则不更新
        //若不存在直接将数据新增到表中
        for (PersonComplaint personComplaint : list) {
            PersonComplaint personComplaintIn = personComplaintDao.findById(personComplaint.getId());
            if (personComplaintIn == null) {
                personComplaint.setUpdateflag(false);
            } else {
                if (personComplaint.getUpdateTime().getTime() < personComplaintIn.getUpdateTime().getTime()) {
                    dbList.add(personComplaint);
                }
                personComplaint.setUpdateflag(true);
            }
        }
        list.removeAll(dbList);
        personComplaintDaoAop.saveBatch(list);
    }
    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    public List<PersonComplaint> findDSOutList(String startDate) {
        return personComplaintDao.findDSOutList(startDate);
    }

    /**
     * 内网数据同步到外网
     * @param list
     */
    public void importBatch(List<PersonComplaint> list) {
        List<PersonAward> dbList = personComplaintDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (PersonComplaint personComplaint : list) {
                personComplaint.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        personComplaint.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, personComplaint.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            personComplaintDaoAop.saveBatch(list);
        }
    }
}
