package com.bcxin.ars.service.supervision;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.supervision.CompanyComplaintDao;
import com.bcxin.ars.dao.supervision.CompanyComplaintDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.supervision.CompanyComplaintPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.supervision.CompanyComplaint;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2019/07/23 0023 11:04
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = CompanyComplaint.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
@DataSyncOutAnnotation(getClazz = CompanyComplaint.class,getImportType = ImportType.BATCH)
public class CompanyComplaintServiceImpl extends BaseService implements CompanyComplaintService {

    @Autowired
    private CompanyComplaintDao companyComplaintDao;
    @Autowired
    private CompanyComplaintDaoAop companyComplaintDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ConfigUtils configUtils;
    @Override
    public int delete(CompanyComplaint record) {
        User currentUser = arsUtil.getCurrentUser();
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser.getUsername());
        return companyComplaintDaoAop.delete(record);
    }

    @Override
    public void save(CompanyComplaint record) {
        User currentUser = arsUtil.getCurrentUser();
        if(record.getId() == null){
            record.setId(idWorker.nextId());
            record.setCreateTime(new Date());

            if(StringUtil.isNotEmpty(record.getSignImgPath())){
                record.setSignImgPath(saveBase64Img(record.getSignImgPath()));
            }
        }else{
            CompanyComplaint dbRecord = companyComplaintDao.findById(record.getId());
            BeanUtils.copyPropertiesIgnore(record,dbRecord,true);
            BeanUtils.copyPropertiesIgnore(dbRecord,record,false);
        }
        //自招单位公司是未驻入系统的，把输入的公司名称保存
        String isInSystem = record.getIsInSystem();
        if((!StringUtils.isEmpty(isInSystem))&&(isInSystem.equals(Constants.NOT_IN_SYS))){
            String companyNameDefine = record.getCompanyNameDefine();
            record.setComplaintCompanyName(companyNameDefine);
            record.setCompanyId(null);
        }
        record.setActive(true);
        record.setUpdateBy(currentUser.getUsername());
        record.setUpdateTime(new Date());
        record.setUpdateflag(true);
        record.setAreaCode(currentUser.getPolice().getAreacode());
        companyComplaintDaoAop.save(record);
    }

    @Override
    public CompanyComplaint findById(Long id) {
        return companyComplaintDao.findById(id);
    }

    @Override
    public void searchForPage(SearchDto dto, AjaxPageResponse page) {
        dto.setPoliceBusiness(false);
        arsUtil.setPoliceSearch(dto);
        CompanyComplaintPageSearchDto searchDto = (CompanyComplaintPageSearchDto)dto;
        if(StringUtil.isNotEmpty(searchDto.getOrgAreaCode())) {
            if (searchDto.getOrgAreaCode().endsWith("0000")) {// 省
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 2) + "____");
            } else if (searchDto.getOrgAreaCode().endsWith("00")) {// 市
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 4) + "__");
            } else {// 区
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode());
            }
        }
        companyComplaintDao.searchForPage((CompanyComplaintPageSearchDto)dto,page);
    }

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    public List<CompanyComplaint> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return companyComplaintDao.searchForDataSynchronization(searchDto);
    }

    /**
     *外网数据同步到内网
     * @param list
     */
    public void  saveOrUpdateForDS(List<CompanyComplaint> list) {
        List<CompanyComplaint> dbList =new ArrayList<CompanyComplaint>();
        //将每一条数据导入内网
        //根据id在内网中查询是否存在，若存在，满足条件外网时间大于内网时间则更新,不满足则不更新
        //若不存在直接将数据新增到表中
        for (CompanyComplaint companyComplaint : list) {
            CompanyComplaint companyComplaintIn = companyComplaintDao.findById(companyComplaint.getId());
            if (companyComplaintIn == null) {
                companyComplaint.setUpdateflag(false);
            } else {
                if (companyComplaint.getUpdateTime().getTime() < companyComplaintIn.getUpdateTime().getTime()) {
                    dbList.add(companyComplaint);
                }
                companyComplaint.setUpdateflag(true);
            }
        }
        list.removeAll(dbList);
        companyComplaintDaoAop.saveBatch(list);
    }
    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    public List<CompanyComplaint> findDSOutList(String startDate) {
        return companyComplaintDao.findDSOutList(startDate);
    }

    /**
     * 内网数据同步到外网
     * @param list
     */
    public void importBatch(List<CompanyComplaint> list) {
        List<CompanyComplaint> dbList = companyComplaintDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (CompanyComplaint companyComplaint : list) {
                companyComplaint.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        companyComplaint.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, companyComplaint.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            companyComplaintDaoAop.saveBatch(list);
        }
    }

}
