package com.bcxin.ars.service.subsidy.impl;

import com.bcxin.ars.dao.subsidy.TrainSubsidyConfigDao;
import com.bcxin.ars.dao.subsidy.TrainSubsidyConfigDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.TrainSubsidyConfigPageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.subsidy.TrainSubsidyConfig;
import com.bcxin.ars.service.subsidy.TrainSubsidyConfigService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
/**
 * 培训单位补贴简称批次配置Service实现类
 *
 * @author linqinglin
 * @Date 2020-05-27 10:30:45
 */
@Service
@Transactional
public class TrainSubsidyConfigServiceImpl implements TrainSubsidyConfigService {

    Logger logger = LoggerFactory.getLogger(TrainSubsidyConfigServiceImpl.class);

    @Autowired
    private TrainSubsidyConfigDao trainSubsidyConfigDao;

    @Autowired
    private TrainSubsidyConfigDaoAop trainSubsidyConfigDaoAop;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private IdWorker idWorker;

    @Override
    public int delete(TrainSubsidyConfig trainSubsidyConfig) {
        User currentUser = arsUtil.getCurrentUser();
        trainSubsidyConfig.setUpdateTime(new Date());
        trainSubsidyConfig.setUpdateBy(currentUser.getUsername());
        return trainSubsidyConfigDaoAop.delete(trainSubsidyConfig);
    }

    @Override
    public void save(TrainSubsidyConfig trainSubsidyConfig) {
        User currentUser = arsUtil.getCurrentUser();
        if(trainSubsidyConfig.getId() == null){
            trainSubsidyConfig.setCreateTime(new Date());
            trainSubsidyConfig.setId(idWorker.nextId());
            trainSubsidyConfig.setBatchNo(0L);
            TrainSubsidyConfig dbTrainSubsidyConfig = trainSubsidyConfigDao.findByTrainIdAndSubsidyCerType(trainSubsidyConfig.getTrainId(),trainSubsidyConfig.getSubsidyCerType());

            if(dbTrainSubsidyConfig != null){
                throw new ArsException("该培训机构已配置，请使用修改功能");
            }

        }else{
            TrainSubsidyConfig dbTrainSubsidyConfig = trainSubsidyConfigDao.findById(trainSubsidyConfig.getId());
            BeanUtils.copyPropertiesIgnore(trainSubsidyConfig,dbTrainSubsidyConfig,true);
            BeanUtils.copyPropertiesIgnore(dbTrainSubsidyConfig,trainSubsidyConfig,false);
        }

        trainSubsidyConfig.setActive(true);
        trainSubsidyConfig.setUpdateBy(currentUser.getUsername());
        trainSubsidyConfig.setUpdateTime(new Date());
        trainSubsidyConfig.setUpdateflag(true);
        trainSubsidyConfig.setUserid(currentUser.getId());
        trainSubsidyConfig.setAreaCode(currentUser.getPolice().getAreacode());
        trainSubsidyConfigDaoAop.save(trainSubsidyConfig);
    }

    @Override
    public TrainSubsidyConfig findById(Long id) {
        return trainSubsidyConfigDao.findById(id);
    }

    @Override
    public void searchForPage(TrainSubsidyConfigPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
       trainSubsidyConfigDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<TrainSubsidyConfig> list) {
        List<TrainSubsidyConfig> dbList = trainSubsidyConfigDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (TrainSubsidyConfig trainSubsidyConfig : list) {
                trainSubsidyConfig.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                       trainSubsidyConfig.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, trainSubsidyConfig.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            trainSubsidyConfigDaoAop.saveBatch(list);
        }
    }

    @Override
    public List<TrainSubsidyConfig> findByBatchId(List<TrainSubsidyConfig> list) {
        return trainSubsidyConfigDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(TrainSubsidyConfig trainSubsidyConfig) {
        User currentUser = arsUtil.getCurrentUser();
        trainSubsidyConfig.setUpdateTime(new Date());
        trainSubsidyConfig.setUpdateBy(currentUser.getUsername());
        trainSubsidyConfigDaoAop.updateSelective(trainSubsidyConfig);
    }
}
