package com.bcxin.ars.service.statistics;

import cn.hutool.core.collection.CollUtil;
import com.bcxin.ars.dao.statistics.ApprovalStatisticsDao;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.statistics.PageResultDTO;
import com.bcxin.ars.dto.statistics.ParamDTO;
import com.bcxin.ars.service.util.SysAreaUtil;
import com.bcxin.ars.util.StringUtil;
import com.beust.jcommander.internal.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 审批情况分析
 * </p>
 *
 * @author 罗鹏
 * @date 2018/4/16
 */
@Service
public class ApprovalStatisticsServiceImpl implements ApprovalStatisticsService {
	
	@Autowired
	private ApprovalStatisticsDao approvalStatisticsDao;

	@Autowired
	private SysAreaUtil sysAreaUtil;

	@Override
	public Map approvalSummary(ParamDTO paramDTO){
		if (StringUtil.isEmpty(paramDTO.getArea())) {
			return Maps.newHashMap();
		}
		paramDTO.setAreaCode(subAreaCode(paramDTO.getArea()));
		return approvalStatisticsDao.getApprovalTrend(paramDTO);
	}

	@Override
	public List<Map> approvalAgingAnalyse(ParamDTO paramDTO){
		paramAreaCode(paramDTO);
		return approvalStatisticsDao.getApprovalAgingAnalyse(paramDTO);
	}

	@Override
	public List<Map> approvalStatusAnalyse(ParamDTO paramDTO){
		paramAreaCode(paramDTO);
		return approvalStatisticsDao.getApprovalStatusAnalyse(paramDTO);
	}


	//保安员资格考试
	@Override
	public Map securityExamSummary(ParamDTO paramDTO){
		if (StringUtil.isEmpty(paramDTO.getArea())) {
			return Maps.newHashMap();
		}
		TreeView treeView = sysAreaUtil.getRegionByCode(paramDTO.getArea());
		/* 市 */
		if ("2".equals(treeView.getLevel())) {
			paramDTO.setCity(paramDTO.getArea());
		}
		/* 区 */
		else if ("2".equals(treeView.getLevel())) {
			paramDTO.setDistrict(paramDTO.getArea());
		}

		return approvalStatisticsDao.getSecurityTrend(paramDTO);
	}

	@Override
	public PageResultDTO getSecurityDetail(ParamDTO paramDTO){
		PageResultDTO resultDTO = new PageResultDTO();
		paramAreaCode(paramDTO);
		List<Map> list = approvalStatisticsDao.getSecurityDetail(paramDTO);
		resultDTO.setAllData(list);
		List<List<Map>> pageList = CollUtil.split(list, paramDTO.getNumPerPage());
		resultDTO.setPageData(pageList.get(paramDTO.getPageNum()));
		resultDTO.setTotalCount(list.size());
		return resultDTO;
	}

	/**
	 * 处理参数中的areaCode
	 * @return
	 */
	private void paramAreaCode(ParamDTO paramDTO){
		if (StringUtil.isNotEmpty(paramDTO.getArea())){
			paramDTO.setAreaCode(paramDTO.getArea());
			return;
		}
		if (StringUtil.isNotEmpty(paramDTO.getCity())) {
			paramDTO.setAreaCode(paramDTO.getCity().substring(0,4));
			return;
		}
		if (StringUtil.isNotEmpty(paramDTO.getProvince())) {
			paramDTO.setAreaCode(paramDTO.getProvince().substring(0,2));
			return;
		}

	}


	/**
	 * 截取areaCode
	 * @param areaCode
	 * @return
	 */
	private String subAreaCode(String areaCode){
		TreeView treeView = sysAreaUtil.getRegionByCode(areaCode);
		/* 省 */
		if ("1".equals(treeView.getLevel())) {
			return areaCode.substring(0,2);
		}
		/* 市 */
		else if ("2".equals(treeView.getLevel())) {
			return areaCode.substring(0,4);
		}
		return areaCode;
	}

	public static void main(String[] args) {
		String areaCode = "450000";
		System.out.println(areaCode.substring(0,2));
		System.out.println(areaCode.substring(0,4));
		System.out.println(areaCode.substring(0,6));
	}
}
