package com.bcxin.ars.service.sb.impl;

import java.util.Date;
import java.util.List;

import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.sb.YearreportDao;
import com.bcxin.ars.dto.sb.YearreportSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Yearreport;
import com.bcxin.ars.service.sb.YearreportService;
import com.bcxin.ars.service.util.ArsUtil;

@Service
@Transactional
public class YearreportServiceImpl implements YearreportService {

    @Autowired
    private YearreportDao yearreportDao;

	@Autowired
	private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
	@Autowired
	private SecurityPersonDao securityPersonDao;

    @Autowired
    private ApprovalUtil approvalUtil;

    @Override
    public Yearreport findById(long id) {
        Yearreport result = yearreportDao.findById(id);
        if (result != null) {
            //查询审批日志信息
            ApprovalDTO dto = new ApprovalDTO();
            dto.setBusinessid(id);
            dto.setBusinesstype(BusinessType.NDBG);
            //TODO
            List list = approvalDAO.getBusinessidAndType(dto);
            result.setApprovallist(list);
        }
        return result;
    }

    @Override
    public void saveOrUpdate(Yearreport yearreport) {
		User currentUser = arsUtil.getCurrentUser();
		if(yearreport.getId() == null){
			yearreport.setActive(true);
			yearreport.setCreateTime(new Date());
			yearreport.setUpdateTime(new Date());
			yearreport.setUpdateBy(currentUser.getUsername());
			//TODO
			yearreport.setUserid(currentUser.getId());
			//待审批或暂存
			yearreportDao.save(yearreport);
			//TODO 保存审批信息
			if(yearreport.getApprovalstate().equals(ApprovalState.DSH)) {
				approvalUtil.saveApproval(BusinessType.NDBG,yearreport.getId(), Constants.ACTIVITI_PROCESS_YEARREPORT);
			}
		}else{
			Yearreport dbYearreport = yearreportDao.findById(yearreport.getId());
			dbYearreport.setUpdateTime(new Date());
			dbYearreport.setUpdateBy(currentUser.getUsername());
			dbYearreport.setAddress(yearreport.getAddress());
			dbYearreport.setApprovaldate(yearreport.getApprovaldate());
			dbYearreport.setApprovalperson(yearreport.getApprovalperson());
			dbYearreport.setApprovalreason(yearreport.getApprovalreason());
			dbYearreport.setCompanyname(yearreport.getCompanyname());
			dbYearreport.setTemplateRar(yearreport.getTemplateRar());

			dbYearreport.setCfnum(yearreport.getCfnum());
			dbYearreport.setCharge(yearreport.getCharge());
			dbYearreport.setCjnum(yearreport.getCjnum());
			dbYearreport.setCzgz(yearreport.getCzgz());
			dbYearreport.setDxnum(yearreport.getDxnum());
			dbYearreport.setFzcompany(yearreport.getFzcompany());
			dbYearreport.setFzqk(yearreport.getFzqk());
			dbYearreport.setGjmanagernum(yearreport.getGjmanagernum());
			dbYearreport.setGjnum(yearreport.getGjnum());
			dbYearreport.setGqnum(yearreport.getGqnum());
			dbYearreport.setGsnum(yearreport.getGsnum());
			dbYearreport.setHdnum(yearreport.getHdnum());
			dbYearreport.setJjss(yearreport.getJjss());
			dbYearreport.setJyqynum(yearreport.getJyqynum());
			dbYearreport.setManagernum(yearreport.getManagernum());
			dbYearreport.setPaxs(yearreport.getPaxs());
			dbYearreport.setPersonnum(yearreport.getPersonnum());
			dbYearreport.setQgbznum(yearreport.getQgbznum());
			dbYearreport.setQsbznum(yearreport.getQsbznum());
			dbYearreport.setQznum(yearreport.getQznum());
			dbYearreport.setRecordnumber(yearreport.getRecordnumber());
			dbYearreport.setServicearea(yearreport.getServicearea());
			dbYearreport.setSjbznum(yearreport.getSjbznum());
			dbYearreport.setTel(yearreport.getTel());
			dbYearreport.setXjnum(yearreport.getXjnum());
			dbYearreport.setXsnum(yearreport.getXsnum());
			dbYearreport.setXynum(yearreport.getXynum());
			dbYearreport.setZhsg(yearreport.getZhsg());
			dbYearreport.setZjnum(yearreport.getZjnum());
			dbYearreport.setZznum(yearreport.getZznum());
			dbYearreport.setSzss(yearreport.getSzss());
			dbYearreport.setProvince(yearreport.getProvince());
			dbYearreport.setCity(yearreport.getCity());
			dbYearreport.setDistrict(yearreport.getDistrict());

			//TODO
			//dbYearreport.setUserid(currentUser.getId().intValue());
			//待审批
			if(yearreport.getApprovalstate()!=null &&!"".equals(yearreport.getApprovalstate()) && !yearreport.getApprovalstate().equals(ApprovalState.DSH)){
				dbYearreport.setApprovalstate(yearreport.getApprovalstate());
			}else {
				dbYearreport.setApprovalstate(ApprovalState.DSH);
				//TODO 保存审批信息
				approvalUtil.saveApproval(BusinessType.NDBG,yearreport.getId(),Constants.ACTIVITI_PROCESS_YEARREPORT);
			}
			yearreportDao.update(dbYearreport);
		}

    }

    @Override
    public void saveOrUpdateForDS(Yearreport yearreport) {
    	
    	if(yearreport.getActive() == null){
    		yearreport.setActive(true);
    	}
    	
        Yearreport dbYearreport = yearreportDao.findById(yearreport.getId());
        if (dbYearreport != null) {
        	if(yearreport.getUpdateTime().getTime() > dbYearreport.getUpdateTime().getTime()){
				yearreportDao.updateForDS(yearreport);
			}
        } else {
            yearreportDao.saveForDS(yearreport);
        }
    }

    @Override
    public Yearreport findByUser(Long userid) {

        return yearreportDao.findByUser(userid);
    }

    @Override
    public YearreportSearchDto search(YearreportSearchDto dto) {
        YearreportSearchDto resultDto = new YearreportSearchDto();
		User currentUser = arsUtil.getCurrentUser();
		//机构信息
		Police police = policeDao.findById(currentUser.getOrgid());
		String areacode =  police.getAreacode();
		if(areacode.endsWith("0000")){//省
			dto.setDistrict(areacode.substring(0,2)+"____");
		}else if(areacode.endsWith("00")){//市
			dto.setDistrict(areacode.substring(0,4)+"__");
		}else{//区
			dto.setDistrict(areacode);
		}
        List<Yearreport> list = yearreportDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(yearreportDao.searchCount(dto));
        return resultDto;
    }

	@Override
	public List<Yearreport> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return yearreportDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public List<Yearreport> findAll() {
		return yearreportDao.findAll();
	}

}
