package com.bcxin.ars.service.sb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.sb.TrainChangeDao;
import com.bcxin.ars.dao.sb.TrainChangeDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.TrainChangeSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.TrainChange;
import com.bcxin.ars.model.sb.TrainChangeworkexperience;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.TrainChangeService;
import com.bcxin.ars.service.sb.TrainChangeworkexperienceService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/19.
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = TrainChange.class)
public class TrainChangeServiceImpl implements TrainChangeService {

    @Autowired
    private TrainChangeDao trainChangeDao;

    @Autowired
    private TrainChangeDaoAop trainChangeDaoAop;

    @Autowired
    private TrainChangeworkexperienceService workexperienceService;

    @Autowired
    private UserDao userDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityScopeDao securityScopeDao;

    @Override
    public TrainChange findById(long id) {
        TrainChange result = trainChangeDao.findById(id);
        if (result != null) {
            result.setApproval(approvalDAO.findBybusinessidAndType(id,BusinessType.PXDWXMBG));

            //查询机构信息
            Police police = policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }
    @Override
    public  List<TrainChange> findByBatchId(List<Approval> approvalList){
        return  trainChangeDao.findByBatchId(approvalList);
    }
    @Override
    public Map searchForPrintf(long id) {
        return trainChangeDao.searchForPrintf(id);
    }
    @Override
    public  void updateBatch(List<TrainChange> list){
        trainChangeDaoAop.updateBatch(list);
    }

    /**
     * 仅适用于申报与暂存
     * @param trainChange
     */
    @Override
    public void saveOrUpdate(TrainChange trainChange) {
        User currentUser = arsUtil.getCurrentUser();

        /**
         * 最后一级机构id处理
         */
        if(trainChange.getOrgid() == null){
            if(trainChange.getDistrictOrgId() != null){
                trainChange.setOrgid(Long.parseLong(trainChange.getDistrictOrgId()));
            }else if(trainChange.getCityOrgId() != null){
                trainChange.setOrgid(Long.parseLong(trainChange.getCityOrgId()));
            }else{
                Police police = policeDao.findByType(Constants.ORGTYPE_PROVINCE).get(0);
                trainChange.setOrgid(police.getId());
            }
        }

        Long userId = currentUser.getId();
        SecurityCompany company = securityCompanyDao.findByUserid(userId);

        if(!trainChange.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)&&company!=null){
            if(StringUtil.isNotEmpty(trainChange.getSecurityScopes())){
                String oldSecurityScope = company.getSecurityScopeType();
                if(StringUtil.isEmpty(oldSecurityScope) &&(
                        StringUtil.isEmpty(company.getInstitutionType())
                        || company.getInstitutionType().equals(Constants.INSTITUTIONTYPE_FWGS)
                        || company.getInstitutionType().equals(Constants.INSTITUTIONTYPE_FGS))
                        ){
                    throw new ArsException("单位原服务范围未维护，请联系系统管理员维护！");
                }

                if(ObjectUtil.equal(oldSecurityScope,trainChange.getSecurityScopes())){
                    throw new ArsException("服务范围与原本的一致，没有变更无需填写！");
                }
            }
            if(StringUtil.isNotEmpty(trainChange.getCompanyname())){
                if(company.getName().equals(trainChange.getCompanyname())){
                    throw new ArsException("单位名称与原本的一致，没有变更无需填写！");
                }
            }
            if(StringUtil.isNotEmpty(trainChange.getAddress())){
                if(company.getLocation()!=null && company.getLocation().equals(trainChange.getAddress())){
                    throw new ArsException("单位地址与原本的一致，没有变更无需填写！");
                }
            }

            List<TrainChange> checkTrainChanges = trainChangeDao.findApproveByUserId(userId);
            if(checkTrainChanges != null && checkTrainChanges.size() > 0){
                String checkMsg = "";
                for (TrainChange checkTrainChange : checkTrainChanges){
                    if(StringUtil.isNotEmpty(trainChange.getNdlegalname()) && StringUtil.isNotEmpty(checkTrainChange.getNdlegalname())){
                        //checkMsg = checkMsg + "法定代表人:" + checkTrainChange.getNdlegalname() + "、";
                        checkMsg = checkMsg + "法定代表人、";
                    }
                    if(StringUtil.isNotEmpty(trainChange.getAddress()) && StringUtil.isNotEmpty(checkTrainChange.getAddress())){
                        //checkMsg = checkMsg + "办公地址:" + checkTrainChange.getAddress() + "、";
                        checkMsg = checkMsg + "办公地址、";
                    }
                    if(StringUtil.isNotEmpty(trainChange.getCompanyname()) && StringUtil.isNotEmpty(checkTrainChange.getCompanyname())){
                        //checkMsg = checkMsg + "单位名称:" + checkTrainChange.getCompanyname() + "、";
                        checkMsg = checkMsg + "单位名称、";
                    }
                }
                if(StringUtil.isNotEmpty(checkMsg)){
                    checkMsg = checkMsg.substring(0,checkMsg.length()-1) + "已提交正在审批，请不要重复提交！";
                    throw new ArsException(checkMsg);
                }
            }
        }

        trainChange.setActive(true);
        trainChange.setUpdateTime(new Date());
        trainChange.setUpdateBy(currentUser.getUsername());
        trainChange.setUserid(userId);

        trainChange.setOldaddress(company.getLocation());
        trainChange.setOldcompanyname(company.getName());

        if (trainChange.getId() == null) {
            trainChange.setCreateTime(new Date());
            trainChangeDao.save(trainChange);
            //TODO 保存审批信息
            if(trainChange.getApprovalstate().equals(ApprovalState.DSH)) {
            	approvalUtil.saveApproval(BusinessType.PXDWXMBG, trainChange.getId(), Constants.ACTIVITI_PROCESS_TRAINCHANGE);
            }
        } else {
            TrainChange dbTrainChange = trainChangeDao.findById(trainChange.getId());
            boolean activity = true;
            if(StringUtil.isNotEmpty(dbTrainChange.getApprovalstate()) && dbTrainChange.getApprovalstate().equals(ApprovalState.DSH)){
                if(dbTrainChange.getOrgid().toString().equals(trainChange.getOrgid().toString())){
                    activity = false;
                    if(StringUtil.isEmpty(trainChange.getCompanyname()) && StringUtil.isEmpty(trainChange.getOldcompanyname())){

                    }else{
                        String companyName = StringUtil.isEmpty(trainChange.getCompanyname())?trainChange.getOldcompanyname():trainChange.getCompanyname();
                        String oldCompanyName = StringUtil.isEmpty(dbTrainChange.getCompanyname())?dbTrainChange.getOldcompanyname():dbTrainChange.getCompanyname();
                        if(!companyName.equals(oldCompanyName)) {
                            Approval approval = approvalDAO.findBybusinessidAndType(trainChange.getId(), BusinessType.PXDWXMBG);
                            if (approval != null) {
                                approvalUtil.updateContent(approval, StringUtil.isEmpty(trainChange.getCompanyname())?trainChange.getOldcompanyname():trainChange.getCompanyname());
                            }
                        }
                    }

                }
            }

            BeanUtils.copyPropertiesIgnore(trainChange,dbTrainChange,"active,createTime,userid",true);
            dbTrainChange.setNdlegalbrith(trainChange.getNdlegalbrith());
            //BeanUtils.copyPropertiesIgnore(trainChange,dbTrainChange,true);
            dbTrainChange.setUpdateBy(currentUser.getUsername());
            dbTrainChange.setUpdateTime(new Date());
            //待审批
            if (!(trainChange.getApprovalstate() != null && !"".equals(trainChange.getApprovalstate()) && !trainChange.getApprovalstate().equals(ApprovalState.DSH))) {
                dbTrainChange.setApprovalstate(ApprovalState.DSH);
                dbTrainChange.setChargecensorstatus("");
                dbTrainChange.setTrainCensorstatus("");

            }
            trainChangeDaoAop.update(dbTrainChange);

            //TODO 保存审批信息
            if(activity && ApprovalState.DSH.equals(dbTrainChange.getApprovalstate())){
                approvalUtil.saveApproval(BusinessType.PXDWXMBG, dbTrainChange.getId(), Constants.ACTIVITI_PROCESS_TRAINCHANGE);
            }
        }

    }




    @Override
    public void saveOrUpdateForIntegrate(TrainChange trainChange, User currentUser) {
        Long userId = currentUser.getId();
        SecurityCompany company = securityCompanyDao.findByUserid(userId);

        if(!trainChange.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)&&company!=null){

            if(StringUtil.isNotEmpty(trainChange.getSecurityScopes())){
                String oldSecurityScope = company.getSecurityScopeType();

                if(oldSecurityScope.equals(trainChange.getSecurityScopes())){
                    throw new ArsException("服务范围与原本的一致，没有变更无需填写！");
                }
            }
            if(StringUtil.isNotEmpty(trainChange.getCompanyname())){
                if(company.getName().equals(trainChange.getCompanyname())){
                    throw new ArsException("单位名称与原本的一致，没有变更无需填写！");
                }
            }
            if(StringUtil.isNotEmpty(trainChange.getAddress())){
                if(company.getLocation()!=null && company.getLocation().equals(trainChange.getAddress())){
                    throw new ArsException("单位地址与原本的一致，没有变更无需填写！");
                }
            }
            if(trainChange.getBgregisteredMoney() != null && company.getRegisteredMoney() != null){
                if(trainChange.getBgregisteredMoney().toString().equals(company.getRegisteredMoney().toString())){
                    throw new ArsException("注册资本与原本的一致，没有变更无需填写！");
                }
            }

            List<TrainChange> checkTrainChanges = trainChangeDao.findApproveByUserId(userId);
            if(checkTrainChanges != null && checkTrainChanges.size() > 0){
                String checkMsg = "";
                for (TrainChange checkTrainChange : checkTrainChanges){
                    if(StringUtil.isNotEmpty(trainChange.getNdlegalname()) && StringUtil.isNotEmpty(checkTrainChange.getNdlegalname())){
                        //checkMsg = checkMsg + "法定代表人:" + checkTrainChange.getNdlegalname() + "、";
                        checkMsg = checkMsg + "法定代表人、";
                    }
                    if(StringUtil.isNotEmpty(trainChange.getAddress()) && StringUtil.isNotEmpty(checkTrainChange.getAddress())){
                        //checkMsg = checkMsg + "办公地址:" + checkTrainChange.getAddress() + "、";
                        checkMsg = checkMsg + "办公地址、";
                    }
                    if(StringUtil.isNotEmpty(trainChange.getCompanyname()) && StringUtil.isNotEmpty(checkTrainChange.getCompanyname())){
                        //checkMsg = checkMsg + "单位名称:" + checkTrainChange.getCompanyname() + "、";
                        checkMsg = checkMsg + "单位名称、";
                    }
                    if(trainChange.getBgregisteredMoney() != null && checkTrainChange.getBgregisteredMoney() != null){
                        //checkMsg = checkMsg + "注册资本:" + checkTrainChange.getBgregisteredMoney() + "、";
                        checkMsg = checkMsg + "注册资本、";
                    }
                    if(StringUtil.isNotEmpty(trainChange.getSecurityScopes()) && StringUtil.isNotEmpty(checkTrainChange.getSecurityScopes())){
                        //checkMsg = checkMsg + "服务范围:" + checkTrainChange.getSecurityScopes() + "、";
                        checkMsg = checkMsg + "服务范围、";
                    }
                }
               /* if(StringUtil.isNotEmpty(checkMsg)){
                    checkMsg = checkMsg.substring(0,checkMsg.length()-1) + "已提交正在审批，请不要重复提交！";
                    throw new ArsException(checkMsg);
                }*/
            }
        }

        //2018年8月22日17:28:43 wjb 如果不包含其他，则其他的名称设为空
        if((null!=trainChange.getSecurityScopes() && !trainChange.getSecurityScopes().contains("20"))||null == trainChange.getSecurityScopes()){
            trainChange.setOtherSecScopeType(null);
        }
        if (trainChange.getId() == null) {

            trainChange.setActive(true);
            trainChange.setCreateTime(new Date());
            trainChange.setUpdateTime(new Date());
            trainChange.setUpdateBy(currentUser.getUsername());
            trainChange.setUserid(userId);

            trainChange.setOldaddress(company.getLocation());
            trainChange.setOldcompanyname(company.getName());
            if(company.getRegisteredMoney()!=null) {
                trainChange.setOldregisteredMoney(company.getRegisteredMoney().toString());
            }
            String securityScopes = company.getSecurityScopeType();
            trainChange.setOldsecurityScopes(securityScopes);
            trainChangeDao.save(trainChange);

            approvalUtil.saveApprovalForIntegrate(BusinessType.PXDWXMBG, trainChange.getId(), Constants.ACTIVITI_PROCESS_TRAINCHANGE,currentUser);
        }
    }

    @Override
    public void  saveOrUpdateForDS(TrainChange trainChange) {
        TrainChange dbTrainChange = trainChangeDao.findById(trainChange.getId());
        if(trainChange.getActive() == null){
        	trainChange.setActive(true);
        }
        if (dbTrainChange != null) {
        	if(trainChange.getUpdateTime().getTime() > dbTrainChange.getUpdateTime().getTime()){
        		trainChange.setNdtrainCensorstatus(dbTrainChange.getNdtrainCensorstatus());
                trainChange.setTrainCensorstatus(dbTrainChange.getTrainCensorstatus());
                trainChange.setChargecensorstatus(dbTrainChange.getChargecensorstatus());
				trainChangeDaoAop.update(trainChange);
			}
        } else {
            trainChangeDao.save(trainChange);
        }
    }

    @Override
    public void updatePoliceId(TrainChange trainChange) {
        Approval approval =  approvalDAO.getById(trainChange.getApprovalId());
        TrainChange dbTrainChange  = trainChangeDao.findById(trainChange.getId());
        dbTrainChange.setPoliceid(trainChange.getPoliceid());
        dbTrainChange.setUpdateTime(new Date());
        trainChangeDaoAop.update(dbTrainChange);
        /***
         * 更新
         */
        approval.setPoliceid(trainChange.getPoliceid());
        approval.setRoleid(null);
        approval.setUpdateTime(new Date());
        approvalDAO.update(approval);

    }

    @Override
    public TrainChangeSearchDto search(TrainChangeSearchDto dto) {
        TrainChangeSearchDto resultDto = new TrainChangeSearchDto();

        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = policeDao.findById(currentUser.getOrgid());
        if (police!=null){
            String areacode =  police.getAreacode();
            if(areacode.endsWith("0000")){//省
                dto.setDistrict(areacode.substring(0,2)+"____");
            }else if(areacode.endsWith("00")){//市
                dto.setDistrict(areacode.substring(0,4)+"__");
            }else{//区
                dto.setDistrict(areacode);
            }
        }
        List<TrainChange> list = trainChangeDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(trainChangeDao.searchCount(dto));
        return resultDto;
    }


    @Override
    public TrainChangeSearchDto searchCompanyCertificate(TrainChangeSearchDto dto) {

        arsUtil.setPoliceSearch(dto);
        TrainChangeSearchDto resultDto = new TrainChangeSearchDto();
        List<TrainChange> list = trainChangeDao.searchCompanyCertificate(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(trainChangeDao.searchCompanyCertificateCount(dto));
        return resultDto;
    }

    @Override
    public void delete(TrainChange trainChange) {
        User currentUser = arsUtil.getCurrentUser();
        trainChange.setUpdateBy(currentUser.getUsername());
        trainChange.setUpdateTime(new Date());
        trainChangeDaoAop.delete(trainChange);
    }

    @Override
    public TrainChange findByUser(Long userid) {
        return trainChangeDao.findByUser(userid);
    }

    @Override
    public void updateAndSaveWorkExperience(TrainChange trainChange, Date[] startdate, Date[] enddate, String[] workCompanyname, String[] post) {
        saveOrUpdate(trainChange);

        User currentUser = arsUtil.getCurrentUser();
        workexperienceService.deleteByTrainChangeId(trainChange.getId());
        TrainChangeworkexperience trainChangeworkexperience = null;
        if (startdate != null) {
            for (int i = 0; i < startdate.length; i++) {
                trainChangeworkexperience = new TrainChangeworkexperience();
                trainChangeworkexperience.setActive(true);
                if(workCompanyname.length>i){
                    trainChangeworkexperience.setCompanyname(workCompanyname[i]);
                }
                trainChangeworkexperience.setCreateTime(new Date());
                if(enddate.length>i){
                    trainChangeworkexperience.setEnddate(enddate[i]);
                }
                trainChangeworkexperience.setTrainChangeId(trainChange.getId());
                if(post.length>i){
                    trainChangeworkexperience.setPost(post[i]);
                }
                trainChangeworkexperience.setStartdate(startdate[i]);
                trainChangeworkexperience.setUpdateBy(currentUser.getUsername());
                trainChangeworkexperience.setUpdateTime(new Date());
                workexperienceService.saveOrUpdate(trainChangeworkexperience);
            }
        }
    }

    @Override
    public List<TrainChange> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return trainChangeDao.searchForDataSynchronization(searchDto);
    }

	@Override
	public List<TrainChange> findAll() {
		return trainChangeDao.findAll();
	}

    @Override
    public PageResult searchTrainChangeList_table(Map<Object, Object> p) {
        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else {
            if (police != null) {
                areacode = police.getAreacode();
            }

        }
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                p.put("district", areacode.substring(0, 4) + "__");
            } else {//区
                p.put("district", areacode);
            }
        }

        if (police != null) {
            if (police.getOrgtype().equals("4")) {
                p.put("orgid", police.getId());
            }
        }
        if (p.get("checkType")!=null) {
            if (currentUser != null) {
                p.put("userid", currentUser.getId());
            }
        }
        return new PageResult(trainChangeDao.countTrainChangeList(p), trainChangeDao.searchTrainChangeList(p));
    }

    @Override
    public void saveOrUpdateForApproval(TrainChange trainChange) {
        trainChange.setUpdateTime(new Date());
        trainChangeDaoAop.update(trainChange);
    }

    @Override
    public void updateCensorStatus(TrainChange trainChange) {
        trainChangeDaoAop.update(trainChange);
    }

    @Override
    public List<TrainChange> findApprovePassByCompanyId(Long companyId) {
        return trainChangeDao.findApprovePassByCompanyId(companyId);
    }

    @Override
    public void saveOrUpdateForApprovalImport(TrainChange trainChange) {
        trainChangeDaoAop.update(trainChange);
    }

    @Override
    public void searchForPage(TrainChangeSearchDto dto, AjaxPageResponse<TrainChange> page) {
        arsUtil.setPoliceSearch(dto);
        trainChangeDao.searchForPage(dto,page);
    }
}
