package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.FamilyDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.FamilySearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Family;
import com.bcxin.ars.service.sb.FamilyService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Family.class)
public class FamilyServiceImpl implements FamilyService{

	@Autowired
	private FamilyDao familyDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public Family findById(long id) {
		return familyDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Family family) {
		User currentUser = arsUtil.getCurrentUser();
		
		Family checkFamily = familyDao.findByFamily(family);
		
		if(family.getId() == null){
			if(checkFamily != null) {
				throw new ArsException("成员信息已存在！");
			}
			family.setActive(true);
			family.setCreateTime(new Date());
			family.setUpdateTime(new Date());
			family.setUpdateBy(currentUser.getUsername());
			familyDao.save(family);
		}else{
			if(checkFamily != null  && checkFamily.getId() != family.getId()) {
				throw new ArsException("成员信息已存在！");
			}
			Family dbFamily = familyDao.findById(family.getId());
			dbFamily.setUpdateBy(currentUser.getUsername());
			dbFamily.setUpdateTime(new Date());

			dbFamily.setCompanyname(family.getCompanyname());
			dbFamily.setIdentifnumber(family.getIdentifnumber());
			dbFamily.setIdentifType(family.getIdentifType());
			dbFamily.setName(family.getName());
			dbFamily.setPhone(family.getPhone());
			dbFamily.setPost(family.getPost());
			dbFamily.setRelationship(family.getRelationship());
			familyDao.update(dbFamily);
		}
		
	}

	@Override
	public void saveOrUpdateForDS(Family family) {

		if(family.getActive() == null){
			family.setActive(true);
		}
		
		if(!family.getActive()){
			familyDao.delete(family);
		}else{
			Family dbFamily = familyDao.findById(family.getId());
			if (dbFamily != null) {
				if(family.getUpdateTime().getTime() > dbFamily.getUpdateTime().getTime()){
					familyDao.update(family);
				}
			} else {
				familyDao.saveForDS(family);
			}
		}
	}

	@Override
	public FamilySearchDto search(FamilySearchDto dto) {
		FamilySearchDto resultDto = new FamilySearchDto();
		List<Family> list =  familyDao.search(dto);
		resultDto.setData(list);
		if(dto.isPaging()) {
			resultDto.setTotalCount(familyDao.searchCount(dto));
		}
		return resultDto;
	}

	@Override
	public void delete(Family family) {
		User currentUser = arsUtil.getCurrentUser();
		family.setUpdateBy(currentUser.getUsername());
		family.setUpdateTime(new Date());
		familyDao.delete(family);
	}

	@Override
	public List<Family> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return familyDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void deleteByPersoncertificateId(Long personcertificateId) {
		familyDao.deleteByPersoncertificateId(personcertificateId);
	}

	@Override
	public List<Family> searchByPid(Long pid) {
		return familyDao.searchByPid(pid);
	}

}
