package com.bcxin.ars.service.sb.impl;

import java.util.Date;
import java.util.List;

import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.util.approval.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.sb.ConfesspersonDao;
import com.bcxin.ars.dto.sb.ConfesspersonSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Confessperson;
import com.bcxin.ars.service.sb.ConfesspersonService;
import com.bcxin.ars.service.util.ArsUtil;

@Service
@Transactional
public class ConfesspersonServiceImpl implements ConfesspersonService{

	@Autowired
	private ConfesspersonDao confesspersonDao;
	
	@Autowired
	private ArsUtil arsUtil;

	@Override
	public Confessperson findById(long id) {
		return confesspersonDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Confessperson confessperson) {
		User currentUser = arsUtil.getCurrentUser();
		if(confessperson.getId() == null){
			confessperson.setActive(true);
			confessperson.setCreateTime(new Date());
			confessperson.setUpdateTime(new Date());
			confessperson.setUpdateBy(currentUser.getUsername());
			confesspersonDao.save(confessperson);


		}else{
			Confessperson dbConfessperson = confesspersonDao.findById(confessperson.getId());
			dbConfessperson.setUpdateTime(new Date());
			dbConfessperson.setUpdateBy(currentUser.getUsername());
			dbConfessperson.setUpdateTime(new Date());
			
			dbConfessperson.setAddress(confessperson.getAddress());
			dbConfessperson.setAge(confessperson.getAge());
			dbConfessperson.setCardnumber(confessperson.getCardnumber());
			dbConfessperson.setCulture(confessperson.getCulture());
			dbConfessperson.setName(confessperson.getName());
			dbConfessperson.setPeronno(confessperson.getPeronno());
			dbConfessperson.setPhone(confessperson.getPhone());
			dbConfessperson.setPlace(confessperson.getPlace());
			dbConfessperson.setPolitics(confessperson.getPolitics());
			dbConfessperson.setSex(confessperson.getSex());
			confesspersonDao.update(dbConfessperson);


		}
		
	}

	@Override
	public ConfesspersonSearchDto search(ConfesspersonSearchDto dto) {
		ConfesspersonSearchDto resultDto = new ConfesspersonSearchDto();
		List<Confessperson> list =  confesspersonDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(confesspersonDao.searchCount(dto));
		return resultDto;
	}

}
